// Copyright 2018 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_PUBLIC_COMMON_MIME_HANDLER_VIEW_MODE_H_
#define CONTENT_PUBLIC_COMMON_MIME_HANDLER_VIEW_MODE_H_

#include "base/macros.h"
#include "content/common/content_export.h"

namespace content {

class CONTENT_EXPORT MimeHandlerViewMode {
 public:
  // Returns true if MimeHandlerViewGuest uses cross-process frames instead of
  // BrowserPlugin.
  static bool UsesCrossProcessFrame();

 private:
  DISALLOW_IMPLICIT_CONSTRUCTORS(MimeHandlerViewMode);
};

}  // namespace content

#endif  // CONTENT_PUBLIC_COMMON_MIME_HANDLER_VIEW_MODE_H_
