/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.securityanalytics.model.CorrelationQuery;
import org.opensearch.securityanalytics.model.CorrelationRuleTrigger;

public class CorrelationRule
implements Writeable,
ToXContentObject {
    private static final Logger log = LogManager.getLogger(CorrelationRule.class);
    public static final String CORRELATION_RULE_INDEX = ".opensearch-sap-correlation-rules-config";
    private static final String NAME = "name";
    public static final String NO_ID = "";
    public static final Long NO_VERSION = 1L;
    private static final String CORRELATION_QUERIES = "correlate";
    private static final String CORRELATION_TIME_WINDOW = "time_window";
    private static final String TRIGGER_FIELD = "trigger";
    private String id;
    private Long version;
    private String name;
    private List<CorrelationQuery> correlationQueries;
    private Long corrTimeWindow;
    private CorrelationRuleTrigger trigger;

    public CorrelationRule(String id, Long version, String name, List<CorrelationQuery> correlationQueries, Long corrTimeWindow, CorrelationRuleTrigger trigger) {
        this.id = id != null ? id : NO_ID;
        this.version = version != null ? version : NO_VERSION;
        this.name = name;
        this.correlationQueries = correlationQueries;
        this.corrTimeWindow = corrTimeWindow != null ? corrTimeWindow : 300000L;
        this.trigger = trigger;
    }

    public CorrelationRule(StreamInput sin) throws IOException {
        this(sin.readString(), sin.readLong(), sin.readString(), sin.readList(CorrelationQuery::readFrom), sin.readLong(), sin.readBoolean() ? new CorrelationRuleTrigger(sin) : null);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(NAME, this.name);
        CorrelationQuery[] correlationQueries = new CorrelationQuery[]{};
        correlationQueries = this.correlationQueries.toArray(correlationQueries);
        builder.field(CORRELATION_QUERIES, (Object)correlationQueries);
        builder.field(CORRELATION_TIME_WINDOW, this.corrTimeWindow);
        builder.field(TRIGGER_FIELD, (ToXContent)this.trigger);
        return builder.endObject();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.id);
        out.writeLong(this.version.longValue());
        out.writeString(this.name);
        for (CorrelationQuery query : this.correlationQueries) {
            query.writeTo(out);
        }
        out.writeBoolean(this.trigger != null);
        if (this.trigger != null) {
            this.trigger.writeTo(out);
        }
        out.writeLong(this.corrTimeWindow.longValue());
    }

    public static CorrelationRule parse(XContentParser xcp, String id, Long version) throws IOException {
        if (id == null) {
            id = NO_ID;
        }
        if (version == null) {
            version = NO_VERSION;
        }
        String name = null;
        ArrayList<CorrelationQuery> correlationQueries = new ArrayList<CorrelationQuery>();
        Long corrTimeWindow = null;
        CorrelationRuleTrigger trigger = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.nextToken(), (XContentParser)xcp);
        block12: while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = xcp.currentName();
            xcp.nextToken();
            switch (fieldName) {
                case "name": {
                    name = xcp.text();
                    continue block12;
                }
                case "correlate": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
                    while (xcp.nextToken() != XContentParser.Token.END_ARRAY) {
                        CorrelationQuery query = CorrelationQuery.parse(xcp);
                        correlationQueries.add(query);
                    }
                    continue block12;
                }
                case "time_window": {
                    corrTimeWindow = xcp.longValue();
                    continue block12;
                }
                case "trigger": {
                    if (xcp.currentToken() == XContentParser.Token.VALUE_NULL) {
                        trigger = null;
                        continue block12;
                    }
                    trigger = CorrelationRuleTrigger.parse(xcp);
                    continue block12;
                }
            }
            xcp.skipChildren();
        }
        return new CorrelationRule(id, version, name, correlationQueries, corrTimeWindow, trigger);
    }

    public static CorrelationRule readFrom(StreamInput sin) throws IOException {
        return new CorrelationRule(sin);
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public void setVersion(Long version) {
        this.version = version;
    }

    public Long getVersion() {
        return this.version;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public List<CorrelationQuery> getCorrelationQueries() {
        return this.correlationQueries;
    }

    public Long getCorrTimeWindow() {
        return this.corrTimeWindow;
    }

    public CorrelationRuleTrigger getCorrelationTrigger() {
        return this.trigger;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CorrelationRule that = (CorrelationRule)o;
        return this.id.equals(that.id) && this.version.equals(that.version) && this.name.equals(that.name) && this.correlationQueries.equals(that.correlationQueries) && this.trigger.equals(that.trigger);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.version, this.name, this.correlationQueries);
    }
}

