/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.action;

import java.io.IOException;
import java.time.Instant;
import java.util.Locale;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.ValidateActions;
import org.opensearch.commons.alerting.model.Table;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;

public class GetCorrelationAlertsRequest
extends ActionRequest {
    private String correlationRuleId;
    private String correlationRuleName;
    private Table table;
    private String severityLevel;
    private String alertState;
    private Instant startTime;
    private Instant endTime;
    public static final String CORRELATION_RULE_ID = "correlation_rule_id";

    public GetCorrelationAlertsRequest(String correlationRuleId, String correlationRuleName, Table table, String severityLevel, String alertState, Instant startTime, Instant endTime) {
        this.correlationRuleId = correlationRuleId;
        this.correlationRuleName = correlationRuleName;
        this.table = table;
        this.severityLevel = severityLevel;
        this.alertState = alertState;
        this.startTime = startTime;
        this.endTime = endTime;
    }

    public GetCorrelationAlertsRequest(StreamInput sin) throws IOException {
        this(sin.readOptionalString(), sin.readOptionalString(), Table.readFrom((StreamInput)sin), sin.readString(), sin.readString(), sin.readOptionalInstant(), sin.readOptionalInstant());
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.correlationRuleId != null && this.correlationRuleId.isEmpty()) {
            validationException = ValidateActions.addValidationError((String)String.format(Locale.getDefault(), "Correlation ruleId is empty or not valid", CORRELATION_RULE_ID), validationException);
        }
        return validationException;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.correlationRuleId);
        out.writeOptionalString(this.correlationRuleName);
        this.table.writeTo(out);
        out.writeString(this.severityLevel);
        out.writeString(this.alertState);
        out.writeOptionalInstant(this.startTime);
        out.writeOptionalInstant(this.endTime);
    }

    public String getCorrelationRuleId() {
        return this.correlationRuleId;
    }

    public Table getTable() {
        return this.table;
    }

    public String getSeverityLevel() {
        return this.severityLevel;
    }

    public String getAlertState() {
        return this.alertState;
    }

    public String getCorrelationRuleName() {
        return this.correlationRuleName;
    }

    public Instant getStartTime() {
        return this.startTime;
    }

    public Instant getEndTime() {
        return this.endTime;
    }
}

