/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.notifications.security;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.notifications.security.UserAccess;
import org.opensearch.notifications.settings.PluginSettings;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\nH\u0016J\u0018\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\n2\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u0018\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\n2\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u0012\u0010\r\u001a\u00020\u000e2\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/opensearch/notifications/security/UserAccessManager;", "Lorg/opensearch/notifications/security/UserAccess;", "()V", "ADMIN_ROLE", "", "doesUserHaveAccess", "", "user", "Lorg/opensearch/commons/authuser/User;", "access", "", "getAllAccessInfo", "getSearchAccessInfo", "validateUser", "", "opensearch-notifications"})
@SourceDebugExtension(value={"SMAP\nUserAccessManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UserAccessManager.kt\norg/opensearch/notifications/security/UserAccessManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,63:1\n1747#2,3:64\n*S KotlinDebug\n*F\n+ 1 UserAccessManager.kt\norg/opensearch/notifications/security/UserAccessManager\n*L\n60#1:64,3\n*E\n"})
public final class UserAccessManager
implements UserAccess {
    @NotNull
    public static final UserAccessManager INSTANCE = new UserAccessManager();
    @NotNull
    public static final String ADMIN_ROLE = "all_access";

    private UserAccessManager() {
    }

    @Override
    public void validateUser(@Nullable User user) {
        if (PluginSettings.INSTANCE.isRbacEnabled()) {
            User user2 = user;
            Collection collection = user2 != null ? user2.getBackendRoles() : null;
            if (collection == null || collection.isEmpty()) {
                throw new OpenSearchStatusException("User doesn't have backend roles configured. Contact administrator.", RestStatus.FORBIDDEN, new Object[0]);
            }
        }
    }

    @Override
    @NotNull
    public List<String> getAllAccessInfo(@Nullable User user) {
        if (user == null) {
            return CollectionsKt.emptyList();
        }
        List list = user.getBackendRoles();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"user.backendRoles");
        return list;
    }

    @Override
    @NotNull
    public List<String> getSearchAccessInfo(@Nullable User user) {
        if (user == null || !PluginSettings.INSTANCE.isRbacEnabled() || user.getRoles().contains(ADMIN_ROLE)) {
            return CollectionsKt.emptyList();
        }
        List list = user.getBackendRoles();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"user.backendRoles");
        return list;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean doesUserHaveAccess(@Nullable User user, @NotNull List<String> access) {
        String it;
        Intrinsics.checkNotNullParameter(access, (String)"access");
        if (user == null) return true;
        if (!PluginSettings.INSTANCE.isRbacEnabled()) {
            return true;
        }
        if (access.isEmpty()) return true;
        if (user.getRoles().contains(ADMIN_ROLE)) return true;
        List list = user.getBackendRoles();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"user.backendRoles");
        Iterable $this$any$iv = list;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            it = (String)element$iv;
            boolean bl = false;
        } while (!access.contains(it));
        return true;
    }
}

