/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.geo.search.aggregations.bucket.geogrid.cells;

import org.opensearch.common.geo.GeoBoundingBox;
import org.opensearch.common.geo.GeoPoint;
import org.opensearch.geo.search.aggregations.bucket.geogrid.cells.CellIdSource;
import org.opensearch.geo.search.aggregations.bucket.geogrid.cells.CellValues;
import org.opensearch.index.fielddata.MultiGeoPointValues;

class BoundedCellValues
extends CellValues {
    private final GeoBoundingBox geoBoundingBox;

    protected BoundedCellValues(MultiGeoPointValues geoValues, int precision, CellIdSource.GeoPointLongEncoder encoder, GeoBoundingBox geoBoundingBox) {
        super(geoValues, precision, encoder);
        this.geoBoundingBox = geoBoundingBox;
    }

    @Override
    int advanceValue(GeoPoint target, int valuesIdx) {
        if (this.geoBoundingBox.pointInBounds(target.getLon(), target.getLat())) {
            this.values[valuesIdx] = this.encoder.encode(target.getLon(), target.getLat(), this.precision);
            return valuesIdx + 1;
        }
        return valuesIdx;
    }
}

