/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.materialproviders.model;

import java.util.List;
import java.util.Objects;
import software.amazon.cryptography.materialproviders.model.DecryptionMaterials;
import software.amazon.cryptography.materialproviders.model.EncryptedDataKey;

public class OnDecryptInput {
    private final DecryptionMaterials materials;
    private final List<EncryptedDataKey> encryptedDataKeys;

    protected OnDecryptInput(BuilderImpl builder) {
        this.materials = builder.materials();
        this.encryptedDataKeys = builder.encryptedDataKeys();
    }

    public DecryptionMaterials materials() {
        return this.materials;
    }

    public List<EncryptedDataKey> encryptedDataKeys() {
        return this.encryptedDataKeys;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected DecryptionMaterials materials;
        protected List<EncryptedDataKey> encryptedDataKeys;

        protected BuilderImpl() {
        }

        protected BuilderImpl(OnDecryptInput model) {
            this.materials = model.materials();
            this.encryptedDataKeys = model.encryptedDataKeys();
        }

        @Override
        public Builder materials(DecryptionMaterials materials) {
            this.materials = materials;
            return this;
        }

        @Override
        public DecryptionMaterials materials() {
            return this.materials;
        }

        @Override
        public Builder encryptedDataKeys(List<EncryptedDataKey> encryptedDataKeys) {
            this.encryptedDataKeys = encryptedDataKeys;
            return this;
        }

        @Override
        public List<EncryptedDataKey> encryptedDataKeys() {
            return this.encryptedDataKeys;
        }

        @Override
        public OnDecryptInput build() {
            if (Objects.isNull(this.materials())) {
                throw new IllegalArgumentException("Missing value for required field `materials`");
            }
            if (Objects.isNull(this.encryptedDataKeys())) {
                throw new IllegalArgumentException("Missing value for required field `encryptedDataKeys`");
            }
            return new OnDecryptInput(this);
        }
    }

    public static interface Builder {
        public Builder materials(DecryptionMaterials var1);

        public DecryptionMaterials materials();

        public Builder encryptedDataKeys(List<EncryptedDataKey> var1);

        public List<EncryptedDataKey> encryptedDataKeys();

        public OnDecryptInput build();
    }
}

