/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.jackson.runtime.serialisers;

import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import io.quarkus.resteasy.reactive.jackson.runtime.ResteasyReactiveServerJacksonRecorder;
import jakarta.inject.Inject;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import org.jboss.resteasy.reactive.server.jackson.JacksonMessageBodyWriterUtil;
import org.jboss.resteasy.reactive.server.spi.ServerMessageBodyWriter;
import org.jboss.resteasy.reactive.server.spi.ServerRequestContext;

public class BasicServerJacksonMessageBodyWriter
extends ServerMessageBodyWriter.AllWriteableMessageBodyWriter {
    private final ObjectWriter defaultWriter;

    @Inject
    public BasicServerJacksonMessageBodyWriter(ObjectMapper mapper) {
        mapper.registerModule((Module)MappingModuleHolder.mappingModule);
        this.defaultWriter = JacksonMessageBodyWriterUtil.createDefaultWriter((ObjectMapper)mapper);
    }

    public void writeResponse(Object o, Type genericType, ServerRequestContext context) throws WebApplicationException, IOException {
        OutputStream stream = context.getOrCreateOutputStream();
        if (o instanceof String) {
            stream.write(((String)o).getBytes(StandardCharsets.UTF_8));
        } else {
            this.defaultWriter.writeValue(stream, o);
        }
        stream.close();
    }

    public void writeTo(Object o, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        JacksonMessageBodyWriterUtil.doLegacyWrite((Object)o, (Annotation[])annotations, httpHeaders, (OutputStream)entityStream, (ObjectWriter)this.defaultWriter);
    }

    static class MappingModuleHolder {
        static final SimpleModule mappingModule = MappingModuleHolder.createMappingModule();

        MappingModuleHolder() {
        }

        private static SimpleModule createMappingModule() {
            SimpleModule module = new SimpleModule();
            for (Class<? extends StdSerializer> serClass : ResteasyReactiveServerJacksonRecorder.getGeneratedSerializers()) {
                try {
                    StdSerializer serializer = serClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                    module.addSerializer(serializer.handledType(), (JsonSerializer)serializer);
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
            return module;
        }
    }
}

