/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.remote.upgrade;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import org.infinispan.Cache;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.commons.util.concurrent.CompletionStages;
import org.infinispan.configuration.cache.StoreConfiguration;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.persistence.manager.PersistenceManager;
import org.infinispan.persistence.remote.RemoteStore;
import org.infinispan.persistence.remote.configuration.RemoteStoreConfiguration;
import org.infinispan.persistence.remote.upgrade.SerializationUtils;

public class AddSourceRemoteStoreTask
implements Function<EmbeddedCacheManager, Void> {
    private final String cacheName;
    private final RemoteStoreConfiguration storeConfiguration;

    public AddSourceRemoteStoreTask(String cacheName, RemoteStoreConfiguration storeConfiguration) {
        this.cacheName = cacheName;
        this.storeConfiguration = storeConfiguration;
    }

    @Override
    public Void apply(EmbeddedCacheManager embeddedCacheManager) {
        ComponentRegistry cr = ComponentRegistry.of((Cache)embeddedCacheManager.getCache(this.cacheName));
        PersistenceManager persistenceManager = (PersistenceManager)cr.getComponent(PersistenceManager.class);
        try {
            if (persistenceManager.getStores(RemoteStore.class).isEmpty()) {
                return (Void)CompletionStages.join((CompletionStage)persistenceManager.addStore((StoreConfiguration)this.storeConfiguration));
            }
            return null;
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    public static class Externalizer
    extends AbstractExternalizer<AddSourceRemoteStoreTask> {
        public Set<Class<? extends AddSourceRemoteStoreTask>> getTypeClasses() {
            return Collections.singleton(AddSourceRemoteStoreTask.class);
        }

        public void writeObject(ObjectOutput output, AddSourceRemoteStoreTask task) throws IOException {
            output.writeObject(task.cacheName);
            output.writeObject(SerializationUtils.toJson(task.storeConfiguration));
        }

        public AddSourceRemoteStoreTask readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            String cacheName = (String)input.readObject();
            String config = (String)input.readObject();
            return new AddSourceRemoteStoreTask(cacheName, SerializationUtils.fromJson(config));
        }
    }
}

