/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.RadiotapPacket;
import org.pcap4j.util.ByteArrays;

public final class RadiotapDataDbmTxPower
implements RadiotapPacket.RadiotapData {
    private static final long serialVersionUID = -7046612192280202993L;
    private static final int LENGTH = 1;
    private final byte txPower;

    public static RadiotapDataDbmTxPower newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        ByteArrays.validateBounds(rawData, offset, length);
        return new RadiotapDataDbmTxPower(rawData, offset, length);
    }

    private RadiotapDataDbmTxPower(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        if (length < 1) {
            StringBuilder sb = new StringBuilder(200);
            sb.append("The data is too short to build a RadiotapDbmTxPower (").append(1).append(" bytes). data: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
            throw new IllegalRawDataException(sb.toString());
        }
        this.txPower = ByteArrays.getByte(rawData, offset);
    }

    private RadiotapDataDbmTxPower(Builder builder2) {
        if (builder2 == null) {
            throw new NullPointerException("builder is null.");
        }
        this.txPower = builder2.txPower;
    }

    public byte getTxPower() {
        return this.txPower;
    }

    public int getTxPowerAsInt() {
        return this.txPower;
    }

    @Override
    public int length() {
        return 1;
    }

    @Override
    public byte[] getRawData() {
        return ByteArrays.toByteArray(this.txPower);
    }

    public Builder getBuilder() {
        return new Builder(this);
    }

    public String toString() {
        return this.toString("");
    }

    @Override
    public String toString(String indent) {
        StringBuilder sb = new StringBuilder();
        String ls = System.getProperty("line.separator");
        sb.append(indent).append("dBm TX power: ").append(ls).append(indent).append("  TX power: ").append(this.txPower).append(" dBm").append(ls);
        return sb.toString();
    }

    public int hashCode() {
        return this.txPower;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!this.getClass().isInstance(obj)) {
            return false;
        }
        RadiotapDataDbmTxPower other = (RadiotapDataDbmTxPower)obj;
        return this.txPower == other.txPower;
    }

    public static final class Builder {
        private byte txPower;

        public Builder() {
        }

        private Builder(RadiotapDataDbmTxPower obj) {
            this.txPower = obj.txPower;
        }

        public Builder txPower(byte txPower) {
            this.txPower = txPower;
            return this;
        }

        public RadiotapDataDbmTxPower build() {
            return new RadiotapDataDbmTxPower(this);
        }
    }
}

