/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.codec.vp8;

import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jitsi.rtp.rtp.RtpPacket;
import org.jitsi_modified.impl.neomedia.codec.video.vp8.DePacketizer;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lorg/jitsi/nlj/codec/vp8/Vp8Utils;", "", "<init>", "()V", "Companion", "jitsi-media-transform"})
public final class Vp8Utils {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final int VP8_PAYLOAD_HEADER_LEN = 3;
    private static final int MIN_HD_HEIGHT = 540;
    private static final int MIN_SD_HEIGHT = 360;
    private static final int HD_LAYER_ID = 2;
    private static final int SD_LAYER_ID = 1;
    private static final int LD_LAYER_ID = 0;
    private static final int SUSPENDED_LAYER_ID = -1;

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0013R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jitsi/nlj/codec/vp8/Vp8Utils$Companion;", "", "<init>", "()V", "VP8_PAYLOAD_HEADER_LEN", "", "MIN_HD_HEIGHT", "MIN_SD_HEIGHT", "HD_LAYER_ID", "SD_LAYER_ID", "LD_LAYER_ID", "SUSPENDED_LAYER_ID", "isKeyFrame", "", "vp8Payload", "Ljava/nio/ByteBuffer;", "getSpatialLayerIndexFromKeyFrame", "getHeightFromKeyFrame", "vp8Packet", "Lorg/jitsi/rtp/rtp/RtpPacket;", "getTemporalLayerIdOfFrame", "jitsi-media-transform"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isKeyFrame(@NotNull ByteBuffer vp8Payload) {
            Intrinsics.checkNotNullParameter(vp8Payload, "vp8Payload");
            return DePacketizer.isKeyFrame(vp8Payload.array(), vp8Payload.arrayOffset(), vp8Payload.limit());
        }

        public final int getSpatialLayerIndexFromKeyFrame(@NotNull ByteBuffer vp8Payload) {
            Intrinsics.checkNotNullParameter(vp8Payload, "vp8Payload");
            int payloadDescriptorLen = DePacketizer.VP8PayloadDescriptor.getSize(vp8Payload.array(), vp8Payload.arrayOffset(), vp8Payload.limit());
            int height = DePacketizer.VP8KeyframeHeader.getHeight(vp8Payload.array(), vp8Payload.arrayOffset() + payloadDescriptorLen + 3);
            return height >= 540 ? 2 : (height >= 360 ? 1 : (height > -1 ? 0 : -1));
        }

        public final int getHeightFromKeyFrame(@NotNull RtpPacket vp8Packet) {
            Intrinsics.checkNotNullParameter(vp8Packet, "vp8Packet");
            int payloadDescriptorLen = DePacketizer.VP8PayloadDescriptor.getSize(vp8Packet.buffer, vp8Packet.getPayloadOffset(), vp8Packet.getPayloadLength());
            return DePacketizer.VP8KeyframeHeader.getHeight(vp8Packet.buffer, vp8Packet.getPayloadOffset() + payloadDescriptorLen + 3);
        }

        public final int getSpatialLayerIndexFromKeyFrame(@NotNull RtpPacket vp8Packet) {
            Intrinsics.checkNotNullParameter(vp8Packet, "vp8Packet");
            int height = this.getHeightFromKeyFrame(vp8Packet);
            return height >= 540 ? 2 : (height >= 360 ? 1 : (height > -1 ? 0 : -1));
        }

        public final int getTemporalLayerIdOfFrame(@NotNull ByteBuffer vp8Payload) {
            Intrinsics.checkNotNullParameter(vp8Payload, "vp8Payload");
            return DePacketizer.VP8PayloadDescriptor.getTemporalLayerIndex(vp8Payload.array(), vp8Payload.arrayOffset(), vp8Payload.limit());
        }

        public final int getTemporalLayerIdOfFrame(@NotNull RtpPacket vp8Packet) {
            Intrinsics.checkNotNullParameter(vp8Packet, "vp8Packet");
            return DePacketizer.VP8PayloadDescriptor.getTemporalLayerIndex(vp8Packet.buffer, vp8Packet.getPayloadOffset(), vp8Packet.getPayloadLength());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

