/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.header;

import gov.nist.javax.sip.header.SIPHeader;
import javax.sip.InvalidArgumentException;
import javax.sip.header.MaxForwardsHeader;
import javax.sip.header.TooManyHopsException;

public class MaxForwards
extends SIPHeader
implements MaxForwardsHeader {
    private static final long serialVersionUID = -3096874323347175943L;
    protected int maxForwards;

    public MaxForwards() {
        super("Max-Forwards");
    }

    public MaxForwards(int m4) throws InvalidArgumentException {
        super("Max-Forwards");
        this.setMaxForwards(m4);
    }

    public int getMaxForwards() {
        return this.maxForwards;
    }

    public void setMaxForwards(int maxForwards) throws InvalidArgumentException {
        if (maxForwards < 0 || maxForwards > 255) {
            throw new InvalidArgumentException("bad max forwards value " + maxForwards);
        }
        this.maxForwards = maxForwards;
    }

    public String encodeBody() {
        return this.encodeBody(new StringBuilder()).toString();
    }

    @Override
    protected StringBuilder encodeBody(StringBuilder buffer) {
        return buffer.append(this.maxForwards);
    }

    public boolean hasReachedZero() {
        return this.maxForwards == 0;
    }

    public void decrementMaxForwards() throws TooManyHopsException {
        if (this.maxForwards > 0) {
            --this.maxForwards;
        } else {
            throw new TooManyHopsException("has already reached 0!");
        }
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof MaxForwardsHeader) {
            MaxForwardsHeader o = (MaxForwardsHeader)other;
            return this.getMaxForwards() == o.getMaxForwards();
        }
        return false;
    }
}

