/*
 *   utils.h
 *
 *   Oliver Fromme  <olli@fromme.com>
 *
 *   Copyright (C) 1997,1998,1999
 *        Oliver Fromme.  All rights reserved.
 *
 *   Redistribution and use in source and binary forms, with or without
 *   modification, are permitted provided that the following conditions
 *   are met:
 *   1. Redistributions of source code must retain the above copyright
 *      notice, this list of conditions and the following disclaimer.
 *   2. Redistributions in binary form must reproduce the above copyright
 *      notice, this list of conditions and the following disclaimer in the
 *      documentation and/or other materials provided with the distribution.
 *   3. Neither the name of the author nor the names of any co-contributors
 *      may be used to endorse or promote products derived from this software
 *      without specific prior written permission.
 *
 *   THIS SOFTWARE IS PROVIDED BY OLIVER FROMME AND CONTRIBUTORS ``AS IS'' AND
 *   ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 *   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 *   ARE DISCLAIMED.  IN NO EVENT SHALL OLIVER FROMME OR CONTRIBUTORS BE LIABLE
 *   FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 *   DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 *   OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 *   HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 *   LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 *   OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 *   SUCH DAMAGE.
 *
 *   @(#)$Id: utils.h,v 1.3 1999/01/01 23:32:06 olli Exp $
 */

static const char cvsid_utils_h[]
    = "@(#)$Id: utils.h,v 1.3 1999/01/01 23:32:06 olli Exp $";

#include <stdlib.h>

typedef int bool;
#ifndef TRUE
#define FALSE 0
#define TRUE 1
#endif

extern char *me;
/*
 *   The name of the executable (without directory).
 *   Initialized by init().
 */

void out_of_memory (void);
/*
 *   Prints the program name followed by a message that there
 *   is not enough memory (to stderr) and exits with code 1.
 */

void *tmalloc (size_t size);
/*
 *   Wrapper for malloc() which checks the result and calls
 *   out_of_memory() if the requested memory could not be
 *   allocated.
 */

char *strndup (char *src, int num);
/*
 *   Like strdup(), but limits the string length to at most
 *   <num> characters (not counting the terminating zero).
 *   The resulting string is always zero-terminated.
 *   Always allocates <num>+1 bytes, even if less space would
 *   be sufficient to store <src>.
 */

char *justify (char *str);
/*
 *   Removes leading and trailing whitespace, and compresses
 *   contained whitespace to single spaces.  Returns <str>.
 *   Whitespace is a sequence of ' ', '\t', '\r' and/or '\n'.
 */

void die (const char *func);
/*
 *   Prints the executable name, func, and the error string
 *   corresponding to errno to stdout, followed by a newline,
 *   and exits the program with code 1 (failure).
 */

void utils_init (char *argv0);
/*
 *   Initializes *me.  Should be the first instruction in
 *   main(), with argv[0] as parameter.
 */

/* EOF */
