/*
 *   utils.c
 *
 *   Oliver Fromme  <olli@fromme.com>
 *
 *   Copyright (C) 1997,1998,1999
 *        Oliver Fromme.  All rights reserved.
 *
 *   Redistribution and use in source and binary forms, with or without
 *   modification, are permitted provided that the following conditions
 *   are met:
 *   1. Redistributions of source code must retain the above copyright
 *      notice, this list of conditions and the following disclaimer.
 *   2. Redistributions in binary form must reproduce the above copyright
 *      notice, this list of conditions and the following disclaimer in the
 *      documentation and/or other materials provided with the distribution.
 *   3. Neither the name of the author nor the names of any co-contributors
 *      may be used to endorse or promote products derived from this software
 *      without specific prior written permission.
 *
 *   THIS SOFTWARE IS PROVIDED BY OLIVER FROMME AND CONTRIBUTORS ``AS IS'' AND
 *   ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 *   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 *   ARE DISCLAIMED.  IN NO EVENT SHALL OLIVER FROMME OR CONTRIBUTORS BE LIABLE
 *   FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 *   DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 *   OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 *   HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 *   LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 *   OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 *   SUCH DAMAGE.
 *
 *   @(#)$Id: utils.c,v 1.3 1999/01/01 23:32:05 olli Exp $
 */

static const char cvsid[]
    = "@(#)$Id: utils.c,v 1.3 1999/01/01 23:32:05 olli Exp $";

#include <stdio.h>
#include <string.h>
#include <errno.h>

#include "utils.h"

char *me;

void out_of_memory (void)
{
	fprintf (stderr, "%s: Out of memory.\n", me);
	exit (1);
}

void *tmalloc (size_t size)
{
	void *mem;

	if (!(mem = malloc(size)))
		out_of_memory();
	return (mem);
}

char *strndup (char *src, int num)
{
	char *dst;

	if (!(dst = (char *) malloc(num+1)))
		return (NULL);
	dst[num] = '\0';
	return (strncpy(dst, src, num));
}

char *justify (char *str)
{
	int si = 0, di = 0, havespc = TRUE;
	char c;

	if (!str)
		return (str);
	while ((c = str[si])) {
		if (c == ' ' || c == '\t' || c == '\r' || c == '\n')
			if (havespc) {
				si++;
				continue;
			}
			else
				havespc = TRUE;
		else
			havespc = FALSE;
		str[di++] = str[si++];
	}
	if (di && havespc)
		di --;
	str[di] = '\0';
	return (str);
}

char *me;

void die (const char *func)
{
	fprintf (stderr, "%s: %s: %s\n", me, func, strerror(errno));
	exit (1);
}

void utils_init (char *argv0)
{
	(me = strrchr(argv0, '/')) ? me++ : (me = argv0);
}

/* EOF */
