/*
 *   getlopt.c
 *
 *   Oliver Fromme  <olli@fromme.com>
 *
 *   Copyright (C) 1997,1998,1999
 *        Oliver Fromme.  All rights reserved.
 *
 *   Redistribution and use in source and binary forms, with or without
 *   modification, are permitted provided that the following conditions
 *   are met:
 *   1. Redistributions of source code must retain the above copyright
 *      notice, this list of conditions and the following disclaimer.
 *   2. Redistributions in binary form must reproduce the above copyright
 *      notice, this list of conditions and the following disclaimer in the
 *      documentation and/or other materials provided with the distribution.
 *   3. Neither the name of the author nor the names of any co-contributors
 *      may be used to endorse or promote products derived from this software
 *      without specific prior written permission.
 *
 *   THIS SOFTWARE IS PROVIDED BY OLIVER FROMME AND CONTRIBUTORS ``AS IS'' AND
 *   ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 *   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 *   ARE DISCLAIMED.  IN NO EVENT SHALL OLIVER FROMME OR CONTRIBUTORS BE LIABLE
 *   FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 *   DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 *   OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 *   HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 *   LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 *   OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 *   SUCH DAMAGE.
 *
 *   @(#)$Id: getlopt.c,v 1.3 1999/01/01 23:31:48 olli Exp $
 */

static const char cvsid[]
    = "@(#)$Id: getlopt.c,v 1.3 1999/01/01 23:31:48 olli Exp $";

#include <stdio.h>
#include "getlopt.h"

int loptind = 1;	/* index in argv[] */
int loptchr = 0;	/* index in argv[loptind] */
char *loptarg;		/* points to argument if present, else to option */

#if defined(ultrix) || defined(ULTRIX)
char *
strdup (char *src)
{
	char *dest;

	if (!(dest = (char *) malloc(strlen(src) + 1)))
		return (NULL);
	return (strcpy(dest, src));
}
#endif

const topt *
findopt (int islong, char *opt, const topt *opts)
{
	if (!opts)
		return (0);
	while (opts->lname || opts->sname) {
		if (islong) {
			if (opts->lname && !strcmp(opts->lname, opt))
				return (opts);
		}
		else
			if (opts->sname == *opt)
				return (opts);
		opts++;
	}
	return (0);
}

int
performoption (int argc, char *argv[], const topt *opt)
{
	int result = GLO_CONTINUE;

	if (!(opt->flags & 1)) /* doesn't take argument */
		if (opt->var)
			if (opt->flags & 2) /* var is *char */
				*((char *) opt->var) = (char) opt->value;
			else
				*((int *) opt->var) = opt->value;
		else
			result = opt->value ? opt->value : opt->sname;
	else { /* requires argument */
		if (loptind >= argc)
			return (GLO_NOARG);
		loptarg = argv[loptind++]+loptchr;
		loptchr = 0;
		if (opt->var)
			if (opt->flags & 2) /* var is *char */
				*((char **) opt->var) = strdup(loptarg);
			else
				*((int *) opt->var) = atoi(loptarg);
		else
			result = opt->value ? opt->value : opt->sname;
	}
	if (opt->func)
		if (opt->func(loptarg) < 0)
			result = GLO_USERERR;
	return (result);
}

int
getsingleopt (int argc, char *argv[], const topt *opts)
{
	char *thisopt;
	const topt *opt;
	static char shortopt[2] = {0, 0};

	if (loptind >= argc)
		return (GLO_END);
	thisopt = argv[loptind];
	if (!loptchr) { /* start new option string */
		if (thisopt[0] != '-' || !thisopt[1]) /* no more options */
			return (GLO_END);
		if (thisopt[1] == '-') /* "--" */
			if (thisopt[2]) { /* long option */
				loptarg = thisopt + 2;
				loptind++;
				if (!(opt = findopt(1, thisopt + 2, opts)))
					return (GLO_UNKNOWN);
				else
					return (performoption(argc, argv, opt));
			}
			else { /* "--" == end of options */
				loptind++;
				return (GLO_END);
			}
		else /* start short option(s) */
			loptchr = 1;
	}
	shortopt[0] = thisopt[loptchr];
	loptarg = shortopt;
	opt = findopt(0, thisopt + (loptchr++), opts);
	if (!thisopt[loptchr]) {
		loptind++;
		loptchr = 0;
	}
	if (!opt)
		return (GLO_UNKNOWN);
	else
		return (performoption(argc, argv, opt));
}

int
getlopt (int argc, char *argv[], const topt *opts)
{
	int result;
	
	while ((result = getsingleopt(argc, argv, opts)) == GLO_CONTINUE);
	return (result);
}

int
parselopts (int argc, char *argv[], const topt *opts, char *progname)
{
	int result;

	while ((result = getlopt(argc, argv, opts)))
		switch (result) {
			case GLO_UNKNOWN:
				fprintf (stderr, "%s: Unknown option \"%s\".\n",
					progname, loptarg);
				exit (1);
			case GLO_NOARG:
				fprintf (stderr, "%s: Missing argument for option \"%s\".\n",
					progname, loptarg);
				exit (1);
			case GLO_USERERR:
				return result;
		}
	return result;
}

/* EOF */
