[manpage_begin crc16 n 1.1.1]
[copyright {2002, Pat Thoyts}]
[moddesc   {Cyclic Redundancy Checks}]
[titledesc {Perform a 16bit Cyclic Redundancy Check}]
[require Tcl 8.2]
[require crc16 [opt 1.1.1]]
[description]
[para]

This package provides a Tcl-only implementation of the CRC
algorithms based upon information provided at
http://www.microconsultants.com/tips/crc/crc.txt

There are a number of permutations available for calculating CRC
checksums and this package can handle all of them. Defaults are set up
for the most common cases.

[section COMMANDS]

[list_begin definitions]

[call [cmd ::crc::crc16] [opt "-format [arg format]"] [opt "-seed [arg value]"] [opt "-implementation [arg procname]"] [arg message]]
[call [cmd ::crc::crc16] [opt "-format [arg format]"] [opt "-seed [arg value]"] [opt "-implementation [arg procname]"] "-filename [arg file]"]
[call [cmd ::crc::crc-ccitt] [opt "-format [arg format]"] [opt "-seed [arg value]"] [opt "-implementation [arg procname]"] [arg message]]
[call [cmd ::crc::crc-ccitt] [opt "-format [arg format]"] [opt "-seed [arg value]"] [opt "-implementation [arg procname]"] "-filename [arg file]"]

The command takes string data or a file name and returns a checksum
value calculated using the CRC algorithm. The command used sets up the
CRC polynomial, initial value and bit ordering for the desired
standard checksum calculation. The result is formatted
using the [arg format](n) specifier provided or as an unsigned integer
(%u) by default.

[list_end]

[section OPTIONS]

[list_begin definitions]

[lst_item "-filename [arg name]"]

Return a checksum for the file contents instead of for parameter data.

[lst_item "-format [arg string]"]

Return the checksum using an alternative format template.

[lst_item "-seed [arg value]"]

Select an alternative seed value for the CRC calculation. The default
is 0 for the CRC16 calculation and 0xFFFF for the CCITT version.
This can be useful for calculating the CRC for data
structures without first converting the whole structure into a
string. The CRC of the previous member can be used as the seed for
calculating the CRC of the next member. It is also used for
accumulating a checksum from fragments of a large message (or file)

[lst_item "-implementation [arg procname]"]

This hook is provided to allow users to provide their own
implementation (perhaps a C compiled extension). The
procedure specfied is called with two parameters. The first is the
data to be checksummed and the second is the seed value. An
integer is expected as the result.

[list_end]

[section EXAMPLES]

[para]
[example {
% crc::crc16 "Hello, World!"
64077
}]

[para]
[example {
% crc::crc-ccitt "Hello, World!"
26586
}]

[para]
[example {
% crc::crc16 -format 0x%X "Hello, World!"
0xFA4D
}]

[para]
[example {
% crc::crc16 -file crc16.tcl
51675
}]

[see_also sum(n) cksum(n) crc32(n)]
[section AUTHORS]
Pat Thoyts

[keywords cksum checksum crc crc32 crc16 {cyclic redundancy check} {data integrity} security]
[manpage_end]

