[comment {-*- tcl -*- doctools manpage}]
[manpage_begin dtplite n 1.0]
[copyright {2004 Andreas Kupries <andreas_kupries@users.sourceforge.net>}]
[titledesc {Lightweight DocTools Markup Processor}]
[moddesc   {Documentation toolbox}]
[description]
[para]

The application described by this document, [syscmd dtplite], is the
successor to the extremely simple [syscmd mpexpand]. Influenced in its
functionality by the [syscmd dtp] doctools processor it is much more
powerful than [syscmd mpexpand], yet still as easy to use; definitely
easier than [syscmd dtp] with its myriad of subcommands and options.

[para]

[syscmd dtplite] is based upon the package [package doctools], like
the other two processors .


[subsection {USE CASES}]

[syscmd dtplite] was written with the following three use cases in
mind.

[para]
[list_begin enum]
[enum]
Validation of a single document, i.e. checking that it was written in
valid doctools format. This mode can also be used to get a preliminary
version of the formatted output for a single document, for display in
a browser, nroff, etc., allowing proofreading of the formatting.

[enum]
Generation of the formatted documentation for a single package,
i.e. all the manpages, plus a table of contents and an index of
keywords.

[enum]
An extension of the previous mode of operation, a method for the easy
generation of one documentation tree for several packages. Especially
unified table of contents and keyword index.

[list_end]

[para]

Beyond the above we also want to make use of the customization
features provided by the HTML formatter. It is not the only format the
application should be able to generate, but we anticipiate it to be
the most commonly used, and it is one of the few which do provide
customization hooks.

[para]

We allow the caller to specify a header string, footer string, a
stylesheet, and data for a bar of navigation links at the top of the
generated document.

While all can be set as long as the formatting engine provides an
appropriate engine parameter (See section [sectref OPTIONS]) the last
two have internal processing which make them specific to HTML.

[subsection {COMMAND LINE}]

[list_begin definitions]

[call [cmd dtplite] [option -o] [arg output] [opt options] [arg format] [arg inputfile]]

This is the form for use case [lb]1[rb]. The [arg options] will be
explained later, in section [sectref OPTIONS].

[list_begin arg]

[arg_def path output in]

This argument specifies where to write the generated document. It can
be the path to a file or directory, or [const -].

The last value causes the application to write the generated
documented to [const stdout].

[nl]

If the [arg output] does not exist then [lb]file dirname $output[rb]
has to exist and must be a writable directory.

The generated document will be written to a file in that directory,
and the name of that file will be derived from the [arg inputfile],
the [arg format], and the value given to option [option -ext] (if
present).


[arg_def (path|handle) format in]

This argument specifies the formatting engine to use when processing
the input, and thus the format of the generated document. See section
[sectref FORMATS] for the possibilities recognized by the application.


[arg_def path inputfile in]

This argument specifies the path to the file to process. It has to
exist, must be readable, and written in [term doctools] format.

[list_end]
[nl]


[call [cmd dtplite] [option -o] [arg output] [opt options] [arg format] [arg inputdirectory]]

This is the form for use case [lb]2[rb]. It differs from the form for
use case [lb]1[rb] by having the input documents specified through a
directory instead of a file. The other arguments are identical, except
for [arg output], which now has to be the path to an existing and
writable directory.

[nl]

The input documents are all files in [arg inputdirectory] or any of
its subdirectories which were recognized by [cmd fileutil::fileType]
as containing text in [term doctools] format.


[call [cmd dtplite] [option -merge] [option -o] [arg output] [opt options] [arg format] [arg inputdirectory]]

This is the form for use case [lb]3[rb]. The only difference to the
form for use case [lb]2[rb] is the additional option [option -merge].

[nl]

Each such call will merge the generated documents coming from
processing the input documents under [arg inputdirectory] or any of
its subdirectories to the files under [arg output]. In this manner it
is possible to incrementally build the unified documentation for any
number of packages. Note that it is necessary to run through all the
packages twice to get fully correct cross-references (for formats
supporting them).

[list_end]

[subsection OPTIONS]

This section describes all the options available to the user of the
application, with

the exception of the options [option -o] and [option -merge]. These
two were described already, in section [sectref {COMMAND LINE}].

[para]
[list_begin opt]
[opt_def -ext string]

If the name of an output file has to be derived from the name of an
input file it will use the name of the [arg format] as the extension
by default. This option here will override this however, forcing it to
use [arg string] as the file extension. This option is ignored if the
name of the output file is fully specified through option [option -o].

[nl]

When used multiple times only the last definition is relevant.


[opt_def -header file]

This option can be used if and only if the selected [arg format]
provides an engine parameter named "header". It takes the contents of
the specified file and assign them to that parameter, for whatever use
by the engine. The HTML engine will insert the text just after the tag
[const <body>].

If navigation buttons are present (see option [option -nav] below),
then the HTML generated for them is appended to the header data
originating here before the final assignment to the parameter.

[nl]

When used multiple times only the last definition is relevant.


[opt_def -footer file]

Like [option -header], except that: Any navigation buttons are ignored,
the corresponding required engine parameter is named "footer", and the
data is inserted just before the tag [const </body>].

[nl]

When used multiple times only the last definition is relevant.


[opt_def -style file]

This option can be used if and only if the selected [arg format]
provides an engine parameter named "meta". When specified it will
generate a piece of HTML code declaring the [arg file] as the
stylesheet for the generated document and assign that to the
parameter. The HTML engine will insert this inot the document, just
after the tag [const <head>].

[nl]

When processing an input directory the stylesheet file is copied into
the output directory and the generated HTML will refer to the copy, to
make the result more self-contained. When processing an input file we
have no location to copy the stylesheet to and so just reference it as
specified.

[nl]

When used multiple times only the last definition is relevant.


[opt_def -nav "label url"]

Use this option to specify a navigation button with [arg label] to
display and the [arg url] to link to. This option can be used if and
only if the selected [arg format] provides an engine parameter named
"header". The HTML generated for this is appended to whatever data we
got from option [option -header] before it is inserted into the
generated documents.

[nl]

When used multiple times all definitions are collected and a
navigation bar is created, with the first definition shown at the left
edge and the last definition to the right.

[list_end]


[subsection FORMATS]

At first the [arg format] argument will be treated as a path to a tcl
file containing the code for the requested formatting engine. The
argument will be treated as the name of one of the predefined formats
listed below if and only if the path does not exist.

[para]

[emph {Note a limitation}]: If treating the format as path to the tcl
script implementing the engine was sucessful, then this script has to
implement not only the engine API for doctools, i.e.

[term doctools_api], but for [term doctoc_api] and [term docidx_api]
as well. Otherwise the generation of a table of contents and of a
keyword index will fail.

[para]

List of predefined formats, i.e. as provided by the
package [package doctools]:

[para]
[list_begin definitions]

[lst_item [const nroff]]

The processor generates *roff output, the standard format for unix
manpages.

[lst_item [const html]]

The processor generates HTML output, for usage in and display by web
browsers. This engine is currently the only one providing the various
engine parameters required for the additional customaization of the
output.

[lst_item [const tmml]]

The processor generates TMML output, the Tcl Manpage Markup Language,
a derivative of XML.

[lst_item [const latex]]

The processor generates LaTeX output.

[lst_item [const wiki]]

The processor generates Wiki markup as understood by [syscmd wikit].

[lst_item [const list]]

The processor extracts the information provided by [cmd manpage_begin].

This format is used internally to extract the meta data from which
both table of contents and keyword index are derived from.

[lst_item [const null]]

The processor does not generate any output.

[list_end]


[subsection {DIRECTORY STRUCTURES}]

In this section we describe the directory structures generated by the
application under [arg output] when processing all documents in an
[arg inputdirectory]. In other words, this is only relevant to the use
cases [lb]2[rb] and [lb]3[rb].

[list_begin definitions]

[lst_item "[lb]2[rb]"]

The following directory structure is created when processing a single
set of input documents.  The file extension used is for output in
HTML, but that is not relevant to the structure and was just used to
have proper file names.

[example {
    output/
        toc.html
        index.html
        files/
            path/to/FOO.html
}]

The last line in the example shows the document
generated for a file FOO located at

[example {
    inputdirectory/path/to/FOO
}]


[lst_item "[lb]3[rb]"]

When merging many packages into a unified set of documents the
generated directory structure is a bit deeper:

[example {
    output
        .toc
        .idx
        .xrf
        toc.html
        index.html
        FOO1/
            ...
        FOO2/
            toc.html
            files/
                path/to/BAR.html
}]

Each of the directories FOO1, ... contains the documents generated for
the package FOO1, ... and follows the structure shown for use case
[lb]2[rb]. The only exception is that there is no per-package index.

[nl]

The files [file .toc], [file .idx], and [file .xrf] contain the
internal status of the whole output and will be read and updated by
the next invokation. Their contents will not be documented. Remove
these files when all packages wanted for the output have been
processed, i.e. when the output is complete.

[list_end]

[see_also doctools_fmt doctoc_fmt docidx_fmt]
[see_also doctools_api doctoc_api docidx_api]
[keywords manpage TMML HTML nroff conversion markup doctools]
[manpage_end]
