/*

Copyright (C) 2000, 2001 Christian Kreibich <christian@whoop.org>.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies of the Software and its documentation and acknowledgment shall be
given in the documentation and software packages that this Software was
used.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/

#ifndef __nd_arp_callbacks_h
#define __nd_arp_callbacks_h

#include <nd_packet.h>
#include <nd_trace.h>
#include <nd_packet.h>

/* Button callbacks */

void    nd_arp_hrd_cb(LND_Packet  *packet,
		      guchar      *header,
		      guchar      *data);

void    nd_arp_pro_cb(LND_Packet  *packet,
		      guchar      *header,
		      guchar      *data);

void    nd_arp_hln_cb(LND_Packet  *packet,
		      guchar      *header,
		      guchar      *data);

void    nd_arp_pln_cb(LND_Packet  *packet,
		      guchar      *header,
		      guchar      *data);

void    nd_arp_op_cb(LND_Packet  *packet,
		     guchar      *header,
		     guchar      *data);

void    nd_arp_sha_cb(LND_Packet  *packet,
		      guchar      *header,
		      guchar      *data);

void    nd_arp_spr_cb(LND_Packet  *packet,
		      guchar      *header,
		      guchar      *data);

void    nd_arp_dha_cb(LND_Packet  *packet,
		      guchar      *header,
		      guchar      *data);

void    nd_arp_dpr_cb(LND_Packet  *packet,
		      guchar      *header,
		      guchar      *data);

/* Menu item callbacks */

void    nd_arp_hrd_value_cb(LND_Packet  *packet,
			    guchar      *header,
			    int          value);

void    nd_arp_hrd_custom_cb(LND_Packet  *packet,
			     guchar      *header,
			     int          value);

void    nd_arp_op_value_cb(LND_Packet  *packet,
			   guchar      *header,
			   int          value);

void    nd_arp_op_custom_cb(LND_Packet  *packet,
			    guchar      *header,
			    int          value);

#endif
