/*

Copyright (C) 2000 - 2003 Christian Kreibich <christian@whoop.org>.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies of the Software and its documentation and acknowledgment shall be
given in the documentation and software packages that this Software was
used.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/
#include <nd.h>
#include <nd_gui.h>

#include <plugins/libnd_cksumfix.h>


/* The Checksum Fix plugin. It's truly minimal and only
 * calls a single function, which is provided by libnetdude's
 * checksum fix plugin. After that, it updates the GUI to
 * give the user some information about the outcome of the
 * operation.
 */


const char *
name(void)
{
  return _("/Checksum Fixer");
}


const char *
description(void)
{
  return _("The Checksum Fix plugin. It fixes the headers of "
	   "all protocols in the packets the plugin is applied "
	   "to. The actual functionality depends on the way "
	   "the protocols implement it.");
}


const char *
author(void)
{
  return _("Christian Kreibich, <christian@whoop.org>");
}

const char *
version(void)
{
  return VERSION_MAJOR;
}

gboolean
init(void)
{
  if (! libnd_plugin_find("Checksum-Fix"))
    return FALSE;

  return TRUE;
}

void
run(LND_Trace *trace)
{
  char message[MAXPATHLEN];
  guint tested, modified;
  
  D_ENTER;
  
  if (!trace)
    D_RETURN;
  
  libnd_cksumfix_run(trace, &tested, &modified);
  
  /* Some GUI candy to let the user see what's going on */
  g_snprintf(message, MAXPATHLEN, _("%i packets checked, %i fixed."),
	     tested, modified);

  nd_gui_statusbar_set(message);

  D_RETURN;
}
