/*
 * Decompiled with CFR 0.152.
 */
package org.apache.naming.factory;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import org.apache.naming.ResourceRef;

public class ResourceFactory
implements ObjectFactory {
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable environment) throws Exception {
        if (obj instanceof ResourceRef) {
            Reference ref = (Reference)obj;
            ObjectFactory factory = null;
            RefAddr factoryRefAddr = ref.get("factory");
            if (factoryRefAddr != null) {
                String factoryClassName = factoryRefAddr.getContent().toString();
                ClassLoader tcl = Thread.currentThread().getContextClassLoader();
                Class<?> factoryClass = null;
                if (tcl != null) {
                    try {
                        factoryClass = tcl.loadClass(factoryClassName);
                    }
                    catch (ClassNotFoundException classNotFoundException) {}
                } else {
                    try {
                        factoryClass = Class.forName(factoryClassName);
                    }
                    catch (ClassNotFoundException classNotFoundException) {}
                }
                if (factoryClass != null) {
                    try {
                        factory = (ObjectFactory)factoryClass.newInstance();
                    }
                    catch (Throwable throwable) {}
                }
            } else if (ref.getClassName().equals("javax.sql.DataSource")) {
                String javaxSqlDataSourceFactoryClassName = System.getProperty("javax.sql.DataSource.Factory", "org.apache.naming.factory.TyrexDataSourceFactory");
                try {
                    factory = (ObjectFactory)Class.forName(javaxSqlDataSourceFactoryClassName).newInstance();
                }
                catch (Throwable throwable) {}
            } else if (ref.getClassName().equals("javax.mail.Session")) {
                String javaxMailSessionFactoryClassName = System.getProperty("javax.mail.Session.Factory", "org.apache.naming.factory.MailSessionFactory");
                try {
                    factory = (ObjectFactory)Class.forName(javaxMailSessionFactoryClassName).newInstance();
                }
                catch (Throwable throwable) {}
            }
            if (factory != null) {
                return factory.getObjectInstance(obj, name, nameCtx, environment);
            }
            throw new NamingException("Cannot create resource instance");
        }
        return null;
    }
}

