/*
 * Decompiled with CFR 0.152.
 */
package org.apache.naming.factory;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import org.apache.naming.ResourceEnvRef;

public class ResourceEnvFactory
implements ObjectFactory {
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable environment) throws Exception {
        if (obj instanceof ResourceEnvRef) {
            Reference ref = (Reference)obj;
            ObjectFactory factory = null;
            RefAddr factoryRefAddr = ref.get("factory");
            if (factoryRefAddr != null) {
                String factoryClassName = factoryRefAddr.getContent().toString();
                ClassLoader tcl = Thread.currentThread().getContextClassLoader();
                Class<?> factoryClass = null;
                if (tcl != null) {
                    try {
                        factoryClass = tcl.loadClass(factoryClassName);
                    }
                    catch (ClassNotFoundException classNotFoundException) {}
                } else {
                    try {
                        factoryClass = Class.forName(factoryClassName);
                    }
                    catch (ClassNotFoundException classNotFoundException) {}
                }
                if (factoryClass != null) {
                    try {
                        factory = (ObjectFactory)factoryClass.newInstance();
                    }
                    catch (Throwable throwable) {}
                }
            }
            if (factory != null) {
                return factory.getObjectInstance(obj, name, nameCtx, environment);
            }
            throw new NamingException("Cannot create resource instance");
        }
        return null;
    }
}

