/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ajp.tomcat4;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.AccessControlException;
import java.util.Stack;
import java.util.Vector;
import org.apache.ajp.tomcat4.Ajp13Logger;
import org.apache.ajp.tomcat4.Ajp13Processor;
import org.apache.ajp.tomcat4.Ajp13Request;
import org.apache.ajp.tomcat4.Ajp13Response;
import org.apache.catalina.Connector;
import org.apache.catalina.Container;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.Service;
import org.apache.catalina.net.DefaultServerSocketFactory;
import org.apache.catalina.net.ServerSocketFactory;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.util.StringManager;

public final class Ajp13Connector
implements Connector,
Lifecycle,
Runnable {
    private int acceptCount = 10;
    private String address = null;
    private int bufferSize = 2048;
    protected Container container = null;
    private Vector created = new Vector();
    private int curProcessors = 0;
    private int debug = 0;
    private ServerSocketFactory factory = null;
    private static final String info = "org.apache.catalina.connector.ajp.Ajp13Connector/1.0";
    private int redirectPort = -1;
    private boolean enableLookups = false;
    protected LifecycleSupport lifecycle = new LifecycleSupport((Lifecycle)this);
    protected int minProcessors = 5;
    private int maxProcessors = 20;
    private int connectionTimeout = -1;
    private int port = 8009;
    private Stack processors = new Stack();
    private String scheme = "http";
    private boolean secure = false;
    private ServerSocket serverSocket = null;
    private StringManager sm = StringManager.getManager((String)"org.apache.ajp.tomcat4");
    private boolean started = false;
    private boolean stopped = false;
    private Thread thread = null;
    private String threadName = null;
    private Object threadSync = new Object();
    private Ajp13Logger logger = new Ajp13Logger();
    private Service service = null;

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public int getAcceptCount() {
        return this.acceptCount;
    }

    public void setAcceptCount(int count) {
        this.acceptCount = count;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public boolean isAvailable() {
        return this.started;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public Container getContainer() {
        return this.container;
    }

    public void setContainer(Container container) {
        this.container = container;
    }

    public int getCurProcessors() {
        return this.curProcessors;
    }

    public int getDebug() {
        return this.debug;
    }

    public void setDebug(int debug) {
        this.debug = debug;
    }

    public boolean getEnableLookups() {
        return this.enableLookups;
    }

    public void setEnableLookups(boolean enableLookups) {
        this.enableLookups = enableLookups;
    }

    public int getRedirectPort() {
        return this.redirectPort;
    }

    public void setRedirectPort(int redirectPort) {
        this.redirectPort = redirectPort;
    }

    public ServerSocketFactory getFactory() {
        if (this.factory == null) {
            Ajp13Connector ajp13Connector = this;
            synchronized (ajp13Connector) {
                this.factory = new DefaultServerSocketFactory();
            }
        }
        return this.factory;
    }

    public void setFactory(ServerSocketFactory factory) {
        this.factory = factory;
    }

    public String getInfo() {
        return info;
    }

    public int getMinProcessors() {
        return this.minProcessors;
    }

    public void setMinProcessors(int minProcessors) {
        this.minProcessors = minProcessors;
    }

    public int getMaxProcessors() {
        return this.maxProcessors;
    }

    public void setMaxProcessors(int maxProcessors) {
        this.maxProcessors = maxProcessors;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getScheme() {
        return this.scheme;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public boolean getSecure() {
        return this.secure;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public Service getService() {
        return this.service;
    }

    public void setService(Service service) {
        this.service = service;
    }

    public Request createRequest() {
        Ajp13Request request = new Ajp13Request(this);
        request.setConnector(this);
        return request;
    }

    public Response createResponse() {
        Ajp13Response response = new Ajp13Response();
        response.setConnector(this);
        return response;
    }

    public void initialize() throws LifecycleException {
    }

    void recycle(Ajp13Processor processor) {
        this.processors.push(processor);
    }

    private Ajp13Processor createProcessor() {
        Stack stack = this.processors;
        synchronized (stack) {
            if (this.processors.size() > 0) {
                Ajp13Processor ajp13Processor = (Ajp13Processor)this.processors.pop();
                return ajp13Processor;
            }
            if (this.maxProcessors > 0 && this.curProcessors < this.maxProcessors) {
                Ajp13Processor ajp13Processor = this.newProcessor();
                return ajp13Processor;
            }
            Ajp13Processor ajp13Processor = null;
            return ajp13Processor;
        }
    }

    private Ajp13Processor newProcessor() {
        Ajp13Processor processor;
        if ((processor = new Ajp13Processor(this, this.curProcessors++)) instanceof Lifecycle) {
            try {
                processor.start();
            }
            catch (LifecycleException e) {
                this.logger.log("newProcessor", e);
                return null;
            }
        }
        this.created.addElement(processor);
        return processor;
    }

    private ServerSocket open() throws IOException {
        ServerSocketFactory factory = this.getFactory();
        if (this.address == null) {
            this.logger.log(this.sm.getString("ajp13Connector.allAddresses"));
            return factory.createSocket(this.port, this.acceptCount);
        }
        try {
            InetAddress is = InetAddress.getByName(this.address);
            this.logger.log(this.sm.getString("ajp13Connector.anAddress", (Object)this.address));
            return factory.createSocket(this.port, this.acceptCount, is);
        }
        catch (Exception e) {
            this.logger.log(this.sm.getString("ajp13Connector.noAddress", (Object)this.address));
            return factory.createSocket(this.port, this.acceptCount);
        }
    }

    public void run() {
        while (!this.stopped) {
            Socket socket;
            block14: {
                socket = null;
                try {
                    socket = this.serverSocket.accept();
                    socket.setSoLinger(true, 100);
                    socket.setKeepAlive(true);
                    if (this.connectionTimeout < 0) break block14;
                    socket.setSoTimeout(this.connectionTimeout);
                }
                catch (AccessControlException ace) {
                    this.logger.log("socket accept security exception: " + ace.getMessage());
                    continue;
                }
                catch (IOException e) {
                    if (this.started && !this.stopped) {
                        this.logger.log("accept: ", e);
                    }
                    try {
                        if (this.serverSocket != null) {
                            this.serverSocket.close();
                        }
                        this.serverSocket = this.open();
                        continue;
                    }
                    catch (IOException ex) {
                        this.logger.log("socket reopen: ", ex);
                        break;
                    }
                }
            }
            Ajp13Processor processor = this.createProcessor();
            if (processor == null) {
                try {
                    this.logger.log(this.sm.getString("ajp13Connector.noProcessor"));
                    socket.close();
                }
                catch (IOException iOException) {}
                continue;
            }
            processor.assign(socket);
        }
        Object object = this.threadSync;
        synchronized (object) {
            this.threadSync.notifyAll();
        }
    }

    private void threadStart() {
        this.logger.log(this.sm.getString("ajp13Connector.starting"));
        this.thread = new Thread((Runnable)this, this.threadName);
        this.thread.setDaemon(true);
        this.thread.start();
    }

    private void threadStop() {
        this.logger.log(this.sm.getString("ajp13Connector.stopping"));
        this.stopped = true;
        Object object = this.threadSync;
        synchronized (object) {
            try {
                this.threadSync.wait(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.thread = null;
    }

    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    public void start() throws LifecycleException {
        if (this.started) {
            throw new LifecycleException(this.sm.getString("ajp13Connector.alreadyStarted"));
        }
        this.threadName = "Ajp13Connector[" + this.port + "]";
        this.logger.setConnector(this);
        this.logger.setName(this.threadName);
        this.lifecycle.fireLifecycleEvent("start", null);
        this.started = true;
        try {
            this.serverSocket = this.open();
        }
        catch (IOException e) {
            throw new LifecycleException(this.threadName + ".open", (Throwable)e);
        }
        this.threadStart();
        while (this.curProcessors < this.minProcessors) {
            if (this.maxProcessors > 0 && this.curProcessors >= this.maxProcessors) break;
            Ajp13Processor processor = this.newProcessor();
            this.recycle(processor);
        }
    }

    public void stop() throws LifecycleException {
        if (!this.started) {
            throw new LifecycleException(this.sm.getString("ajp13Connector.notStarted"));
        }
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.started = false;
        int i = this.created.size() - 1;
        while (i >= 0) {
            Ajp13Processor processor = (Ajp13Processor)this.created.elementAt(i);
            if (processor instanceof Lifecycle) {
                try {
                    processor.stop();
                }
                catch (LifecycleException e) {
                    this.logger.log("Ajp13Connector.stop", e);
                }
            }
            --i;
        }
        this.threadStop();
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.serverSocket = null;
        }
    }
}

