/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ajp.test;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import org.apache.ajp.Ajp13;
import org.apache.ajp.AjpRequest;
import org.apache.ajp.test.TestAjp13;
import org.apache.tomcat.util.http.MimeHeaders;

class Ajp13Server
extends Thread {
    boolean shutdown = false;

    Ajp13Server() {
    }

    void shutdown() {
        this.shutdown = true;
        this.interrupt();
    }

    public void run() {
        try {
            ServerSocket server = new ServerSocket(8009);
            TestAjp13.println("Ajp13Server running...");
            Socket socket = server.accept();
            Ajp13 ajp13 = new Ajp13();
            MimeHeaders headers = new MimeHeaders();
            AjpRequest request = new AjpRequest();
            ajp13.setSocket(socket);
            boolean moreRequests = true;
            while (moreRequests && !this.shutdown) {
                int status = 0;
                try {
                    status = ajp13.receiveNextRequest(request);
                }
                catch (IOException e) {
                    if (this.shutdown) {
                        TestAjp13.println("Ajp13Server told to shutdown");
                        break;
                    }
                    TestAjp13.println("process: ajp13.receiveNextRequest -> " + e);
                }
                if (status == -2 || status != 200) break;
                TestAjp13.println(request.toString());
                String message = "<html><body><pre>hello from ajp13:  " + System.getProperty("line.separator") + request.toString() + "</pre></body></html>";
                headers.addValue("content-type").setString("text/html");
                headers.addValue("content-length").setInt(message.length());
                headers.addValue("my-header").setString("my value");
                ajp13.sendHeaders(200, headers);
                byte[] b = message.getBytes();
                ajp13.doWrite(b, 0, b.length);
                ajp13.finish();
                request.recycle();
                headers.recycle();
            }
            try {
                ajp13.close();
            }
            catch (IOException e) {
                TestAjp13.println("process: ajp13.close ->" + e);
            }
            try {
                socket.close();
            }
            catch (IOException e) {
                TestAjp13.println("process: socket.close ->" + e);
            }
            socket = null;
            TestAjp13.println("process:  done");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e.toString());
        }
    }
}

