/*
 * Decompiled with CFR 0.152.
 */
package tyrex.util;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.lang.reflect.Array;

public class WeakList {
    private Reference[] _table;
    private static ReferenceQueue _queue = new ReferenceQueue();
    public static final int INITIAL_SIZE = 2;
    static /* synthetic */ Class class$java$lang$Integer;

    public void add(Object object) {
        if (object == null) {
            throw new NullPointerException("Argument 'obj' is null");
        }
        if (this._table == null) {
            this._table = new Reference[2];
            this._table[0] = new WeakReference<Object>(object, _queue);
        } else {
            this.processQueue();
            int n = 0;
            while (n < this._table.length) {
                if (this._table[n] == null || this._table[n].get() == null) {
                    this._table[n] = new WeakReference<Object>(object, _queue);
                    return;
                }
                ++n;
            }
            Reference[] referenceArray = new Reference[this._table.length + 1];
            System.arraycopy(this._table, 0, referenceArray, 0, this._table.length);
            referenceArray[this._table.length] = new WeakReference<Object>(object, _queue);
            this._table = referenceArray;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void clear() {
        if (this._table != null) {
            int n = 0;
            while (n < this._table.length) {
                this._table[n] = null;
                ++n;
            }
            this._table = null;
        }
        this.processQueue();
    }

    public boolean contains(Object object) {
        if (this._table == null) {
            return false;
        }
        this.processQueue();
        int n = 0;
        while (n < this._table.length) {
            Reference reference = this._table[n];
            if (reference != null && reference.get() == object) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public Object[] list() {
        if (this._table == null) {
            return new Object[0];
        }
        this.processQueue();
        Object[] objectArray = new Object[this._table.length];
        int n = 0;
        int n2 = 0;
        while (n2 < this._table.length) {
            Reference reference = this._table[n2];
            if (reference != null) {
                objectArray[n] = reference.get();
                if (objectArray[n] != null) {
                    ++n;
                }
            }
            ++n2;
        }
        if (n == 0) {
            return new Object[0];
        }
        if (n == objectArray.length) {
            return objectArray;
        }
        Object[] objectArray2 = new Object[n];
        System.arraycopy(objectArray, 0, objectArray2, 0, n);
        return objectArray2;
    }

    public Object[] list(Class clazz) {
        if (this._table == null) {
            return (Object[])Array.newInstance(clazz, 0);
        }
        this.processQueue();
        Object[] objectArray = (Object[])Array.newInstance(clazz, this._table.length);
        int n = 0;
        int n2 = 0;
        while (n2 < this._table.length) {
            Reference reference = this._table[n2];
            if (reference != null) {
                objectArray[n] = reference.get();
                if (objectArray[n] != null) {
                    ++n;
                }
            }
            ++n2;
        }
        if (n == 0) {
            return (Object[])Array.newInstance(clazz, 0);
        }
        if (n == objectArray.length) {
            return objectArray;
        }
        Object[] objectArray2 = (Object[])Array.newInstance(clazz, n);
        System.arraycopy(objectArray, 0, objectArray2, 0, n);
        return objectArray2;
    }

    public static void main(String[] stringArray) {
        try {
            Integer n = new Integer(1);
            Integer n2 = new Integer(2);
            WeakList weakList = new WeakList();
            weakList.add(n);
            weakList.add(n2);
            Integer[] integerArray = (Integer[])weakList.list(class$java$lang$Integer != null ? class$java$lang$Integer : (class$java$lang$Integer = WeakList.class$("java.lang.Integer")));
            int n3 = 0;
            while (n3 < integerArray.length) {
                System.out.println(integerArray[n3]);
                integerArray[n3] = null;
                ++n3;
            }
            integerArray = null;
            n2 = null;
            Runtime.getRuntime().gc();
            integerArray = (Integer[])weakList.list(class$java$lang$Integer != null ? class$java$lang$Integer : (class$java$lang$Integer = WeakList.class$("java.lang.Integer")));
            n3 = 0;
            while (n3 < integerArray.length) {
                System.out.println(integerArray[n3]);
                integerArray[n3] = null;
                ++n3;
            }
            integerArray = null;
            n = null;
            Runtime.getRuntime().gc();
            integerArray = (Integer[])weakList.list(class$java$lang$Integer != null ? class$java$lang$Integer : (class$java$lang$Integer = WeakList.class$("java.lang.Integer")));
            n3 = 0;
            while (n3 < integerArray.length) {
                System.out.println(integerArray[n3]);
                ++n3;
            }
        }
        catch (Exception exception) {
            System.out.println(exception);
            exception.printStackTrace();
        }
    }

    private void processQueue() {
        Reference reference = _queue.poll();
        while (reference != null) {
            int n = 0;
            while (n < this._table.length) {
                if (this._table[n] == reference) {
                    this._table[n] = null;
                    break;
                }
                ++n;
            }
            reference = _queue.poll();
        }
    }

    public Object remove(Object object) {
        if (object == null) {
            throw new NullPointerException("Argument 'obj' is null");
        }
        if (this._table == null) {
            return null;
        }
        this.processQueue();
        int n = 0;
        while (n < this._table.length) {
            Reference reference = this._table[n];
            if (reference != null && reference.get() == object) {
                this._table[n] = null;
                return object;
            }
            ++n;
        }
        return null;
    }
}

