/*
    GQ -- a GTK-based LDAP client
    Copyright (C) 1998-2001 Bert Vermeulen

    This program is released under the Gnu General Public License with
    the additional exemption that compiling, linking, and/or using
    OpenSSL is allowed.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/* $Id: util.h,v 1.16 2002/07/03 20:13:05 stamfest Exp $ */

#ifndef GQ_UTIL_H_INCLUDED
#define GQ_UTIL_H_INCLUDED

#include <gtk/gtk.h>
#include <ldap.h>
#include <ldap_schema.h>

#include "config.h" 

LDAP *open_connection(struct ldapserver *server);
void close_connection(struct ldapserver *server, int always);
void clear_server_schema(struct ldapserver *server);

gboolean delete_entry_full(struct ldapserver *server, char *dn,
			   gboolean recursive);
gboolean delete_entry(struct ldapserver *server, char *dn);
gboolean do_recursive_delete(struct ldapserver *server, char* dn);

void set_busycursor(void);
void set_normalcursor(void);
void make_message(char *buffer, int bufsize, int cnt, char *singular, char *plural, char *suffix);
int close_on_esc(GtkWidget *widget, GdkEventKey *event, gpointer obj);
int func_on_esc(GtkWidget *widget, GdkEventKey *event, GtkWidget *window);
int tokenize(struct tokenlist *list, char *keyword);
char *detokenize(struct tokenlist *list, int token);
gpointer detokenize_data(struct tokenlist *list, int token);
char *get_username(void);
void statusbar_msg(char *message);
struct ldapserver *server_by_name(char *name);
int is_leaf_entry(struct ldapserver *server, char *dn);
gboolean is_direct_parent(char *child, char *possible_parent);
gboolean is_ancestor(char *child, char *possible_ancestor);
GList *ar2glist(char *ar[]);
void warning_popup(GList *messages);
void single_warning_popup(char *message);
GList *find_at_by_mr_oid(struct ldapserver *server, char *oid);
GList *find_at_by_s_oid(struct ldapserver *server, char *oid);
GList *find_mr_by_s_oid(struct ldapserver *server, char *oid);
GList *find_oc_by_at(struct ldapserver *server, char *atname);

LDAPAttributeType *find_canonical_at_by_at(struct server_schema *schema,
					   char *attr);

struct gq_template *find_template_by_name(char *templatename);
void dump_mods(LDAPMod **mods);
const char *find_s_by_at_oid(struct ldapserver *server, const char *oid);
int query_popup(const char *title, gchar **outbuf, gboolean is_password);
int question_popup(const char *title, const char *question);

GList *get_suffixes(struct ldapserver *server);

#ifndef HAVE_LDAP_STR2DN
#define gq_ldap_explode_dn ldap_explode_dn
#define gq_exploded_free ldap_value_free
#else
char **gq_ldap_explode_dn(const char *dn, int dummy);
void gq_exploded_free(char **exploded_dn);
#endif

#endif

/* 
   Local Variables:
   c-basic-offset: 5
   End:
 */
