/*
    GQ -- a GTK-based LDAP client
    Copyright (C) 1998-2001 Bert Vermeulen

    This program is released under the Gnu General Public License with
    the additional exemption that compiling, linking, and/or using
    OpenSSL is allowed.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/* $Id: search.h,v 1.3 2002/04/24 05:50:22 stamfest Exp $ */

#ifndef GQ_SEARCH_H_INCLUDED
#define GQ_SEARCH_H_INCLUDED

struct resultset {
     char dn[MAX_DN_LEN];
     struct oc *objectclass;
     struct attrs *attributes;
     int num_attributes;
     struct resultset *next;
};

struct attrs {
     char name[128];
     int column;
     struct attrs *next;
};


void new_searchmode(GHashTable *hash);
void servername_changed_callback(GHashTable *hash);
gint searchbase_button_pressed(GtkWidget *widget, GdkEventButton *event, GHashTable *hash);
void findbutton_pressed_callback(GHashTable *hash);

struct resultset *new_resultset(GHashTable *hash);
void free_resultset(struct resultset *set);

int column_by_attr(struct attrs **attrlist, char *attribute);
int new_attr(struct attrs **attrlist, char *attr);
struct attrs *find_attr(struct attrs *attrlist, char *attr);
void free_cur_attrs(struct attrs *attrlist);

void query(GHashTable *hash);

void results_popup_menu(GHashTable *hash, GdkEventButton *event, struct resultset *set);
void search_new_from_entry_callback(GHashTable *hash);
void search_edit_entry_callback(GHashTable *hash);
void delete_search_entry(GHashTable *hash);
int select_entry_callback(GtkWidget *clist, gint row, gint column,
			   GdkEventButton *event, gpointer hash);
int unselect_entry_callback(GtkWidget *clist, gint row, gint column,
			   GdkEventButton *event, gpointer hash);

void cleanup_search_mode(GHashTable *hash);

#endif /* GQ_SEARCH_H_INCLUDED */
