/*
    GQ -- a GTK-based LDAP client
    Copyright (C) 1998-2001 Bert Vermeulen

    This file (dt_entry.c) is
    Copyright (C) 2002 by Peter Stamfest and Bert Vermeulen

    This program is released under the Gnu General Public License with
    the additional exemption that compiling, linking, and/or using
    OpenSSL is allowed.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/* $Id: dt_entry.c,v 1.5 2002/06/05 15:14:52 stamfest Exp $ */

#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>

#include <glib.h>
#include <gdk/gdk.h>
#include <gtk/gtk.h>

#include <config.h>

#include "dt_entry.h"

#include "common.h"
#include "util.h"
#include "errorchain.h"
#include "input.h"
#include "tinput.h"
#include "browse.h"
#include "encode.h"
#include "ldif.h" /* for b64_decode */
#include "syntax.h"


static dt_entry_handler dt_entry_handler_vtab = {
     {
	  dt_entry_get_widget,
	  dt_entry_get_data,
	  dt_entry_set_data,
	  bervalLDAPMod
     },
     decode_utf8, /* encode method */
     encode_utf8, /* decode method */
};

display_type_handler *dt_entry_get_handler() {
     return (display_type_handler *) &dt_entry_handler_vtab;
}


GtkWidget *dt_entry_get_widget(struct formfill *form, GByteArray *data,
			       GtkSignalFunc *activatefunc,
			       GHashTable *hash) 
{
    GtkWidget *inputbox;


    inputbox = gtk_entry_new();
    if(activatefunc)
	gtk_signal_connect_object(GTK_OBJECT(inputbox), "activate",
				  GTK_SIGNAL_FUNC(activatefunc), 
				  (gpointer) hash);
    if(data) {
	GByteArray *encoded =
	     DT_ENTRY(form->dt_handler)->encode(data->data, data->len);
/*  	printf("setting text '%s' orglen=%d len1=%d len2=%d\n", */
/*  	       encoded->data, */
/*  	       data->len, */
/*  	       encoded->len, strlen(encoded->data)); */
	gtk_entry_set_text(GTK_ENTRY(inputbox), encoded->data);
	g_byte_array_free(encoded, TRUE);
    }

    return inputbox;
}

GByteArray *dt_entry_get_data(struct formfill *form, GtkWidget *widget) 
{
    GByteArray *copy;
    int l;

    gchar *content = gtk_editable_get_chars(GTK_EDITABLE(widget), 0, -1);
    if (!content) return NULL;

    l = strlen(content);
    if (l == 0) {
	g_free(content);
	return NULL;
    }

    copy = DT_ENTRY(form->dt_handler)->decode(content, strlen(content));
    
/*      printf("getting orgtext '%s' text '%s' orglen=%d len1=%d len2=%d\n", */
/*  	   content, */
/*  	   copy->data, */
/*  	   strlen(content), */
/*  	   copy->len, strlen(copy->data)); */

    g_free(content);

    return copy;
}

void dt_entry_set_data(struct formfill *form, GByteArray *data,
		       GtkWidget *widget) 
{
    if(data) {
	GByteArray *encoded =
	     DT_ENTRY(form->dt_handler)->encode(data->data, data->len);
/*  	printf("setting text '%s' orglen=%d len1=%d len2=%d\n", */
/*  	       encoded->data, */
/*  	       data->len, */
/*  	       encoded->len, strlen(encoded->data)); */

	gtk_entry_set_text(GTK_ENTRY(widget), encoded->data);
	g_byte_array_free(encoded, TRUE);
    } else {
	gtk_entry_set_text(GTK_ENTRY(widget), "");
    }
}

GByteArray *decode_utf8(const char *val, int len)
{
     GByteArray *gb = g_byte_array_new();

     if (gb) {
	  gb = g_byte_array_set_size(gb, len + 1);
	  memset(gb->data, 0, len + 1);
	  decode_string(gb->data, val, len);
	  /* trusting g_byte_array_set_size to keep that nul-byte */
	  g_byte_array_set_size(gb, strlen(gb->data));
     }
/*       printf("identity %s %d\n", gb->data, len); */
     return gb;
}

GByteArray *encode_utf8(const char *val, int len)
{
     GByteArray *gb = g_byte_array_new();

     if (gb) {
	  gb = g_byte_array_set_size(gb, 2 * len + 1);
	  memset(gb->data, 0, 2 * len + 1);
	  encode_string(gb->data, val, len);
	  /* trusting g_byte_array_set_size to keep that nul-byte */
	  g_byte_array_set_size(gb, strlen(gb->data));
     }
     return gb;
}

/* 
   Local Variables:
   c-basic-offset: 5
   End:
 */
