#!/usr/bin/perl

if ($ARGV[0] eq "A") {

    my $prefix, $bindir, $datadir, $version;
    open(IN,"$ARGV[1]") or die('input file not found');
    open(OUT,">$ARGV[2]") or die('input file not found');
    
    $prefix=$ARGV[3];
    $bindir=$ARGV[4];
    $datadir=$ARGV[5];
    $version=$ARGV[6];

    while($_=<IN>) {
	s/\@prefix\@/$prefix/g;
	s/\@bindir\@/$bindir/g;
	s/\@datadir\@/$datadir/g;
	s/\@VERSION\@/$version/g;
	s/\@PACKAGE\@/eboard/g;
	print OUT $_;
    }
    close OUT;
    close IN;

} else {

    unlink("config.h");
    
    my $path, $os;
    
    $path=$ENV{PATH};
    $path="$path:/bin:/sbin:/usr/bin:/usr/sbin:/opt/bin:/opt/sbin";
    $ENV{PATH}=$path;
    
    open(UNAME,"uname -s |") or die('cannot run uname -s');
    
    open(CONFIG,">config.h") or die('cannot write config.h');
    
    $_ = <UNAME>;
    chomp;
    $os=$_;
    
    close(UNAME);
    
    print CONFIG "#define VERSION \"$ARGV[0]\"\n";
    print CONFIG "#define DATADIR \"$ARGV[1]\"\n";
    
    if ($os eq "Linux") {
	print CONFIG "#define HAVE_SYS_SOUNDCARD_H 1\n";
    }
    
    if ($os eq "FreeBSD") {
	print CONFIG "#define HAVE_SYS_SOUNDCARD_H 1\n";
    }
    
    if ($os eq "NetBSD") {
	print CONFIG "#define HAVE_SYS_AUDIOIO_H 1\n";
    }
    
    if ($os eq "OpenBSD") {
	print CONFIG "#define HAVE_SYS_AUDIOIO_H 1\n";
    }
    
    if ($os eq "SunOS") {
	print CONFIG "#define HAVE_STRINGS_H 1\n";
    }
    
    close CONFIG;
    print "configured for $os\n";
}

