/* filebrowser.c - draws an interactive file browser
   Copyright (C) 1996-2000 Paul Sheer

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
   02111-1307, USA.
 */

#include <config.h>
#include <stdio.h>
#include <my_string.h>
#include <stdlib.h>
#include <stdarg.h>

#include <sys/types.h>
#include <sys/stat.h>

#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

#ifdef HAVE_FCNTL_H
#include <fcntl.h>
#endif

#include <X11/Intrinsic.h>
#include "lkeysym.h"

#include "stringtools.h"
#include "app_glob.c"

#include "coolwidget.h"
#include "editcmddef.h"

#include "mad.h"

extern struct look *look;

#define GETFILE_GET_DIRECTORY		1
#define GETFILE_GET_EXISTING_FILE	2
#define GETFILE_BROWSER			4

#define FILE_BROWSER_START_WIDTH	40
#define FILE_BROWSER_START_HEIGHT	15

int option_file_browser_width = FILE_BROWSER_START_WIDTH;
int option_file_browser_height = FILE_BROWSER_START_HEIGHT;

void CDrawBrowser (const char *ident, Window parent, int x, int y,
		   const char *dir, const char *file, const char *label)
{
    (*look->draw_browser) (ident, parent, x, y, dir, file, label);
}

char *CGetFile (Window parent, int x, int y,
		const char *dir, const char *file, const char *label)
{
    return (*look->get_file_or_dir) (parent, x, y, dir, file, label, 0);
}

char *CGetDirectory (Window parent, int x, int y,
		     const char *dir, const char *file, const char *label)
{
    return (*look->get_file_or_dir) (parent, x, y, dir, file, label, GETFILE_GET_DIRECTORY);
}

char *CGetSaveFile (Window parent, int x, int y,
		    const char *dir, const char *file, const char *label)
{
    return (*look->get_file_or_dir) (parent, x, y, dir, file, label, 0);
}

char *CGetLoadFile (Window parent, int x, int y,
		    const char *dir, const char *file, const char *label)
{
    return (*look->get_file_or_dir) (parent, x, y, dir, file, label, GETFILE_GET_EXISTING_FILE);
}


