#ifndef _NAP_WINIO_H
#define _NAP_WINIO_H

/* Copyright (c) 2000  Kevin Sullivan <nite@gis.net>
 *
 * Please refer to the COPYRIGHT file for more information.
 */

#include "cmds.h"

#define MAIN_SCREEN 0
#define RESULT_SCREEN 1

struct colortab_s 
{
  const char *in;
  int pair, c;
};
typedef struct colortab_s colortab_t;

struct cmds_s 
{
  char *cmd;
  struct cmds_s *prev;
  struct cmds_s *next;
};
typedef struct cmds_s cmds_t;

/* a "scroll list" entry (i.e., a line in the main srcoll) */
struct scrls_s
{
  unsigned char ln[256];     /* the line, null terminated? */
  unsigned char ddd;         /* 2 to mark the output of /lastlog
				(these will not be matched by the next
				/lastlog). 0 if? 1 if? */
  chans_t *chan;             /* current channel at this line (not used) */
  struct scrls_s *own;       /* ? */
  struct scrls_s *prev;      /* doubly linked */
  struct scrls_s *next;      /* doubly linked */
};
typedef struct scrls_s scrls_t;


#ifndef MCURSES
void resize(void);
#endif

int switchtoscreen(int n);
void mainscr(void);
void wstats(WINDOW *);
void drw(WINDOW *);
void dstatus(void);
void addlog(char *, char *, unsigned char);
int wp(WINDOW *, const char *, ...);
scrls_t *scrend(scrls_t *);
void addscroll(WINDOW *, char *);
void dscr(WINDOW *);
void dscroll(WINDOW *, int);
int doesc(WINDOW *, const char *);
int cmdcnt(cmds_t *);
cmds_t *cmdend(cmds_t *);
int input(WINDOW *, sock_t *);
void initwin(unsigned char);
void indraw(void);
unsigned char gchr(WINDOW *);

#endif /* not _NAP_WINIO_H */
