#ifndef _NAP_ALIAS_H
#define _NAP_ALIAS_H

/* Copyright (c) 2000  Kevin Sullivan <nite@gis.net>
 *
 * Please refer to the COPYRIGHT file for more information.
 */


struct alias_s 
{
  unsigned char *nm;
  unsigned char *args;
  struct alias_s *next;
};
typedef struct alias_s alias_t;

/* holds an assignment of variables to values */
struct sets_s 
{
  unsigned char *nm;   /* name of this variable */
  char *d;             /* string value */
  int t;               /* 0 if d represents a number, 1 otherwise */
  long int intval;     /* numeric value of d, or 0 if not a number */
  struct sets_s *next;
};
typedef struct sets_s sets_t;


char *ins(char *, char *, int, int);
void prt(char **);
unsigned char *dovars(unsigned char *);
char **form_vtoks(char *, int *);
unsigned char *doalias(alias_t *, char **, int);
int savealiases(char *);
int loadaliases(char *);
int loadsets(const char *, WINDOW *, int, int);
int savesets(const char *);
void printsets(WINDOW *win);
void addset(const char *, const char *);
void chset(const char *, const char *);
sets_t *findset(const char *);
char *getval(const char *);
char *getrealval(const char *);
char *getval_t(const char *, int *);
char *getval_t_r(const char *, int *, int);
void delset(const char *);
long nvar(const char *);
char *strev(char *, unsigned char, unsigned char, char *(*)());
char *cmp(char *);

#endif
