/*
** THIS FILE IS A COPY OF A KGI-LEVEL HARDWARE DESCRIPTION HEADER FILE
**
** THIS IS NOT THE REFERENCE FILE,  ortalo 2002/12/11
**
*/

/* ----------------------------------------------------------------------------
**	Matrox Gx00 register definitions
** ----------------------------------------------------------------------------
**	Copyright (C)	1999-2002	Johan Karlberg
**					Rodolphe Ortalo
**
**	This file is distributed under the terms and conditions of the 
**	MIT/X public license. Please see the file COPYRIGHT.MIT included
**	with this software for details of these terms and conditions.
**
** ----------------------------------------------------------------------------
**	MAINTAINER	Rodolphe_Ortalo
**
**	$Id: Gx00.h,v 1.1 2002/12/23 13:17:35 ortalo Exp $
*/
#ifndef _Matrox_Gx00_h_2
#define _Matrox_Gx00_h_2

/* PCI config region */

#ifndef PCI_VENDOR_ID_MATROX
#	define PCI_VENDOR_ID_MATROX 0x102B
#endif

#ifndef PCI_DEVICE_ID_MATROX_MYS
#	define PCI_DEVICE_ID_MATROX_MYS 0x051A
#endif

#ifndef PCI_DEVICE_ID_MATROX_G200_PCI
#	define PCI_DEVICE_ID_MATROX_G200_PCI 0x0520
#endif

#ifndef PCI_DEVICE_ID_MATROX_G200_AGP
#	define PCI_DEVICE_ID_MATROX_G200_AGP 0x0521
#endif

#ifndef PCI_DEVICE_ID_MATROX_G400
#	define PCI_DEVICE_ID_MATROX_G400 0x0525
#endif

#ifndef PCI_DEVICE_ID_MATROX_G550
#	define PCI_DEVICE_ID_MATROX_G550 0x2527
#endif

/* power management */
#define MGAG_PCI_PM_CSR 0xE0

/* the options register is a mess. */

#define MGAG_PCI_OPTION1 0x40

/* common */

#	define MGAG_O1_SYSCLKDIS	(0x01 << 2)
#	define MGAG_O1_SYSPLLPDN	(0x01 << 5)
#	define MGAG_O1_VGAIOEN		(0x01 << 8)
#	define MGAG_O1_HARDPWMSK	(0x01 << 14)
#	define MGAG_O1_NORETRY		(0x01 << 29)
#	define MGAG_O1_BIOSEN		(0x01 << 30)
#	define MGAG_O1_POWERPC		(0x01 << 31)

/* 1x64 ONLY */

#	define M1x64_O1_SYSCLKSEL_SHIFT	0
#	define M1x64_O1_SYSCLKSEL_MASK	(0x03 << M1x64_O1_SYSCLKSEL_SHIFT)
#	define M1x64_O1_SYSCLKSEL_PCI	(0x00 << M1x64_O1_SYSCLKSEL_SHIFT)
#	define M1x64_O1_SYSCLKSEL_SYS	(0x01 << M1x64_O1_SYSCLKSEL_SHIFT)
#	define M1x64_O1_SYSCLKSEL_EXT	(0x02 << M1x64_O1_SYSCLKSEL_SHIFT)
#	define M1x64_O1_GCLKDIV		(0x01 << 3)
#	define M1x64_O1_MCLKDIV		(0x01 << 4)
#	define M1x64_O1_FBMASKN_SHIFT	9
#	define M1x64_O1_FBMASKN_MASK	(0x07 << M1x64_O1_FBMASKN_SHIFT)
#	define M1x64_O1_MEMCONFIG	(0x01 << 12)
#	define M1x64_O1_SPLITMODE	(0x01 << 13)
#	define M1x64_O1_UNIMEM		(0x01 << 15)
#	define M1x64_O1_RFHCNT_SHIFT	16
#	define M1x64_O1_RFHCNT_MASK	(0x0F << M1x64_O1_RFHCNT_SHIFT)
#	define M1x64_O1_EEPROMWT	(0x01 << 20)
#	define M1x64_O1_PRODUCTID_SHIFT	24
#	define M1x64_O1_PRODUCTID_MASK	(0x1F << M1x64_O1_PRODUCTID_SHIFT)

/* G200 ONLY */

#	define G200_O1_SYSCLKSEL_SHIFT	0
#	define G200_O1_SYSCLKSEL_MASK	(0x03 << G200_O1_SYSCLKSEL_SHIFT)
#	define G200_O1_SYSCLKSEL_PCI	(0x00 << G200_O1_SYSCLKSEL_SHIFT)
#	define G200_O1_SYSCLKSEL_SYS	(0x01 << G200_O1_SYSCLKSEL_SHIFT)
#	define G200_O1_SYSCLKSEL_EXT	(0x02 << G200_O1_SYSCLKSEL_SHIFT)
#	define G200_O1_GCLKDIV		(0x01 <<  3)
#	define G200_O1_MCLKDIV		(0x01 <<  4)
#	define G200_O1_PLLSEL		(0x01 <<  6)
#	define G200_O1_MEMCONFIG_SHIFT	10
#	define G200_O1_MEMCONFIG_MASK	(0x07 << G200_O1_MEMCONFIG_SHIFT)
#	define G200_O1_RFHCNT_SHIFT	15
#	define G200_O1_RFHCNT_MASK	(0x3F << G200_O1_RFHCNT_SHIFT)
#	define G200_O1_ENHMEMACC	(0x01 << 22)

/* G400 ONLY */

#	define G400_O1_PLLSEL		(0x01 << 6)
#	define G400_O1_MEMCONFIG_SHIFT	10
#	define G400_O1_MEMCONFIG_MASK	(0x07 << G400_O1_MEMCONFIG_SHIFT)
#	define G400_O1_RFHCNT_SHIFT	15
#	define G400_O1_RFHCNT_MASK	(0x3F << G400_O1_RFHCNT_SHIFT)
#	define G400_O1_ENHMEMACC	(0x01 << 22)
#	define G400_O1_NOHIREQ		(0x01 << 28)

#define MGAG_PCI_OPTION2 0x50

/* common */

#	define MGAG_O2_EEPROMWT		(0x01 << 8)
#	define MGAG_O2_MODCLKP_SHIFT	19
#	define MGAG_O2_MODCLKP_MASK	(0x07 << MGAG_O2_MODCLKP_SHIFT)

/* G200 ONLY */

#	define G200_O2_MBUFTYPE0	(0x01 << 12)
#	define G200_O2_MBUFTYPE1	(0x01 << 13)
#	define G200_O2_NOGCLKDIV	(0x01 << 14)
#	define G200_O2_NOMCLKDIV	(0x01 << 15)
#	define G200_O2_NOWCLKDIV	(0x01 << 16)
#	define G200_O2_WCLKDIV		(0x01 << 17)

/* G400 ONLY */

#	define G400_O2_MOD2CLKP_SHIFT	16
#	define G400_O2_MOD2CLKP_MASK	(0x03 << G400_O2_MOD2CLKP_SHIFT)
#	define G400_O2_CODCLKSEL_SHIFT	24
#	define G400_O2_CODCLKSEL_MASK	(0x03 << G400_O2_CODCLKSEL_SHIFT)
#	define G400_O2_CODCLKSEL_PCI	(0x00 << G400_O2_CODCLKSEL_SHIFT)
#	define G400_O2_CODCLKSEL_SYS	(0x01 << G400_O2_CODCLKSEL_SHIFT)
#	define G400_O2_CODCLKSEL_MCLK	(0x02 << G400_O2_CODCLKSEL_SHIFT)
#	define G400_O2_CODCLKSEL_AGP	(0x03 << G400_O2_CODCLKSEL_SHIFT)
#	define G400_O2_CODPREDIV	(0x01 << 26)
#	define G400_O2_CODPSTDIV	(0x01 << 27)

#define MGAG_PCI_OPTION3 0x54

/* G400 ONLY */

#	define G400_O3_GCLKSEL_SHIFT	0
#	define G400_O3_GCLKSEL_MASK	(0x03 << G400_O3_GCLKSEL_SHIFT)
#	define G400_O3_GCLKSEL_PCI	(0x00 << G400_O3_GCLKSEL_SHIFT)
#	define G400_O3_GCLKSEL_SYS	(0x01 << G400_O3_GCLKSEL_SHIFT)
#	define G400_O3_GCLKSEL_MCLK	(0x02 << G400_O3_GCLKSEL_SHIFT)
#	define G400_O3_GCLKSEL_AGP	(0x03 << G400_O3_GCLKSEL_SHIFT)
#	define G400_O3_GCLKDIV_SHIFT	3
#	define G400_O3_GCLKDIV_2_5	(0x01 << G400_O3_GCLKDIV_SHIFT)
#	define G400_O3_GCLKDIV_MASK	(0x07 << G400_O3_GCLKDIV_SHIFT)
#	define G400_O3_GCLKDCYC_SHIFT	6
#	define G400_O3_GCLKDCYC_MASK	(0x0F << G400_O3_GCLKDCYC_SHIFT)
#	define G400_O3_MCLKSEL_SHIFT	10
#	define G400_O3_MCLKSEL_MASK	(0x03 << G400_O3_MCLKSEL_SHIFT)
#	define G400_O3_MCLKSEL_PCI	(0x00 << G400_O3_MCLKSEL_SHIFT)
#	define G400_O3_MCLKSEL_SYS	(0x01 << G400_O3_MCLKSEL_SHIFT)
#	define G400_O3_MCLKSEL_MCLK	(0x02 << G400_O3_MCLKSEL_SHIFT)
#	define G400_O3_MCLKSEL_AGP	(0x03 << G400_O3_MCLKSEL_SHIFT)
#	define G400_O3_MCLKDIV_SHIFT	13
#	define G400_O3_MCLKDIV_BYPASS	(0x05 << G400_O3_MCLKDIV_SHIFT)
#	define G400_O3_MCLKDIV_MASK	(0x07 << G400_O3_MCLKDIV_SHIFT)
#	define G400_O3_MCLKDCYC_SHIFT	16
#	define G400_O3_MCLKDCYC_MASK	(0x0F << G400_O3_MCLKDCYC_SHIFT)
#	define G400_O3_WCLKSEL_SHIFT	20
#	define G400_O3_WCLKSEL_MASK	(0x03 << G400_O3_WCLKSEL_SHIFT)
#	define G400_O3_WCLKSEL_PCI	(0x00 << G400_O3_WCLKSEL_SHIFT)
#	define G400_O3_WCLKSEL_SYS	(0x01 << G400_O3_WCLKSEL_SHIFT)
#	define G400_O3_WCLKSEL_MCLK	(0x02 << G400_O3_WCLKSEL_SHIFT)
#	define G400_O3_WCLKSEL_AGP	(0x03 << G400_O3_WCLKSEL_SHIFT)
#	define G400_O3_WCLKDIV_SHIFT	23
#	define G400_O3_WCLKDIV_2_5	(0x01 << G400_O3_WCLKDIV_SHIFT)
#	define G400_O3_WCLKDIV_MASK	(0x07 << G400_O3_WCLKDIV_SHIFT)
#	define G400_O3_WCLKDCYC_SHIFT	26
#	define G400_O3_WCLKDCYC_MASK	(0x0F << G400_O3_WCLKDCYC_SHIFT)

/* Gx50 only! */

#define MGAG_PCI_MEMMISC 0x58

#define MGAG_MGABASE1_SIZE	(0x01 << 14)	/* 16K */
#define MGAG_MGABASE3_SIZE	(0x01 << 23)	/* 8MB */
#define MGAG_ROM_SIZE           0x10000

#define M1x64_MGABASE2_SIZE	(0x01 << 23)	/* 8M */
#define  G200_MGABASE2_SIZE	(0x01 << 24)	/* 16M */
#define  G400_MGABASE2_SIZE	(0x01 << 25)	/* 32M */
/* TODO: Check update for G550 */
#define  G550_MGABASE2_SIZE	G400_MGABASE2_SIZE

/* control aperture */

#define MGAG_DMAWIN	0x0000
#define MGAG_DWGREG0	0x1C00
#define	MGAG_HSTREG	0x1E00
#define MGAG_VGAREG	0x1F00
#define MGAG_WIMEMDATA	0x2000
#define MGAG_DWGREG1	0x2C00
#define	MGAG_RAMDAC	0x3C00
#define	MGAG_BESREG	0x3D00
#define	MGAG_VINCODEC	0x3E00

/* register map */

/* Host configuration registers. */

#define FIFOSTATUS				(MGAG_HSTREG+0x10)	/* RO */
#	define FIFO_COUNT_MASK			0x7F
#	define FIFO_BFULL			0x100
#	define FIFO_BEMPTY			0x200

#define STATUS					(MGAG_HSTREG+0x14)
#	define STATUS_SOFTRAPEN			(0x01 << 0)	/* RO */
#	define STATUS_PICKPEN			(0x01 << 2)	/* RO */
#	define STATUS_VSYNCSTS			(0x01 << 3)	/* RO */
#	define STATUS_VSYNCPEN			(0x01 << 4)	/* RO */
#	define STATUS_VLINEPEN			(0x01 << 5)	/* RO */
#	define STATUS_EXTPEN			(0x01 << 6)	/* RO */
#	define STATUS_WPEN			(0x01 << 7)	/* RO, G200+ */
#	define STATUS_WCPEN			(0x01 << 8)	/* RO, G200+ */
#	define STATUS_C2VLINEPEN		(0x01 << 9)	/* RO, G400+ */
#	define STATUS_WPEN1			(0x01 << 10)	/* G400+ */
#	define STATUS_WCPEN1			(0x01 << 11)	/* G400+ */
#	define STATUS_DWGENGSTS			(0x01 << 16)	/* RO */
#	define STATUS_ENDPRDMASTS		(0x01 << 17)	/* RO */
#	define STATUS_WBUSY			(0x01 << 18)	/* RO, G200+ */
#	define STATUS_WBUSY1			(0x01 << 19)	/* RO, G400+ */
#	define STATUS_WARPBFPATH		(0x01 << 20)	/* RO, G400+ */
#	define STATUS_WFIPATH			(0x01 << 21)	/* RO, G400+ */
#	define STATUS_WFOPATH			(0x01 << 22)	/* RO, G400+ */
#	define STATUS_SWFLAG_SHIFT		28				/* G200+ */
#	define STATUS_SWFLAG_MASK		(0x0F << STAT_SWFLAG_SHIFT)	/* G200+ */

#define ICLEAR					(MGAG_HSTREG+0x18)	/* WO */
#	define ICLEAR_SOFTRAPICLR		(0x01 << 0)	/* RO */
#	define ICLEAR_PICKPICLR			(0x01 << 2)	/* RO */
#	define ICLEAR_VSYNCICLR			(0x01 << 4)	/* RO */
#	define ICLEAR_VLINEICLR			(0x01 << 5)	/* RO */
#	define ICLEAR_EXTICLR			(0x01 << 6)	/* RO */
#	define ICLEAR_WICLR			(0x01 << 7)	/* RO, G200+ */
#	define ICLEAR_WCICLR			(0x01 << 8)	/* RO, G200+ */
#	define ICLEAR_C2VLINEICLR		(0x01 << 9)	/* RO, G400+ */
#	define ICLEAR_WICLR1			(0x01 << 10)	/* G400+ */
#	define ICLEAR_WCICLR1			(0x01 << 11)	/* G400+ */

#define IEN					(MGAG_HSTREG+0x1C)
#	define IEN_SOFTRAPIEN			(0x01 << 0)	/* RO */
#	define IEN_PICKPIEN			(0x01 << 2)	/* RO */
/* Check if the following really exists (in CRTC11 I think) -- ortalo */
#	define IEN_VSYNCIEN			(0x01 << 4)	/* RO */
#	define IEN_VLINEIEN			(0x01 << 5)	/* RO */
#	define IEN_EXTIEN			(0x01 << 6)	/* RO */
#	define IEN_WIEN				(0x01 << 7)	/* RO, G200+ */
#	define IEN_WCIEN			(0x01 << 8)	/* RO, G200+ */
#	define IEN_C2VLINEIEN			(0x01 << 9)	/* RO, G400+ */
#	define IEN_WIEN1			(0x01 << 10)	/* G400+ */
#	define IEN_WCIEN1			(0x01 << 11)	/* G400+ */

#define VCOUNT					(MGAG_HSTREG+0x20)	/* RO */
#define DMAMAP30				(MGAG_HSTREG+0x30)
#define DMAMAP74				(MGAG_HSTREG+0x34)
#define DMAMAPB8				(MGAG_HSTREG+0x38)
#define DMAMAPFC				(MGAG_HSTREG+0x3C)

#define RST					(MGAG_HSTREG+0x40)
#define RST_SOFTRESET  0x1
#define RST_SOFTEXTRST 0x2

#define MEMRDBK					(MGAG_HSTREG+0x44)	/* G200+ */
#	define MCLKBRD0_SHIFT			0
#	define MCLKBRD0_MASK			(0x0F << MCLKBRD0_SHIFT)
#	define MCLKBRD1_SHIFT			5
#	define MCLKBRD1_MASK			(0x0F << MCLKBRD1_SHIFT)
#	define STRMFCTL_SHIFT			22
#	define STRMFCTL_MASK			(0x03 << STRMFCTL_SHIFT)
#	define MRSOPCOD_SHIFT			25
#	define MRSOPCOD_MASK			(0x0F << MRSOPCOD_SHIFT)

#define TEST0					(MGAG_HSTREG+0x48)	/* G200+ */
#define TEST1					(MGAG_HSTREG+0x0C)	/* G400+ */
#define AGP_PLL					(MGAG_HSTREG+0x4C)	/* G200+ */
#define PRIMPTR					(MGAG_HSTREG+0x50)	/* G200+ */

#define OPMODE					(MGAG_HSTREG+0x54)
#	define OPMODE_DMAMOD_SHIFT		2
#	define OPMODE_DMAMOD_MASK		(0x03 << OPMODE_DMAMOD_SHIFT)
#	define OPMODE_DMAMOD_GENERAL_WRITE	(0x00 << OPMODE_DMAMOD_SHIFT)
#	define OPMODE_DMAMOD_BLIT_WRITE		(0x01 << OPMODE_DMAMOD_SHIFT)
#	define OPMODE_DMAMOD_VECTOR_WRITE	(0x02 << OPMODE_DMAMOD_SHIFT)
#	define OPMODE_DMAMOD_VERTEX_WRITE	(0x03 << OPMODE_DMAMOD_SHIFT)	/* G200+ */
#	define OPMODE_DMADATASIZ_SHIFT		8
#	define OPMODE_DMADATASIZ_MASK		(0x03 << OPMODE_DMADATASIZ_SHIFT)
#	define OPMODE_DMADATASIZ_LE		(0x00 << OPMODE_DMADATASIZ_SHIFT)
#	define OPMODE_DMADATASIZ_BE_8BPP	(0x00 << OPMODE_DMADATASIZ_SHIFT)
#	define OPMODE_DMADATASIZ_BE_16BPP	(0x01 << OPMODE_DMADATASIZ_SHIFT)
#	define OPMODE_DMADATASIZ_LE_32BPP	(0x02 << OPMODE_DMADATASIZ_SHIFT)
#	define OPMODE_DIRDATASIZ_SHIFT		16
#	define OPMODE_DIRDATASIZ_MASK		(0x03 << OPMODE_DIRDATASIZ_SHIFT)
#	define OPMODE_DIRDATASIZ_LE		(0x00 << OPMODE_DMADATASIZ_SHIFT)
#	define OPMODE_DIRDATASIZ_BE_8BPP	(0x00 << OPMODE_DMADATASIZ_SHIFT)
#	define OPMODE_DIRDATASIZ_BE_16BPP	(0x01 << OPMODE_DMADATASIZ_SHIFT)
#	define OPMODE_DIRDATASIZ_LE_32BPP	(0x02 << OPMODE_DMADATASIZ_SHIFT)

#define PRIMADDRESS	(MGAG_HSTREG+0x58)	/* G200+ */
#define PRIMADDRESS_DMAMOD_MASK  0x00000003
#define PRIMADDRESS_DMAMOD_GENERAL_WRITE 0x00
#define PRIMADDRESS_DMAMOD_BLIT_WRITE    0x01
#define PRIMADDRESS_DMAMOD_VECTOR_WRITE  0x02
#define PRIMADDRESS_DMAMOD_VERTEX_WRITE  0x03
#define PRIMADDRESS_ADDRESS_MASK 0xFFFFFFFC

#define PRIMEND		(MGAG_HSTREG+0x5C)	/* G200+ */
#define PRIMEND_PRIMNOSTART (0x01 << 0)
#define PRIMEND_PAGPXFER    (0x01 << 1)
#define PRIMEND_ADDRESS_MASK 0xFFFFFFFC

/* Indirect write, there are 16 of these 32bits apart. */

#define DWG_INDIR_WT	(MGAG_HSTREG+0x80)	/* WO */

#define CACHEFLUSH	(MGAG_VGAREG+0xFF)


/* VGA compatibility registers */

#define ECRT0					0x00
#	define ECRT0_STARTADD0_SHIFT		0
#	define ECRT0_STARTADD0_MASK		(0x0F << ECRT0_STARTADD0_SHIFT)
#	define ECRT0_OFFSET_SHIFT		4
#	define ECRT0_OFFSET_MASK		(0x07 << ECRT0_OFFSET_SHIFT)
#	define ECRT0_INTERLACE			(0x01 << 7)
#	define ECRT0_STARTADD1_SHIFT		6				/* G200+ */
#	define ECRT0_STARTADD1_MASK		(0x01 << ECRT0_STARTADD1_SHIFT)	/* G200+ */

#define ECRT1					0x01
#	define ECRT1_HTOTAL_SHIFT		0
#	define ECRT1_HTOTAL_MASK		(0x01 << ECRT1_HTOTAL_SHIFT)
#	define ECRT1_HBLKSTR_SHIFT		1
#	define ECRT1_HBLKSTR_MASK		(0x01 << ECRT1_HBLKSTR_SHIFT)
#	define ECRT1_HSYNCSTR_SHIFT		2
#	define ECRT1_HSYNCSTR_MASK		(0x01 << ECRT1_HSYNCSTR_SHIFT)
#	define ECRT1_HRSTEN			(0x01 << 3)
#	define ECRT1_HSYNCOFF			(0x01 << 4)
#	define ECRT1_VSYNCOFF			(0x01 << 5)
#	define ECRT1_HBLKEND_SHIFT		6
#	define ECRT1_HBLKEND_MASK		(0x01 << ECRT1_HBLKEND_SHIFT)
#	define ECRT1_VRSTEN			(0x01 << 7)

#define ECRT2					0x02
#	define ECRT2_VTOTAL_SHIFT		0
#	define ECRT2_VTOTAL_MASK		(0x03 << ECRT2_VTOTAL_SHIFT)
#	define ECRT2_VDISPEND_SHIFT		2
#	define ECRT2_VDISPEND_MASK		(0x01 << ECRT2_VDISPEND_SHIFT)
#	define ECRT2_VBLKSTR_SHIFT		4
#	define ECRT2_VBLKSTR_MASK		(0x03 << ECRT2_VBLKSTR_SHIFT)
#	define ECRT2_VSYNCSTR_SHIFT		6
#	define ECRT2_VSYNCSTR_MASK		(0x03 << ECRT2_VSYNCSTR_SHIFT)
#	define ECRT2_LINECOMP_SHIFT		7
#	define ECRT2_LINECOMP_MASK		(0x01 << ECRT2_LINECOMP_SHIFT)

#define ECRT3					0x03
#	define ECRT3_SCALE_SHIFT		0
#	define ECRT3_SCALE_MASK			(0x07 << ECRT3_SCALE_SHIFT)
#	define ECRT3_SLOW256			(0x01 << 5)
#	define ECRT3_CSYNCEN			(0x01 << 6)
#	define ECRT3_MGAMODE			(0x01 << 7)

#define ECRT4					0x04
#define ECRT5					0x05

#define ECRT6					0x06
#	define ECRT6_HIPRILVL_SHIFT		0
#	define ECRT6_HIPRILVL_MASK		(0x01 << ECRT6_HIPRILVL_SHIFT)
#	define ECRT6_MAXHIPRI_SHIFT		4
#	define ECRT6_MAXHIPRI_MASK		(0x01 << ECRT6_MAXHIPRI_SHIFT)

#define ECRT7					0x07
#	define ECRT7_CRTCBLK0			0x01				/* G200 ONLY */
#	define ECRT7_WINSIZE_SHIFT		3				/* G400 ONLY */
#	define ECRT7_WINSIZE_MASK		(0x07 << ECRT7_WINSIZE_SHIFT)	/* G400 ONLY */
#	define ECRT7_WINFREQ_SHIFT		7				/* G400 ONLY */
#	define ECRT7_WINFREQ_MASK		(0x07 << ECRT7_WINFREQ_SHIFT)	/* G400 ONLY */

#define ECRT8					0x08	/* G400 ONLY */
#	define ECRT8_STARTADD21_SHIFT		0
#	define ECRT8_STARTADD21_MASK		(0x01 << ECRT8_STARTADD21_SHIFT)
#	define ECRT8_PAGE8_SHIFT		4
#	define ECRT8_PAGE8_MASK			(0x01 << ECRT8_PAGE8_SHIFT)

#define MMIO_MISCr				(MGAG_VGAREG+0xCC)
#define MMIO_MISCw				(MGAG_VGAREG+0xC2)
#define MMIO_SEQi				(MGAG_VGAREG+0xC4)
#define MMIO_SEQd				(MGAG_VGAREG+0xC5)
#define MMIO_FEATr				(MGAG_VGAREG+0xCA)
#define MMIO_FEATw				(MGAG_VGAREG+0xDA)
#define MMIO_CRTCi				(MGAG_VGAREG+0xD4)
#define MMIO_CRTCd				(MGAG_VGAREG+0xD5)
#define MMIO_INSTS0r				(MGAG_VGAREG+0xC2)
#define MMIO_INSTS1r				(MGAG_VGAREG+0xDA)
#define MMIO_DACSTATr				(MGAG_VGAREG+0xC7) /* Byte access only */
#define MMIO_CRTCEXTi				(MGAG_VGAREG+0xDE)
#define MMIO_CRTCEXTd				(MGAG_VGAREG+0xDF)

/* leftover, is this standard enough to be in VGA.h? */

#define MISC_CLOCK_1X				0x08

/*
** DAC registers
*/

/* Pseudo-DAC registers: access to pointer shapes */
#define POINTER_FB_AREA_SIZE (1 KB)
#define PX_POINTER1       0x10000000
#define PX_POINTER2       0x20000000
#define PX_POINTER3       0x40000000 /* etc. if wanted... */

/* Extended DAC definitions */

#define	PALWTADD				0x00
#define	PALDATA					0x01
#define	PIXRDMSK				0x02
#define	PALRDADD				0x03
#define	X_DATAREG				0x0A

#define	CURPOS					0x0C
#define	CURPOSXL				(CURPOS+0x00)
#define	CURPOSXH				(CURPOS+0x01)
#define	CURPOSYL				(CURPOS+0x02)
#define	CURPOSYH				(CURPOS+0x03)

#define C2CTL					0x10	/* G400+ */
#define C2HPARAM				0x14	/* G400+ */
#define C2HSYNC					0x18	/* G400+ */
#define C2VPARAM				0x1C	/* G400+ */
#define C2VSYNC					0x20	/* G400+ */
#define C2PRELOAD				0x24	/* G400+ */
#define C2STARTADD0				0x28	/* G400+ */
#define C2STARTADD1				0x2C	/* G400+ */
#define C2PL2STARTADD0				0x30	/* G400+ */
#define C2PL2STARTADD1				0x34	/* G400+ */
#define C2PL3STARTADD0				0x38	/* G400+ */
#define C2PL3STARTADD1				0x3C	/* G400+ */
#define C2OFFSET				0x40	/* G400+ */
#define C2MISC					0x44	/* G400+ */
#define C2VCOUNT				0x48	/* G400+ */
#define C2DATACTL				0x4C	/* G400+ */
#define C2SUBPICLUT				0x50	/* G400+ */
#define C2PICSTARTADD0				0x54	/* G400+ */
#define C2PICSTARTADD1				0x58	/* G400+ */

/* Indexed registers */

#define	XCURADDL				0x04
#define	XCURADDH				0x05

#define	XCURCTRL				0x06
#	define CUR_DIS				0x00
#	define CUR_3_COL			0x01
#	define CUR_XGA				0x02
#	define CUR_X				0x03
#	define CUR_16_COL			0x04

#define	XVREFCTRL				0x18

#define	XMULCTRL				0x19
#	define MUL_8_PAL			0x00
#	define MUL_15_PAL			0x01
#	define MUL_16_PAL			0x02
#	define MUL_24_PAL			0x03
#	define MUL_32_DIR			0x04
#	define MUL_32_PAL			0x07

#define	XPIXCLKCTRL				0x1A
#	define XPIXCLKCTRL_PIXCLKSEL_SHIFT	0
#	define XPIXCLKCTRL_PIXCLKSEL_MASK	(0x03 << XPIXCLKCTRL_PIXCLKSEL_SHIFT)
#	define XPIXCLKCTRL_PIXCLKSEL_PCI	(0x00 << XPIXCLKCTRL_PIXCLKSEL_SHIFT)
#	define XPIXCLKCTRL_PIXCLKSEL_PIXPLL	(0x01 << XPIXCLKCTRL_PIXCLKSEL_SHIFT)
#	define XPIXCLKCTRL_PIXCLKSEL_VDO	(0x02 << XPIXCLKCTRL_PIXCLKSEL_SHIFT)
#	define XPIXCLKCTRL_PIXCLKSEL_SYSPLL	(0x03 << XPIXCLKCTRL_PIXCLKSEL_SHIFT)	/* G400+ */
#	define XPIXCLKCTRL_PIXCLKDIS		(0x01 << 2)
#	define XPIXCLKCTRL_PIXPLLPDN		(0x01 << 3)

#define	XGENCTRL				0x1D
#	define XGENCTRL_VS			(0x01 << 0)	/* 1x64 ONLY */
#	define XGENCTRL_ALPHAEN			(0x01 << 1)
#	define XGENCTRL_PEDON			(0x01 << 4)
#	define XGENCTRL_IOGSYNCDIS		(0x01 << 5)

#define XMISCCTRL				0x1E
#	define XMISCCTRL_DACPDN			(0x01 << 0)
#	define XMISCCTRL_MCFSEL_SHIFT		1
#	define XMISCCTRL_MCFSEL_MASK		(0x03 << XMISCCTRL_MCFSEL_SHIFT)
#	define XMISCCTRL_MCFSEL_VGA		(0x00 << XMISCCTRL_MCFSEL_SHIFT)
#	define XMISCCTRL_MCFSEL_MAFC		(0x01 << XMISCCTRL_MCFSEL_SHIFT)
#	define XMISCCTRL_MCFSEL_DIS		(0x03 << XMISCCTRL_MCFSEL_SHIFT)
#	define XMISCCTRL_MCFSEL_PLM		(0x02 << XMISCCTRL_MCFSEL_SHIFT)	/* G200+ */
#	define XMISCCTRL_VGA8DAC		(0x01 << 3)
#	define XMISCCTRL_RAMCS			(0x01 << 4)
#	define XMISCCTRL_VDOUTSEL_SHIFT		5
#	define XMISCCTRL_VDOUTSEL_G200_MASK	(0x03 << XMISCCTRL_VDOUTSEL_SHIFT)
#	define XMISCCTRL_VDOUTSEL_G400_MASK	(0x07 << XMISCCTRL_VDOUTSEL_SHIFT)
#	define XMISCCTRL_VDOUTSEL_MAFC12	(0x00 << XMISCCTRL_VDOUTSEL_SHIFT)
#	define XMISCCTRL_VDOUTSEL_BYPASS656	(0x02 << XMISCCTRL_VDOUTSEL_SHIFT)
#	define XMISCCTRL_VDOUTSEL_2NDMAFC12	(0x04 << XMISCCTRL_VDOUTSEL_SHIFT)	/* G400+ */
#	define XMISCCTRL_VDOUTSEL_2NDBYPASS656	(0x06 << XMISCCTRL_VDOUTSEL_SHIFT)	/* G400+ */

#define XPANELMODE				0x1F	/* G400+ */
#define XMAFCDEL				0x20	/* G400+ */
#define XGENIOCTRL				0x2A
#define XGENIODATA				0x2B
#define XSYSPLLM				0x2C
#define XSYSPLLN				0x2D
#define XSYSPLLP				0x2E
#define XSYSPLLSTAT				0x2F	/* RO */
#	define XSYSPLLSTAT_SYSLOCK		(0x01 << 6)

#define XZOOMCTRL				0x38
#	define XZOOMCTRL_HZOOM_SHIFT		0
#	define XZOOMCTRL_HZOOM_MASK		(0x03 << XZOOMCTRL_HZOOM_SHIFT)
#	define XZOOMCTRL_HZOOM_1X		(0x00 << XZOOMCTRL_HZOOM_SHIFT)
#	define XZOOMCTRL_HZOOM_2X		(0x01 << XZOOMCTRL_HZOOM_SHIFT)
#	define XZOOMCTRL_HZOOM_4X		(0x03 << XZOOMCTRL_HZOOM_SHIFT)

#define XSENSETEST				0x3A
#define XCRCREML				0x3C	/* RO */
#define XCRCREMH				0x3D	/* RO */
#define XCRCBITSEL				0x3E
#define XCOLMSK					0x40
#define XCOLKEY					0x42
#define XPIXPLLAM				0x44
#define XPIXPLLAN				0x45
#define XPIXPLLAP				0x46
#define XPIXPLLBM				0x48
#define XPIXPLLBN				0x49
#define XPIXPLLBP				0x4A

#define XPIXPLLCM				0x4C
#	define XPIXPLLM_PIXPLLM_SHIFT		0
#	define XPIXPLLM_PIXPLLM_MASK		(0x1F << XPIXPLLM_PIXPLLM_SHIFT)
#	define XPIXPLLM_MASK			XPIXPLLM_PIXPLLM_MASK

#define XPIXPLLCN				0x4D
#	define XPIXPLLN_PIXPLLN_SHIFT		0
#	define XPIXPLLN_PIXPLLN_MASK		(0x7F << XPIXPLLN_PIXPLLN_SHIFT)
#	define XPIXPLLN_MASK			XPIXPLLN_PIXPLLN_MASK

#define XPIXPLLCP				0x4E
#	define XPIXPLLP_PIXPLLP_SHIFT		0
#	define XPIXPLLP_PIXPLLP_MASK		(0x07 << XPIXPLLP_PIXPLLP_SHIFT)
#	define XPIXPLLP_PIXPLLS_SHIFT		3
#	define XPIXPLLP_PIXPLLS_MASK		(0x03 << XPIXPLLP_PIXPLLS_SHIFT)
#	define XPIXPLLP_MASK			(XPIXPLLP_PIXPLLP_MASK | XPIXPLLP_PIXPLLS_MASK)

#define XPIXPLLSTAT				0x4F	/* RO */
#	define XPIXPLLSTAT_PIXLOCK		(0x01 << 6)

#define XKEYOPMODE				0x51	/* G200+ */
#define XCOLMSK0RED				0x52	/* G200+ */
#define XCOLMSK0GREEN				0x53	/* G200+ */
#define XCOLMSK0BLUE				0x54	/* G200+ */
#define XCOLKEY0RED				0x55	/* G200+ */
#define XCOLKEY0GREEN				0x56	/* G200+ */
#define XCOLKEY0BLUE				0x57	/* G200+ */
#define	XCURCOL0RED				0x08
#define	XCURCOL0GREEN				0x09
#define	XCURCOL0BLUE				0x0A
#define	XCURCOL1RED				0x0C
#define	XCURCOL1GREEN				0x0D
#define	XCURCOL1BLUE				0x0E
#define	XCURCOL2RED				0x10
#define	XCURCOL2GREEN				0x11
#define	XCURCOL2BLUE				0x12
#define	XCURCOL3RED				0x60	/* G200+ */
#define	XCURCOL3GREEN				0x61	/* G200+ */
#define	XCURCOL3BLUE				0x62	/* G200+ */
#define	XCURCOL4RED				0x63	/* G200+ */
#define	XCURCOL4GREEN				0x64	/* G200+ */
#define	XCURCOL4BLUE				0x65	/* G200+ */
#define	XCURCOL5RED				0x66	/* G200+ */
#define	XCURCOL5GREEN				0x67	/* G200+ */
#define	XCURCOL5BLUE				0x68	/* G200+ */
#define	XCURCOL6RED				0x69	/* G200+ */
#define	XCURCOL6GREEN				0x6A	/* G200+ */
#define	XCURCOL6BLUE				0x6B	/* G200+ */
#define	XCURCOL7RED				0x6C	/* G200+ */
#define	XCURCOL7GREEN				0x6D	/* G200+ */
#define	XCURCOL7BLUE				0x6E	/* G200+ */
#define	XCURCOL8RED				0x6F	/* G200+ */
#define	XCURCOL8GREEN				0x70	/* G200+ */
#define	XCURCOL8BLUE				0x71	/* G200+ */
#define	XCURCOL9RED				0x72	/* G200+ */
#define	XCURCOL9GREEN				0x73	/* G200+ */
#define	XCURCOL9BLUE				0x74	/* G200+ */
#define	XCURCOL10RED				0x75	/* G200+ */
#define	XCURCOL10GREEN				0x76	/* G200+ */
#define	XCURCOL10BLUE				0x77	/* G200+ */
#define	XCURCOL11RED				0x78	/* G200+ */
#define	XCURCOL11GREEN				0x79	/* G200+ */
#define	XCURCOL11BLUE				0x7A	/* G200+ */
#define	XCURCOL12RED				0x7B	/* G200+ */
#define	XCURCOL12GREEN				0x7C	/* G200+ */
#define	XCURCOL12BLUE				0x7D	/* G200+ */
#define	XCURCOL13RED				0x7E	/* G200+ */
#define	XCURCOL13GREEN				0x7F	/* G200+ */
#define	XCURCOL13BLUE				0x80	/* G200+ */
#define	XCURCOL14RED				0x81	/* G200+ */
#define	XCURCOL14GREEN				0x82	/* G200+ */
#define	XCURCOL14BLUE				0x83	/* G200+ */
#define	XCURCOL15RED				0x84	/* G200+ */
#define	XCURCOL15GREEN				0x85	/* G200+ */
#define	XCURCOL15BLUE				0x86	/* G200+ */

/* following for Gx50+ it seems -- ortalo */
#define	XOUTPUTCONN				0x8A	/* Gx50+ */
#define	XSYNCCTRL				0x8B	/* Gx50+ */
/* Video engine definitions, taken from matroxfb */
#define	XVIDPLLSTAT				0x8C	/* Gx50+, RO */
#	define XVIDPLLSTAT_VIDLOCK		(0x01 << 6)
#define	XVIDPLLP				0x8D	/* Gx50+ */
#define	XVIDPLLM				0x8E	/* Gx50+ */
#define	XVIDPLLN				0x8F	/* Gx50+ */

#define	XPWRCTRL				0xA0	/* Gx50+ */

/* drawiung engine defintions */

#define DWGCTL					(MGAG_DWGREG0+0x00) /* WO */
#	define DWGCTL_OPCOD_SHIFT		0
#	define DWGCTL_OPCOD_MASK		(0x0F << DWGCTL_OPCOD_SHIFT)
#	define DWGCTL_OPCOD_LINE_OPEN		(0x00 << DWGCTL_OPCOD_SHIFT)
#	define DWGCTL_OPCOD_AUTOLINE_OPEN	(0x01 << DWGCTL_OPCOD_SHIFT)
#	define DWGCTL_OPCOD_LINE_CLOSE		(0x02 << DWGCTL_OPCOD_SHIFT)
#	define DWGCTL_OPCOD_AUTOLINE_CLOSE	(0x03 << DWGCTL_OPCOD_SHIFT)
#	define DWGCTL_OPCOD_TRAP		(0x04 << DWGCTL_OPCOD_SHIFT)
#	define DWGCTL_OPCOD_TEXTURE_TRAP	(0x06 << DWGCTL_OPCOD_SHIFT)
#	define DWGCTL_OPCOD_TRAP_ILOAD		(0x05 << DWGCTL_OPCOD_SHIFT)	/* 1x64 ONLY */
#	define DWGCTL_OPCOD_BITBLT		(0x08 << DWGCTL_OPCOD_SHIFT)
#	define DWGCTL_OPCOD_ILOAD		(0x09 << DWGCTL_OPCOD_SHIFT)
#	define DWGCTL_OPCOD_ILOAD_SCALE		(0x0D << DWGCTL_OPCOD_SHIFT)	/* 1x64 ONLY */
#	define DWGCTL_OPCOD_ILOAD_FILTER	(0x0F << DWGCTL_OPCOD_SHIFT)	/* 1x64 ONLY */
#	define DWGCTL_OPCOD_IDUMP		(0x0A << DWGCTL_OPCOD_SHIFT)	/* 1x64 ONLY */
#	define DWGCTL_OPCOD_ILOAD_HIQH		(0x07 << DWGCTL_OPCOD_SHIFT)	/* 1x64 ONLY */
#	define DWGCTL_OPCOD_ILOAD_HIQHV		(0x0E << DWGCTL_OPCOD_SHIFT)	/* 1x64 ONLY */
#	define DWGCTL_ATYPE_SHIFT		4
#	define DWGCTL_ATYPE_MASK		(0x07 << DWGCTL_ATYPE_SHIFT)
#	define DWGCTL_ATYPE_RPL			(0x00 << DWGCTL_ATYPE_SHIFT)
#	define DWGCTL_ATYPE_RSTR		(0x01 << DWGCTL_ATYPE_SHIFT)
#	define DWGCTL_ATYPE_ZI			(0x03 << DWGCTL_ATYPE_SHIFT)
#	define DWGCTL_ATYPE_BLK			(0x04 << DWGCTL_ATYPE_SHIFT)
#	define DWGCTL_ATYPE_I			(0x07 << DWGCTL_ATYPE_SHIFT)
#	define DWGCTL_LINEAR			(0x01 << 7)
#	define DWGCTL_ZMODE_SHIFT		8
#	define DWGCTL_ZMODE_MASK		(0x07 << DWGCTL_ZMODE_SHIFT)
#	define DWGCTL_ZMODE_NOZCMP		(0x00 << DWGCTL_ZMODE_SHIFT)
#	define DWGCTL_ZMODE_ZE			(0x02 << DWGCTL_ZMODE_SHIFT)
#	define DWGCTL_ZMODE_ZNE			(0x03 << DWGCTL_ZMODE_SHIFT)
#	define DWGCTL_ZMODE_ZLT			(0x04 << DWGCTL_ZMODE_SHIFT)
#	define DWGCTL_ZMODE_ZLTE		(0x05 << DWGCTL_ZMODE_SHIFT)
#	define DWGCTL_ZMODE_ZGT			(0x06 << DWGCTL_ZMODE_SHIFT)
#	define DWGCTL_ZMODE_ZGTE		(0x07 << DWGCTL_ZMODE_SHIFT)
#	define DWGCTL_SOLID			(0x01 << 11)
#	define DWGCTL_ARZERO			(0x01 << 12)
#	define DWGCTL_SGNZERO			(0x01 << 13)
#	define DWGCTL_SHFTZERO			(0x01 << 14)
#	define DWGCTL_BOP_SHIFT			16
#	define DWGCTL_BOP_MASK			(0x0F << DWGCTL_BOP_SHIFT)
#	define DWGCTL_TRANS_SHIFT		20
#	define DWGCTL_TRANS_MASK		(0x0F << DWGCTL_TRANS_SHIFT)
#	define DWGCTL_BLTMOD_SHIFT		25
#	define DWGCTL_BLTMOD_MASK		(0xF << DWGCTL_BLTMOD_SHIFT)
#	define DWGCTL_BLTMOD_BMONOLEF		(0x0 << DWGCTL_BLTMOD_SHIFT)
#	define DWGCTL_BLTMOD_BMONOWF		(0x4 << DWGCTL_BLTMOD_SHIFT)
#	define DWGCTL_BLTMOD_PLAN		(0x1 << DWGCTL_BLTMOD_SHIFT)
#	define DWGCTL_BLTMOD_BFCOL		(0x2 << DWGCTL_BLTMOD_SHIFT)
#	define DWGCTL_BLTMOD_UYUV		(0x14 << DWGCTL_BLTMOD_SHIFT)
#	define DWGCTL_BLTMOD_32BGR		(0x3 << DWGCTL_BLTMOD_SHIFT)
#	define DWGCTL_BLTMOD_32RGB		(0x7 << DWGCTL_BLTMOD_SHIFT)
#	define DWGCTL_BLTMOD_24BGR		(0xB << DWGCTL_BLTMOD_SHIFT)
#	define DWGCTL_BLTMOD_24RGB		(0xF << DWGCTL_BLTMOD_SHIFT)
#	define DWGCTL_PATTERN			(0x01 << 29)
#	define DWGCTL_TRANSC			(0x01 << 30)
#	define DWGCTL_CLIPDIS			(0x01 << 31)	/* G200+ */

#define MACCESS 				(MGAG_DWGREG0+0x04)	/* WO */
#	define MACCESS_PWIDTH_SHIFT		0
#	define MACCESS_PWIDTH_MASK		(0x03 << MACCESS_PWIDTH_SHIFT)
#	define MACCESS_PWIDTH_PW8		(0x00 << MACCESS_PWIDTH_SHIFT)
#	define MACCESS_PWIDTH_PW16		(0x01 << MACCESS_PWIDTH_SHIFT)
#	define MACCESS_PWIDTH_PW32		(0x02 << MACCESS_PWIDTH_SHIFT)
#	define MACCESS_PWIDTH_PW24		(0x03 << MACCESS_PWIDTH_SHIFT)
#	define MACCESS_ZWIDTH_SHIFT		3
#	define MACCESS_ZWIDTH_MASK		(0x03 << MACCESS_ZWIDTH_SHIFT)
#	define MACCESS_ZWIDTH_ZW16		(0x00 << 3)	/* G200+ */
#	define MACCESS_ZWIDTH_ZW32		(0x01 << 3)	/* G200+ */
#	define MACCESS_ZWIDTH_ZW15		(0x02 << 3)	/* G400 Rev B+ */
#	define MACCESS_ZWIDTH_ZW24		(0x03 << 3)	/* G400 Rev B+ */
#	define MACCESS_JEDECRST			(0x01 << 14)
#	define MACCESS_MEMRESET			(0x01 << 15)
#	define MACCESS_FOGEN			(0x01 << 26)	/* G200+ */
#	define MACCESS_BYPASS332		(0x01 << 28)	/* G400 Rev B+ */
#	define MACCESS_TLUTLOAD			(0x01 << 29)	/* G200+ */
#	define MACCESS_NODITHER			(0x01 << 30)
#	define MACCESS_DIT555			(0x01 << 31)

#define MCTLWTST				(MGAG_DWGREG0+0x08)	/* WO */
#	define M1x64_MCTLWTST_CASLTCNY		(0x01 << 0)
#	define M1x64_MCTLWTST_RCDELAY		(0x01 << 8)
#	define M1x64_MCTLWTST_RASMIN_SHIFT	16
#	define M1x64_MCTLWTST_RASMIN_MASK	(0x03 << M1x64_MCTLWTST_RASMIN_SHIFT)

/* G200+ */

#	define Gx00_MCTLWTST_CASLTCNY_SHIFT	0
#	define Gx00_MCTLWTST_CASLTCNY_MASK	(0x07 << Gx00_MCTLWTST_CASLTCNY_SHIFT)
#	define Gx00_MCTLWTST_RRDDELAY_SHIFT	4
#	define Gx00_MCTLWTST_RRDDELAY_MASK	(0x03 << Gx00_MCTLWTST_RRDDELAY_SHIFT)
#	define Gx00_MCTLWTST_RCDDELAY_SHIFT	7
#	define Gx00_MCTLWTST_RCDDELAY_MASK	(0x03 << Gx00_MCTLWTST_RCDDELAY_SHIFT)
#	define Gx00_MCTLWTST_RASMIN_SHIFT	10
#	define Gx00_MCTLWTST_RASMIN_MASK	(0x07 << Gx00_MCTLWTST_RASMIN_SHIFT)
#	define Gx00_MCTLWTST_RPDELAY_SHIFT	14
#	define Gx00_MCTLWTST_RPDELAY_MASK	(0x03 << Gx00_MCTLWTST_RPDELAY_SHIFT)
#	define Gx00_MCTLWTST_WRDELAY_SHIFT	18
#	define Gx00_MCTLWTST_WRDELAY_MASK	(0x03 << Gx00_MCTLWTST_WRDELAY_SHIFT)
#	define Gx00_MCTLWTST_RDDELAY		(0x01 << 21)
#	define Gx00_MCTLWTST_SMRDELAY_SHIFT	23
#	define Gx00_MCTLWTST_SMRDELAY_MASK	(0x03 << Gx00_MCTLWTST_SMRDELAY_SHIFT)
#	define Gx00_MCTLWTST_BWCDELAY_SHIFT	26
#	define Gx00_MCTLWTST_BWCDELAY_MASK	(0x03 << Gx00_MCTLWTST_BWCDELAY_SHIFT)
#	define Gx00_MCTLWTST_BPLDELAY_SHIFT	29
#	define Gx00_MCTLWTST_BPLDELAY_MASK	(0x07 << Gx00_MCTLWTST_BPLDELAY_SHIFT)

/* G400 specific (maybe good for G200?) */
#define G200_MCTLWTST_RESET_VALUE 0x84A49921
#define G400_MCTLWTST_RESET_VALUE 0x84A49921
#define G550_MCTLWTST_RESET_VALUE 0x84A49921

#define ZORG					(MGAG_DWGREG0+0x0C)	/* WO */
#define PAT0					(MGAG_DWGREG0+0x10)	/* WO */
#define PAT1					(MGAG_DWGREG0+0x14)	/* WO */
#define PLNWT					(MGAG_DWGREG0+0x1C)	/* WO */
#define BCOL					(MGAG_DWGREG0+0x20)	/* WO */
#define FCOL					(MGAG_DWGREG0+0x24)	/* WO */
#define SRC0					(MGAG_DWGREG0+0x30)	/* WO */
#define SRC1					(MGAG_DWGREG0+0x34)	/* WO */
#define SRC2					(MGAG_DWGREG0+0x38)	/* WO */
#define SRC3					(MGAG_DWGREG0+0x3C)	/* WO */
#define XYSTRT					(MGAG_DWGREG0+0x40)	/* WO */
#define XYEND					(MGAG_DWGREG0+0x44)	/* WO */
#define SHIFT					(MGAG_DWGREG0+0x50)	/* WO */
#define DMAPAD					(MGAG_DWGREG0+0x54)	/* WO */

#define SGN					(MGAG_DWGREG0+0x58)	/* WO */
#	define SGN_SDYDXL			0x01
#	define SGN_SCANLEFT			0x01
#	define SGN_SDXL				(0x01 << 1)
#	define SGN_SDY				(0x01 << 2)
#	define SGN_SDXR				(0x01 << 5)
#	define SGN_BRKLEFT			(0x01 << 8)	/* G200+ */
#	define SGN_BRKLEFTTOP			(0x01 << 9)	/* G400+ */
#	define SGN_FASTCROP			(0x01 << 10)	/* G400+ */
#	define SGN_BL				(0x01 << 11)	/* G400+ */
#	define SGN_SBE				(0x01 << 12)	/* G400+ */
#	define SGN_SSE				(0x01 << 13)	/* G400+ */
#	define SGN_US				(0x01 << 14)	/* G400+ */
#	define SGN_CENTERSNAP			(0x01 << 15)	/* G400+ */
#	define SGN_SUBPIXEN			(0x01 << 16)	/* G400+ */
#	define SGN_BRKRIGHTTOP			(0x01 << 17)	/* G400+ */
#	define SGN_ERRORINIT			(0x01 << 31)	/* G200+ */

#define LEN					(MGAG_DWGREG0+0x5C)	/* WO */
#define AR0					(MGAG_DWGREG0+0x60)	/* WO */
#define AR1					(MGAG_DWGREG0+0x64)	/* WO */
#define AR2					(MGAG_DWGREG0+0x68)	/* WO */
#define AR3					(MGAG_DWGREG0+0x6C)	/* WO */
#define AR4					(MGAG_DWGREG0+0x70)	/* WO */
#define AR5					(MGAG_DWGREG0+0x74)	/* WO */
#define AR6					(MGAG_DWGREG0+0x78)	/* WO */

#define CXBNDRY					(MGAG_DWGREG0+0x80)	/* WO */
#	define CXBNDRY_CXLEFT_SHIFT		0
#	define CXBNDRY_CXLEFT_MASK		(0x0FFF << CXBNDRY_CXLEFT_SHIFT)
#	define CXBNDRY_CXRIGHT_SHIFT		16
#	define CXBNDRY_CXRIGHT_MASK		(0x0FFF << CXBNDRY_CXRIGHT_SHIFT)

#define FXBNDRY					(MGAG_DWGREG0+0x84)	/* WO */
#define FXBNDRY_FXLEFT_SHIFT 0
#define FXBNDRY_FXLEFT_MASK (0xFFFF << FXBNDRY_FXLEFT_SHIFT)
#define FXBNDRY_FXRIGHT_SHIFT 16
#define FXBNDRY_FXRIGHT_MASK (0xFFFF << FXBNDRY_FXRIGHT_SHIFT)

#define YDSTLEN					(MGAG_DWGREG0+0x88)	/* WO */
#define PITCH					(MGAG_DWGREG0+0x8C)	/* WO */
#define PITCH_IY_MASK 0x1FFF
#define PITCH_YLIN (1 << 15)
#define YDST					(MGAG_DWGREG0+0x90)	/* WO */
#define YDSTORG					(MGAG_DWGREG0+0x94)	/* WO, G200- */
#define YTOP					(MGAG_DWGREG0+0x98)	/* WO */
#define YBOT					(MGAG_DWGREG0+0x9C)	/* WO */
#define CXLEFT					(MGAG_DWGREG0+0xA0)	/* WO */
#define CXRIGHT					(MGAG_DWGREG0+0xA4)	/* WO */
#define FXLEFT					(MGAG_DWGREG0+0xA8)	/* WO */
#define FXRIGHT					(MGAG_DWGREG0+0xAC)	/* WO */
#define XDST					(MGAG_DWGREG0+0xB0)	/* WO */
#define FOGSTART				(MGAG_DWGREG0+0xC4)	/* WO, G200+ */
#define FOGXINC					(MGAG_DWGREG0+0xD4)	/* WO, G200+ */
#define FOGYINC					(MGAG_DWGREG0+0xE4)	/* WO, G200+ */
#define FOGCOL					(MGAG_DWGREG0+0xF4)	/* WO, G200+ */
#define DR0					(MGAG_DWGREG0+0xC0)	/* WO */
#define DR2					(MGAG_DWGREG0+0xC8)	/* WO */
#define DR3					(MGAG_DWGREG0+0xCC)	/* WO */
#define DR4					(MGAG_DWGREG0+0xD0)	/* WO */
#define DR6					(MGAG_DWGREG0+0xD8)	/* WO */
#define DR7					(MGAG_DWGREG0+0xDC)	/* WO */
#define DR8					(MGAG_DWGREG0+0xE0)	/* WO */
#define DR10					(MGAG_DWGREG0+0xE8)	/* WO */
#define DR11					(MGAG_DWGREG0+0xEC)	/* WO */
#define DR12					(MGAG_DWGREG0+0xF0)	/* WO */
#define DR14					(MGAG_DWGREG0+0xF8)	/* WO */
#define DR15					(MGAG_DWGREG0+0xFC)	/* WO */
#define TMR0					(MGAG_DWGREG1+0x00)	/* WO, G200+ */
#define TMR1					(MGAG_DWGREG1+0x04)	/* WO, G200+ */
#define TMR2					(MGAG_DWGREG1+0x08)	/* WO, G200+ */
#define TMR3					(MGAG_DWGREG1+0x0C)	/* WO, G200+ */
#define TMR4					(MGAG_DWGREG1+0x10)	/* WO, G200+ */
#define TMR5					(MGAG_DWGREG1+0x14)	/* WO, G200+ */
#define TMR6					(MGAG_DWGREG1+0x18)	/* WO, G200+ */
#define TMR7					(MGAG_DWGREG1+0x1C)	/* WO, G200+ */
#define TMR8					(MGAG_DWGREG1+0x20)	/* WO, G200+ */
#define TEXORG					(MGAG_DWGREG1+0x24)	/* WO, G200+ */
#define TEXWIDTH				(MGAG_DWGREG1+0x28)	/* WO, G200+ */
#define TEXHEIGHT				(MGAG_DWGREG1+0x2C)	/* WO, G200+ */
#define TEXCTL					(MGAG_DWGREG1+0x30)	/* WO, G200+ */
#define TEXTRANS				(MGAG_DWGREG1+0x34)	/* WO, G200+ */
#define TEXTRANSHIGH				(MGAG_DWGREG1+0x38)	/* WO, G200+ */
#define TEXCTL2					(MGAG_DWGREG1+0x3C)	/* WO, G200+ */
#define SECADDRESS				(MGAG_DWGREG1+0x40)	/* G200+ */
#define SECADDRESS_DMAMOD_MASK  0x00000003
#define SECADDRESS_DMAMOD_GENERAL_WRITE 0x00
#define SECADDRESS_DMAMOD_BLIT_WRITE    0x01
#define SECADDRESS_DMAMOD_VECTOR_WRITE  0x02
#define SECADDRESS_DMAMOD_VERTEX_WRITE  0x03
#define SECADDRESS_ADDRESS_MASK 0xFFFFFFFC
#define SECEND					(MGAG_DWGREG1+0x44)	/* G200+ */
#define SECEND_PAGPXFER    (0x01 << 1)
#define SECEND_ADDRESS_MASK 0xFFFFFFFC

#define SOFTRAP					(MGAG_DWGREG1+0x48)	/* G200+ */
#define SOFTRAP_SOFTRAPHAND 0xFFFFFFFC
#define SOFTRAPHAND SOFTRAP_SOFTRAPHAND /* for brevity */
#define DWGSYNC					(MGAG_DWGREG1+0x4C)	/* G200+ */
#define DR0_Z32_LSB				(MGAG_DWGREG1+0x50)	/* WO, G200+ */
#define DR0_Z32_MSB				(MGAG_DWGREG1+0x54)	/* WO, G200+ */
#define TEXFILTER				(MGAG_DWGREG1+0x58)	/* WO, G200+ */
#define TEXBORDERCOL				(MGAG_DWGREG1+0x5C)	/* WO, G200+ */
#define DR2_Z32_LSB				(MGAG_DWGREG1+0x60)	/* WO, G200+ */
#define DR2_Z32_MSB				(MGAG_DWGREG1+0x64)	/* WO, G200+ */
#define DR3_Z32_LSB				(MGAG_DWGREG1+0x68)	/* WO, G200+ */
#define DR3_Z32_MSB				(MGAG_DWGREG1+0x6C)	/* WO, G200+ */
#define ALPHASTART				(MGAG_DWGREG1+0x70)	/* WO, G200+ */
#define ALPHAXINC				(MGAG_DWGREG1+0x74)	/* WO, G200+ */
#define ALPHAYINC				(MGAG_DWGREG1+0x78)	/* WO, G200+ */
#define ALPHACTRL				(MGAG_DWGREG1+0x7C)	/* WO, G200+ */
#define SPECRSTART				(MGAG_DWGREG1+0x80)	/* WO, G200+ */
#define SPECRXINC				(MGAG_DWGREG1+0x84)	/* WO, G200+ */
#define SPECRYINC				(MGAG_DWGREG1+0x88)	/* WO, G200+ */
#define SPECGSTART				(MGAG_DWGREG1+0x8C)	/* WO, G200+ */
#define SPECGXINC				(MGAG_DWGREG1+0x90)	/* WO, G200+ */
#define SPECGYINC				(MGAG_DWGREG1+0x94)	/* WO, G200+ */
#define SPECBSTART				(MGAG_DWGREG1+0x98)	/* WO, G200+ */
#define SPECBXINC				(MGAG_DWGREG1+0x9C)	/* WO, G200+ */
#define SPECBYINC				(MGAG_DWGREG1+0xA0)	/* WO, G200+ */
#define TEXORG1					(MGAG_DWGREG1+0xA4)	/* WO, G200+ */
#define TEXORG2					(MGAG_DWGREG1+0xA8)	/* WO, G200+ */
#define TEXORG3					(MGAG_DWGREG1+0xAC)	/* WO, G200+ */
#define TEXORG4					(MGAG_DWGREG1+0xB0)	/* WO, G200+ */
#define SRCORG					(MGAG_DWGREG1+0xB4)	/* WO, G200+ */
#define DSTORG					(MGAG_DWGREG1+0xB8)	/* WO, G200+ */
#define STENCIL					(MGAG_DWGREG1+0xC8)	/* WO, G400+ */
#define STENCILCTL				(MGAG_DWGREG1+0xCC)	/* WO, G400+ */
#define SETUPADDRESS				(MGAG_DWGREG1+0xD0)	/* G200+ */
#define SETUPEND				(MGAG_DWGREG1+0xD4)	/* G200+ */
#define TBUMPMAT				(MGAG_DWGREG1+0xF0)	/* WO, G400+ */
#define TBUMPFMT				(MGAG_DWGREG1+0xF4)	/* WO, G400+ */
#define TDUALSTAGE0				(MGAG_DWGREG1+0xF8)	/* WO, G400+ */
#define TDUALSTAGE1				(MGAG_DWGREG1+0xFC)	/* WO, G400+ */

/*
** WARP registers, These only occur in G200 and newer.
*/

#define WIADDR					(MGAG_DWGREG0+0x1C0)	/* WO */
#define WIADDR_WMODE_MASK    0x3
#define WIADDR_WMODE_SUSPEND 0x0
#define WIADDR_WMODE_RESUME  0x1
#define WIADDR_WMODE_JUMP    0x2
#define WIADDR_WMODE_START   0x3
#define WIADDR_WAGP          (1 << 2)
#define WIADDR_WIADDR_MASK   0xFFFFFFF8

#define WFLAG					(MGAG_DWGREG0+0x1C4)	/* WO */

#define WGETMSB					(MGAG_DWGREG0+0x1C8)	/* WO */
#define WGETMSB_WGETMSBMIN_SHIFT  0
#define WGETMSB_WGETMSBMIN_MASK   (0x1F << WGETMSB_WGETMSBMIN_SHIFT)
#define WGETMSB_WGETMSBMAX_SHIFT  8
#define WGETMSB_WGETMSBMAX_MASK   (0x1F << WGETMSB_WGETMSBMAX_SHIFT)
#define WGETMSB_WBRKLEFTTOP       (1 << 16)
#define WGETMSB_WFASTCROP         (1 << 17)
#define WGETMSB_WCENTERSNAP       (1 << 18)
#define WGETMSB_WBRKRIGHTTOP      (1 << 19)

#define WVRTXSZ					(MGAG_DWGREG0+0x1CC)	/* WO */
#define WVRTXSZ_WVRTXSZ_SHIFT  0
#define WVRTXSZ_WVRTXSZ_MASK   (0x3F << WVRTXSZ_WVRTXSZ_SHIFT)
#define WVRTXSZ_PRIMSZ_SHIFT   8
#define WVRTXSZ_PRIMSZ_MASK    (0x3F << WVRTXSZ_PRIMSZ_SHIFT)

#define WACCEPTSEQ				(MGAG_DWGREG0+0x1D4)	/* WO, G400+ */
#define WACCEPTSEQ_SEQDST0_SHIFT  0
#define WACCEPTSEQ_SEQDST0_MASK   (0x3F << WACCEPTSEQ_SEQDST0_SHIFT)
#define WACCEPTSEQ_SEQDST1_SHIFT  6
#define WACCEPTSEQ_SEQDST1_MASK   (0x3F << WACCEPTSEQ_SEQDST1_SHIFT)
#define WACCEPTSEQ_SEQDST2_SHIFT  12
#define WACCEPTSEQ_SEQDST2_MASK   (0x3F << WACCEPTSEQ_SEQDST2_SHIFT)
#define WACCEPTSEQ_SEQDST3_SHIFT  18
#define WACCEPTSEQ_SEQDST3_MASK   (0x3F << WACCEPTSEQ_SEQDST3_SHIFT)
#define WACCEPTSEQ_SEQLEN_SHIFT   24
#define WACCEPTSEQ_SEQLEN_MASK    (0x3 << WACCEPTSEQ_SEQLEN_SHIFT)
#define WACCEPTSEQ_SEQLEN_0       (0x0 << WACCEPTSEQ_SEQLEN_SHIFT)
#define WACCEPTSEQ_SEQLEN_01      (0x1 << WACCEPTSEQ_SEQLEN_SHIFT)
#define WACCEPTSEQ_SEQLEN_012     (0x2 << WACCEPTSEQ_SEQLEN_SHIFT)
#define WACCEPTSEQ_SEQLEN_0123    (0x3 << WACCEPTSEQ_SEQLEN_SHIFT)
#define WACCEPTSEQ_WFIRSTTAG      (1 << 26)
#define WACCEPTSEQ_WSAMETAG       (1 << 27)
#define WACCEPTSEQ_SEQOFF         (1 << 28)

#define WIADDR2					(MGAG_DWGREG0+0x1D8)	/* WO, G400+ */
#define WIADDR2_WMODE_MASK    0x3
#define WIADDR2_WMODE_SUSPEND 0x0
#define WIADDR2_WMODE_RESUME  0x1
#define WIADDR2_WMODE_JUMP    0x2
#define WIADDR2_WMODE_START   0x3
#define WIADDR2_WAGP          (1 << 2)
#define WIADDR2_WIADDR_MASK   0xFFFFFFF8

#define WFLAG1					(MGAG_DWGREG0+0x1E0)	/* WO, G400+ */
#define WIADDRNB2				(MGAG_DWGREG0+0x200)	/* WO, G400+ */
#define WIADDRNB1				(MGAG_DWGREG0+0x204)	/* RO, G400+ */
#define WFLAGNB1				(MGAG_DWGREG0+0x208)	/* G400+ */
#define WIADDRNB				(MGAG_HSTREG+0x60)
#define WIFLAGNB				(MGAG_HSTREG+0x64)
#define WIMEMADDR				(MGAG_HSTREG+0x68)	/* WO */
#define WCODEADDR				(MGAG_HSTREG+0x6C)	/* RO */

#define WMISC					(MGAG_HSTREG+0x70)
#define WMISC_WUCODECACHE  (1 << 0)
#define WMISC_WMASTER       (1 << 1)
#define WMISC_WCACHEFLUSH  (1 << 3)

#define WIMEMDATA				(MGAG_WIMEMDATA+0x000)
#define WIMEMDATA1				(MGAG_WIMEMDATA+0x100)	/* G400+ */

/* There are 64 of these, spaced at 4 byte */
/* "WR" is too short IMHO -- ortalo */
#define WARPREG_BASE				(MGAG_DWGREG1+0x100)
#define WARPREG(x)   (WARPREG_BASE | ((x) << 2))

/* Back-end Scaler defintions */

#define BESA1ORG				(MGAG_BESREG+0x00)	/* WO */
#define BESA2ORG				(MGAG_BESREG+0x04)	/* WO */
#define BESB1ORG				(MGAG_BESREG+0x08)	/* WO */
#define BESB2ORG				(MGAG_BESREG+0x0C)	/* WO */
#define BESA1CORG				(MGAG_BESREG+0x10)	/* WO */
#define BESA2CORG				(MGAG_BESREG+0x14)	/* WO */
#define BESB1CORG				(MGAG_BESREG+0x18)	/* WO */
#define BESB2CORG				(MGAG_BESREG+0x1C)	/* WO */
#define BESCTL					(MGAG_BESREG+0x20)
#define BESPITCH				(MGAG_BESREG+0x24)	/* WO */
#define BESHCOORD				(MGAG_BESREG+0x28)	/* WO */
#define BESVCOORD				(MGAG_BESREG+0x2C)	/* WO */
#define BESHISCAL				(MGAG_BESREG+0x30)	/* WO */
#define BESVISCAL				(MGAG_BESREG+0x34)	/* WO */
#define BESHSRCST				(MGAG_BESREG+0x38)	/* WO */
#define BESHSRCEND				(MGAG_BESREG+0x3C)	/* WO */
#define BESLUMACTL				(MGAG_BESREG+0x40)	/* WO, G400+ */
#define BESV1WGHT				(MGAG_BESREG+0x48)	/* WO */
#define BESV2WGHT				(MGAG_BESREG+0x4C)	/* WO */
#define BESHSRCLST				(MGAG_BESREG+0x50)	/* WO */
#define BESV1SRCLST				(MGAG_BESREG+0x54)	/* WO */
#define BESV2SRCLST				(MGAG_BESREG+0x58)	/* WO */
#define BESA1C3ORG				(MGAG_BESREG+0x60)	/* WO, G400+ */
#define BESA2C3ORG				(MGAG_BESREG+0x64)	/* WO, G400+ */
#define BESB1C3ORG				(MGAG_BESREG+0x68)	/* WO, G400+ */
#define BESB2C3ORG				(MGAG_BESREG+0x6C)	/* WO, G400+ */
#define BESGLOBCTL				(MGAG_BESREG+0xC0)
#define BESSTATUS				(MGAG_BESREG+0xC4)	/* RO */

/* VIDEO Codec definitions */

#define VINCTL0					(MGAG_VINCODEC+0x00)	/* WO */
#define VINCTL1					(MGAG_VINCODEC+0x04)	/* WO */
#define VBIADDR0				(MGAG_VINCODEC+0x08)	/* WO */
#define VBIADDR1				(MGAG_VINCODEC+0x0C)	/* WO */
#define VINADDR0				(MGAG_VINCODEC+0x10)	/* WO */
#define VINADDR1				(MGAG_VINCODEC+0x14)	/* WO */
#define VINNEXTWIN				(MGAG_VINCODEC+0x18)	/* WO */
#define VINCTL					(MGAG_VINCODEC+0x1C)	/* WO */
#define VINADDR2				(MGAG_VINCODEC+0x20)	/* WO, G400+ */
#define VINADDR3				(MGAG_VINCODEC+0x24)	/* WO, G400+ */
#define VINCTL2					(MGAG_VINCODEC+0x28)	/* WO, G400+ */
#define VINCTL3					(MGAG_VINCODEC+0x2C)	/* WO, G400+ */
#define VSTATUS					(MGAG_VINCODEC+0x30)	/* RO */
#define VICLEAR					(MGAG_VINCODEC+0x34)	/* WO */
#define VIEN					(MGAG_VINCODEC+0x38)
#define VINHEIGHT				(MGAG_VINCODEC+0x3C)	/* access unknown, G400+ */
#define CODECCTL				(MGAG_VINCODEC+0x40)	/* WO */
#define CODECADDR				(MGAG_VINCODEC+0x44)	/* WO */
#define CODECHOSTPTR				(MGAG_VINCODEC+0x48)	/* WO */
#define CODECHARDPTR				(MGAG_VINCODEC+0x4C)	/* RO */
#define CODECLCODE				(MGAG_VINCODEC+0x50)	/* RO */

/* Builds a 8bits (pseudo-)DMA value for a reg */

#define MGA_DMA(x) ((((x) & 0x2000) >> 6) | (((x) & 0x1FC) >> 2))

#define MGA_DMA4(x,y,z,t) (MGA_DMA(x) | (MGA_DMA(y) << 8) \
		| (MGA_DMA(z) << 16) | (MGA_DMA(t) << 24))

/*
** some TAG values to identify different buffer types
*/

/* tag length in bytes (must be a multiple of 4) */
#define MGAG_ACCEL_TAG_LENGTH 4

/*
** Buffer type definition
*/
#define MGAG_ACCEL_TAG_TYPE_MASK 0xF
/* drawing engine type: regular display list (reg,val) */
#define MGAG_ACCEL_TAG_DRAWING_ENGINE 0x1
/* setup engine type: vertex - G200+ only */
#define MGAG_ACCEL_TAG_WARP_TRIANGLE_LIST 0x2
#define MGAG_ACCEL_TAG_WARP_TRIANGLE_STRIP 0x3
#define MGAG_ACCEL_TAG_WARP_TRIANGLE_FAN 0x4

/*
 * Pipe type definition
 */
/* G(ouraud) and Z(buffer) are implicit (all pipes)
*/
/* Specular highlight */
#define MGA_ACCEL_TAG_WARP_SPEC  (1 << 4)
/* Alpha channel */
#define MGA_ACCEL_TAG_WARP_ALPHA (1 << 5)
/* Vertex fog interpolation */
#define MGA_ACCEL_TAG_WARP_FOG   (1 << 6)
/* dual texture stage - G400+ only */
#define MGA_ACCEL_TAG_WARP_T2    (1 << 7)


/* to be OR (|) to last accel register setup to activate engine */

#define ACCEL_GO				0x100

#define PLL_DELAY				100000

#define KHZ					*1000
#define MHZ					*1000000

#define NrSEQRegs				2
#define NrDACRegs				2
#define NrEDACRegs				2
#define NrCRTRegs				(0x18+1)
#define NrECRTRegs				(0x08+1)

#endif /*_Matrox_Gx00_h_2 */
