/* valaccodelinedirective.vala
 *
 * Copyright (C) 2006  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <ccode/valaccodelinedirective.h>
#include <ccode/valaccodewriter.h>




struct _ValaCCodeLineDirectivePrivate {
	char* _filename;
	gint _line;
};

#define VALA_CCODE_LINE_DIRECTIVE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CCODE_LINE_DIRECTIVE, ValaCCodeLineDirectivePrivate))
enum  {
	VALA_CCODE_LINE_DIRECTIVE_DUMMY_PROPERTY,
	VALA_CCODE_LINE_DIRECTIVE_FILENAME,
	VALA_CCODE_LINE_DIRECTIVE_LINE
};
static void vala_ccode_line_directive_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer);
static gpointer vala_ccode_line_directive_parent_class = NULL;
static void vala_ccode_line_directive_dispose (GObject * obj);



ValaCCodeLineDirective* vala_ccode_line_directive_new (const char* _filename, gint _line) {
	GParameter * __params;
	GParameter * __params_it;
	ValaCCodeLineDirective * self;
	g_return_val_if_fail (_filename != NULL, NULL);
	__params = g_new0 (GParameter, 1);
	__params_it = __params;
	__params_it->name = "filename";
	g_value_init (&__params_it->value, G_TYPE_STRING);
	g_value_set_string (&__params_it->value, _filename);
	__params_it++;
	self = g_object_newv (VALA_TYPE_CCODE_LINE_DIRECTIVE, __params_it - __params, __params);
	vala_ccode_line_directive_set_line (self, _line);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


static void vala_ccode_line_directive_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer) {
	ValaCCodeLineDirective * self;
	char* _tmp0;
	self = VALA_CCODE_LINE_DIRECTIVE (base);
	g_return_if_fail (VALA_IS_CCODE_WRITER (writer));
	if (!vala_ccode_writer_get_bol (writer)) {
		vala_ccode_writer_write_newline (writer);
	}
	_tmp0 = NULL;
	vala_ccode_writer_write_string (writer, (_tmp0 = g_strdup_printf ("#line %d \"%s\"", self->priv->_line, self->priv->_filename)));
	_tmp0 = (g_free (_tmp0), NULL);
	vala_ccode_writer_write_newline (writer);
}


char* vala_ccode_line_directive_get_filename (ValaCCodeLineDirective* self) {
	g_return_val_if_fail (VALA_IS_CCODE_LINE_DIRECTIVE (self), NULL);
	return self->priv->_filename;
}


void vala_ccode_line_directive_set_filename (ValaCCodeLineDirective* self, const char* value) {
	char* _tmp2;
	const char* _tmp1;
	g_return_if_fail (VALA_IS_CCODE_LINE_DIRECTIVE (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_filename = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : g_strdup (_tmp1))), (self->priv->_filename = (g_free (self->priv->_filename), NULL)), _tmp2);
}


gint vala_ccode_line_directive_get_line (ValaCCodeLineDirective* self) {
	g_return_val_if_fail (VALA_IS_CCODE_LINE_DIRECTIVE (self), 0);
	return self->priv->_line;
}


void vala_ccode_line_directive_set_line (ValaCCodeLineDirective* self, gint value) {
	g_return_if_fail (VALA_IS_CCODE_LINE_DIRECTIVE (self));
	self->priv->_line = value;
}


static void vala_ccode_line_directive_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ValaCCodeLineDirective * self;
	self = VALA_CCODE_LINE_DIRECTIVE (object);
	switch (property_id) {
		case VALA_CCODE_LINE_DIRECTIVE_FILENAME:
		g_value_set_string (value, vala_ccode_line_directive_get_filename (self));
		break;
		case VALA_CCODE_LINE_DIRECTIVE_LINE:
		g_value_set_int (value, vala_ccode_line_directive_get_line (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_ccode_line_directive_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ValaCCodeLineDirective * self;
	self = VALA_CCODE_LINE_DIRECTIVE (object);
	switch (property_id) {
		case VALA_CCODE_LINE_DIRECTIVE_FILENAME:
		vala_ccode_line_directive_set_filename (self, g_value_get_string (value));
		break;
		case VALA_CCODE_LINE_DIRECTIVE_LINE:
		vala_ccode_line_directive_set_line (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_ccode_line_directive_class_init (ValaCCodeLineDirectiveClass * klass) {
	vala_ccode_line_directive_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaCCodeLineDirectivePrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_ccode_line_directive_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_ccode_line_directive_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_ccode_line_directive_dispose;
	VALA_CCODE_NODE_CLASS (klass)->write = vala_ccode_line_directive_real_write;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_CCODE_LINE_DIRECTIVE_FILENAME, g_param_spec_string ("filename", "filename", "filename", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_CCODE_LINE_DIRECTIVE_LINE, g_param_spec_int ("line", "line", "line", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void vala_ccode_line_directive_init (ValaCCodeLineDirective * self) {
	self->priv = VALA_CCODE_LINE_DIRECTIVE_GET_PRIVATE (self);
}


static void vala_ccode_line_directive_dispose (GObject * obj) {
	ValaCCodeLineDirective * self;
	self = VALA_CCODE_LINE_DIRECTIVE (obj);
	self->priv->_filename = (g_free (self->priv->_filename), NULL);
	G_OBJECT_CLASS (vala_ccode_line_directive_parent_class)->dispose (obj);
}


GType vala_ccode_line_directive_get_type (void) {
	static GType vala_ccode_line_directive_type_id = 0;
	if (G_UNLIKELY (vala_ccode_line_directive_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeLineDirectiveClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_line_directive_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeLineDirective), 0, (GInstanceInitFunc) vala_ccode_line_directive_init };
		vala_ccode_line_directive_type_id = g_type_register_static (VALA_TYPE_CCODE_NODE, "ValaCCodeLineDirective", &g_define_type_info, 0);
	}
	return vala_ccode_line_directive_type_id;
}




