#!/usr/local/bin/perl
# clone_mod.cgi
# Clone an existing module under a new name

require './webmin-lib.pl';
&ReadParse();
&error_setup($text{'clone_err'});

# Symlink the code directory
$src = $in{'mod'};
%minfo = &get_module_info($src);
$count = 2;
do {
	$dst = $src.$count;
	$count++;
	} while(-d "../$dst");
symlink($src, "../$dst") || &error(&text('clone_elink', $!));

# Copy the config directory
mkdir("$config_directory/$dst", 0700);
$out = `(cd $config_directory/$src ; tar cvf - .) | (cd $config_directory/$dst ; tar xvpf -) 2>&1`;
if ($?) {
	&error(&text('clone_ecopy', $out));
	}
$in{'desc'} = &text('clone_desc', $minfo{'desc'}) if (!$in{'desc'});
open(CLONE, ">$config_directory/$dst/clone");
print CLONE "desc=$in{'desc'}\n";
close(CLONE);

# Grant access to the clone to this user
&read_acl(undef, \%acl);
open(ACL, "> ".&acl_filename());
foreach $u (keys %acl) {
	local @mods = @{$acl{$u}};
	if ($u eq $ENV{'REMOTE_USER'}) {
		@mods = &unique(@mods, $dst);
		}
	print ACL "$u: ",join(' ', @mods),"\n";
	}
close(ACL);

&redirect("");

