#!/usr/local/bin/perl

local $format;
local $out;

require "./time-lib.pl";

&ReadParse();

$in{ 'year' } = substr( $in{ 'year' }, 2, length( $in{ 'year' } ) );

if( $in{ 'action' } eq $text{ 'action_apply' } )
{
  &error( $text{ 'acl_nosys' } ) if( $access{ 'sysdate' } );
  $in{ 'date' } = "0". $in{ 'date' } if( $in{ 'date' } <= 9 );
  $format = $in{ 'month' }. $in{ 'date' }. $in{ 'hour' }. $in{ 'minute' }. $in{ 'year' }. ".". $in{ 'second' };
  `date $format`;

} elsif ( $in{ 'action' } eq $text{ 'action_save' } ) {
  &error( $text{ 'acl_nohw' } ) if( $access{ 'hwdate' } );
  $format = "--set --date=\"". $in{ 'month' }. "/". $in{ 'date' }. "/". $in{ 'year' }. " ". $in{ 'hour' }. ":". $in{ 'minute' }. ":". $in{ 'second' }. "\"";
  $out = `hwclock $format`;
  &error( &text( 'error_hw', $out ) ) if( $out ne "" );

} elsif( $in{ 'action' } eq $text{ 'action_sync' } ) {
  &error( $text{ 'acl_nosys' } ) if( $access{ 'sysdate' } );
  $out = `hwclock --hctosys`;
  &error( &text( 'error_sync', $out ) ) if( $out ne "" );

} elsif( $in{ 'action' } eq $text{ 'action_timeserver_sys' } ||
	 $in{ 'action' } eq $text{ 'action_timeserver_hw' } ) {
  &open_socket( $in{ 'timeserver' }, 37, SOCK);
  read(SOCK, $rawtime, 4);
  close(SOCK);
  $rawtime = unpack("N", $rawtime);
  $rawtime -= (17 * 366 + 53 * 365) * 24 * 60 * 60;
  @tm = localtime($rawtime);

  if ($in{ 'action' } eq $text{ 'action_timeserver_sys' } ) {
	# Set system time
	$format = sprintf "%2.2d%2.2d%2.2d%2.2d%4.4d.%2.2d",
			$tm[4]+1, $tm[3], $tm[2], $tm[1], $tm[5]+1900, $tm[0];
	system("date $format >/dev/null 2>&1");
	}
  else {
	# Set hardware clock time
	$format = sprintf "%d/%d/%d %d:%d:%d",
			$tm[4]+1, $tm[3], $tm[5]+1900, $tm[2], $tm[1], $tm[0];
	system("hwclock --set \"--date=$format\" >/dev/null 2>&1");
	}
  $config{'timeserver'} = $in{'timeserver'};
  &write_file("$module_config_directory/config", \%config);
}

&redirect("");

