#!/usr/local/bin/perl
# list_virtusers.cgi
# Display a list of all domain and address mappings

require './sendmail-lib.pl';
require './virtusers-lib.pl';
$access{'vmode'} || &error($text{'virtusers_ecannot'});
&header($text{'virtusers_title'}, "");
print "<hr>\n";

$conf = &get_sendmailcf();
$vfile = &virtusers_file($conf);
($vdbm, $vdbmtype) = &virtusers_dbm($conf);
if (!$vdbm) {
	# No Kvirtuser directive in sendmail.cf
	print "<p><b>$text{'virtusers_edirective'}</b> <p>\n";
	print "<hr>\n";
	&footer("", $text{'index_return'});
	exit;
	}
if (!-r $vfile) {
	# Text file not found
	print "<p><b>",&text('virtusers_efile', "<tt>$vfile</tt>",
	      "<tt>$vdbm</tt>", "/config.cgi?$module_name"),"</b><p>\n";
	print "<hr>\n";
	&footer("", $text{'index_return'});
	exit;
	}
@virts = &list_virtusers($vfile);
if ($access{'vmode'} == 2) {
	@virts = grep { $_->{'from'} =~ /$access{'vaddrs'}/ } @virts;
	}
@virts = grep { $access{"vedit_".&virt_type($_->{'to'})} } @virts; 

&virtuser_form();
if (@virts) {
	# sort if needed
	if ($config{'sort_mode'} == 1) {
		@virts = sort sort_by_domain @virts;
		}

	# render table of virtusers
	$mid = int((@virts+1)/2);
	print "<table width=100%> <tr><td width=50% valign=top>\n";
	&virts_table(@virts[0..$mid-1]);
	print "</td><td width=50% valign=top>\n";
	if ($mid < @virts) { &virts_table(@virts[$mid..$#virts]); }
	print "</td></tr> </table><br>\n";
	}
if ($access{'vmode'} == 1 && $access{'vedit_0'} && $access{'vedit_1'} &&
    $access{'vedit_2'} && $access{'vmax'} == 0) {
	print "<a href='edit_file.cgi?mode=virtusers'>",
		&text('file_edit', "<tt>$vfile</tt>"),"</a><p>\n";
	}

print &text('virtusers_desc1', 'list_aliases.cgi'),"<p>\n";
print &text('virtusers_desc2', 'list_cws.cgi'),"<br>\n";

print "<hr>\n";
&footer("", $text{'index_return'});

sub virts_table
{
print "<table border width=100%>\n";
print "<tr $tb> <td><b>$text{'virtusers_for'}</b></td> ",
      "<td><b>$text{'virtusers_to'}</b></td> </tr>\n";
foreach $m (@_) {
	print "<tr $cb> <td><a href=\"edit_virtuser.cgi?num=$m->{'num'}\">",
	      "<tt>$m->{'from'}</tt></a></td> <td>\n";
	if ($m->{'to'} =~ /^error:(.*)$/) {
		print &text('virtusers_error', "<tt>$1</tt>");
		}
	elsif ($m->{'to'} =~ /^\%1\@(\S+)$/) {
		print &text('virtusers_domain', "<tt>$1</tt>");
		}
	else {
		print &text('virtusers_address', "<tt>$m->{'to'}</tt>");
		}
	print "</td> </tr>\n";
	}
print "</table>\n";
}

