#!/usr/local/bin/perl
# list_boxes.cgi
# List the mailboxes of all local users

require './sendmail-lib.pl';

if ($access{'mmode'} == 0) {
	&error($text{'boxes_ecannot'});
	}
elsif ($access{'mmode'} == 2) {
	if ($access{'musers'} =~ /^\S+$/) {
		&redirect("list_mail.cgi?user=$access{'musers'}");
		exit;
		}
	foreach $u (split(/\s+/, $access{'musers'})) {
		$ucan{$u}++;
		}
	}
elsif ($access{'mmode'} == 3) {
	foreach $u (split(/\s+/, $access{'musers'})) {
		$ucant{$u}++;
		}
	}

&header($text{'boxes_title'}, "");
print "<hr>\n";

setpwent();
while(@u = getpwent()) {
	next if (!$ucan{$u[0]} && $access{'mmode'} == 2);
	next if ($ucant{$u[0]} && $access{'mmode'} == 3);
	local @st = stat("$config{'mail_dir'}/$u[0]");
	push(@users, [ $u[0], $st[7] ]);
	}
endpwent();
@users = sort { $b->[1] <=> $a->[1] } @users;

print "<table width=100%><tr><td valign=top width=50%>\n";
$mid = int((@users+1) / 2);
&users_table(@users[0 .. $mid-1]);
print "</td><td valign=top width=50%>\n";
&users_table(@users[$mid .. $#users]);
print "</td></tr></table><p>\n";

print "<hr>\n";
&footer("", $text{'index_return'});

sub users_table
{
print "<table border width=100%>\n";
print "<tr $tb> <td><b>$text{'boxes_user'}</b></td> ",
      "<td><b>$text{'boxes_size'}</b></td> </tr>\n";
foreach $u (@_) {
	print "<tr $cb> <td><a href=\"list_mail.cgi?user=$u->[0]\">",
	      "$u->[0]</a></td>\n";
	print "<td>",defined($u->[1]) ? $u->[1]
				      : $text{'boxes_none'},"</td> </tr>\n";
	}
print "</table>\n";
}

