# boxes-lib.pl
# Functions to parsing user mail files

# list_mails(user, [start], [end])
sub list_mails
{
local (@rv, $h, $done);
local @index = &build_index($_[0]);
local ($start, $end);
if (@_ == 1) {
	$start = 0; $end = @index-1;
	}
elsif ($_[2] < 0) {
	$start = @index+$_[2]-1; $end = @index+$_[1]-1;
	$start = $start<0 ? 0 : $start;
	}
else {
	$start = $_[1]; $end = $_[2];
	$end = @index-1 if ($end >= @index);
	}
@rv = map { undef } @index;
open(MAIL, "$config{'mail_dir'}/$_[0]");
for($i=$start; $i<=$end; $i++) {
	local ($mail, $line, @headers);
	seek(MAIL, $index[$i]->[0], 0);
	$line = <MAIL>;	# skip From line

	# read mail headers
	$mail->{'line'} = $index[$i]->[1];
	local $lnum = 1;
	while(1) {
		$lnum++;
		($line = <MAIL>) =~ s/\r|\n//g;
		$mail->{'size'} += length($line);
		if ($line =~ /^(\S+):\s*(.*)/) {
			push(@headers, [ $1, $2 ]);
			}
		elsif ($line =~ /^(\s+.*)/) {
			$headers[$#headers]->[1] .= $1;
			}
		else { last; }
		}
	$mail->{'headers'} = \@headers;
	foreach $h (@headers) {
		$mail->{'header'}->{lc($h->[0])} = $h->[1];
		}

	# read the mail body
	while(1) {
		$line = <MAIL>;
		last if (!$line || $line =~ /^From\s+.*\d+\n/);
		$lnum++;
		$mail->{'size'} += length($line);
		$mail->{'body'} .= $line;
		}
	$mail->{'eline'} = $mail->{'line'} + $lnum - 1;
	$mail->{'idx'} = $i;
	$rv[$i] = $mail;
	}
return @rv;
}

# search_mail(user, field, match)
# Returns an array of messages matching some search
sub search_mail
{
local @index = &build_index($_[0]);
local (@rv, $i);
open(MAIL, "$config{'mail_dir'}/$_[0]");
for($i=@index-1; $i>=0; $i--) {
	local ($mail, $line, @headers);
	seek(MAIL, $index[$i]->[0], 0);
	$line = <MAIL>;	# skip From line

	# read mail headers
	$mail->{'line'} = $index[$i]->[1];
	local $lnum = 1;
	while(1) {
		$lnum++;
		($line = <MAIL>) =~ s/\r|\n//g;
		$mail->{'size'} += length($line);
		if ($line =~ /^(\S+):\s*(.*)/) {
			push(@headers, [ $1, $2 ]);
			}
		elsif ($line =~ /^(\s+.*)/) {
			$headers[$#headers]->[1] .= $1;
			}
		else { last; }
		}
	$mail->{'headers'} = \@headers;
	foreach $h (@headers) {
		$mail->{'header'}->{lc($h->[0])} = $h->[1];
		}

	# read mail body
	while(1) {
		$line = <MAIL>;
		last if (!$line || $line =~ /^From\s+.*\d+\n/);
		$lnum++;
		$mail->{'size'} += length($line);
		$mail->{'body'} .= $line;
		}
	$mail->{'eline'} = $mail->{'line'} + $lnum - 1;
	$mail->{'idx'} = $i;
	if ($_[1] eq 'body' && $mail->{'body'} =~ /$_[2]/i ||
	    $_[1] ne 'body' && $mail->{'header'}->{$_[1]} =~ /$_[2]/i) {
		push(@rv, $mail);
		}
	}
return @rv;

}

# build_index(user)
sub build_index
{
local @index;
local @ist = stat("$module_config_directory/$_[0].index");
local @st = stat("$config{'mail_dir'}/$_[0]");
if (!@ist || $ist[9] < $st[9]) {
	# Need to build index
	local $pos = 0;
	local $lnum = 0;
	open(MAIL, "$config{'mail_dir'}/$_[0]");
	while(<MAIL>) {
		if (/^From\s+.*\d+\n/) {
			push(@index, [ $pos, $lnum ]);
			}
		$pos += length($_);
		$lnum++;
		}
	close(MAIL);
	open(INDEX, ">$module_config_directory/$_[0].index");
	print INDEX map { $_->[0]." ".$_->[1]."\n" } @index;
	close(INDEX);
	}
else {
	# Read the index file
	open(INDEX, "$module_config_directory/$_[0].index");
	@index = map { /(\d+)\s+(\d+)/; [ $1, $2 ] } <INDEX>;
	close(INDEX);
	}
return @index;
}

# parse_mail(&mail)
# Extracts the attachments from the mail body
sub parse_mail
{
local $ct = $_[0]->{'header'}->{'content-type'};
local (@attach, $h, $a);
if ($ct =~ /multipart\/(\S+)/i && ($ct =~ /boundary="([^"]+)"/i ||
				   $ct =~ /boundary=([^;\s]+)/i)) {
	# Multipart MIME message
	local $bound = "--".$1;
	local @lines = split(/\n/, $_[0]->{'body'});
	local $l;
	local $max = @lines;
	while($l < $max && $lines[$l++] ne $bound) {
		# skip to first boundary
		}
	while(1) {
		# read attachment headers
		local (@headers, $attach);
		while($lines[$l]) {
			if ($lines[$l] =~ /^(\S+):\s*(.*)/) {
				push(@headers, [ $1, $2 ]);
				}
			elsif ($lines[$l] =~ /^(\s+.*)/) {
				$headers[$#headers]->[1] .= $1;
				}
			$l++;
			}
		$l++;
		$attach->{'headers'} = \@headers;
		foreach $h (@headers) {
			$attach->{'header'}->{lc($h->[0])} = $h->[1];
			}
		if ($attach->{'header'}->{'content-type'} =~ /^([^;]+)/) {
			$attach->{'type'} = lc($1);
			}
		else {
			$attach->{'type'} = 'text/plain';
			}
		if ($attach->{'header'}->{'content-disposition'} =~
		    /filename="([^"]+)"/i) {
			$attach->{'filename'} = $1;
			}
		elsif ($attach->{'header'}->{'content-disposition'} =~
		       /filename=([^;\s]+)/i) {
			$attach->{'filename'} = $1;
			}
		elsif ($attach->{'header'}->{'content-type'} =~
		    /name="([^"]+)"/i) {
			$attach->{'filename'} = $1;
			}

		# read the attachment body
		while($l < $max && $lines[$l] !~ /^$bound(--)?$/) {
			$attach->{'data'} .= $lines[$l]."\n";
			$l++;
			}

		# decode if necessary
		if (lc($attach->{'header'}->{'content-transfer-encoding'}) eq
		    'base64') {
			$attach->{'data'} = &b64decode($attach->{'data'});
			}
		elsif (lc($attach->{'header'}->{'content-transfer-encoding'}) eq
		       'x-uue') {
			$attach->{'data'} = &uudecode($attach->{'data'});
			}
		elsif (lc($attach->{'header'}->{'content-transfer-encoding'}) eq
		       'quoted-printable') {
			$attach->{'data'} = &quoted_decode($attach->{'data'});
			}

		$attach->{'idx'} = scalar(@attach);
		push(@attach, $attach);
		if ($attach->{'type'} eq 'message/rfc822') {
			# Decode this included email as well
			local ($amail, @aheaders, $i);
			local @alines = split(/\n/, $attach->{'data'});
			while($i < @alines && $alines[$i]) {
				if ($alines[$i] =~ /^(\S+):\s*(.*)/) {
					push(@aheaders, [ $1, $2 ]);
					}
				elsif ($alines[$i] =~ /^(\s+.*)/) {
					$aheaders[$#aheaders]->[1] .= $1;
					}
				$i++;
				}
			$amail->{'headers'} = \@aheaders;
			foreach $h (@aheaders) {
				$amail->{'header'}->{lc($h->[0])} = $h->[1];
				}
			splice(@alines, 0, $i);
			$amail->{'body'} = join("\n", @alines)."\n";
			&parse_mail($amail);
			map { $_->{'idx'} += scalar(@attach) }
			    @{$amail->{'attach'}};
			push(@attach, @{$amail->{'attach'}});
			}
		elsif ($attach->{'type'} =~ /multipart\/(\S+)/i) {
			# This attachment contains more attachments
			local $amail = { 'header' => $attach->{'header'},
					 'body' => $attach->{'data'} };
			&parse_mail($amail);
			pop(@attach);
			map { $_->{'idx'} += scalar(@attach) }
			    @{$amail->{'attach'}};
			push(@attach, @{$amail->{'attach'}});
			}
		last if ($l >= $max || $lines[$l] eq "$bound--");
		$l++;
		}
	$_[0]->{'attach'} = \@attach;
	}
elsif ($_[0]->{'body'} =~ /begin\s+([0-7]+)\s+(\S+)/i) {
	# Looks like a uuencoded message!
	local $filename = $2;
	$_[0]->{'attach'} = [ { 'type' => &guess_type($filename),
				'idx' => 0,
				'filename' => $filename,
				'data' => &uudecode($_[0]->{'body'}) } ];
	}
elsif ($_[0]->{'header'}->{'content-transfer-encoding'} eq 'base64') {
	# Signed body section
	$ct =~ s/;.*$//;
	$_[0]->{'attach'} = [ { 'type' => lc($ct),
				'idx' => 0,
				'data' => &b64decode($_[0]->{'body'}) } ];
	}
else {
	# One big attachment (probably text)
	local ($type, $body);
	($type = $ct) =~ s/;.*$//;
	$type = 'text/plain' if (!$type);
	if ($_[0]->{'header'}->{'content-transfer-encoding'} eq 'base64') {
		$body = &b64decode($_[0]->{'body'});
		}
	else {
		$body = $_[0]->{'body'};
		}
	$_[0]->{'attach'} = [ { 'type' => lc($type),
				'idx' => 0,
				'data' => $body } ];
	}
}

# delete_mail(user, &mail, ...)
sub delete_mail
{
local $lref = &read_file_lines("$config{'mail_dir'}/$_[0]");
local @m = sort { $b->{'line'} <=> $a->{'line'} } @_[1..@_-1];
local $m;
foreach $m (@m) {
	splice(@$lref, $m->{'line'}, $m->{'eline'} - $m->{'line'} + 1);
	}
&flush_file_lines();
}

# send_mail(&mail)
sub send_mail
{
local (%header, $h);
if ($config{'send_mode'}) {
	# Connect to SMTP server
	foreach $h (@{$_[0]->{'headers'}}) {
		$header{lc($h->[0])} = $h->[1];
		}
	&open_socket($config{'send_mode'}, 25, MAIL);
	&smtp_command(MAIL);
	&smtp_command(MAIL, "helo ".&from_hostname()."\n");
	local @from = &address_parts($header{'from'});
	&smtp_command(MAIL, "mail from: $from[0]\n");
	foreach $u (&address_parts($header{'to'}.",".$header{'cc'}.
						 ",".$header{'bcc'})) {
		&smtp_command(MAIL, "rcpt to: $u\n");
		}
	&smtp_command(MAIL, "data\n");
	}
else {
	# Start sendmail
	open(MAIL, "| $config{'sendmail_path'} -t >/dev/null 2>&1");
	}
foreach $h (@{$_[0]->{'headers'}}) {
	print MAIL $h->[0],": ",$h->[1],"\n";
	}
print MAIL "MIME-Version: 1.0\n";
local $bound = "--------".time();
print MAIL "Content-Type: multipart/mixed; boundary=\"$bound\"\n";
print MAIL "\n";

# Send attachments
print MAIL "This is a multi-part message in MIME format.\n";
foreach $a (@{$_[0]->{'attach'}}) {
	print MAIL "--",$bound,"\n";
	local $enc;
	foreach $h (@{$a->{'headers'}}) {
		print MAIL $h->[0],": ",$h->[1],"\n";
		$enc = $h->[1] if (lc($h->[0]) eq 'content-transfer-encoding');
		}
	print MAIL "\n";
	if (lc($enc) eq 'base64') {
		print MAIL &encode_base64($a->{'data'});
		}
	else {
		print MAIL $a->{'data'};
		print MAIL "\n" if ($a->{'data'} !~ /\n$/);
		}
	}
print MAIL "--",$bound,"--\n";
if ($config{'send_mode'}) {
	&smtp_command(MAIL, ".\n");
	&smtp_command(MAIL, "quit\n");
	}
close(MAIL);
}

# b64decode(string)
# Converts a string from base64 format to normal
sub b64decode
{
    local($str) = $_[0];
    local($res);
    $str =~ tr|A-Za-z0-9+=/||cd;
    $str =~ s/=+$//;
    $str =~ tr|A-Za-z0-9+/| -_|;
    while ($str =~ /(.{1,60})/gs) {
        my $len = chr(32 + length($1)*3/4);
        $res .= unpack("u", $len . $1 );
    }
    return $res;
}

sub guess_type
{
local $e;
if (!%mime_types) {
	open(MIME, "../mime.types");
	while(<MIME>) {
		s/\r|\n//g;
		s/#.*$//g;
		local @s = split(/\s+/);
		foreach $e (@s[1..$#s]) {
			$mime_types{$e} = $s[0];
			}
		}
	close(MIME);
	}
if ($_[0] =~ /\.([A-z0-9]+)$/ && $mime_types{$1}) {
	return $mime_types{$1};
	}
return "application/octet-stream";
}

# can_read_mail(user)
sub can_read_mail
{
return 0 if ($access{'mmode'} == 0);
return 1 if ($access{'mmode'} == 1);
local $u;
if ($access{'mmode'} == 2) {
	foreach $u (split(/\s+/, $access{'musers'})) {
		return 1 if ($u eq $_[0]);
		}
	return 0;
	}
else {
	foreach $u (split(/\s+/, $access{'musers'})) {
		return 0 if ($u eq $_[0]);
		}
	return 1;
	}
}

# from_hostname()
sub from_hostname
{
local ($d, $masq);
local $conf = &get_sendmailcf();
foreach $d (&find_type("D", $conf)) {
	if ($d->{'value'} =~ /^M\s*(\S*)/) { $masq = $1; }
	}
return $masq ? $masq : &get_system_hostname();
}

# mail_from_queue(qfile, dfile)
sub mail_from_queue
{
local $mail;
open(QF, $_[0]);
while(<QF>) {
	s/\r|\n//g;
	if (/^H\?[^\?]*\?(\S+):\s+(.*)/ || /^H(\S+):\s+(.*)/) {
		push(@headers, [ $1, $2 ]);
		}
	elsif (/^(\s+.*)/) {
		$headers[$#headers]->[1] .= $1;
		}
	}
close(QF);
$mail->{'headers'} = \@headers;
foreach $h (@headers) {
	$mail->{'header'}->{lc($h->[0])} = $h->[1];
	}

# Read the mail body
open(DF, $_[1]);
while(<DF>) {
	$mail->{'body'} .= $_;
	}
close(DF);
return $mail;
}

# wrap_lines(text, width)
# Given a multi-line string, return an array of lines wrapped to
# the given width
sub wrap_lines
{
local @rv;
local $w = $_[1];
foreach $rest (split(/\n/, $_[0])) {
	if ($rest =~ /\S/) {
		while($rest =~ /^(.{1,$w}\S*)\s*([\0-\377]*)$/) {
			push(@rv, $1);
			$rest = $2;
			}
		}
	else {
		# Empty line .. keep as it is
		push(@rv, $rest);
		}
	}
return @rv;
}

# smtp_command(handle, command)
sub smtp_command
{
local ($m, $c) = @_;
print $m $c;
local $r = <$m>;
if ($r !~ /^[23]\d+/) {
	&error(&text('send_esmtp', "<tt>$c</tt>", "<tt>$r</tt>"));
	}
}

# address_parts(string)
sub address_parts
{
local @rv;
local $rest = $_[0];
while($rest =~ /([^<>\s,'"\@]+\@[A-z0-9\-\.\!]+)(.*)/) {
	push(@rv, $1);
	$rest = $2;
	}
return @rv;
}

# link_urls(text)
sub link_urls
{
local $r = $_[0];
$r =~ s/((http|ftp|https|mailto):[^><"'\s&\?]+)/<a href="$1">$1<\/a>/g;
return $r;
}

# uudecode(text)
sub uudecode
{
local @lines = split(/\n/, $_[0]);
local ($l, $data);
for($l=0; $lines[$l] !~ /begin\s+([0-7]+)\s/i; $l++) { }
while($lines[++$l]) {
	$data .= unpack("u", $lines[$l]);
	}
return $data;
}

sub simplify_date
{
if ($_[0] =~ /^(\S+),\s+0*(\d+)\s+(\S+)\s+(\d+)\s+(\d+):(\d+)/) {
	return "$2/$3/$4 $5:$6";
	}
return $_[0];
}

sub simplify_from
{
local $rv = $_[0];
$rv =~ s/<[^>]+>//g;
return &html_escape($rv);
}

sub simplify_subject
{
return $_[0] =~ /\S/ ? &html_escape($_[0]) : "<br>";
}

# quoted_decode(text)
sub quoted_decode
{
local $t = $_[0];
$t =~ s/=\n//g;
$t =~ s/=(\S\S)/pack("c",hex($1))/ge;
return $t;
}

1;
