#!/usr/local/bin/perl
# edit_fshare.cgi
# Display a form for editing or creating a new directory share

require './samba-lib.pl';
&ReadParse();
$s = $in{'share'};
if ($s) {
	if ($s eq "global") {
		&header($text{'share_title1'}, "");
		}
	else {
		&header($text{'share_title2'}, "");
		}
	&get_share($s);
	}
else {
	&header($text{'share_title3'}, "");
	}
print "<hr>\n";

print "<form action=save_fshare.cgi>\n";
if ($s) { print "<input type=hidden name=old_name value=\"$s\">\n"; }

# Vital share options..
print "<table border width=100%>\n";
print "<tr $tb> <td><b>$text{'share_info'}</b></td> </tr>\n";
print "<tr $cb> <td><table cellpadding=2>\n";
if ($s ne "global") {
	if ($copy = &getval("copy")) {
		print "<tr> <td colspan=4><b>",&text('share_copy', $copy),
		      "</b></td> </tr>\n";
		}
	print "<tr> <td align=right><b>$text{'share_name'}</b></td>\n";
	printf "<td colspan=3><input type=radio name=homes value=0 %s>\n",
		$s eq "homes" ? "" : "checked";
	printf "<input size=10 name=share value=\"%s\">&nbsp;&nbsp;&nbsp;\n",
		$s eq "homes" ? "" : $s;
	printf "<input type=radio name=homes value=1 %s> $text{'share_home'}\n",
		$s eq "homes" ? "checked" : "";
	print "</td> </tr>\n";
	}

print "<tr> <td align=right><b>$text{'share_dir'}</b></td>\n";
printf "<td colspan=3><input name=path size=40 value=\"%s\">\n",
	&getval("path");
print &file_chooser_button("path", 1);
print "</td> </tr>\n";

print "<tr> <td align=right><b>$text{'share_available'}</b></td>\n";
print "<td>",&yesno_input("available"),"</td>\n";

print "<td align=right><b>$text{'share_browseable'}</b></td>\n";
print "<td>",&yesno_input("browseable"),"</td> </tr>\n";

print "<td align=right><b>$text{'share_comment'}</b></td>\n";
printf "<td colspan=3><input size=40 name=comment value=\"%s\"></td> </tr>\n",
	&getval("comment");

print "</table> </td></tr></table><p>\n";
if ($s eq "global") {
	print "<input type=submit value=$text{'save'}> </form>\n";
	}
elsif ($s) {
	print "<table width=100%> <tr>\n";
	print "<td align=left><input type=submit value=$text{'save'}></td>\n";
	print "</form><form action=view_users.cgi>\n";
	print "<input type=hidden name=share value=\"$s\">\n";
	print "<td align=center><input type=submit value=\"$text{'share_view'}\"></td>\n";
	print "</form><form action=delete_share.cgi>\n";
	print "<input type=hidden name=share value=\"$s\">\n";
	print "<td align=right><input type=submit value=$text{'delete'}></td>\n";
	print "</form> </tr> </table>\n";
	}
else {
	print "<input type=submit value=$text{'create'}> </form>\n";
	}

if ($s) {
	# Icons for other share options
	$us = "share=".&urlize($s);
	print "<hr>\n";
	print "<h3>$text{'share_option'}</h3>\n";
	&icons_table( [ "edit_sec.cgi?$us", "edit_fperm.cgi?$us",
			"edit_fname.cgi?$us", "edit_fmisc.cgi?$us" ],
		      [ $text{'share_security'},
			$text{'share_permission'},
			$text{'share_naming'},
			$text{'share_misc'} ],
		      [ "images/icon_2.gif", "images/icon_7.gif",
			"images/icon_8.gif", "images/icon_4.gif" ] );
	}

print "<hr>\n";
&footer("", $text{'index_sharelist'});

