#!/usr/local/bin/perl
# copy_group.cgi
# Copy some group's quota to a number of others

require './quota-lib.pl';
&ReadParse();
$whatfailed = $text{'copy_group_0'};
$access{'filesys'} eq "*" ||
	&error($text{'copy_group_1'});
&can_edit_group($in{'group'}) ||
	&error($text{'copy_group_2'});

if ($in{'dest'} == 0) {
	# Copy to all groups
	setgrent();
	while(@ginfo = getgrent()) { push(@copyto, $ginfo[0]); }
	endgrent();
	}
elsif ($in{'dest'} == 1) {
	# Copy to selected groups
	@copyto = split(/\s+/, $in{'groups'});
	}
elsif ($in{'dest'} == 2) {
	# Copy to groups containing users
	foreach $u (split(/\s+/, $in{'users'})) {
		@uinfo = getpwnam($u);
		@ginfo = getgrgid($uinfo[3]);
		push(@copyto, $ginfo[0]);
		$user{$u}++;
		}
	setgrent();
	while(@ginfo = getgrent()) {
		foreach $m (split(/\s+/, $ginfo[3])) {
			if ($user{$m}) {
				push(@copyto, $ginfo[0]);
				last;
				}
			}
		}
	endgrent();
	}
@copyto = &unique(@copyto);
@copyto = grep { $_ ne $in{'group'} } @copyto;
if (!@copyto) { &error($text{'copy_group_3'}); }
foreach $c (@copyto) {
	&can_edit_group($c) ||
		&error(&text('copy_group_4', $c));
	}

# Do the copy
&copy_group_quota($in{'group'}, @copyto);
&redirect("group_filesys.cgi?group=$in{'group'}");

