#!/usr/local/bin/perl
# index.cgi
# Display a list of all known printers

require './lpadmin-lib.pl';
&header($text{'index_title'}, "", undef, 1, 1);
print "<hr><p>\n";
@plist = &list_printers();

if (@plist) {
	print "<table border width=100%>\n";
	print "<tr $tb> <td><b>$text{'index_name'}</b></td> ",
	      "<td><b>$text{'index_desc'}</b></td> ",
	      "<td><b>$text{'index_to'}</b></td> ",
              "<td><b>$text{'index_driver'}</b></td> ",
	      "<td><b>$text{'index_jobs'}</b></td> </tr>\n";
	for($i=0; $i<@plist; $i++) {
		local ($wdrv, $hdrv, $drv);
		$p = &get_printer($plist[$i]);
		print "<tr $cb>\n";
		if (&can_edit_printer($p->{'name'})) {
			print "<td><a href=\"edit_printer.cgi?",
			      "name=$p->{'name'}\">$p->{'name'}</a></td>\n";
			}
		else {
			print "<td>$p->{'name'}</td>\n";
			}
		print "<td>",$p->{'desc'} ? $p->{'desc'} : "<br>","</td>\n";
		if (!$webmin_windows_driver) {
			$wdrv = &is_webmin_windows_driver($p->{'iface'}, $p);
			}
		$wdrv = &is_windows_driver($p->{'iface'}, $p) if (!$wdrv);
		$hdrv = &is_hpnp_driver($p->{'iface'}, $p);
		if ($wdrv) {
			print "<td><tt>\\\\$wdrv->{'server'}",
			      "\\$wdrv->{'share'}</tt></td>\n";
			$p->{'iface'} = $wdrv->{'program'};
			}
		elsif ($hdrv) {
			print "<td><tt>HPNP $hdrv->{'server'}:",
			      "$hdrv->{'port'}</tt></td>\n";
			$p->{'iface'} = $hdrv->{'program'};
			}
		elsif ($p->{'rhost'}) {
			local $qu = $p->{'rqueue'} ? $p->{'rqueue'}
						   : $p->{'name'};
			print"<td><tt>$p->{'rhost'}:$qu</tt></td>\n";
			}
		elsif ($p->{'dhost'}) {
			print"<td><tt>$p->{'dhost'}:$p->{'dport'}</tt></td>\n";
			}
		else {
			print "<td>",&dev_name($p->{'dev'}),"</td>\n";
			}
		if (!$webmin_print_driver) {
			$drv = &is_webmin_driver($p->{'iface'}, $p);
			}
		$drv = &is_driver($p->{'iface'}, $p)
			if ($drv->{'mode'} == 0 || $drv->{'mode'} == 2);
		print "<td>$drv->{'desc'}</td>\n";
		print "<td><a href=\"list_jobs.cgi?name=",
		      "$p->{'name'}\">$text{'index_list'}</a></td> </tr>\n";
		}
	print "</table>\n";
	}
else { print "<h3>$text{'index_none'}</h3>\n"; }
print "<a href=edit_printer.cgi?new=1>$text{'index_add'}</a>\n"
	if ($access{'add'});
print "<p>\n";

# display button to start or stop the scheduler (lpd, lpsched, etc..)
$pid = &sched_running();
if ($pid < 0 || !$access{'stop'}) {
	# cannot stop or start..
	}
elsif ($pid) {
	print "<hr>\n";
	print "<form action=stop.cgi>\n";
        print "<input type=hidden name=pid value=$pid>\n";
        print "<table width=100%><tr><td>\n";
        print "<input type=submit value=\"$text{'index_stop'}\"></td>\n";
	print "<td>$text{'index_stopmsg'}</td> </tr></table>\n";
        print "</form>\n";
	}
else {
	print "<hr>\n";
	print "<form action=start.cgi>\n";
        print "<table width=100%><tr><td>\n";
        print "<input type=submit value=\"$text{'index_start'}\"></td>\n";
	print "<td>$text{'index_startmsg'}</td> </tr></table>\n";
        print "</form>\n";
	}

print "<hr>\n";
&footer("/", $text{'index'});

