#!/usr/local/bin/perl
# tunefs.cgi
# You can tune a filesystem, but you can't tuna fish

require './format-lib.pl';
&ReadParse();
&can_edit_disk($in{'dev'}) || &error("You are not allowed to tune this disk");
$whatfailed = "Failed to tune filesystem";

$cmd = "tunefs";
$cmd .= &opt_check("ufs_a", "number of contiguous blocks", '\d+', "-a");
$cmd .= &opt_check("ufs_d", "rotational delay", '\d+', "-d");
$cmd .= &opt_check("ufs_e", "maximum number of blocks", '\d+', "-e");
$cmd .= &opt_check("ufs_m", "percentage of reserved space", '\d+', "-m");
$cmd .= $in{ufs_o} ? " -o $in{ufs_o}" : "";
$in{dev} =~ s/dsk/rdsk/g;
$cmd .= " $in{dev}";

&header("Create Filesystem", "");
print "<hr>\n";

print "Executing command <tt>$cmd</tt> ...<p>\n";
print "<pre>\n";
open(TUNEFS, "$cmd 2>&1 </dev/null |");
while(<TUNEFS>) { print; }
close(TUNEFS);
print "</pre>\n";
if ($?) { print "... <b>command failed!</b> <p>\n"; }
else { print "... command complete. <p>\n"; }

print "<hr>\n";
&footer("", "disk list");

