#!/usr/local/bin/perl
# index.cgi
# Display a list of known disks and partitions

require './format-lib.pl';
$whatfailed = "Failed to list disks";
&header("Partitions on Local Disks", "", undef, 1, 1);
print "<hr>\n";
$extwidth = 300;

print "<table border width=100%>\n";
print "<tr $tb> <td><b>Disk</b></td> <td><b>Partitions</b></td> </tr>\n";
@dlist = &list_disks();
for($i=0; $i<@dlist; $i++) {
	$dl = $dlist[$i];
	next if (!&can_edit_disk($dl->{'device'}));
	print "<tr $cb> <td valign=top><table>\n";
	print "<tr> <td><b>Disk Type:</b></td> ";
	if ($dl->{'type'}) {
		print "<td>$dl->{'type'}</td></tr>\n";
		print "<tr> <td><b>Cylinders:</b></td> <td>$dl->{'cyl'}</td> </tr>\n";
		}
	else {
		print"<td>Unknown</td></tr>\n";
		}
	$dl->{'device'} =~ /c(\d+)t(\d+)d(\d+)/;
	print "<tr> <td><b>SCSI Controller:</b></td> <td>$1</td> </tr>\n";
	print "<tr> <td><b>SCSI Target:</b></td> <td>$2</td> </tr>\n";
	print "<tr> <td><b>SCSI Unit:</b></td> <td>$3</td> </tr>\n";
	print "</table></td> <td valign=top>\n";
	if (!$dl->{'device'}) {
		# Drive type unknown..
		print "<b>Disk type unknown</b>\n";
		}
	elsif (@parts = &list_partitions($dl->{'device'})) {
		# Known and formatted..
		print "<table> <tr> <td><b>No.</b></td> <td><b>Type</b></td>\n";
		print "<td><b>Extent</b></td> <td><b>Start</b></td>\n";
		print "<td><b>End</b></td> <td><b>Use</b></td> </tr>\n";
		for($j=0; $j<@parts; $j++) {
			$p = $parts[$j];
			print "<tr> <td><a href=\"edit_part.cgi?$i+$j\">$j</a>",
			      "</td> <td>$p->{'tag'}</td> <td>\n";
			if ($p->{'end'} != 0) {
				printf
				  "<img src=images/gap.gif height=10 width=%d>",
				  $extwidth*$p->{'start'}/$dl->{'cyl'};
				printf
				  "<img src=images/use.gif height=10 width=%d>",
				  $extwidth*($p->{'end'}-$p->{'start'})/
				  $dl->{'cyl'};
				printf
				  "<img src=images/gap.gif height=10 width=%d>",
				  $extwidth*($dl->{'cyl'}-$p->{'end'})/
				  $dl->{'cyl'};
				print "</td> <td>$p->{'start'}</td> ",
				      "<td>$p->{'end'}</td> <td>\n";
				@stat = &device_status($p->{'device'});
				if ($stat[1] =~ /^meta/) {
					print "MetaDisk\n";
					}
				elsif ($stat[0] && $stat[3] == -1) {
					print "<tt><a href=/mount/edit_mount.cgi?index=$stat[4]&temp=1>$stat[0]</a></tt>\n";
					}
				elsif ($stat[0]) {
					print "<tt><a href=/mount/edit_mount.cgi?index=$stat[3]>$stat[0]</a></tt>\n";
					}
				print "</td> </tr>\n";
				}
			else { print "<td colspan=4></td>\n"; }
			}
		print "</table>\n";
		}
	else {
		# Disk is not formatted.. 
		print "<b>This disk is not formatted</b>\n";
		}
	print "</td> </tr>\n";
	}
print "</table><p>\n";

print "<hr>\n";
&footer("/", "index");

