#!/usr/local/bin/perl
# index.cgi
# List all subnets and shared networks

require './dhcpd-lib.pl';
&header($text{'index_title'}, "", undef, 1, 1);
print "<hr>\n";
$conf = &get_config();

# Check if dhcpd is installed
if (!(-x $config{'dhcpd_path'})) {
	print "<p>";
	print(&text('index_dhcpdnotfound',$config{'dhcpd_path'}));
	print "<p>\n";
	print "<hr>\n";
	&footer("/", $text{'index_return'});
	exit;
	}

# Check if it is the right version
$out = `$config{'dhcpd_path'} -v 2>&1`;
if ($out !~ /DHCP/ || $out =~ /V1/) {
        print "<p>";
        print(&text('index_dhcpdver',$config{'dhcpd_path'}));
        print "<p>\n";
        print "<hr>\n";
        &footer("/", $text{'index_return'});
	exit;
	}

# get subnets
@subn = &find("subnet", $conf);
map { $_->{'order'} = $_->{'index'} } @subn;
@shan = &find("shared-network", $conf);
foreach $s (@shan) {
	foreach $sn (&find("subnet", $s->{'members'})) {
		push(@subn, $sn);
		$shared{$sn} = $s->{'index'};
		$sn->{'order'} = $s->{'index'} + $sn->{'index'}/100;
		}
	}
@subn = sort { $a->{'order'} <=> $b->{'order'} } @subn;

# display subnets and shared nets
foreach $s (@subn) {
	push(@links, "edit_subnet.cgi?idx=$s->{'index'}".
		     ($shared{$s} ne "" ? "&sidx=$shared{$s}" : ""));
	push(@titles, $s->{'values'}->[0]);
	push(@icons, "images/subnet.gif");
	}
foreach $s (@shan) {
	push(@links, "edit_shared.cgi?idx=$s->{'index'}");
	push(@titles, $s->{'values'}->[0]);
	push(@icons, "images/shared.gif");
	}
print "<h3>$text{'index_subtitle'}</h3>\n";
if (@links) {
	&icons_table(\@links, \@titles, \@icons, 5);
	}
else {
	print "$text{'index_nosubdef'} <p>\n";
	}
print "<a href='edit_subnet.cgi?new=1'>$text{'index_addsub'}</a>&nbsp;&nbsp;\n";
print "<a href='edit_shared.cgi?new=1'>$text{'index_addnet'}</a><p>\n";
print "<hr>\n";

# get hosts
@host = &find("host", $conf);
map { $_->{'order'} = $_->{'index'} } @host;
@group = &find("group", $conf);
foreach $g (@group) {
	foreach $h (&find("host", $g->{'members'})) {
		push(@host, $h);
		$group{$h} = $g->{'index'};
		$h->{'order'} = $g->{'index'} + $h->{'index'}/100;
		push(@{$g->{'hosts'}}, $h->{'values'}->[0]);
		}
	}
@host = sort { $a->{'order'} <=> $b->{'order'} } @host;

# display hosts
@links = @titles = @icons = ();
foreach $h (@host) {
	push(@links, "edit_host.cgi?idx=$h->{'index'}".
		     ($group{$h} ne "" ? "&gidx=$group{$h}" : ""));
	push(@titles, $h->{'values'}->[0]);
	push(@icons, "images/host.gif");
	}
foreach $g (@group) {
	push(@links, "edit_group.cgi?idx=$g->{'index'}");
	$gm = @{$g->{'hosts'}};
	if ($gm == 0) { push(@titles, $text{'index_nomemb'}); }
	elsif ($gm == 1) { push(@titles, $text{'index_1memb'}); }
	else { push(@titles, "$gm $text{'index_memb'}"); }
	push(@icons, "images/group.gif");
	}
print "<h3>$text{'index_hst'}</h3>\n";
if (@links) {
	&icons_table(\@links, \@titles, \@icons, 5);
	}
else {
	print "$text{'index_nohst'} <p>\n";
	}
print "<a href='edit_host.cgi?new=1'>$text{'index_addhst'}</a>&nbsp;&nbsp;\n";
print "<a href='edit_group.cgi?new=1'>$text{'index_addhstg'}</a><p>\n";
print "<hr>\n";

print "<table>\n";
print "<form action=edit_options.cgi>\n";
print "<tr> <td><input type=submit value=\"$text{'index_buttego'}\"></td>\n";
print "<td>$text{'index_ego'} \n";
print "</td> </tr>\n";
print "</form>\n";

print "<form action=list_leases.cgi>\n";
print "<tr> <td><input type=submit value=\"$text{'index_buttlal'}\"></td>\n";
print "<td>$text{'index_lal'} \n";
print "</td> </tr>\n";
print "</form>\n";

if (open(PID, $config{'pid_file'})) {
	chop($pid = <PID>);
	close(PID);
	}
if ($pid && kill(0, $pid)) {
	print "<form action=restart.cgi>\n";
	print "<input type=hidden name=pid value=$pid>\n";
	print "<tr> <td><input type=submit value=\"$text{'index_buttapply'}\"></td>\n";
	print "<td>$text{'index_apply'} \n";
	print "</td></tr>\n";
	print "</form>\n";
	}
else {
	print "<form action=start.cgi>\n";
	print "<tr> <td><input type=submit value=\"$text{'index_buttstart'}\"></td>\n";
	print "<td>$text{'index_start'} \n";
	print "</td> </tr>\n";
	print "</form>\n";
	}
print "</table>\n";

print "<hr>\n";
&footer("/", $text{'index_return'});

