#!/usr/local/bin/perl
# restart.cgi
# Send a SIGHUP to apache

require './apache-lib.pl';
&ReadParse();
&error_setup($text{'restart_err'});

$conf = &get_config();
$pidfilestr = &find_directive_struct("PidFile", $conf);
$pidfile = $pidfilestr ? $pidfilestr->{'words'}->[0]
		       : "logs/httpd.pid";
$pidfile = &server_root($pidfile, $conf);

if (-x $config{'apachectl_path'}) {
	# use apachectl to restart
	$out = `$config{'apachectl_path'} restart 2>&1`;
	if ($out !~ /httpd restarted/) {
		&error("<tt>$out</tt>");
		}
	}
else {
	# send SIGHUP directly
	open(PID, $pidfile) || &error(&text('restart_epid', $pidfile));
	<PID> =~ /(\d+)/ || &error(&text('restart_epid2', $pidfile));
	close(PID);
	kill('HUP', $1) || &error(&text('restart_esig', $1));
	}

# Check if restart was successful.. some config file error may have caused it
# to silently fail
sleep(1);
if (!open(PID, $pidfile) || <PID> !~ /(\d+)/ || !kill(0, $1)) {
	# Not running..  find out why
	$errorlogstr = &find_directive_struct("ErrorLog", $conf);
	$errorlog = $errorlogstr ? $errorlogstr->{'words'}->[0]
				 : "logs/error_log";
	if ($errorlog eq 'syslog' || $errorlog =~ /^\|/) {
		&error($text{'restart_eunknown'});
		}
	else {
		$errorlog = &server_root($errorlog, $conf);
		$out = `tail -5 $errorlog`;
		&error("<pre>$out</pre>");
		}
	}
&redirect($in{'redir'});

