#!/usr/local/bin/perl
# save_user.cgi
# Modify or create a webmin user

$| = 1;
require './acl-lib.pl';
&ReadParse();
@ulist = &list_users();
if ($in{'old'}) {
	$in{'name'} = $in{'old'} if (!$access{'rename'});
	&can_edit_user($in{'old'}) || &error($text{'save_euser'});
	foreach $u (@ulist) {
		$old = $u if ($u->{'name'} eq $in{'old'});
		}
	}
else {
	$access{'create'} || &error($text{'save_ecreate'});
	}
&error_setup($text{'save_err'});

$in{'name'} =~ /^[A-z0-9\-\_\.]+$/ ||
	&error(&text('save_ename', $in{'name'}));
if (!$in{'old'} || $in{'old'} ne $in{'name'}) {
	foreach $u (@ulist) {
		if ($u->{'name'} eq $in{'name'}) {
			&error(&text('save_edup', $in{'name'}));
			}
		}
	}

foreach $u (@ulist) {
	if ($u->{'name'} eq $ENV{'REMOTE_USER'}) {
		$me = $u;
		}
	}
@mcan = $access{'mode'} == 1 ? @{$me->{'modules'}} :
	$access{'mode'} == 2 ? split(/\s+/, $access{'mods'}) :
			       &list_modules();
map { $mcan{$_}++ } @mcan;

@mods = split(/\0/, $in{'mod'});
foreach $m (@mods) {
	$mcan{$m} || &error(&text('save_emod', $m));
	}
if ($in{'old'}) {
	# Add modules that this user already has, but were not allowed
	# to be changed or are not available for this OS
	foreach $m (@{$old->{'modules'}}) {
		push(@mods, $m) if (!$mcan{$m});
		}
	}
if ($ENV{'REMOTE_USER'} eq $in{'old'} && &indexof("acl", @mods) == -1) {
	&error($text{'save_edeny'});
	}

$salt = chr(int(rand(26))+65).chr(int(rand(26))+65);
$user{'name'} = $in{'name'};
$user{'modules'} = \@mods;
$user{'lang'} = !$access{'lang'} ? $old->{'lang'} :
		$in{'lang_def'} ? undef : $in{'lang'};
$user{'cert'} = !$access{'chcert'} ? $old->{'cert'} :
		$in{'cert_def'} ? undef : $in{'cert'};
$user{'notabs'} = $in{'notabs'};
$raddr = $ENV{'REMOTE_ADDR'};
@ips = split(/\s+/, $in{'ips'});
if ($in{'ipmode'} == 1) {
	$user{'allow'} = join(" ", @ips);
	if ($old->{'name'} eq $ENV{'REMOTE_USER'} && !&ip_match($raddr, @ips)) {
		&error(&text('save_eself', $raddr));
		}
	}
elsif ($in{'ipmode'} == 2) {
	$user{'deny'} = join(" ", @ips);
	if ($old->{'name'} eq $ENV{'REMOTE_USER'} && &ip_match($raddr, @ips)) {
		&error(&text('save_eself', $raddr));
		}
	}
if ($in{'pass_def'} == 0) {
	$in{'pass'} =~ /:/ && &error($text{'save_ecolon'});
	$salt = chr(int(rand(26))+65).chr(int(rand(26))+65);
	$user{'pass'} = crypt($in{'pass'}, $salt);
	$user{'sync'} = 0;
	}
elsif ($in{'pass_def'} == 1) {
	$user{'pass'} = $in{'oldpass'};
	$user{'sync'} = 0;
	}
else {
	&foreign_check("useradmin") || &error($text{'save_eos'});
	&foreign_require("useradmin", "user-lib.pl");
	foreach $uu (&foreign_call("useradmin", "list_users")) {
		$user{'pass'} = $uu->{'pass'} if ($uu->{'user'} eq $in{'name'});
		}
	defined($user{'pass'}) ||
		&error(&text('save_eunix', $in{'name'}));
	if ($user{'pass'} =~ /^\$1\$/ && crypt("foo", "xx") !~ /^\$1\$/ &&
	    crypt('test', '$1$A9wB3O18$zaZgqrEmb9VNltWTL454R/') ne
		  '$1$A9wB3O18$zaZgqrEmb9VNltWTL454R/') {
		&error($text{'save_emd5'});
		}
	$user{'sync'} = 1;
	}

if ($in{'old'}) {
	# update user and all ACLs
	&modify_user($in{'old'}, \%user);
	foreach $u (&list_users()) {
		%uaccess = &get_module_acl($u->{'name'});
		local @au = split(/\s+/, $uaccess{'users'});
		local $idx = &indexof($in{'old'}, @au);
		if ($idx != -1) {
			$au[$idx] = $in{'name'};
			$uaccess{'users'} = join(" ", @au);
			&save_module_acl(\%uaccess, $u->{'name'});
			}
		}
	}
else {
	# create and add to access list
	&create_user(\%user, $in{'clone'});
	if ($access{'users'} ne '*') {
		$access{'users'} .= " ".$in{'name'};
		&save_module_acl(\%access);
		}
	}
&restart_miniserv();
&redirect("");

# ip_match(ip, [match]+)
# Checks an IP address against a list of IPs, networks and networks/masks
sub ip_match
{
local(@io, @mo, @ms, $i, $j);
@io = split(/\./, $_[0]);
for($i=1; $i<@_; $i++) {
	local $mismatch = 0;
	if ($_[$i] =~ /^(\S+)\/(\S+)$/) {
		# Compare with network/mask
		@mo = split(/\./, $1); @ms = split(/\./, $2);
		for($j=0; $j<4; $j++) {
			if ((int($io[$j]) & int($ms[$j])) != int($mo[$j])) {
				$mismatch = 1;
				}
			}
		}
	else {
		# Compare with IP or network
		@mo = split(/\./, $_[$i]);
		while(@mo && !$mo[$#mo]) { pop(@mo); }
		for($j=0; $j<@mo; $j++) {
			if ($mo[$j] != $io[$j]) {
				$mismatch = 1;
				}
			}
		}
	return 1 if (!$mismatch);
	}
return 0;
}

