/* A Bison parser, made from parse.y
   by GNU bison 1.35.  */

#define YYBISON 1  /* Identify Bison output.  */

# define	CREATE	257
# define	ADD	258
# define	PORT	259
# define	BIND	260
# define	CLONE	261
# define	DOT	262
# define	BLOCK	263
# define	OPEN	264
# define	RESET	265
# define	DEFAULT	266
# define	SET	267
# define	ACTION	268
# define	PERSONALITY	269
# define	RANDOM	270
# define	ANNOTATE	271
# define	NO	272
# define	FINSCAN	273
# define	FRAGMENT	274
# define	DROP	275
# define	OLD	276
# define	NEW	277
# define	COLON	278
# define	PROXY	279
# define	UPTIME	280
# define	DROPRATE	281
# define	IN	282
# define	SYN	283
# define	UID	284
# define	GID	285
# define	ROUTE	286
# define	ENTRY	287
# define	LINK	288
# define	NET	289
# define	UNREACH	290
# define	SLASH	291
# define	LATENCY	292
# define	MS	293
# define	LOSS	294
# define	BANDWIDTH	295
# define	SUBSYSTEM	296
# define	OPTION	297
# define	TO	298
# define	SHARED	299
# define	NETWORK	300
# define	TUNNEL	301
# define	TARPIT	302
# define	DYNAMIC	303
# define	USE	304
# define	IF	305
# define	OTHERWISE	306
# define	EQUAL	307
# define	SOURCE	308
# define	OS	309
# define	IP	310
# define	BETWEEN	311
# define	DASH	312
# define	TIME	313
# define	INTERNAL	314
# define	STRING	315
# define	CMDSTRING	316
# define	IPSTRING	317
# define	NUMBER	318
# define	PROTO	319
# define	FLOAT	320

#line 30 "parse.y"

#include <sys/types.h>

#include "config.h"

#ifdef HAVE_SYS_TIME_H
#include <sys/time.h>
#endif
#include <sys/tree.h>
#include <sys/queue.h>

#include <stdio.h>
#include <stdlib.h>
#include <err.h>
#include <stdarg.h>
#include <string.h>
#include <errno.h>
#include <time.h>

#include <pcap.h>
#include <dnet.h>

#include <event.h>

#include "honeyd.h"
#include "personality.h"
#include "router.h"
#include "plugins_config.h"
#include "plugins.h"
#include "template.h"
#include "condition.h"
#include "interface.h"
#include "pfvar.h"
#ifdef HAVE_PYTHON
#include "pyextend.h"
#endif

int hydlex(void);
int hydparse(void);
int hyderror(char *, ...);
int hydwarn(char *, ...);

#define yylex hydlex
#define yyparse hydparse
#define yyerror hyderror
#define yywarn hydwarn
#define yyin hydin

pf_osfp_t pfctl_get_fingerprint(const char *);
struct action *honeyd_protocol(struct template *, int);
void port_action_clone(struct action *, struct action *);

int lineno;
char *filename;
int errors = 0;
int curtype = -1;	/* Lex sets it to SOCK_STREAM or _DGRAM */


#line 119 "parse.y"
#ifndef YYSTYPE
typedef union {
	char *string;
	int number;
	struct link_drop drop;
	struct addr addr;
	struct action action;
	struct template *tmpl;
	struct personality *pers;
	struct addrinfo *ai;
	enum fragpolicy fragp;
	float floatp;
	struct condition condition;
	struct tm time;
	struct condition_time timecondition;
} yystype;
# define YYSTYPE yystype
# define YYSTYPE_IS_TRIVIAL 1
#endif
#ifndef YYDEBUG
# define YYDEBUG 0
#endif



#define	YYFINAL		166
#define	YYFLAG		-32768
#define	YYNTBASE	67

/* YYTRANSLATE(YYLEX) -- Bison token number corresponding to YYLEX. */
#define YYTRANSLATE(x) ((unsigned)(x) <= 320 ? yytranslate[x] : 94)

/* YYTRANSLATE[YYLEX] -- Bison token number corresponding to YYLEX. */
static const char yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     3,     4,     5,
       6,     7,     8,     9,    10,    11,    12,    13,    14,    15,
      16,    17,    18,    19,    20,    21,    22,    23,    24,    25,
      26,    27,    28,    29,    30,    31,    32,    33,    34,    35,
      36,    37,    38,    39,    40,    41,    42,    43,    44,    45,
      46,    47,    48,    49,    50,    51,    52,    53,    54,    55,
      56,    57,    58,    59,    60,    61,    62,    63,    64,    65,
      66
};

#if YYDEBUG
static const short yyprhs[] =
{
       0,     0,     1,     4,     7,    10,    13,    16,    19,    22,
      25,    28,    31,    34,    41,    48,    54,    60,    64,    69,
      74,    78,    85,    90,    95,   101,   107,   112,   119,   123,
     127,   131,   137,   148,   157,   162,   167,   169,   172,   175,
     178,   181,   183,   185,   189,   193,   196,   199,   203,   207,
     213,   219,   221,   223,   226,   228,   230,   232,   234,   236,
     238,   240,   241,   245,   246,   249,   250,   254,   257,   258,
     266,   271,   276,   281,   287,   288,   290,   291,   293,   298,
     303,   308,   311,   316
};
static const short yyrhs[] =
{
      -1,    67,    68,     0,    67,    69,     0,    67,    70,     0,
      67,    71,     0,    67,    72,     0,    67,    73,     0,    67,
      74,     0,    67,    88,     0,     3,    61,     0,     3,    12,
       0,    49,    61,     0,     4,    81,    65,     5,    64,    80,
       0,     4,    81,    50,    81,    51,    91,     0,     4,    81,
      52,    50,    81,     0,     4,    81,    42,    62,    89,     0,
       6,    77,    81,     0,     6,    91,    77,    81,     0,     6,
      77,    44,    61,     0,     7,    61,    81,     0,    13,    81,
      12,    65,    14,    80,     0,    13,    81,    15,    82,     0,
      13,    81,    26,    64,     0,    13,    81,    27,    28,    83,
       0,    13,    81,    27,    29,    83,     0,    13,    81,    30,
      64,     0,    13,    81,    30,    64,    31,    64,     0,    17,
      82,    75,     0,    17,    82,    76,     0,    32,    33,    77,
       0,    32,    33,    77,    46,    78,     0,    32,    77,     4,
      35,    78,    77,    84,    85,    86,    87,     0,    32,    77,
       4,    35,    78,    47,    77,    77,     0,    32,    77,    34,
      78,     0,    32,    77,    36,    78,     0,    19,     0,    18,
      19,     0,    20,    21,     0,    20,    22,     0,    20,    23,
       0,    63,     0,    62,     0,    77,    37,    64,     0,    77,
      24,    64,     0,    90,    61,     0,    90,    62,     0,    90,
      60,    62,     0,    90,    25,    79,     0,    90,    25,    61,
      24,    64,     0,    90,    25,    61,    24,    61,     0,     9,
       0,    11,     0,    90,    10,     0,    61,     0,    12,     0,
      77,     0,    62,     0,    16,     0,    66,     0,    64,     0,
       0,    38,    64,    39,     0,     0,    40,    83,     0,     0,
      41,    64,    64,     0,    41,    64,     0,     0,    21,    57,
      64,    39,    58,    64,    39,     0,    43,    61,    61,    64,
       0,    43,    61,    61,    66,     0,    43,    61,    61,    61,
       0,    43,    61,    61,    37,    61,     0,     0,    45,     0,
       0,    48,     0,    54,    55,    53,    62,     0,    54,    56,
      53,    77,     0,    54,    56,    53,    78,     0,    59,    92,
       0,    57,    93,    58,    93,     0,    64,    24,    64,    61,
       0
};

#endif

#if YYDEBUG
/* YYRLINE[YYN] -- source line where rule number YYN was defined. */
static const short yyrline[] =
{
       0,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     147,   153,   158,   168,   176,   184,   193,   208,   215,   238,
     266,   274,   292,   298,   304,   315,   326,   336,   348,   354,
     361,   367,   373,   402,   413,   424,   437,   438,   440,   441,
     442,   444,   450,   470,   491,   503,   510,   520,   534,   542,
     568,   584,   590,   596,   605,   612,   618,   625,   633,   640,
     644,   649,   650,   655,   656,   661,   662,   666,   671,   672,
     681,   692,   703,   715,   731,   735,   741,   745,   751,   764,
     772,   780,   790,   797
};
#endif


#if (YYDEBUG) || defined YYERROR_VERBOSE

/* YYTNAME[TOKEN_NUM] -- String name of the token TOKEN_NUM. */
static const char *const yytname[] =
{
  "$", "error", "$undefined.", "CREATE", "ADD", "PORT", "BIND", "CLONE", 
  "DOT", "BLOCK", "OPEN", "RESET", "DEFAULT", "SET", "ACTION", 
  "PERSONALITY", "RANDOM", "ANNOTATE", "NO", "FINSCAN", "FRAGMENT", 
  "DROP", "OLD", "NEW", "COLON", "PROXY", "UPTIME", "DROPRATE", "IN", 
  "SYN", "UID", "GID", "ROUTE", "ENTRY", "LINK", "NET", "UNREACH", 
  "SLASH", "LATENCY", "MS", "LOSS", "BANDWIDTH", "SUBSYSTEM", "OPTION", 
  "TO", "SHARED", "NETWORK", "TUNNEL", "TARPIT", "DYNAMIC", "USE", "IF", 
  "OTHERWISE", "EQUAL", "SOURCE", "OS", "IP", "BETWEEN", "DASH", "TIME", 
  "INTERNAL", "STRING", "CMDSTRING", "IPSTRING", "NUMBER", "PROTO", 
  "FLOAT", "config", "creation", "addition", "subsystem", "binding", 
  "set", "annotate", "route", "finscan", "fragment", "ipaddr", "ipnet", 
  "ipaddrplusport", "action", "template", "personality", "rate", 
  "latency", "packetloss", "bandwidth", "randomearlydrop", "option", 
  "shared", "flags", "condition", "timecondition", "time", 0
};
#endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives. */
static const short yyr1[] =
{
       0,    67,    67,    67,    67,    67,    67,    67,    67,    67,
      68,    68,    68,    69,    69,    69,    70,    71,    71,    71,
      71,    72,    72,    72,    72,    72,    72,    72,    73,    73,
      74,    74,    74,    74,    74,    74,    75,    75,    76,    76,
      76,    77,    77,    78,    79,    80,    80,    80,    80,    80,
      80,    80,    80,    80,    81,    81,    81,    82,    82,    83,
      83,    84,    84,    85,    85,    86,    86,    86,    87,    87,
      88,    88,    88,    88,    89,    89,    90,    90,    91,    91,
      91,    91,    92,    93
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN. */
static const short yyr2[] =
{
       0,     0,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     6,     6,     5,     5,     3,     4,     4,
       3,     6,     4,     4,     5,     5,     4,     6,     3,     3,
       3,     5,    10,     8,     4,     4,     1,     2,     2,     2,
       2,     1,     1,     3,     3,     2,     2,     3,     3,     5,
       5,     1,     1,     2,     1,     1,     1,     1,     1,     1,
       1,     0,     3,     0,     2,     0,     3,     2,     0,     7,
       4,     4,     4,     5,     0,     1,     0,     1,     4,     4,
       4,     2,     4,     4
};

/* YYDEFACT[S] -- default rule to reduce with in state S when YYTABLE
   doesn't specify something else to do.  Zero means the default is an
   error. */
static const short yydefact[] =
{
       1,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     2,     3,     4,     5,     6,     7,     8,     9,    11,
      10,    55,    54,    42,    41,    56,     0,     0,     0,     0,
       0,     0,     0,    58,    57,     0,     0,     0,     0,    12,
       0,     0,     0,     0,     0,     0,     0,    81,     0,    17,
       0,    20,     0,     0,     0,     0,     0,     0,    36,     0,
      28,    29,    30,     0,     0,     0,     0,    74,     0,     0,
       0,     0,     0,     0,     0,    19,    18,     0,    22,    23,
       0,     0,    26,    37,    38,    39,    40,     0,     0,     0,
      34,    35,     0,    72,    70,    71,    75,    16,     0,    15,
      76,    78,    79,    80,     0,     0,    76,    60,    59,    24,
      25,     0,    31,     0,     0,    73,    14,    51,    52,    77,
      13,     0,     0,    82,    21,    27,     0,    61,    43,    53,
       0,     0,    45,    46,    83,     0,     0,    63,     0,     0,
      48,    47,    33,     0,     0,    65,     0,     0,    62,    64,
       0,    68,    50,    49,    44,    67,     0,    32,    66,     0,
       0,     0,     0,     0,    69,     0,     0
};

static const short yydefgoto[] =
{
       1,    11,    12,    13,    14,    15,    16,    17,    60,    61,
      25,    90,   140,   120,    26,    35,   109,   137,   145,   151,
     157,    18,    97,   121,    30,    47,    74
};

static const short yypact[] =
{
  -32768,    30,    -2,     4,   -41,   -50,     4,   -13,   -18,   -19,
     -15,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,
  -32768,-32768,-32768,-32768,-32768,-32768,    39,   -28,    -9,    -5,
      23,     4,    -7,-32768,-32768,    77,    23,    36,    -6,-32768,
      15,     4,    32,    83,    45,    55,    46,-32768,    50,-32768,
       4,-32768,    47,   -13,    49,    74,    51,    95,-32768,    78,
  -32768,-32768,    70,    82,    23,    23,    26,    73,    68,     4,
      56,    59,    23,    99,    66,-32768,-32768,   111,-32768,-32768,
      10,    10,    96,-32768,-32768,-32768,-32768,    23,    23,    91,
  -32768,-32768,    69,-32768,-32768,-32768,-32768,-32768,    21,-32768,
       3,-32768,    91,-32768,    65,    46,     3,-32768,-32768,-32768,
  -32768,    71,-32768,   -38,    72,-32768,-32768,-32768,-32768,-32768,
  -32768,    -8,    76,-32768,-32768,-32768,    23,    94,-32768,-32768,
      44,    79,-32768,-32768,-32768,    23,    75,    93,   110,   114,
  -32768,-32768,-32768,   101,    10,   102,   -26,    80,-32768,-32768,
      81,   121,-32768,-32768,-32768,    84,    89,-32768,-32768,    85,
     108,    92,    87,   113,-32768,   153,-32768
};

static const short yypgoto[] =
{
  -32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,
      -4,     6,-32768,    48,     0,   103,   -80,-32768,-32768,-32768,
  -32768,-32768,-32768,-32768,    57,-32768,    52
};


#define	YYLAST		157


static const short yytable[] =
{
      29,   110,   129,    33,    37,    52,    32,    21,    53,   126,
      19,    31,   117,    27,   118,    36,    21,   130,    28,    54,
      55,    23,    24,    56,    23,    24,    50,    44,    45,    49,
     165,    51,    62,     2,     3,   152,     4,     5,   153,    48,
      63,    68,    38,     6,    23,    24,    39,     7,    46,    34,
      76,   119,   131,   132,   133,    66,    22,    23,    24,    20,
      89,    89,     8,    92,   149,    22,    23,    24,   102,    99,
      64,    91,    65,     9,   107,    27,   108,    67,   103,    10,
      28,    40,    69,    89,    89,    23,    24,    93,    70,    41,
      94,    42,    95,   112,   113,    57,    58,    59,    71,    84,
      85,    86,    80,    81,    43,   138,    23,    24,    72,   127,
      73,    75,    77,    79,    83,    82,    87,    88,    96,    98,
     100,   101,   135,   104,   105,   106,   139,   111,   114,   122,
     115,   142,   136,   144,   146,   125,   128,   134,   147,   143,
     148,   141,   156,   150,   154,   155,   159,   161,   158,   160,
     162,   163,   164,   166,   124,   116,    78,   123
};

static const short yycheck[] =
{
       4,    81,    10,    16,     8,    12,     6,    12,    15,    47,
      12,    61,     9,    54,    11,    33,    12,    25,    59,    26,
      27,    62,    63,    30,    62,    63,    30,    55,    56,    29,
       0,    31,    36,     3,     4,    61,     6,     7,    64,    44,
       4,    41,    61,    13,    62,    63,    61,    17,    57,    62,
      50,    48,    60,    61,    62,    61,    61,    62,    63,    61,
      64,    65,    32,    37,   144,    61,    62,    63,    72,    69,
      34,    65,    36,    43,    64,    54,    66,    62,    72,    49,
      59,    42,    50,    87,    88,    62,    63,    61,     5,    50,
      64,    52,    66,    87,    88,    18,    19,    20,    53,    21,
      22,    23,    28,    29,    65,    61,    62,    63,    53,   113,
      64,    61,    65,    64,    19,    64,    46,    35,    45,    51,
      64,    62,   126,    24,    58,    14,   130,    31,    37,    64,
      61,   135,    38,    40,    24,    64,    64,    61,    24,    64,
      39,    62,    21,    41,    64,    64,    57,    39,    64,    64,
      58,    64,    39,     0,   106,    98,    53,   105
};
/* -*-C-*-  Note some compilers choke on comments on `#line' lines.  */
#line 3 "/usr/local/share/bison/bison.simple"

/* Skeleton output parser for bison,

   Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002 Free Software
   Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* This is the parser code that is written into each bison parser when
   the %semantic_parser declaration is not specified in the grammar.
   It was written by Richard Stallman by simplifying the hairy parser
   used when %semantic_parser is specified.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

#if ! defined (yyoverflow) || defined (YYERROR_VERBOSE)

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# if YYSTACK_USE_ALLOCA
#  define YYSTACK_ALLOC alloca
# else
#  ifndef YYSTACK_USE_ALLOCA
#   if defined (alloca) || defined (_ALLOCA_H)
#    define YYSTACK_ALLOC alloca
#   else
#    ifdef __GNUC__
#     define YYSTACK_ALLOC __builtin_alloca
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning. */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
# else
#  if defined (__STDC__) || defined (__cplusplus)
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   define YYSIZE_T size_t
#  endif
#  define YYSTACK_ALLOC malloc
#  define YYSTACK_FREE free
# endif
#endif /* ! defined (yyoverflow) || defined (YYERROR_VERBOSE) */


#if (! defined (yyoverflow) \
     && (! defined (__cplusplus) \
	 || (YYLTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  short yyss;
  YYSTYPE yyvs;
# if YYLSP_NEEDED
  YYLTYPE yyls;
# endif
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAX (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# if YYLSP_NEEDED
#  define YYSTACK_BYTES(N) \
     ((N) * (sizeof (short) + sizeof (YYSTYPE) + sizeof (YYLTYPE))	\
      + 2 * YYSTACK_GAP_MAX)
# else
#  define YYSTACK_BYTES(N) \
     ((N) * (sizeof (short) + sizeof (YYSTYPE))				\
      + YYSTACK_GAP_MAX)
# endif

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  register YYSIZE_T yyi;		\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (0)
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack)					\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack, Stack, yysize);				\
	Stack = &yyptr->Stack;						\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAX;	\
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (0)

#endif


#if ! defined (YYSIZE_T) && defined (__SIZE_TYPE__)
# define YYSIZE_T __SIZE_TYPE__
#endif
#if ! defined (YYSIZE_T) && defined (size_t)
# define YYSIZE_T size_t
#endif
#if ! defined (YYSIZE_T)
# if defined (__STDC__) || defined (__cplusplus)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# endif
#endif
#if ! defined (YYSIZE_T)
# define YYSIZE_T unsigned int
#endif

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		-2
#define YYEOF		0
#define YYACCEPT	goto yyacceptlab
#define YYABORT 	goto yyabortlab
#define YYERROR		goto yyerrlab1
/* Like YYERROR except do call yyerror.  This remains here temporarily
   to ease the transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */
#define YYFAIL		goto yyerrlab
#define YYRECOVERING()  (!!yyerrstatus)
#define YYBACKUP(Token, Value)					\
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    {								\
      yychar = (Token);						\
      yylval = (Value);						\
      yychar1 = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { 								\
      yyerror ("syntax error: cannot back up");			\
      YYERROR;							\
    }								\
while (0)

#define YYTERROR	1
#define YYERRCODE	256


/* YYLLOC_DEFAULT -- Compute the default location (before the actions
   are run).

   When YYLLOC_DEFAULT is run, CURRENT is set the location of the
   first token.  By default, to implement support for ranges, extend
   its range to the last symbol.  */

#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)       	\
   Current.last_line   = Rhs[N].last_line;	\
   Current.last_column = Rhs[N].last_column;
#endif


/* YYLEX -- calling `yylex' with the right arguments.  */

#if YYPURE
# if YYLSP_NEEDED
#  ifdef YYLEX_PARAM
#   define YYLEX		yylex (&yylval, &yylloc, YYLEX_PARAM)
#  else
#   define YYLEX		yylex (&yylval, &yylloc)
#  endif
# else /* !YYLSP_NEEDED */
#  ifdef YYLEX_PARAM
#   define YYLEX		yylex (&yylval, YYLEX_PARAM)
#  else
#   define YYLEX		yylex (&yylval)
#  endif
# endif /* !YYLSP_NEEDED */
#else /* !YYPURE */
# define YYLEX			yylex ()
#endif /* !YYPURE */


/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)			\
do {						\
  if (yydebug)					\
    YYFPRINTF Args;				\
} while (0)
/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
#endif /* !YYDEBUG */

/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef	YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   SIZE_MAX < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#if YYMAXDEPTH == 0
# undef YYMAXDEPTH
#endif

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif

#ifdef YYERROR_VERBOSE

# ifndef yystrlen
#  if defined (__GLIBC__) && defined (_STRING_H)
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
static YYSIZE_T
#   if defined (__STDC__) || defined (__cplusplus)
yystrlen (const char *yystr)
#   else
yystrlen (yystr)
     const char *yystr;
#   endif
{
  register const char *yys = yystr;

  while (*yys++ != '\0')
    continue;

  return yys - yystr - 1;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined (__GLIBC__) && defined (_STRING_H) && defined (_GNU_SOURCE)
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
#   if defined (__STDC__) || defined (__cplusplus)
yystpcpy (char *yydest, const char *yysrc)
#   else
yystpcpy (yydest, yysrc)
     char *yydest;
     const char *yysrc;
#   endif
{
  register char *yyd = yydest;
  register const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif
#endif

#line 315 "/usr/local/share/bison/bison.simple"


/* The user can define YYPARSE_PARAM as the name of an argument to be passed
   into yyparse.  The argument should have type void *.
   It should actually point to an object.
   Grammar actions can access the variable by casting it
   to the proper pointer type.  */

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
#  define YYPARSE_PARAM_ARG void *YYPARSE_PARAM
#  define YYPARSE_PARAM_DECL
# else
#  define YYPARSE_PARAM_ARG YYPARSE_PARAM
#  define YYPARSE_PARAM_DECL void *YYPARSE_PARAM;
# endif
#else /* !YYPARSE_PARAM */
# define YYPARSE_PARAM_ARG
# define YYPARSE_PARAM_DECL
#endif /* !YYPARSE_PARAM */

/* Prevent warning if -Wstrict-prototypes.  */
#ifdef __GNUC__
# ifdef YYPARSE_PARAM
int yyparse (void *);
# else
int yyparse (void);
# endif
#endif

/* YY_DECL_VARIABLES -- depending whether we use a pure parser,
   variables are global, or local to YYPARSE.  */

#define YY_DECL_NON_LSP_VARIABLES			\
/* The lookahead symbol.  */				\
int yychar;						\
							\
/* The semantic value of the lookahead symbol. */	\
YYSTYPE yylval;						\
							\
/* Number of parse errors so far.  */			\
int yynerrs;

#if YYLSP_NEEDED
# define YY_DECL_VARIABLES			\
YY_DECL_NON_LSP_VARIABLES			\
						\
/* Location data for the lookahead symbol.  */	\
YYLTYPE yylloc;
#else
# define YY_DECL_VARIABLES			\
YY_DECL_NON_LSP_VARIABLES
#endif


/* If nonreentrant, generate the variables here. */

#if !YYPURE
YY_DECL_VARIABLES
#endif  /* !YYPURE */

int
yyparse (YYPARSE_PARAM_ARG)
     YYPARSE_PARAM_DECL
{
  /* If reentrant, generate the variables here. */
#if YYPURE
  YY_DECL_VARIABLES
#endif  /* !YYPURE */

  register int yystate;
  register int yyn;
  int yyresult;
  /* Number of tokens to shift before error messages enabled.  */
  int yyerrstatus;
  /* Lookahead token as an internal (translated) token number.  */
  int yychar1 = 0;

  /* Three stacks and their tools:
     `yyss': related to states,
     `yyvs': related to semantic values,
     `yyls': related to locations.

     Refer to the stacks thru separate pointers, to allow yyoverflow
     to reallocate them elsewhere.  */

  /* The state stack. */
  short	yyssa[YYINITDEPTH];
  short *yyss = yyssa;
  register short *yyssp;

  /* The semantic value stack.  */
  YYSTYPE yyvsa[YYINITDEPTH];
  YYSTYPE *yyvs = yyvsa;
  register YYSTYPE *yyvsp;

#if YYLSP_NEEDED
  /* The location stack.  */
  YYLTYPE yylsa[YYINITDEPTH];
  YYLTYPE *yyls = yylsa;
  YYLTYPE *yylsp;
#endif

#if YYLSP_NEEDED
# define YYPOPSTACK   (yyvsp--, yyssp--, yylsp--)
#else
# define YYPOPSTACK   (yyvsp--, yyssp--)
#endif

  YYSIZE_T yystacksize = YYINITDEPTH;


  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;
#if YYLSP_NEEDED
  YYLTYPE yyloc;
#endif

  /* When reducing, the number of symbols on the RHS of the reduced
     rule. */
  int yylen;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss;
  yyvsp = yyvs;
#if YYLSP_NEEDED
  yylsp = yyls;
#endif
  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed. so pushing a state here evens the stacks.
     */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyssp >= yyss + yystacksize - 1)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = yyssp - yyss + 1;

#ifdef yyoverflow
      {
	/* Give user a chance to reallocate the stack. Use copies of
	   these so that the &'s don't force the real ones into
	   memory.  */
	YYSTYPE *yyvs1 = yyvs;
	short *yyss1 = yyss;

	/* Each stack pointer address is followed by the size of the
	   data in use in that stack, in bytes.  */
# if YYLSP_NEEDED
	YYLTYPE *yyls1 = yyls;
	/* This used to be a conditional around just the two extra args,
	   but that might be undefined if yyoverflow is a macro.  */
	yyoverflow ("parser stack overflow",
		    &yyss1, yysize * sizeof (*yyssp),
		    &yyvs1, yysize * sizeof (*yyvsp),
		    &yyls1, yysize * sizeof (*yylsp),
		    &yystacksize);
	yyls = yyls1;
# else
	yyoverflow ("parser stack overflow",
		    &yyss1, yysize * sizeof (*yyssp),
		    &yyvs1, yysize * sizeof (*yyvsp),
		    &yystacksize);
# endif
	yyss = yyss1;
	yyvs = yyvs1;
      }
#else /* no yyoverflow */
# ifndef YYSTACK_RELOCATE
      goto yyoverflowlab;
# else
      /* Extend the stack our own way.  */
      if (yystacksize >= YYMAXDEPTH)
	goto yyoverflowlab;
      yystacksize *= 2;
      if (yystacksize > YYMAXDEPTH)
	yystacksize = YYMAXDEPTH;

      {
	short *yyss1 = yyss;
	union yyalloc *yyptr =
	  (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
	if (! yyptr)
	  goto yyoverflowlab;
	YYSTACK_RELOCATE (yyss);
	YYSTACK_RELOCATE (yyvs);
# if YYLSP_NEEDED
	YYSTACK_RELOCATE (yyls);
# endif
# undef YYSTACK_RELOCATE
	if (yyss1 != yyssa)
	  YYSTACK_FREE (yyss1);
      }
# endif
#endif /* no yyoverflow */

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;
#if YYLSP_NEEDED
      yylsp = yyls + yysize - 1;
#endif

      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
		  (unsigned long int) yystacksize));

      if (yyssp >= yyss + yystacksize - 1)
	YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", yystate));

  goto yybackup;


/*-----------.
| yybackup.  |
`-----------*/
yybackup:

/* Do appropriate processing given the current state.  */
/* Read a lookahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to lookahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYFLAG)
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* yychar is either YYEMPTY or YYEOF
     or a valid token in external form.  */

  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = YYLEX;
    }

  /* Convert token to internal form (in yychar1) for indexing tables with */

  if (yychar <= 0)		/* This means end of input. */
    {
      yychar1 = 0;
      yychar = YYEOF;		/* Don't call YYLEX any more */

      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yychar1 = YYTRANSLATE (yychar);

#if YYDEBUG
     /* We have to keep this `#if YYDEBUG', since we use variables
	which are defined only if `YYDEBUG' is set.  */
      if (yydebug)
	{
	  YYFPRINTF (stderr, "Next token is %d (%s",
		     yychar, yytname[yychar1]);
	  /* Give the individual parser a way to print the precise
	     meaning of a token, for further debugging info.  */
# ifdef YYPRINT
	  YYPRINT (stderr, yychar, yylval);
# endif
	  YYFPRINTF (stderr, ")\n");
	}
#endif
    }

  yyn += yychar1;
  if (yyn < 0 || yyn > YYLAST || yycheck[yyn] != yychar1)
    goto yydefault;

  yyn = yytable[yyn];

  /* yyn is what to do for this token type in this state.
     Negative => reduce, -yyn is rule number.
     Positive => shift, yyn is new state.
       New state is final state => don't bother to shift,
       just return success.
     0, or most negative number => error.  */

  if (yyn < 0)
    {
      if (yyn == YYFLAG)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }
  else if (yyn == 0)
    goto yyerrlab;

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the lookahead token.  */
  YYDPRINTF ((stderr, "Shifting token %d (%s), ",
	      yychar, yytname[yychar1]));

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;
#if YYLSP_NEEDED
  *++yylsp = yylloc;
#endif

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  yystate = yyn;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     `$$ = $1'.

     Otherwise, the following line sets YYVAL to the semantic value of
     the lookahead token.  This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];

#if YYLSP_NEEDED
  /* Similarly for the default location.  Let the user run additional
     commands if for instance locations are ranges.  */
  yyloc = yylsp[1-yylen];
  YYLLOC_DEFAULT (yyloc, (yylsp - yylen), yylen);
#endif

#if YYDEBUG
  /* We have to keep this `#if YYDEBUG', since we use variables which
     are defined only if `YYDEBUG' is set.  */
  if (yydebug)
    {
      int yyi;

      YYFPRINTF (stderr, "Reducing via rule %d (line %d), ",
		 yyn, yyrline[yyn]);

      /* Print the symbols being reduced, and their result.  */
      for (yyi = yyprhs[yyn]; yyrhs[yyi] > 0; yyi++)
	YYFPRINTF (stderr, "%s ", yytname[yyrhs[yyi]]);
      YYFPRINTF (stderr, " -> %s\n", yytname[yyr1[yyn]]);
    }
#endif

  switch (yyn) {

case 10:
#line 148 "parse.y"
{
		if (template_create(yyvsp[0].string) == NULL)
			yyerror("Template \"%s\" exists already", yyvsp[0].string);
		free(yyvsp[0].string);
	}
    break;
case 11:
#line 154 "parse.y"
{
		if (template_create("default") == NULL)
			yyerror("Template \"default\" exists already");
	}
    break;
case 12:
#line 159 "parse.y"
{		
		struct template *tmpl;
		if ((tmpl = template_create(yyvsp[0].string)) == NULL)
			yyerror("Template \"%s\" exists already", yyvsp[0].string);
		tmpl->flags |= TEMPLATE_DYNAMIC;
		free(yyvsp[0].string);
	}
    break;
case 13:
#line 169 "parse.y"
{
		if (yyvsp[-4].tmpl != NULL && template_add(yyvsp[-4].tmpl, yyvsp[-3].number, yyvsp[-1].number, &yyvsp[0].action) == -1)
			yyerror("Can not add port %d to template \"%s\"",
			    yyvsp[-1].number, yyvsp[-4].tmpl != NULL ? yyvsp[-4].tmpl->name : "<unknown>");
		if (yyvsp[0].action.action)
			free(yyvsp[0].action.action);
	}
    break;
case 14:
#line 177 "parse.y"
{	
		if (yyvsp[-4].tmpl == NULL || yyvsp[-2].tmpl == NULL)
			break;
		if (!(yyvsp[-4].tmpl->flags & TEMPLATE_DYNAMIC))
			yyerror("Cannot add templates to non-dynamic template \"%s\"", yyvsp[-4].tmpl->name);
		template_insert_dynamic(yyvsp[-4].tmpl, yyvsp[-2].tmpl, &yyvsp[0].condition);
	}
    break;
case 15:
#line 185 "parse.y"
{	
		if (yyvsp[-3].tmpl == NULL || yyvsp[0].tmpl == NULL)
			break;
		if (!(yyvsp[-3].tmpl->flags & TEMPLATE_DYNAMIC))
			yyerror("Cannot add templates to non-dynamic template \"%s\"", yyvsp[-3].tmpl->name);
		template_insert_dynamic(yyvsp[-3].tmpl, yyvsp[0].tmpl, NULL);
	}
    break;
case 16:
#line 194 "parse.y"
{
		struct addr tmp;
		int isaddr;

		isaddr = addr_aton(yyvsp[-3].tmpl->name, &tmp) == -1 ? 0 : 1;

		yyvsp[-1].string[strlen(yyvsp[-1].string) - 1] = '\0';
		if (yyvsp[-3].tmpl != NULL &&
		    template_subsystem(yyvsp[-3].tmpl, yyvsp[-1].string+1, isaddr, yyvsp[0].number) == -1)
			yyerror("Can not add subsystem \"%s\" to template \"%s\"",
			    yyvsp[-1].string+1, yyvsp[-3].tmpl != NULL ? yyvsp[-3].tmpl->name : "<unknown>");
		free(yyvsp[-1].string);
	}
    break;
case 17:
#line 209 "parse.y"
{
		/* Bind to an IP address and start subsystems */
		if (yyvsp[0].tmpl == NULL ||
		    template_clone(addr_ntoa(&yyvsp[-1].addr), yyvsp[0].tmpl, 1) == NULL)
			yyerror("Binding to %s failed", addr_ntoa(&yyvsp[-1].addr));
	}
    break;
case 18:
#line 216 "parse.y"
{
		struct template *tmpl;

		/* Special magic */
		if ((tmpl = template_find(addr_ntoa(&yyvsp[-1].addr))) != NULL) {
			if (!(tmpl->flags & TEMPLATE_DYNAMIC)) {
				yyerror("Template \"%s\" already specified as "
				    "non-dynamic template", addr_ntoa(&yyvsp[-1].addr));
				break;
			}
		} else if ((tmpl = template_create(addr_ntoa(&yyvsp[-1].addr))) == NULL) {
			yyerror("Could not create template \"%s\"",
			    addr_ntoa(&yyvsp[-1].addr));
			break;
		}

		/* 
		 * Add this point we do have the right template.
		 * We just need to add the proper condition.
		 */
		template_insert_dynamic(tmpl, yyvsp[0].tmpl, &yyvsp[-2].condition);
	}
    break;
case 19:
#line 239 "parse.y"
{
		struct interface *inter;
		struct template *tmpl;

		/* Bind an IP address to an external interface */
		if ((inter = interface_find(yyvsp[0].string)) == NULL) {
			yyerror("Interface \"%s\" does not exist.", yyvsp[0].string);
			free(yyvsp[0].string);
			break;
		}
		if (inter->if_ent.intf_link_addr.addr_type != ADDR_TYPE_ETH) {
			yyerror("Interface \"%s\" does not support arp.", yyvsp[0].string);
			free(yyvsp[0].string);
			break;
		}

		if ((tmpl = template_create(addr_ntoa(&yyvsp[-2].addr))) == NULL) {
			yyerror("Template \"%s\" exists already",
			    addr_ntoa(&yyvsp[-2].addr));
			break;
		}

		/* Make this template external. */
		tmpl->flags |= TEMPLATE_EXTERNAL;
		tmpl->inter = inter;
		free(yyvsp[0].string);
	}
    break;
case 20:
#line 267 "parse.y"
{
		/* Just clone.  This is not the final destination yet */
		if (yyvsp[0].tmpl == NULL || template_clone(yyvsp[-1].string, yyvsp[0].tmpl, 0) == NULL)
			yyerror("Cloning to %s failed", yyvsp[-1].string);
		free(yyvsp[-1].string);
	}
    break;
case 21:
#line 275 "parse.y"
{
		struct action *action;

		if (yyvsp[-4].tmpl == NULL) {
			yyerror("No template");
			break;
		}
		
		if ((action = honeyd_protocol(yyvsp[-4].tmpl, yyvsp[-2].number)) == NULL) {
			yyerror("Bad protocol");
			break;
		}

		port_action_clone(action, &yyvsp[0].action);
		if (yyvsp[0].action.action != NULL)
			free(yyvsp[0].action.action);
	}
    break;
case 22:
#line 293 "parse.y"
{
		if (yyvsp[-2].tmpl == NULL || yyvsp[0].pers == NULL)
			break;
		yyvsp[-2].tmpl->person = personality_clone(yyvsp[0].pers);
	}
    break;
case 23:
#line 299 "parse.y"
{
		if (yyvsp[-2].tmpl == NULL || yyvsp[0].number == 0)
			break;
		yyvsp[-2].tmpl->timestamp = yyvsp[0].number * 2;
	}
    break;
case 24:
#line 305 "parse.y"
{
		if (yyvsp[-3].tmpl == NULL)
			break;
		if (yyvsp[0].floatp > 100) {
			yyerror("Droprate too high: %f", yyvsp[0].floatp);
			break;
		}

		yyvsp[-3].tmpl->drop_inrate = yyvsp[0].floatp * 100;
	}
    break;
case 25:
#line 316 "parse.y"
{
		if (yyvsp[-3].tmpl == NULL)
			break;
		if (yyvsp[0].floatp > 100) {
			yyerror("Droprate too high: %f", yyvsp[0].floatp);
			break;
		}

		yyvsp[-3].tmpl->drop_synrate = yyvsp[0].floatp * 100;
	}
    break;
case 26:
#line 327 "parse.y"
{
		if (yyvsp[-2].tmpl == NULL)
			break;
		if (!yyvsp[0].number) {
			yyerror("Bad uid %d", yyvsp[0].number);
			break;
		}
		yyvsp[-2].tmpl->uid = yyvsp[0].number;
	}
    break;
case 27:
#line 337 "parse.y"
{
		if (yyvsp[-4].tmpl == NULL)
			break;
		if (!yyvsp[-2].number || !yyvsp[0].number) {
			yyerror("Bad uid %d, gid %d", yyvsp[-2].number, yyvsp[0].number);
			break;
		}
		yyvsp[-4].tmpl->uid = yyvsp[-2].number;
		yyvsp[-4].tmpl->gid = yyvsp[0].number;
	}
    break;
case 28:
#line 349 "parse.y"
{
		if (yyvsp[-1].pers == NULL)
			break;
		yyvsp[-1].pers->disallow_finscan = !yyvsp[0].number;
	}
    break;
case 29:
#line 355 "parse.y"
{
		if (yyvsp[-1].pers == NULL)
			break;
		yyvsp[-1].pers->fragp = yyvsp[0].fragp;
	}
    break;
case 30:
#line 362 "parse.y"
{
		if (router_start(&yyvsp[0].addr, NULL) == -1)
			yyerror("Defining entry point failed: %s",
			    addr_ntoa(&yyvsp[0].addr));
	}
    break;
case 31:
#line 368 "parse.y"
{
		if (router_start(&yyvsp[-2].addr, &yyvsp[0].addr) == -1)
			yyerror("Defining entry point failed: %s",
			    addr_ntoa(&yyvsp[-2].addr));
	}
    break;
case 32:
#line 374 "parse.y"
{
		struct router *r, *newr;
		struct addr defroute;

		if ((r = router_find(&yyvsp[-8].addr)) == NULL) {
			yyerror("Unknown router %s", addr_ntoa(&yyvsp[-8].addr));
			break;
		}
		if ((newr = router_find(&yyvsp[-4].addr)) == NULL)
			newr = router_new(&yyvsp[-4].addr);
		if (router_add_net(r, &yyvsp[-5].addr, newr, yyvsp[-3].number, yyvsp[-2].number, yyvsp[-1].number, &yyvsp[0].drop) == -1)
			yyerror("Could not add route to %s", addr_ntoa(&yyvsp[-5].addr));

		if (yyvsp[-1].number == 0 && yyvsp[0].drop.high != 0)
			yywarn("Ignoring drop between statement without "
			       "specified bandwidth.");

		addr_pton("0.0.0.0/0", &defroute);
		defroute.addr_bits = 0; /* work around libdnet bug */

		/* Only insert a reverse route, if the current route is
		 * not the default route.
		 */
		if (addr_cmp(&defroute, &yyvsp[-5].addr) != 0 &&
		    router_add_net(newr, &defroute, r, yyvsp[-3].number, yyvsp[-2].number, yyvsp[-1].number, &yyvsp[0].drop) == -1)
			yyerror("Could not add default route to %s",
			    addr_ntoa(&yyvsp[-5].addr));
	}
    break;
case 33:
#line 403 "parse.y"
{
		struct router *r;

		if ((r = router_find(&yyvsp[-6].addr)) == NULL) {
			yyerror("Unknown router %s\n", addr_ntoa(&yyvsp[-6].addr));
			break;
		}
		if (router_add_tunnel(r, &yyvsp[-3].addr, &yyvsp[-1].addr, &yyvsp[0].addr) == -1)
			yyerror("Could not add tunnel to %s", addr_ntoa(&yyvsp[0].addr));
	}
    break;
case 34:
#line 414 "parse.y"
{
		struct router *r;

		if ((r = router_find(&yyvsp[-2].addr)) == NULL) {
			yyerror("Unknown router %s", addr_ntoa(&yyvsp[-2].addr));
			break;
		}
		if (router_add_link(r, &yyvsp[0].addr) == -1)
			yyerror("Could not add link %s", addr_ntoa(&yyvsp[0].addr));
	}
    break;
case 35:
#line 425 "parse.y"
{
		struct router *r;

		if ((r = router_find(&yyvsp[-2].addr)) == NULL) {
			yyerror("Unknown router %s", addr_ntoa(&yyvsp[-2].addr));
			break;
		}
		if (router_add_unreach(r, &yyvsp[0].addr) == -1)
			yyerror("Could not add unreachable net %s",
			    addr_ntoa(&yyvsp[0].addr));
	}
    break;
case 36:
#line 437 "parse.y"
{ yyval.number = 1; }
    break;
case 37:
#line 438 "parse.y"
{ yyval.number = 0; }
    break;
case 38:
#line 440 "parse.y"
{ yyval.fragp = FRAG_DROP; }
    break;
case 39:
#line 441 "parse.y"
{ yyval.fragp = FRAG_OLD; }
    break;
case 40:
#line 442 "parse.y"
{ yyval.fragp = FRAG_NEW; }
    break;
case 41:
#line 445 "parse.y"
{
		if (addr_pton(yyvsp[0].string, &yyval.addr) < 0)
			yyerror("Illegal IP address %s", yyvsp[0].string);
		free(yyvsp[0].string);
	}
    break;
case 42:
#line 451 "parse.y"
{
		struct addrinfo ai, *aitop;

		memset(&ai, 0, sizeof (ai));
		ai.ai_family = AF_INET;
		ai.ai_socktype = 0;
		ai.ai_flags = 0;

		/* Remove quotation marks */
		yyvsp[0].string[strlen(yyvsp[0].string) - 1] = '\0';
		if (getaddrinfo(yyvsp[0].string+1, NULL, &ai, &aitop) != 0) {
			yyerror("getaddrinfo failed: %s", yyvsp[0].string+1);
			break;
		}
		addr_ston(aitop->ai_addr, &yyval.addr);
		freeaddrinfo(aitop);
		free(yyvsp[0].string);
	}
    break;
case 43:
#line 471 "parse.y"
{
		char src[25];
		struct addr b;
		snprintf(src, sizeof(src), "%s/%d",
		    addr_ntoa(&yyvsp[-2].addr), yyvsp[0].number);
		if (addr_pton(src, &yyval.addr) < 0)
			yyerror("Illegal IP network %s", src);
		/* Fix libdnet error */
		if (yyvsp[0].number == 0)
			yyval.addr.addr_bits = 0;

		/* Test if this is a legal network */
		addr_net(&yyval.addr, &b);
		b.addr_bits = yyval.addr.addr_bits;
		if (memcmp(&yyval.addr.addr_ip, &b.addr_ip, IP_ADDR_LEN)) {
			yyval.addr = b;
			yywarn("Bad network mask in %s", src);
		}
	}
    break;
case 44:
#line 492 "parse.y"
{
		if (curtype == -1) {
			yyerror("Bad port type");
			break;
		}
		yyval.ai = cmd_proxy_getinfo(addr_ntoa(&yyvsp[-2].addr), curtype, yyvsp[0].number);
		curtype = -1;
		if (yyval.ai == NULL)
			yyerror("Illegal IP address port pair");
	}
    break;
case 45:
#line 504 "parse.y"
{
		memset(&yyval.action, 0, sizeof(yyval.action));
		yyval.action.action = yyvsp[0].string;
		yyval.action.flags = yyvsp[-1].number;
		yyval.action.status = PORT_OPEN;
	}
    break;
case 46:
#line 511 "parse.y"
{
		memset(&yyval.action, 0, sizeof(yyval.action));
		yyvsp[0].string[strlen(yyvsp[0].string) - 1] = '\0';
		if ((yyval.action.action = strdup(yyvsp[0].string + 1)) == NULL)
			yyerror("Out of memory");
		yyval.action.status = PORT_OPEN;
		yyval.action.flags = yyvsp[-1].number;
		free(yyvsp[0].string);
	}
    break;
case 47:
#line 521 "parse.y"
{
#ifdef HAVE_PYTHON
		memset(&yyval.action, 0, sizeof(yyval.action));
		yyvsp[0].string[strlen(yyvsp[0].string) - 1] = '\0';
		if ((yyval.action.action_extend = pyextend_load_module(yyvsp[0].string+1)) == NULL)
			yyerror("Bad python module: \"%s\"", yyvsp[0].string+1);
		yyval.action.status = PORT_PYTHON;
		yyval.action.flags = yyvsp[-2].number;
		free(yyvsp[0].string);
#else
		yyerror("Python support is not available.");
#endif
	}
    break;
case 48:
#line 535 "parse.y"
{
		memset(&yyval.action, 0, sizeof(yyval.action));
		yyval.action.status = PORT_PROXY;
		yyval.action.action = NULL;
		yyval.action.aitop = yyvsp[0].ai;
		yyval.action.flags = yyvsp[-2].number;
	}
    break;
case 49:
#line 543 "parse.y"
{
		memset(&yyval.action, 0, sizeof(yyval.action));
		yyval.action.status = PORT_PROXY;
		yyval.action.action = NULL;
		yyval.action.aitop = NULL;
		yyval.action.flags = yyvsp[-4].number;
		if (yyvsp[-2].string[0] != '$') {
			if (curtype == -1) {
				yyerror("Bad port type");
				break;
			}
			yyval.action.aitop = cmd_proxy_getinfo(yyvsp[-2].string, curtype, yyvsp[0].number);
			curtype = -1;
			if (yyval.action.aitop == NULL)
				yyerror("Illegal host name in proxy");
		} else {
			char proxy[1024];

			snprintf(proxy, sizeof(proxy), "%s:%d", yyvsp[-2].string, yyvsp[0].number);
			yyval.action.action = strdup(proxy);
			if (yyval.action.action == NULL)
				yyerror("Out of memory");
		}
		free(yyvsp[-2].string);
	}
    break;
case 50:
#line 569 "parse.y"
{
		char proxy[1024];
		memset(&yyval.action, 0, sizeof(yyval.action));
		yyval.action.status = PORT_PROXY;
		yyval.action.action = NULL;
		yyval.action.aitop = NULL;
		yyval.action.flags = yyvsp[-4].number;

		snprintf(proxy, sizeof(proxy), "%s:%s", yyvsp[-2].string, yyvsp[0].string);
		yyval.action.action = strdup(proxy);
		if (yyval.action.action == NULL)
				yyerror("Out of memory");
		free(yyvsp[-2].string);
		free(yyvsp[0].string);
	}
    break;
case 51:
#line 585 "parse.y"
{
		memset(&yyval.action, 0, sizeof(yyval.action));
		yyval.action.status = PORT_BLOCK;
		yyval.action.action = NULL;
	}
    break;
case 52:
#line 591 "parse.y"
{
		memset(&yyval.action, 0, sizeof(yyval.action));
		yyval.action.status = PORT_RESET;
		yyval.action.action = NULL;
	}
    break;
case 53:
#line 597 "parse.y"
{
		memset(&yyval.action, 0, sizeof(yyval.action));
		yyval.action.status = PORT_OPEN;
		yyval.action.action = NULL;
		yyval.action.flags = yyvsp[-1].number;
	}
    break;
case 54:
#line 606 "parse.y"
{
		yyval.tmpl = template_find(yyvsp[0].string);
		if (yyval.tmpl == NULL)
			yyerror("Unknown template \"%s\"", yyvsp[0].string);
		free(yyvsp[0].string);
	}
    break;
case 55:
#line 613 "parse.y"
{
		yyval.tmpl = template_find("default");
		if (yyval.tmpl == NULL)
			yyerror("Unknown template \"%s\"", "default");
	}
    break;
case 56:
#line 619 "parse.y"
{
		yyval.tmpl = template_find(addr_ntoa(&yyvsp[0].addr));
		if (yyval.tmpl == NULL)
			yyerror("Unknown template \"%s\"", addr_ntoa(&yyvsp[0].addr));
	}
    break;
case 57:
#line 626 "parse.y"
{
		yyvsp[0].string[strlen(yyvsp[0].string) - 1] = '\0';
		yyval.pers = personality_find(yyvsp[0].string+1);
		if (yyval.pers == NULL)
			yyerror("Unknown personality \"%s\"", yyvsp[0].string+1);
		free(yyvsp[0].string);
	}
    break;
case 58:
#line 634 "parse.y"
{
		yyval.pers = personality_random();
		if (yyval.pers == NULL)
			yyerror("Random personality failed");
	}
    break;
case 59:
#line 641 "parse.y"
{
		yyval.floatp = yyvsp[0].floatp;
	}
    break;
case 60:
#line 645 "parse.y"
{
		yyval.floatp = yyvsp[0].number;
	}
    break;
case 61:
#line 649 "parse.y"
{ yyval.number = 0; }
    break;
case 62:
#line 651 "parse.y"
{
		yyval.number = yyvsp[-1].number;
	}
    break;
case 63:
#line 655 "parse.y"
{ yyval.number = 0; }
    break;
case 64:
#line 657 "parse.y"
{
		yyval.number = yyvsp[0].floatp * 100;
	}
    break;
case 65:
#line 661 "parse.y"
{ yyval.number = 0; }
    break;
case 66:
#line 663 "parse.y"
{
		yyval.number = yyvsp[-1].number * yyvsp[0].number;
	}
    break;
case 67:
#line 667 "parse.y"
{
		yyval.number = yyvsp[0].number;
	}
    break;
case 68:
#line 671 "parse.y"
{ memset(&yyval.drop, 0, sizeof(yyval.drop)); }
    break;
case 69:
#line 673 "parse.y"
{
		if (yyvsp[-1].number <= yyvsp[-4].number)
			yyerror("Incorrect thresholds. First number needs to "
				"be smaller than second number.");
		yyval.drop.low = yyvsp[-4].number;
		yyval.drop.high = yyvsp[-1].number;
	}
    break;
case 70:
#line 682 "parse.y"
{
		struct honeyd_plugin_cfg cfg;

		memset(&cfg, 0, sizeof(struct honeyd_plugin_cfg));
		cfg.cfg_int = yyvsp[0].number;
		cfg.cfg_type = HD_CONFIG_INT;
		plugins_config_item_add(yyvsp[-2].string, yyvsp[-1].string, &cfg);
		
		free(yyvsp[-2].string); free(yyvsp[-1].string);
	}
    break;
case 71:
#line 693 "parse.y"
{
		struct honeyd_plugin_cfg cfg;

		memset(&cfg, 0, sizeof(struct honeyd_plugin_cfg));
		cfg.cfg_flt = yyvsp[0].floatp;
		cfg.cfg_type = HD_CONFIG_FLT;
		plugins_config_item_add(yyvsp[-2].string, yyvsp[-1].string, &cfg);

		free(yyvsp[-2].string); free(yyvsp[-1].string);
        }
    break;
case 72:
#line 704 "parse.y"
{
		struct honeyd_plugin_cfg cfg;

		memset(&cfg, 0, sizeof(struct honeyd_plugin_cfg));
		cfg.cfg_str = yyvsp[0].string;
		cfg.cfg_type = HD_CONFIG_STR;
		plugins_config_item_add(yyvsp[-2].string, yyvsp[-1].string, &cfg);

		free(yyvsp[-2].string); free(yyvsp[-1].string); free(yyvsp[0].string);
        }
    break;
case 73:
#line 716 "parse.y"
{
		struct honeyd_plugin_cfg cfg;
		char path[MAXPATHLEN];

		snprintf(path, sizeof(path), "/%s", yyvsp[0].string);

		memset(&cfg, 0, sizeof(struct honeyd_plugin_cfg));
		cfg.cfg_str = path;
		cfg.cfg_type = HD_CONFIG_STR;
		plugins_config_item_add(yyvsp[-3].string, yyvsp[-2].string, &cfg);

		free(yyvsp[-3].string); free(yyvsp[-2].string); free(yyvsp[0].string);
        }
    break;
case 74:
#line 732 "parse.y"
{
	yyval.number = 0;
}
    break;
case 75:
#line 736 "parse.y"
{
	yyval.number = 1;
}
    break;
case 76:
#line 742 "parse.y"
{
	yyval.number = 0;
}
    break;
case 77:
#line 746 "parse.y"
{
	yyval.number = PORT_TARPIT;
}
    break;
case 78:
#line 752 "parse.y"
{
		pf_osfp_t fp;
		yyvsp[0].string[strlen(yyvsp[0].string) - 1] = '\0';
		if ((fp = pfctl_get_fingerprint(yyvsp[0].string+1)) == PF_OSFP_NOMATCH)
			yyerror("Unknown fingerprint \"%s\"", yyvsp[0].string+1);
		if ((yyval.condition.match_arg = malloc(sizeof(fp))) == NULL)
			yyerror("Out of memory");
		memcpy(yyval.condition.match_arg, &fp, sizeof(fp));
		yyval.condition.match = condition_match_osfp;
		yyval.condition.match_arglen = sizeof(fp);
		free (yyvsp[0].string);
	}
    break;
case 79:
#line 765 "parse.y"
{
		if ((yyval.condition.match_arg = malloc(sizeof(struct addr))) == NULL)
			yyerror("Out of memory");
		memcpy(yyval.condition.match_arg, &yyvsp[0].addr, sizeof(struct addr));
		yyval.condition.match = condition_match_addr;
		yyval.condition.match_arglen = sizeof(struct addr);
	}
    break;
case 80:
#line 773 "parse.y"
{
		if ((yyval.condition.match_arg = malloc(sizeof(struct addr))) == NULL)
			yyerror("Out of memory");
		memcpy(yyval.condition.match_arg, &yyvsp[0].addr, sizeof(struct addr));
		yyval.condition.match = condition_match_addr;
		yyval.condition.match_arglen = sizeof(struct addr);
	}
    break;
case 81:
#line 781 "parse.y"
{
		if ((yyval.condition.match_arg = malloc(sizeof(struct condition_time))) == NULL)
			yyerror("Out of memory");
		memcpy(yyval.condition.match_arg, &yyvsp[0].timecondition, sizeof(struct condition_time));
		yyval.condition.match = condition_match_time;
		yyval.condition.match_arglen = sizeof(struct condition_time);
	}
    break;
case 82:
#line 791 "parse.y"
{
		yyval.timecondition.tm_start = yyvsp[-2].time;
		yyval.timecondition.tm_end = yyvsp[0].time;
	}
    break;
case 83:
#line 798 "parse.y"
{
		int ispm = -1;
		int hour, minute;

		if (strcmp(yyvsp[0].string, "am") == 0) {
			ispm = 0;
		} else if (strcmp(yyvsp[0].string, "pm") == 0) {
			ispm = 1;
		} else {
			yyerror("Bad time specifier, use 'am' or 'pm': %s", yyvsp[0].string);
			break;
		}
		free (yyvsp[0].string);

		hour = yyvsp[-3].number + (ispm ? 12 : 0);
		minute = yyvsp[-1].number;

		memset(&yyval.time, 0, sizeof(yyval.time));
		yyval.time.tm_hour = hour;
		yyval.time.tm_min = minute;
	}
    break;
}

#line 705 "/usr/local/share/bison/bison.simple"


  yyvsp -= yylen;
  yyssp -= yylen;
#if YYLSP_NEEDED
  yylsp -= yylen;
#endif

#if YYDEBUG
  if (yydebug)
    {
      short *yyssp1 = yyss - 1;
      YYFPRINTF (stderr, "state stack now");
      while (yyssp1 != yyssp)
	YYFPRINTF (stderr, " %d", *++yyssp1);
      YYFPRINTF (stderr, "\n");
    }
#endif

  *++yyvsp = yyval;
#if YYLSP_NEEDED
  *++yylsp = yyloc;
#endif

  /* Now `shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTBASE] + *yyssp;
  if (yystate >= 0 && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTBASE];

  goto yynewstate;


/*------------------------------------.
| yyerrlab -- here on detecting error |
`------------------------------------*/
yyerrlab:
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;

#ifdef YYERROR_VERBOSE
      yyn = yypact[yystate];

      if (yyn > YYFLAG && yyn < YYLAST)
	{
	  YYSIZE_T yysize = 0;
	  char *yymsg;
	  int yyx, yycount;

	  yycount = 0;
	  /* Start YYX at -YYN if negative to avoid negative indexes in
	     YYCHECK.  */
	  for (yyx = yyn < 0 ? -yyn : 0;
	       yyx < (int) (sizeof (yytname) / sizeof (char *)); yyx++)
	    if (yycheck[yyx + yyn] == yyx)
	      yysize += yystrlen (yytname[yyx]) + 15, yycount++;
	  yysize += yystrlen ("parse error, unexpected ") + 1;
	  yysize += yystrlen (yytname[YYTRANSLATE (yychar)]);
	  yymsg = (char *) YYSTACK_ALLOC (yysize);
	  if (yymsg != 0)
	    {
	      char *yyp = yystpcpy (yymsg, "parse error, unexpected ");
	      yyp = yystpcpy (yyp, yytname[YYTRANSLATE (yychar)]);

	      if (yycount < 5)
		{
		  yycount = 0;
		  for (yyx = yyn < 0 ? -yyn : 0;
		       yyx < (int) (sizeof (yytname) / sizeof (char *));
		       yyx++)
		    if (yycheck[yyx + yyn] == yyx)
		      {
			const char *yyq = ! yycount ? ", expecting " : " or ";
			yyp = yystpcpy (yyp, yyq);
			yyp = yystpcpy (yyp, yytname[yyx]);
			yycount++;
		      }
		}
	      yyerror (yymsg);
	      YYSTACK_FREE (yymsg);
	    }
	  else
	    yyerror ("parse error; also virtual memory exhausted");
	}
      else
#endif /* defined (YYERROR_VERBOSE) */
	yyerror ("parse error");
    }
  goto yyerrlab1;


/*--------------------------------------------------.
| yyerrlab1 -- error raised explicitly by an action |
`--------------------------------------------------*/
yyerrlab1:
  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
	 error, discard it.  */

      /* return failure if at end of input */
      if (yychar == YYEOF)
	YYABORT;
      YYDPRINTF ((stderr, "Discarding token %d (%s).\n",
		  yychar, yytname[yychar1]));
      yychar = YYEMPTY;
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */

  yyerrstatus = 3;		/* Each real token shifted decrements this */

  goto yyerrhandle;


/*-------------------------------------------------------------------.
| yyerrdefault -- current state does not do anything special for the |
| error token.                                                       |
`-------------------------------------------------------------------*/
yyerrdefault:
#if 0
  /* This is wrong; only states that explicitly want error tokens
     should shift them.  */

  /* If its default is to accept any token, ok.  Otherwise pop it.  */
  yyn = yydefact[yystate];
  if (yyn)
    goto yydefault;
#endif


/*---------------------------------------------------------------.
| yyerrpop -- pop the current state because it cannot handle the |
| error token                                                    |
`---------------------------------------------------------------*/
yyerrpop:
  if (yyssp == yyss)
    YYABORT;
  yyvsp--;
  yystate = *--yyssp;
#if YYLSP_NEEDED
  yylsp--;
#endif

#if YYDEBUG
  if (yydebug)
    {
      short *yyssp1 = yyss - 1;
      YYFPRINTF (stderr, "Error: state stack now");
      while (yyssp1 != yyssp)
	YYFPRINTF (stderr, " %d", *++yyssp1);
      YYFPRINTF (stderr, "\n");
    }
#endif

/*--------------.
| yyerrhandle.  |
`--------------*/
yyerrhandle:
  yyn = yypact[yystate];
  if (yyn == YYFLAG)
    goto yyerrdefault;

  yyn += YYTERROR;
  if (yyn < 0 || yyn > YYLAST || yycheck[yyn] != YYTERROR)
    goto yyerrdefault;

  yyn = yytable[yyn];
  if (yyn < 0)
    {
      if (yyn == YYFLAG)
	goto yyerrpop;
      yyn = -yyn;
      goto yyreduce;
    }
  else if (yyn == 0)
    goto yyerrpop;

  if (yyn == YYFINAL)
    YYACCEPT;

  YYDPRINTF ((stderr, "Shifting error token, "));

  *++yyvsp = yylval;
#if YYLSP_NEEDED
  *++yylsp = yylloc;
#endif

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturn;

/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturn;

/*---------------------------------------------.
| yyoverflowab -- parser overflow comes here.  |
`---------------------------------------------*/
yyoverflowlab:
  yyerror ("parser stack overflow");
  yyresult = 2;
  /* Fall through.  */

yyreturn:
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
  return yyresult;
}
#line 820 "parse.y"


int
yyerror(char *fmt, ...)
{
	va_list ap;
	errors = 1;

	va_start(ap, fmt);
	fprintf(stderr, "%s:%d: ", filename, lineno);
	vfprintf(stderr, fmt, ap);
	fprintf(stderr, "\n");
	va_end(ap);
	return (0);
}

int
yywarn(char *fmt, ...)
{
	va_list ap;

	va_start(ap, fmt);
	fprintf(stderr, "%s:%d: ", filename, lineno);
	vfprintf(stderr, fmt, ap);
	fprintf(stderr, "\n");
	va_end(ap);
	return (0);
}

int
parse_configuration(FILE *input, char *name)
{
	extern FILE *yyin;

	lineno = 1;
	filename = name;
	yyin = input;
	yyparse();
	return (errors ? -1 : 0);
}
