
/* "UNTIL", a graphics editor,
   Copyright (C) 1985, 1990 California Institute of Technology.
   Original authors: Glenn Gribble, port by Steve DeWeerth
   Unix Port Maintainer: John Lazzaro
   Maintainers's address: lazzaro@hobiecat.cs.caltech.edu;
                          CB 425 CU Boulder/Boulder CO 91125. 

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation (Version 1, 1989).

This program is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
USA. */


/*******************************************************************************/
/*                                                                             */ 
/*  file contains stuff to interface with the "graphics tablet"                */
/*  cleaned up by steve - 7 May 1990                                           */
/*                                                                             */ 
/*******************************************************************************/

#include <p2c/p2c.h>

#include "tablet_stuff.h"

#ifndef MYLIB_H
#include <p2c/mylib.h>
#endif

#ifndef SYSDEVS_H
#include <p2c/sysdevs.h>
#endif

#ifndef NEWTABLET_H
#include <p2c/newtablet.h>
#endif


mypen curPen;
short grid_mul, grid_rnd;
boolean grid_hex;
void *updateProc;
short boopTime, boopFreq;


void boop(void)
{
  /* BEEPER(boopFreq, boopTime); */
}


Local long iRound(long i, long r)
{
  return ((long)floor((double)i / r + 0.5) * r);
}


/* procedure changed by steve - 7 May 1990 */
void update_tablet0(void)
{
  mypen oPen;
  short x, y, status;
  m_tablet_info pen;

  oPen = curPen;

  m_readpen(&pen);
  curPen.sx = pen.x;
  curPen.sy = pen.y;

  /* untransform screen coords into user space */
  mat_untransform(pen.x, pen.y, &curPen.rx, &curPen.ry);

  /* set snap-to-grid coordinates */
  if (!grid_hex) {
    curPen.x = (curPen.rx + grid_rnd) / grid_mul * grid_mul;
    curPen.y = (curPen.ry + grid_rnd) / grid_mul * grid_mul;
  } 
  else {
    curPen.y = iRound(curPen.ry, grid_mul * 7);
    if (!((curPen.y / (grid_mul * 7)) & 1))
      curPen.x = iRound(curPen.rx, grid_mul * 8);
    else
      curPen.x = iRound(curPen.rx - grid_mul * 4, grid_mul * 8) + grid_mul * 4;
  }
  
  /* set alpha coordinates */
  curPen.ax = pen.ax;
  curPen.ay = pen.ay;

  /* set other curPen parameters */
  curPen.near_ = pen.near_;
  curPen.depressed = pen.depressed;
  curPen.dn = pen.dn;
  curPen.up = pen.up;

  if (oPen.near_ != curPen.near_ || curPen.dn || curPen.up) {
    curPen.moving = true;
    curPen.amoving = true;
  } else {
    curPen.moving = (oPen.x != curPen.x || oPen.y != curPen.y);
    curPen.amoving = (oPen.ax != curPen.ax || oPen.ay != curPen.ay);
  }
}


void update_tablet(void)
{
    ((void(*)(boolean allCommands))updateProc)(false);
}


void update_tablet_all(void)
{
    ((void(*)(boolean allCommands))updateProc)(true);
}
