/*

  silcwin32util.c

  Author: Pekka Riikonen <priikone@silcnet.org>

  Copyright (C) 2001 - 2005 Pekka Riikonen

  The contents of this file are subject to one of the Licenses specified 
  in the COPYING file;  You may not use this file except in compliance 
  with the License.
  
  The software distributed under the License is distributed on an "AS IS"
  basis, in the hope that it will be useful, but WITHOUT WARRANTY OF ANY
  KIND, either expressed or implied.  See the COPYING file for more
  information.

*/
/* $Id: silcwin32util.c,v 1.5.4.4 2005/04/30 15:31:27 priikone Exp $ */

#include "silcincludes.h"

/* XXX GNU regex may work on Win32 too!! */
char *silc_string_regexify(const char *string)
{
  return strdup(string);
}

char *silc_string_regex_combine(const char *string1, const char *string2)
{
  return strdup(string1);
}

int silc_string_regex_match(const char *regex, const char *string)
{
  return TRUE;
}

int silc_string_match(const char *string1, const char *string2)
{
  return TRUE;
}

#define FILETIME_1970 0x019db1ded53e8000
const BYTE DWLEN = sizeof(DWORD) * 8;

/* Return current time in struct timeval. Code ripped from some xntp
   implementation on http://src.openresources.com. */

int silc_gettimeofday(struct timeval *tv)
{
  FILETIME ft;
  __int64 msec;
  
  GetSystemTimeAsFileTime(&ft);
  msec = (__int64) ft.dwHighDateTime << DWLEN | ft.dwLowDateTime;
  msec = (msec - FILETIME_1970) / 10;
  tv->tv_sec  = (long) (msec / 1000000);
  tv->tv_usec = (long) (msec % 1000000);

  return 0;
}

char *silc_get_username(void)
{
  DWORD maxlen = 128;
  char username[128];
  GetUserName(username, &maxlen);
  return strdup(username);
}

char *silc_get_real_name(void)
{
  return silc_get_username();
}
