/* GtkamlClassDefinition.vala
 *
 * Copyright (C) 2008 Vlad Grecescu
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with main.c; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor Boston, MA 02110-1301,  USA
 *
 * Author:
 *        Vlad Grecescu (b100dian@gmail.com)
 */

#include "GtkamlClassDefinition.h"
#include <gee/arraylist.h>
#include <gee/collection.h>
#include <vala/valasymbol.h>




struct _GtkamlClassDefinitionPrivate {
	ValaSourceReference* _source_reference;
	char* _identifier;
	char* _base_ns;
	ValaClass* _base_type;
	GeeList* _attrs;
	GtkamlClassDefinition* _parent_container;
	GeeList* _children;
	DefinitionScope _definition_scope;
	GtkamlConstructMethod* _construct_method;
	GtkamlAddMethod* _add_method;
	char* _construct_code;
	char* _preconstruct_code;
};

#define GTKAML_CLASS_DEFINITION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GTKAML_TYPE_CLASS_DEFINITION, GtkamlClassDefinitionPrivate))
enum  {
	GTKAML_CLASS_DEFINITION_DUMMY_PROPERTY,
	GTKAML_CLASS_DEFINITION_SOURCE_REFERENCE,
	GTKAML_CLASS_DEFINITION_IDENTIFIER,
	GTKAML_CLASS_DEFINITION_BASE_FULL_NAME,
	GTKAML_CLASS_DEFINITION_BASE_NS,
	GTKAML_CLASS_DEFINITION_BASE_TYPE,
	GTKAML_CLASS_DEFINITION_ATTRS,
	GTKAML_CLASS_DEFINITION_PARENT_CONTAINER,
	GTKAML_CLASS_DEFINITION_CHILDREN,
	GTKAML_CLASS_DEFINITION_DEFINITION_SCOPE,
	GTKAML_CLASS_DEFINITION_CONSTRUCT_METHOD,
	GTKAML_CLASS_DEFINITION_ADD_METHOD,
	GTKAML_CLASS_DEFINITION_CONSTRUCT_CODE,
	GTKAML_CLASS_DEFINITION_PRECONSTRUCT_CODE
};
static gpointer gtkaml_class_definition_parent_class = NULL;
static void gtkaml_class_definition_finalize (GObject* obj);




GType definition_scope_get_type (void) {
	static GType definition_scope_type_id = 0;
	if (G_UNLIKELY (definition_scope_type_id == 0)) {
		static const GEnumValue values[] = {{DEFINITION_SCOPE_MAIN_CLASS, "DEFINITION_SCOPE_MAIN_CLASS", "main-class"}, {DEFINITION_SCOPE_PUBLIC, "DEFINITION_SCOPE_PUBLIC", "public"}, {DEFINITION_SCOPE_PRIVATE, "DEFINITION_SCOPE_PRIVATE", "private"}, {DEFINITION_SCOPE_CONSTRUCTOR, "DEFINITION_SCOPE_CONSTRUCTOR", "constructor"}, {0, NULL, NULL}};
		definition_scope_type_id = g_enum_register_static ("DefinitionScope", values);
	}
	return definition_scope_type_id;
}


GtkamlClassDefinition* gtkaml_class_definition_construct (GType object_type, ValaSourceReference* source_reference, const char* identifier, const char* base_ns, ValaClass* base_type, DefinitionScope definition_scope, GtkamlClassDefinition* parent_container) {
	GtkamlClassDefinition * self;
	GeeArrayList* _tmp0;
	GeeArrayList* _tmp1;
	g_return_val_if_fail (source_reference != NULL, NULL);
	g_return_val_if_fail (identifier != NULL, NULL);
	g_return_val_if_fail (base_ns != NULL, NULL);
	g_return_val_if_fail (base_type != NULL, NULL);
	self = g_object_newv (object_type, 0, NULL);
	gtkaml_class_definition_set_source_reference (self, source_reference);
	gtkaml_class_definition_set_base_ns (self, base_ns);
	gtkaml_class_definition_set_identifier (self, identifier);
	gtkaml_class_definition_set_base_type (self, base_type);
	gtkaml_class_definition_set_definition_scope (self, definition_scope);
	gtkaml_class_definition_set_parent_container (self, parent_container);
	_tmp0 = NULL;
	gtkaml_class_definition_set_attrs (self, (GeeList*) (_tmp0 = gee_array_list_new (GTKAML_TYPE_ATTRIBUTE, (GBoxedCopyFunc) g_object_ref, g_object_unref, g_direct_equal)));
	(_tmp0 == NULL) ? NULL : (_tmp0 = (gee_collection_object_unref (_tmp0), NULL));
	gtkaml_class_definition_set_construct_method (self, NULL);
	_tmp1 = NULL;
	gtkaml_class_definition_set_children (self, (GeeList*) (_tmp1 = gee_array_list_new (GTKAML_TYPE_CLASS_DEFINITION, (GBoxedCopyFunc) g_object_ref, g_object_unref, g_direct_equal)));
	(_tmp1 == NULL) ? NULL : (_tmp1 = (gee_collection_object_unref (_tmp1), NULL));
	gtkaml_class_definition_set_construct_code (self, NULL);
	gtkaml_class_definition_set_preconstruct_code (self, NULL);
	return self;
}


GtkamlClassDefinition* gtkaml_class_definition_new (ValaSourceReference* source_reference, const char* identifier, const char* base_ns, ValaClass* base_type, DefinitionScope definition_scope, GtkamlClassDefinition* parent_container) {
	return gtkaml_class_definition_construct (GTKAML_TYPE_CLASS_DEFINITION, source_reference, identifier, base_ns, base_type, definition_scope, parent_container);
}


void gtkaml_class_definition_add_attribute (GtkamlClassDefinition* self, GtkamlAttribute* attr) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (attr != NULL);
	gee_collection_add ((GeeCollection*) self->priv->_attrs, attr);
}


void gtkaml_class_definition_add_child (GtkamlClassDefinition* self, GtkamlClassDefinition* child) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (child != NULL);
	gee_collection_add ((GeeCollection*) self->priv->_children, child);
}


ValaSourceReference* gtkaml_class_definition_get_source_reference (GtkamlClassDefinition* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_source_reference;
}


void gtkaml_class_definition_set_source_reference (GtkamlClassDefinition* self, ValaSourceReference* value) {
	ValaSourceReference* _tmp2;
	ValaSourceReference* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_source_reference = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : vala_source_reference_ref (_tmp1)), (self->priv->_source_reference == NULL) ? NULL : (self->priv->_source_reference = (vala_source_reference_unref (self->priv->_source_reference), NULL)), _tmp2);
	g_object_notify ((GObject *) self, "source-reference");
}


const char* gtkaml_class_definition_get_identifier (GtkamlClassDefinition* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_identifier;
}


void gtkaml_class_definition_set_identifier (GtkamlClassDefinition* self, const char* value) {
	char* _tmp2;
	const char* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_identifier = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : g_strdup (_tmp1)), self->priv->_identifier = (g_free (self->priv->_identifier), NULL), _tmp2);
	g_object_notify ((GObject *) self, "identifier");
}


char* gtkaml_class_definition_get_base_full_name (GtkamlClassDefinition* self) {
	char* baseful_name;
	g_return_val_if_fail (self != NULL, NULL);
	/*BUG return (ns == null)? base_type.name : ns + "." + base_type.name;
	BUG return (base_ns == null)? base_type.name : (base_ns + "." + base_type.name);*/
	baseful_name = NULL;
	if (self->priv->_base_ns == NULL) {
		char* _tmp1;
		const char* _tmp0;
		_tmp1 = NULL;
		_tmp0 = NULL;
		baseful_name = (_tmp1 = (_tmp0 = vala_symbol_get_name ((ValaSymbol*) self->priv->_base_type), (_tmp0 == NULL) ? NULL : g_strdup (_tmp0)), baseful_name = (g_free (baseful_name), NULL), _tmp1);
	} else {
		char* _tmp3;
		char* _tmp2;
		_tmp3 = NULL;
		_tmp2 = NULL;
		baseful_name = (_tmp3 = g_strconcat (_tmp2 = g_strconcat (self->priv->_base_ns, ".", NULL), vala_symbol_get_name ((ValaSymbol*) self->priv->_base_type), NULL), baseful_name = (g_free (baseful_name), NULL), _tmp3);
		_tmp2 = (g_free (_tmp2), NULL);
	}
	return baseful_name;
}


const char* gtkaml_class_definition_get_base_ns (GtkamlClassDefinition* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_base_ns;
}


void gtkaml_class_definition_set_base_ns (GtkamlClassDefinition* self, const char* value) {
	char* _tmp2;
	const char* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_base_ns = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : g_strdup (_tmp1)), self->priv->_base_ns = (g_free (self->priv->_base_ns), NULL), _tmp2);
	g_object_notify ((GObject *) self, "base-ns");
}


ValaClass* gtkaml_class_definition_get_base_type (GtkamlClassDefinition* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_base_type;
}


void gtkaml_class_definition_set_base_type (GtkamlClassDefinition* self, ValaClass* value) {
	ValaClass* _tmp2;
	ValaClass* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_base_type = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : vala_code_node_ref (_tmp1)), (self->priv->_base_type == NULL) ? NULL : (self->priv->_base_type = (vala_code_node_unref (self->priv->_base_type), NULL)), _tmp2);
	g_object_notify ((GObject *) self, "base-type");
}


GeeList* gtkaml_class_definition_get_attrs (GtkamlClassDefinition* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_attrs;
}


void gtkaml_class_definition_set_attrs (GtkamlClassDefinition* self, GeeList* value) {
	GeeList* _tmp2;
	GeeList* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_attrs = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : gee_collection_object_ref (_tmp1)), (self->priv->_attrs == NULL) ? NULL : (self->priv->_attrs = (gee_collection_object_unref (self->priv->_attrs), NULL)), _tmp2);
	g_object_notify ((GObject *) self, "attrs");
}


GtkamlClassDefinition* gtkaml_class_definition_get_parent_container (GtkamlClassDefinition* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_parent_container;
}


void gtkaml_class_definition_set_parent_container (GtkamlClassDefinition* self, GtkamlClassDefinition* value) {
	g_return_if_fail (self != NULL);
	self->priv->_parent_container = value;
	g_object_notify ((GObject *) self, "parent-container");
}


GeeList* gtkaml_class_definition_get_children (GtkamlClassDefinition* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_children;
}


void gtkaml_class_definition_set_children (GtkamlClassDefinition* self, GeeList* value) {
	GeeList* _tmp2;
	GeeList* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_children = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : gee_collection_object_ref (_tmp1)), (self->priv->_children == NULL) ? NULL : (self->priv->_children = (gee_collection_object_unref (self->priv->_children), NULL)), _tmp2);
	g_object_notify ((GObject *) self, "children");
}


DefinitionScope gtkaml_class_definition_get_definition_scope (GtkamlClassDefinition* self) {
	g_return_val_if_fail (self != NULL, 0);
	return self->priv->_definition_scope;
}


void gtkaml_class_definition_set_definition_scope (GtkamlClassDefinition* self, DefinitionScope value) {
	g_return_if_fail (self != NULL);
	self->priv->_definition_scope = value;
	g_object_notify ((GObject *) self, "definition-scope");
}


GtkamlConstructMethod* gtkaml_class_definition_get_construct_method (GtkamlClassDefinition* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_construct_method;
}


void gtkaml_class_definition_set_construct_method (GtkamlClassDefinition* self, GtkamlConstructMethod* value) {
	GtkamlConstructMethod* _tmp2;
	GtkamlConstructMethod* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_construct_method = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : g_object_ref (_tmp1)), (self->priv->_construct_method == NULL) ? NULL : (self->priv->_construct_method = (g_object_unref (self->priv->_construct_method), NULL)), _tmp2);
	g_object_notify ((GObject *) self, "construct-method");
}


GtkamlAddMethod* gtkaml_class_definition_get_add_method (GtkamlClassDefinition* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_add_method;
}


void gtkaml_class_definition_set_add_method (GtkamlClassDefinition* self, GtkamlAddMethod* value) {
	GtkamlAddMethod* _tmp2;
	GtkamlAddMethod* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_add_method = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : g_object_ref (_tmp1)), (self->priv->_add_method == NULL) ? NULL : (self->priv->_add_method = (g_object_unref (self->priv->_add_method), NULL)), _tmp2);
	g_object_notify ((GObject *) self, "add-method");
}


const char* gtkaml_class_definition_get_construct_code (GtkamlClassDefinition* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_construct_code;
}


void gtkaml_class_definition_set_construct_code (GtkamlClassDefinition* self, const char* value) {
	char* _tmp2;
	const char* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_construct_code = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : g_strdup (_tmp1)), self->priv->_construct_code = (g_free (self->priv->_construct_code), NULL), _tmp2);
	g_object_notify ((GObject *) self, "construct-code");
}


const char* gtkaml_class_definition_get_preconstruct_code (GtkamlClassDefinition* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_preconstruct_code;
}


void gtkaml_class_definition_set_preconstruct_code (GtkamlClassDefinition* self, const char* value) {
	char* _tmp2;
	const char* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_preconstruct_code = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : g_strdup (_tmp1)), self->priv->_preconstruct_code = (g_free (self->priv->_preconstruct_code), NULL), _tmp2);
	g_object_notify ((GObject *) self, "preconstruct-code");
}


static void gtkaml_class_definition_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GtkamlClassDefinition * self;
	self = GTKAML_CLASS_DEFINITION (object);
	switch (property_id) {
		case GTKAML_CLASS_DEFINITION_SOURCE_REFERENCE:
		vala_value_set_source_reference (value, gtkaml_class_definition_get_source_reference (self));
		break;
		case GTKAML_CLASS_DEFINITION_IDENTIFIER:
		g_value_set_string (value, gtkaml_class_definition_get_identifier (self));
		break;
		case GTKAML_CLASS_DEFINITION_BASE_FULL_NAME:
		g_value_set_string (value, gtkaml_class_definition_get_base_full_name (self));
		break;
		case GTKAML_CLASS_DEFINITION_BASE_NS:
		g_value_set_string (value, gtkaml_class_definition_get_base_ns (self));
		break;
		case GTKAML_CLASS_DEFINITION_BASE_TYPE:
		vala_value_set_code_node (value, gtkaml_class_definition_get_base_type (self));
		break;
		case GTKAML_CLASS_DEFINITION_ATTRS:
		g_value_set_object (value, gtkaml_class_definition_get_attrs (self));
		break;
		case GTKAML_CLASS_DEFINITION_PARENT_CONTAINER:
		g_value_set_object (value, gtkaml_class_definition_get_parent_container (self));
		break;
		case GTKAML_CLASS_DEFINITION_CHILDREN:
		g_value_set_object (value, gtkaml_class_definition_get_children (self));
		break;
		case GTKAML_CLASS_DEFINITION_DEFINITION_SCOPE:
		g_value_set_enum (value, gtkaml_class_definition_get_definition_scope (self));
		break;
		case GTKAML_CLASS_DEFINITION_CONSTRUCT_METHOD:
		g_value_set_object (value, gtkaml_class_definition_get_construct_method (self));
		break;
		case GTKAML_CLASS_DEFINITION_ADD_METHOD:
		g_value_set_object (value, gtkaml_class_definition_get_add_method (self));
		break;
		case GTKAML_CLASS_DEFINITION_CONSTRUCT_CODE:
		g_value_set_string (value, gtkaml_class_definition_get_construct_code (self));
		break;
		case GTKAML_CLASS_DEFINITION_PRECONSTRUCT_CODE:
		g_value_set_string (value, gtkaml_class_definition_get_preconstruct_code (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gtkaml_class_definition_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GtkamlClassDefinition * self;
	self = GTKAML_CLASS_DEFINITION (object);
	switch (property_id) {
		case GTKAML_CLASS_DEFINITION_SOURCE_REFERENCE:
		gtkaml_class_definition_set_source_reference (self, vala_value_get_source_reference (value));
		break;
		case GTKAML_CLASS_DEFINITION_IDENTIFIER:
		gtkaml_class_definition_set_identifier (self, g_value_get_string (value));
		break;
		case GTKAML_CLASS_DEFINITION_BASE_NS:
		gtkaml_class_definition_set_base_ns (self, g_value_get_string (value));
		break;
		case GTKAML_CLASS_DEFINITION_BASE_TYPE:
		gtkaml_class_definition_set_base_type (self, vala_value_get_code_node (value));
		break;
		case GTKAML_CLASS_DEFINITION_ATTRS:
		gtkaml_class_definition_set_attrs (self, g_value_get_object (value));
		break;
		case GTKAML_CLASS_DEFINITION_PARENT_CONTAINER:
		gtkaml_class_definition_set_parent_container (self, g_value_get_object (value));
		break;
		case GTKAML_CLASS_DEFINITION_CHILDREN:
		gtkaml_class_definition_set_children (self, g_value_get_object (value));
		break;
		case GTKAML_CLASS_DEFINITION_DEFINITION_SCOPE:
		gtkaml_class_definition_set_definition_scope (self, g_value_get_enum (value));
		break;
		case GTKAML_CLASS_DEFINITION_CONSTRUCT_METHOD:
		gtkaml_class_definition_set_construct_method (self, g_value_get_object (value));
		break;
		case GTKAML_CLASS_DEFINITION_ADD_METHOD:
		gtkaml_class_definition_set_add_method (self, g_value_get_object (value));
		break;
		case GTKAML_CLASS_DEFINITION_CONSTRUCT_CODE:
		gtkaml_class_definition_set_construct_code (self, g_value_get_string (value));
		break;
		case GTKAML_CLASS_DEFINITION_PRECONSTRUCT_CODE:
		gtkaml_class_definition_set_preconstruct_code (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gtkaml_class_definition_class_init (GtkamlClassDefinitionClass * klass) {
	gtkaml_class_definition_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GtkamlClassDefinitionPrivate));
	G_OBJECT_CLASS (klass)->get_property = gtkaml_class_definition_get_property;
	G_OBJECT_CLASS (klass)->set_property = gtkaml_class_definition_set_property;
	G_OBJECT_CLASS (klass)->finalize = gtkaml_class_definition_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GTKAML_CLASS_DEFINITION_SOURCE_REFERENCE, vala_param_spec_source_reference ("source-reference", "source-reference", "source-reference", VALA_TYPE_SOURCE_REFERENCE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GTKAML_CLASS_DEFINITION_IDENTIFIER, g_param_spec_string ("identifier", "identifier", "identifier", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GTKAML_CLASS_DEFINITION_BASE_FULL_NAME, g_param_spec_string ("base-full-name", "base-full-name", "base-full-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GTKAML_CLASS_DEFINITION_BASE_NS, g_param_spec_string ("base-ns", "base-ns", "base-ns", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GTKAML_CLASS_DEFINITION_BASE_TYPE, vala_param_spec_code_node ("base-type", "base-type", "base-type", VALA_TYPE_CLASS, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GTKAML_CLASS_DEFINITION_ATTRS, gee_param_spec_collection_object ("attrs", "attrs", "attrs", GEE_TYPE_LIST, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GTKAML_CLASS_DEFINITION_PARENT_CONTAINER, g_param_spec_object ("parent-container", "parent-container", "parent-container", GTKAML_TYPE_CLASS_DEFINITION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GTKAML_CLASS_DEFINITION_CHILDREN, gee_param_spec_collection_object ("children", "children", "children", GEE_TYPE_LIST, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GTKAML_CLASS_DEFINITION_DEFINITION_SCOPE, g_param_spec_enum ("definition-scope", "definition-scope", "definition-scope", TYPE_DEFINITION_SCOPE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GTKAML_CLASS_DEFINITION_CONSTRUCT_METHOD, g_param_spec_object ("construct-method", "construct-method", "construct-method", GTKAML_TYPE_CONSTRUCT_METHOD, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GTKAML_CLASS_DEFINITION_ADD_METHOD, g_param_spec_object ("add-method", "add-method", "add-method", GTKAML_TYPE_ADD_METHOD, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GTKAML_CLASS_DEFINITION_CONSTRUCT_CODE, g_param_spec_string ("construct-code", "construct-code", "construct-code", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GTKAML_CLASS_DEFINITION_PRECONSTRUCT_CODE, g_param_spec_string ("preconstruct-code", "preconstruct-code", "preconstruct-code", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void gtkaml_class_definition_instance_init (GtkamlClassDefinition * self) {
	self->priv = GTKAML_CLASS_DEFINITION_GET_PRIVATE (self);
}


static void gtkaml_class_definition_finalize (GObject* obj) {
	GtkamlClassDefinition * self;
	self = GTKAML_CLASS_DEFINITION (obj);
	(self->priv->_source_reference == NULL) ? NULL : (self->priv->_source_reference = (vala_source_reference_unref (self->priv->_source_reference), NULL));
	self->priv->_identifier = (g_free (self->priv->_identifier), NULL);
	self->priv->_base_ns = (g_free (self->priv->_base_ns), NULL);
	(self->priv->_base_type == NULL) ? NULL : (self->priv->_base_type = (vala_code_node_unref (self->priv->_base_type), NULL));
	(self->priv->_attrs == NULL) ? NULL : (self->priv->_attrs = (gee_collection_object_unref (self->priv->_attrs), NULL));
	(self->priv->_children == NULL) ? NULL : (self->priv->_children = (gee_collection_object_unref (self->priv->_children), NULL));
	(self->priv->_construct_method == NULL) ? NULL : (self->priv->_construct_method = (g_object_unref (self->priv->_construct_method), NULL));
	(self->priv->_add_method == NULL) ? NULL : (self->priv->_add_method = (g_object_unref (self->priv->_add_method), NULL));
	self->priv->_construct_code = (g_free (self->priv->_construct_code), NULL);
	self->priv->_preconstruct_code = (g_free (self->priv->_preconstruct_code), NULL);
	G_OBJECT_CLASS (gtkaml_class_definition_parent_class)->finalize (obj);
}


GType gtkaml_class_definition_get_type (void) {
	static GType gtkaml_class_definition_type_id = 0;
	if (gtkaml_class_definition_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (GtkamlClassDefinitionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gtkaml_class_definition_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GtkamlClassDefinition), 0, (GInstanceInitFunc) gtkaml_class_definition_instance_init, NULL };
		gtkaml_class_definition_type_id = g_type_register_static (G_TYPE_OBJECT, "GtkamlClassDefinition", &g_define_type_info, 0);
	}
	return gtkaml_class_definition_type_id;
}




