/*
 * Copyright (c) 2001-2009 XORP, Inc.
 * See the XORP LICENSE.lgpl file for licensing, conditions, and warranties
 * on use.
 *
 * DO NOT EDIT THIS FILE - IT IS PROGRAMMATICALLY GENERATED
 *
 * Generated by 'tgt-gen'.
 */

#ident "$XORP: xorp/xrl/targets/pim_base.cc,v 1.68 2009/01/05 18:31:15 jtc Exp $"


#include "pim_base.hh"


XrlPimTargetBase::XrlPimTargetBase(XrlCmdMap* cmds)
    : _cmds(cmds)
{
    if (_cmds)
	add_handlers();
}

XrlPimTargetBase::~XrlPimTargetBase()
{
    if (_cmds)
	remove_handlers();
}

bool
XrlPimTargetBase::set_command_map(XrlCmdMap* cmds)
{
    if (_cmds == 0 && cmds) {
        _cmds = cmds;
        add_handlers();
        return true;
    }
    if (_cmds && cmds == 0) {
	remove_handlers();
        _cmds = cmds;
        return true;
    }
    return false;
}

const XrlCmdError
XrlPimTargetBase::handle_common_0_1_get_target_name(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "common/0.1/get_target_name");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    string name;
    try {
	XrlCmdError e = common_0_1_get_target_name(
	    name);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "common/0.1/get_target_name", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("name", name);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_common_0_1_get_version(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "common/0.1/get_version");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    string version;
    try {
	XrlCmdError e = common_0_1_get_version(
	    version);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "common/0.1/get_version", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("version", version);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_common_0_1_get_status(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "common/0.1/get_status");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t status;
    string reason;
    try {
	XrlCmdError e = common_0_1_get_status(
	    status,
	    reason);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "common/0.1/get_status", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("status", status);
	pxa_outputs->add("reason", reason);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_common_0_1_shutdown(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "common/0.1/shutdown");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = common_0_1_shutdown();
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "common/0.1/shutdown", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_cli_processor_0_1_process_command(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 5) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(5), XORP_UINT_CAST(xa_inputs.size()), "cli_processor/0.1/process_command");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    string ret_processor_name;
    string ret_cli_term_name;
    uint32_t ret_cli_session_id;
    string ret_command_output;
    try {
	XrlCmdError e = cli_processor_0_1_process_command(
	    xa_inputs.get(0, "processor_name").text(),
	    xa_inputs.get(1, "cli_term_name").text(),
	    xa_inputs.get(2, "cli_session_id").uint32(),
	    xa_inputs.get(3, "command_name").text(),
	    xa_inputs.get(4, "command_args").text(),
	    ret_processor_name,
	    ret_cli_term_name,
	    ret_cli_session_id,
	    ret_command_output);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "cli_processor/0.1/process_command", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("ret_processor_name", ret_processor_name);
	pxa_outputs->add("ret_cli_term_name", ret_cli_term_name);
	pxa_outputs->add("ret_cli_session_id", ret_cli_session_id);
	pxa_outputs->add("ret_command_output", ret_command_output);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_finder_event_observer_0_1_xrl_target_birth(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(2), XORP_UINT_CAST(xa_inputs.size()), "finder_event_observer/0.1/xrl_target_birth");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = finder_event_observer_0_1_xrl_target_birth(
	    xa_inputs.get(0, "target_class").text(),
	    xa_inputs.get(1, "target_instance").text());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "finder_event_observer/0.1/xrl_target_birth", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_finder_event_observer_0_1_xrl_target_death(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(2), XORP_UINT_CAST(xa_inputs.size()), "finder_event_observer/0.1/xrl_target_death");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = finder_event_observer_0_1_xrl_target_death(
	    xa_inputs.get(0, "target_class").text(),
	    xa_inputs.get(1, "target_instance").text());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "finder_event_observer/0.1/xrl_target_death", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_raw_packet4_client_0_1_recv(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 10) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(10), XORP_UINT_CAST(xa_inputs.size()), "raw_packet4_client/0.1/recv");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = raw_packet4_client_0_1_recv(
	    xa_inputs.get(0, "if_name").text(),
	    xa_inputs.get(1, "vif_name").text(),
	    xa_inputs.get(2, "src_address").ipv4(),
	    xa_inputs.get(3, "dst_address").ipv4(),
	    xa_inputs.get(4, "ip_protocol").uint32(),
	    xa_inputs.get(5, "ip_ttl").int32(),
	    xa_inputs.get(6, "ip_tos").int32(),
	    xa_inputs.get(7, "ip_router_alert").boolean(),
	    xa_inputs.get(8, "ip_internet_control").boolean(),
	    xa_inputs.get(9, "payload").binary());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "raw_packet4_client/0.1/recv", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_raw_packet6_client_0_1_recv(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 12) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(12), XORP_UINT_CAST(xa_inputs.size()), "raw_packet6_client/0.1/recv");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = raw_packet6_client_0_1_recv(
	    xa_inputs.get(0, "if_name").text(),
	    xa_inputs.get(1, "vif_name").text(),
	    xa_inputs.get(2, "src_address").ipv6(),
	    xa_inputs.get(3, "dst_address").ipv6(),
	    xa_inputs.get(4, "ip_protocol").uint32(),
	    xa_inputs.get(5, "ip_ttl").int32(),
	    xa_inputs.get(6, "ip_tos").int32(),
	    xa_inputs.get(7, "ip_router_alert").boolean(),
	    xa_inputs.get(8, "ip_internet_control").boolean(),
	    xa_inputs.get(9, "ext_headers_type").list(),
	    xa_inputs.get(10, "ext_headers_payload").list(),
	    xa_inputs.get(11, "payload").binary());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "raw_packet6_client/0.1/recv", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_mfea_client_0_1_recv_kernel_signal_message4(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 7) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(7), XORP_UINT_CAST(xa_inputs.size()), "mfea_client/0.1/recv_kernel_signal_message4");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = mfea_client_0_1_recv_kernel_signal_message4(
	    xa_inputs.get(0, "xrl_sender_name").text(),
	    xa_inputs.get(1, "message_type").uint32(),
	    xa_inputs.get(2, "vif_name").text(),
	    xa_inputs.get(3, "vif_index").uint32(),
	    xa_inputs.get(4, "source_address").ipv4(),
	    xa_inputs.get(5, "dest_address").ipv4(),
	    xa_inputs.get(6, "protocol_message").binary());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "mfea_client/0.1/recv_kernel_signal_message4", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_mfea_client_0_1_recv_kernel_signal_message6(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 7) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(7), XORP_UINT_CAST(xa_inputs.size()), "mfea_client/0.1/recv_kernel_signal_message6");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = mfea_client_0_1_recv_kernel_signal_message6(
	    xa_inputs.get(0, "xrl_sender_name").text(),
	    xa_inputs.get(1, "message_type").uint32(),
	    xa_inputs.get(2, "vif_name").text(),
	    xa_inputs.get(3, "vif_index").uint32(),
	    xa_inputs.get(4, "source_address").ipv6(),
	    xa_inputs.get(5, "dest_address").ipv6(),
	    xa_inputs.get(6, "protocol_message").binary());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "mfea_client/0.1/recv_kernel_signal_message6", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_mfea_client_0_1_recv_dataflow_signal4(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 15) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(15), XORP_UINT_CAST(xa_inputs.size()), "mfea_client/0.1/recv_dataflow_signal4");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = mfea_client_0_1_recv_dataflow_signal4(
	    xa_inputs.get(0, "xrl_sender_name").text(),
	    xa_inputs.get(1, "source_address").ipv4(),
	    xa_inputs.get(2, "group_address").ipv4(),
	    xa_inputs.get(3, "threshold_interval_sec").uint32(),
	    xa_inputs.get(4, "threshold_interval_usec").uint32(),
	    xa_inputs.get(5, "measured_interval_sec").uint32(),
	    xa_inputs.get(6, "measured_interval_usec").uint32(),
	    xa_inputs.get(7, "threshold_packets").uint32(),
	    xa_inputs.get(8, "threshold_bytes").uint32(),
	    xa_inputs.get(9, "measured_packets").uint32(),
	    xa_inputs.get(10, "measured_bytes").uint32(),
	    xa_inputs.get(11, "is_threshold_in_packets").boolean(),
	    xa_inputs.get(12, "is_threshold_in_bytes").boolean(),
	    xa_inputs.get(13, "is_geq_upcall").boolean(),
	    xa_inputs.get(14, "is_leq_upcall").boolean());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "mfea_client/0.1/recv_dataflow_signal4", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_mfea_client_0_1_recv_dataflow_signal6(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 15) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(15), XORP_UINT_CAST(xa_inputs.size()), "mfea_client/0.1/recv_dataflow_signal6");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = mfea_client_0_1_recv_dataflow_signal6(
	    xa_inputs.get(0, "xrl_sender_name").text(),
	    xa_inputs.get(1, "source_address").ipv6(),
	    xa_inputs.get(2, "group_address").ipv6(),
	    xa_inputs.get(3, "threshold_interval_sec").uint32(),
	    xa_inputs.get(4, "threshold_interval_usec").uint32(),
	    xa_inputs.get(5, "measured_interval_sec").uint32(),
	    xa_inputs.get(6, "measured_interval_usec").uint32(),
	    xa_inputs.get(7, "threshold_packets").uint32(),
	    xa_inputs.get(8, "threshold_bytes").uint32(),
	    xa_inputs.get(9, "measured_packets").uint32(),
	    xa_inputs.get(10, "measured_bytes").uint32(),
	    xa_inputs.get(11, "is_threshold_in_packets").boolean(),
	    xa_inputs.get(12, "is_threshold_in_bytes").boolean(),
	    xa_inputs.get(13, "is_geq_upcall").boolean(),
	    xa_inputs.get(14, "is_leq_upcall").boolean());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "mfea_client/0.1/recv_dataflow_signal6", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_redist_transaction4_0_1_start_transaction(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "redist_transaction4/0.1/start_transaction");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t tid;
    try {
	XrlCmdError e = redist_transaction4_0_1_start_transaction(
	    tid);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "redist_transaction4/0.1/start_transaction", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("tid", tid);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_redist_transaction4_0_1_commit_transaction(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "redist_transaction4/0.1/commit_transaction");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = redist_transaction4_0_1_commit_transaction(
	    xa_inputs.get(0, "tid").uint32());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "redist_transaction4/0.1/commit_transaction", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_redist_transaction4_0_1_abort_transaction(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "redist_transaction4/0.1/abort_transaction");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = redist_transaction4_0_1_abort_transaction(
	    xa_inputs.get(0, "tid").uint32());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "redist_transaction4/0.1/abort_transaction", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_redist_transaction4_0_1_add_route(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 9) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(9), XORP_UINT_CAST(xa_inputs.size()), "redist_transaction4/0.1/add_route");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = redist_transaction4_0_1_add_route(
	    xa_inputs.get(0, "tid").uint32(),
	    xa_inputs.get(1, "dst").ipv4net(),
	    xa_inputs.get(2, "nexthop").ipv4(),
	    xa_inputs.get(3, "ifname").text(),
	    xa_inputs.get(4, "vifname").text(),
	    xa_inputs.get(5, "metric").uint32(),
	    xa_inputs.get(6, "admin_distance").uint32(),
	    xa_inputs.get(7, "cookie").text(),
	    xa_inputs.get(8, "protocol_origin").text());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "redist_transaction4/0.1/add_route", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_redist_transaction4_0_1_delete_route(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 9) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(9), XORP_UINT_CAST(xa_inputs.size()), "redist_transaction4/0.1/delete_route");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = redist_transaction4_0_1_delete_route(
	    xa_inputs.get(0, "tid").uint32(),
	    xa_inputs.get(1, "dst").ipv4net(),
	    xa_inputs.get(2, "nexthop").ipv4(),
	    xa_inputs.get(3, "ifname").text(),
	    xa_inputs.get(4, "vifname").text(),
	    xa_inputs.get(5, "metric").uint32(),
	    xa_inputs.get(6, "admin_distance").uint32(),
	    xa_inputs.get(7, "cookie").text(),
	    xa_inputs.get(8, "protocol_origin").text());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "redist_transaction4/0.1/delete_route", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_redist_transaction4_0_1_delete_all_routes(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(2), XORP_UINT_CAST(xa_inputs.size()), "redist_transaction4/0.1/delete_all_routes");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = redist_transaction4_0_1_delete_all_routes(
	    xa_inputs.get(0, "tid").uint32(),
	    xa_inputs.get(1, "cookie").text());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "redist_transaction4/0.1/delete_all_routes", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_redist_transaction6_0_1_start_transaction(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "redist_transaction6/0.1/start_transaction");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t tid;
    try {
	XrlCmdError e = redist_transaction6_0_1_start_transaction(
	    tid);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "redist_transaction6/0.1/start_transaction", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("tid", tid);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_redist_transaction6_0_1_commit_transaction(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "redist_transaction6/0.1/commit_transaction");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = redist_transaction6_0_1_commit_transaction(
	    xa_inputs.get(0, "tid").uint32());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "redist_transaction6/0.1/commit_transaction", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_redist_transaction6_0_1_abort_transaction(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "redist_transaction6/0.1/abort_transaction");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = redist_transaction6_0_1_abort_transaction(
	    xa_inputs.get(0, "tid").uint32());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "redist_transaction6/0.1/abort_transaction", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_redist_transaction6_0_1_add_route(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 9) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(9), XORP_UINT_CAST(xa_inputs.size()), "redist_transaction6/0.1/add_route");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = redist_transaction6_0_1_add_route(
	    xa_inputs.get(0, "tid").uint32(),
	    xa_inputs.get(1, "dst").ipv6net(),
	    xa_inputs.get(2, "nexthop").ipv6(),
	    xa_inputs.get(3, "ifname").text(),
	    xa_inputs.get(4, "vifname").text(),
	    xa_inputs.get(5, "metric").uint32(),
	    xa_inputs.get(6, "admin_distance").uint32(),
	    xa_inputs.get(7, "cookie").text(),
	    xa_inputs.get(8, "protocol_origin").text());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "redist_transaction6/0.1/add_route", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_redist_transaction6_0_1_delete_route(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 9) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(9), XORP_UINT_CAST(xa_inputs.size()), "redist_transaction6/0.1/delete_route");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = redist_transaction6_0_1_delete_route(
	    xa_inputs.get(0, "tid").uint32(),
	    xa_inputs.get(1, "dst").ipv6net(),
	    xa_inputs.get(2, "nexthop").ipv6(),
	    xa_inputs.get(3, "ifname").text(),
	    xa_inputs.get(4, "vifname").text(),
	    xa_inputs.get(5, "metric").uint32(),
	    xa_inputs.get(6, "admin_distance").uint32(),
	    xa_inputs.get(7, "cookie").text(),
	    xa_inputs.get(8, "protocol_origin").text());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "redist_transaction6/0.1/delete_route", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_redist_transaction6_0_1_delete_all_routes(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(2), XORP_UINT_CAST(xa_inputs.size()), "redist_transaction6/0.1/delete_all_routes");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = redist_transaction6_0_1_delete_all_routes(
	    xa_inputs.get(0, "tid").uint32(),
	    xa_inputs.get(1, "cookie").text());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "redist_transaction6/0.1/delete_all_routes", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_mld6igmp_client_0_1_add_membership4(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 5) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(5), XORP_UINT_CAST(xa_inputs.size()), "mld6igmp_client/0.1/add_membership4");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = mld6igmp_client_0_1_add_membership4(
	    xa_inputs.get(0, "xrl_sender_name").text(),
	    xa_inputs.get(1, "vif_name").text(),
	    xa_inputs.get(2, "vif_index").uint32(),
	    xa_inputs.get(3, "source").ipv4(),
	    xa_inputs.get(4, "group").ipv4());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "mld6igmp_client/0.1/add_membership4", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_mld6igmp_client_0_1_add_membership6(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 5) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(5), XORP_UINT_CAST(xa_inputs.size()), "mld6igmp_client/0.1/add_membership6");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = mld6igmp_client_0_1_add_membership6(
	    xa_inputs.get(0, "xrl_sender_name").text(),
	    xa_inputs.get(1, "vif_name").text(),
	    xa_inputs.get(2, "vif_index").uint32(),
	    xa_inputs.get(3, "source").ipv6(),
	    xa_inputs.get(4, "group").ipv6());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "mld6igmp_client/0.1/add_membership6", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_mld6igmp_client_0_1_delete_membership4(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 5) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(5), XORP_UINT_CAST(xa_inputs.size()), "mld6igmp_client/0.1/delete_membership4");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = mld6igmp_client_0_1_delete_membership4(
	    xa_inputs.get(0, "xrl_sender_name").text(),
	    xa_inputs.get(1, "vif_name").text(),
	    xa_inputs.get(2, "vif_index").uint32(),
	    xa_inputs.get(3, "source").ipv4(),
	    xa_inputs.get(4, "group").ipv4());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "mld6igmp_client/0.1/delete_membership4", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_mld6igmp_client_0_1_delete_membership6(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 5) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(5), XORP_UINT_CAST(xa_inputs.size()), "mld6igmp_client/0.1/delete_membership6");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = mld6igmp_client_0_1_delete_membership6(
	    xa_inputs.get(0, "xrl_sender_name").text(),
	    xa_inputs.get(1, "vif_name").text(),
	    xa_inputs.get(2, "vif_index").uint32(),
	    xa_inputs.get(3, "source").ipv6(),
	    xa_inputs.get(4, "group").ipv6());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "mld6igmp_client/0.1/delete_membership6", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_enable_vif(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(2), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/enable_vif");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = pim_0_1_enable_vif(
	    xa_inputs.get(0, "vif_name").text(),
	    xa_inputs.get(1, "enable").boolean());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/enable_vif", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_start_vif(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/start_vif");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = pim_0_1_start_vif(
	    xa_inputs.get(0, "vif_name").text());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/start_vif", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_stop_vif(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/stop_vif");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = pim_0_1_stop_vif(
	    xa_inputs.get(0, "vif_name").text());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/stop_vif", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_enable_all_vifs(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/enable_all_vifs");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = pim_0_1_enable_all_vifs(
	    xa_inputs.get(0, "enable").boolean());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/enable_all_vifs", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_start_all_vifs(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/start_all_vifs");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = pim_0_1_start_all_vifs();
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/start_all_vifs", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_stop_all_vifs(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/stop_all_vifs");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = pim_0_1_stop_all_vifs();
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/stop_all_vifs", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_enable_pim(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/enable_pim");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = pim_0_1_enable_pim(
	    xa_inputs.get(0, "enable").boolean());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/enable_pim", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_start_pim(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/start_pim");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = pim_0_1_start_pim();
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/start_pim", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_stop_pim(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/stop_pim");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = pim_0_1_stop_pim();
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/stop_pim", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_enable_cli(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/enable_cli");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = pim_0_1_enable_cli(
	    xa_inputs.get(0, "enable").boolean());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/enable_cli", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_start_cli(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/start_cli");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = pim_0_1_start_cli();
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/start_cli", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_stop_cli(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/stop_cli");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = pim_0_1_stop_cli();
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/stop_cli", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_enable_bsr(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/enable_bsr");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = pim_0_1_enable_bsr(
	    xa_inputs.get(0, "enable").boolean());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/enable_bsr", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_start_bsr(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/start_bsr");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = pim_0_1_start_bsr();
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/start_bsr", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_stop_bsr(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/stop_bsr");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = pim_0_1_stop_bsr();
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/stop_bsr", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_add_config_scope_zone_by_vif_name4(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(2), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/add_config_scope_zone_by_vif_name4");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = pim_0_1_add_config_scope_zone_by_vif_name4(
	    xa_inputs.get(0, "scope_zone_id").ipv4net(),
	    xa_inputs.get(1, "vif_name").text());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/add_config_scope_zone_by_vif_name4", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_add_config_scope_zone_by_vif_name6(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(2), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/add_config_scope_zone_by_vif_name6");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = pim_0_1_add_config_scope_zone_by_vif_name6(
	    xa_inputs.get(0, "scope_zone_id").ipv6net(),
	    xa_inputs.get(1, "vif_name").text());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/add_config_scope_zone_by_vif_name6", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_add_config_scope_zone_by_vif_addr4(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(2), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/add_config_scope_zone_by_vif_addr4");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = pim_0_1_add_config_scope_zone_by_vif_addr4(
	    xa_inputs.get(0, "scope_zone_id").ipv4net(),
	    xa_inputs.get(1, "vif_addr").ipv4());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/add_config_scope_zone_by_vif_addr4", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_add_config_scope_zone_by_vif_addr6(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(2), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/add_config_scope_zone_by_vif_addr6");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = pim_0_1_add_config_scope_zone_by_vif_addr6(
	    xa_inputs.get(0, "scope_zone_id").ipv6net(),
	    xa_inputs.get(1, "vif_addr").ipv6());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/add_config_scope_zone_by_vif_addr6", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_delete_config_scope_zone_by_vif_name4(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(2), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/delete_config_scope_zone_by_vif_name4");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = pim_0_1_delete_config_scope_zone_by_vif_name4(
	    xa_inputs.get(0, "scope_zone_id").ipv4net(),
	    xa_inputs.get(1, "vif_name").text());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/delete_config_scope_zone_by_vif_name4", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_delete_config_scope_zone_by_vif_name6(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(2), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/delete_config_scope_zone_by_vif_name6");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = pim_0_1_delete_config_scope_zone_by_vif_name6(
	    xa_inputs.get(0, "scope_zone_id").ipv6net(),
	    xa_inputs.get(1, "vif_name").text());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/delete_config_scope_zone_by_vif_name6", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_delete_config_scope_zone_by_vif_addr4(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(2), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/delete_config_scope_zone_by_vif_addr4");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = pim_0_1_delete_config_scope_zone_by_vif_addr4(
	    xa_inputs.get(0, "scope_zone_id").ipv4net(),
	    xa_inputs.get(1, "vif_addr").ipv4());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/delete_config_scope_zone_by_vif_addr4", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_delete_config_scope_zone_by_vif_addr6(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(2), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/delete_config_scope_zone_by_vif_addr6");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = pim_0_1_delete_config_scope_zone_by_vif_addr6(
	    xa_inputs.get(0, "scope_zone_id").ipv6net(),
	    xa_inputs.get(1, "vif_addr").ipv6());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/delete_config_scope_zone_by_vif_addr6", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_add_config_cand_bsr4(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 6) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(6), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/add_config_cand_bsr4");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = pim_0_1_add_config_cand_bsr4(
	    xa_inputs.get(0, "scope_zone_id").ipv4net(),
	    xa_inputs.get(1, "is_scope_zone").boolean(),
	    xa_inputs.get(2, "vif_name").text(),
	    xa_inputs.get(3, "vif_addr").ipv4(),
	    xa_inputs.get(4, "bsr_priority").uint32(),
	    xa_inputs.get(5, "hash_mask_len").uint32());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/add_config_cand_bsr4", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_add_config_cand_bsr6(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 6) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(6), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/add_config_cand_bsr6");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = pim_0_1_add_config_cand_bsr6(
	    xa_inputs.get(0, "scope_zone_id").ipv6net(),
	    xa_inputs.get(1, "is_scope_zone").boolean(),
	    xa_inputs.get(2, "vif_name").text(),
	    xa_inputs.get(3, "vif_addr").ipv6(),
	    xa_inputs.get(4, "bsr_priority").uint32(),
	    xa_inputs.get(5, "hash_mask_len").uint32());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/add_config_cand_bsr6", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_delete_config_cand_bsr4(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(2), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/delete_config_cand_bsr4");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = pim_0_1_delete_config_cand_bsr4(
	    xa_inputs.get(0, "scope_zone_id").ipv4net(),
	    xa_inputs.get(1, "is_scope_zone").boolean());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/delete_config_cand_bsr4", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_delete_config_cand_bsr6(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(2), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/delete_config_cand_bsr6");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = pim_0_1_delete_config_cand_bsr6(
	    xa_inputs.get(0, "scope_zone_id").ipv6net(),
	    xa_inputs.get(1, "is_scope_zone").boolean());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/delete_config_cand_bsr6", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_add_config_cand_rp4(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 6) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(6), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/add_config_cand_rp4");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = pim_0_1_add_config_cand_rp4(
	    xa_inputs.get(0, "group_prefix").ipv4net(),
	    xa_inputs.get(1, "is_scope_zone").boolean(),
	    xa_inputs.get(2, "vif_name").text(),
	    xa_inputs.get(3, "vif_addr").ipv4(),
	    xa_inputs.get(4, "rp_priority").uint32(),
	    xa_inputs.get(5, "rp_holdtime").uint32());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/add_config_cand_rp4", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_add_config_cand_rp6(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 6) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(6), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/add_config_cand_rp6");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = pim_0_1_add_config_cand_rp6(
	    xa_inputs.get(0, "group_prefix").ipv6net(),
	    xa_inputs.get(1, "is_scope_zone").boolean(),
	    xa_inputs.get(2, "vif_name").text(),
	    xa_inputs.get(3, "vif_addr").ipv6(),
	    xa_inputs.get(4, "rp_priority").uint32(),
	    xa_inputs.get(5, "rp_holdtime").uint32());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/add_config_cand_rp6", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_delete_config_cand_rp4(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 4) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(4), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/delete_config_cand_rp4");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = pim_0_1_delete_config_cand_rp4(
	    xa_inputs.get(0, "group_prefix").ipv4net(),
	    xa_inputs.get(1, "is_scope_zone").boolean(),
	    xa_inputs.get(2, "vif_name").text(),
	    xa_inputs.get(3, "vif_addr").ipv4());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/delete_config_cand_rp4", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_delete_config_cand_rp6(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 4) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(4), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/delete_config_cand_rp6");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = pim_0_1_delete_config_cand_rp6(
	    xa_inputs.get(0, "group_prefix").ipv6net(),
	    xa_inputs.get(1, "is_scope_zone").boolean(),
	    xa_inputs.get(2, "vif_name").text(),
	    xa_inputs.get(3, "vif_addr").ipv6());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/delete_config_cand_rp6", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_add_config_static_rp4(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 4) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(4), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/add_config_static_rp4");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = pim_0_1_add_config_static_rp4(
	    xa_inputs.get(0, "group_prefix").ipv4net(),
	    xa_inputs.get(1, "rp_addr").ipv4(),
	    xa_inputs.get(2, "rp_priority").uint32(),
	    xa_inputs.get(3, "hash_mask_len").uint32());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/add_config_static_rp4", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_add_config_static_rp6(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 4) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(4), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/add_config_static_rp6");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = pim_0_1_add_config_static_rp6(
	    xa_inputs.get(0, "group_prefix").ipv6net(),
	    xa_inputs.get(1, "rp_addr").ipv6(),
	    xa_inputs.get(2, "rp_priority").uint32(),
	    xa_inputs.get(3, "hash_mask_len").uint32());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/add_config_static_rp6", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_delete_config_static_rp4(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(2), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/delete_config_static_rp4");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = pim_0_1_delete_config_static_rp4(
	    xa_inputs.get(0, "group_prefix").ipv4net(),
	    xa_inputs.get(1, "rp_addr").ipv4());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/delete_config_static_rp4", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_delete_config_static_rp6(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(2), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/delete_config_static_rp6");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = pim_0_1_delete_config_static_rp6(
	    xa_inputs.get(0, "group_prefix").ipv6net(),
	    xa_inputs.get(1, "rp_addr").ipv6());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/delete_config_static_rp6", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_delete_config_all_static_group_prefixes_rp4(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/delete_config_all_static_group_prefixes_rp4");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = pim_0_1_delete_config_all_static_group_prefixes_rp4(
	    xa_inputs.get(0, "rp_addr").ipv4());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/delete_config_all_static_group_prefixes_rp4", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_delete_config_all_static_group_prefixes_rp6(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/delete_config_all_static_group_prefixes_rp6");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = pim_0_1_delete_config_all_static_group_prefixes_rp6(
	    xa_inputs.get(0, "rp_addr").ipv6());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/delete_config_all_static_group_prefixes_rp6", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_delete_config_all_static_rps(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/delete_config_all_static_rps");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = pim_0_1_delete_config_all_static_rps();
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/delete_config_all_static_rps", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_config_static_rp_done(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/config_static_rp_done");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = pim_0_1_config_static_rp_done();
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/config_static_rp_done", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_get_vif_proto_version(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/get_vif_proto_version");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t proto_version;
    try {
	XrlCmdError e = pim_0_1_get_vif_proto_version(
	    xa_inputs.get(0, "vif_name").text(),
	    proto_version);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/get_vif_proto_version", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("proto_version", proto_version);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_set_vif_proto_version(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(2), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/set_vif_proto_version");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = pim_0_1_set_vif_proto_version(
	    xa_inputs.get(0, "vif_name").text(),
	    xa_inputs.get(1, "proto_version").uint32());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/set_vif_proto_version", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_reset_vif_proto_version(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/reset_vif_proto_version");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = pim_0_1_reset_vif_proto_version(
	    xa_inputs.get(0, "vif_name").text());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/reset_vif_proto_version", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_get_vif_hello_triggered_delay(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/get_vif_hello_triggered_delay");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t hello_triggered_delay;
    try {
	XrlCmdError e = pim_0_1_get_vif_hello_triggered_delay(
	    xa_inputs.get(0, "vif_name").text(),
	    hello_triggered_delay);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/get_vif_hello_triggered_delay", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("hello_triggered_delay", hello_triggered_delay);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_set_vif_hello_triggered_delay(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(2), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/set_vif_hello_triggered_delay");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = pim_0_1_set_vif_hello_triggered_delay(
	    xa_inputs.get(0, "vif_name").text(),
	    xa_inputs.get(1, "hello_triggered_delay").uint32());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/set_vif_hello_triggered_delay", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_reset_vif_hello_triggered_delay(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/reset_vif_hello_triggered_delay");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = pim_0_1_reset_vif_hello_triggered_delay(
	    xa_inputs.get(0, "vif_name").text());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/reset_vif_hello_triggered_delay", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_get_vif_hello_period(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/get_vif_hello_period");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t hello_period;
    try {
	XrlCmdError e = pim_0_1_get_vif_hello_period(
	    xa_inputs.get(0, "vif_name").text(),
	    hello_period);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/get_vif_hello_period", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("hello_period", hello_period);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_set_vif_hello_period(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(2), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/set_vif_hello_period");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = pim_0_1_set_vif_hello_period(
	    xa_inputs.get(0, "vif_name").text(),
	    xa_inputs.get(1, "hello_period").uint32());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/set_vif_hello_period", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_reset_vif_hello_period(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/reset_vif_hello_period");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = pim_0_1_reset_vif_hello_period(
	    xa_inputs.get(0, "vif_name").text());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/reset_vif_hello_period", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_get_vif_hello_holdtime(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/get_vif_hello_holdtime");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t hello_holdtime;
    try {
	XrlCmdError e = pim_0_1_get_vif_hello_holdtime(
	    xa_inputs.get(0, "vif_name").text(),
	    hello_holdtime);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/get_vif_hello_holdtime", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("hello_holdtime", hello_holdtime);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_set_vif_hello_holdtime(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(2), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/set_vif_hello_holdtime");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = pim_0_1_set_vif_hello_holdtime(
	    xa_inputs.get(0, "vif_name").text(),
	    xa_inputs.get(1, "hello_holdtime").uint32());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/set_vif_hello_holdtime", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_reset_vif_hello_holdtime(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/reset_vif_hello_holdtime");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = pim_0_1_reset_vif_hello_holdtime(
	    xa_inputs.get(0, "vif_name").text());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/reset_vif_hello_holdtime", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_get_vif_dr_priority(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/get_vif_dr_priority");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t dr_priority;
    try {
	XrlCmdError e = pim_0_1_get_vif_dr_priority(
	    xa_inputs.get(0, "vif_name").text(),
	    dr_priority);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/get_vif_dr_priority", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("dr_priority", dr_priority);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_set_vif_dr_priority(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(2), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/set_vif_dr_priority");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = pim_0_1_set_vif_dr_priority(
	    xa_inputs.get(0, "vif_name").text(),
	    xa_inputs.get(1, "dr_priority").uint32());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/set_vif_dr_priority", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_reset_vif_dr_priority(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/reset_vif_dr_priority");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = pim_0_1_reset_vif_dr_priority(
	    xa_inputs.get(0, "vif_name").text());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/reset_vif_dr_priority", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_get_vif_propagation_delay(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/get_vif_propagation_delay");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t propagation_delay;
    try {
	XrlCmdError e = pim_0_1_get_vif_propagation_delay(
	    xa_inputs.get(0, "vif_name").text(),
	    propagation_delay);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/get_vif_propagation_delay", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("propagation_delay", propagation_delay);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_set_vif_propagation_delay(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(2), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/set_vif_propagation_delay");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = pim_0_1_set_vif_propagation_delay(
	    xa_inputs.get(0, "vif_name").text(),
	    xa_inputs.get(1, "propagation_delay").uint32());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/set_vif_propagation_delay", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_reset_vif_propagation_delay(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/reset_vif_propagation_delay");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = pim_0_1_reset_vif_propagation_delay(
	    xa_inputs.get(0, "vif_name").text());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/reset_vif_propagation_delay", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_get_vif_override_interval(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/get_vif_override_interval");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t override_interval;
    try {
	XrlCmdError e = pim_0_1_get_vif_override_interval(
	    xa_inputs.get(0, "vif_name").text(),
	    override_interval);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/get_vif_override_interval", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("override_interval", override_interval);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_set_vif_override_interval(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(2), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/set_vif_override_interval");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = pim_0_1_set_vif_override_interval(
	    xa_inputs.get(0, "vif_name").text(),
	    xa_inputs.get(1, "override_interval").uint32());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/set_vif_override_interval", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_reset_vif_override_interval(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/reset_vif_override_interval");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = pim_0_1_reset_vif_override_interval(
	    xa_inputs.get(0, "vif_name").text());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/reset_vif_override_interval", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_get_vif_is_tracking_support_disabled(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/get_vif_is_tracking_support_disabled");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    bool is_tracking_support_disabled;
    try {
	XrlCmdError e = pim_0_1_get_vif_is_tracking_support_disabled(
	    xa_inputs.get(0, "vif_name").text(),
	    is_tracking_support_disabled);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/get_vif_is_tracking_support_disabled", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("is_tracking_support_disabled", is_tracking_support_disabled);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_set_vif_is_tracking_support_disabled(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(2), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/set_vif_is_tracking_support_disabled");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = pim_0_1_set_vif_is_tracking_support_disabled(
	    xa_inputs.get(0, "vif_name").text(),
	    xa_inputs.get(1, "is_tracking_support_disabled").boolean());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/set_vif_is_tracking_support_disabled", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_reset_vif_is_tracking_support_disabled(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/reset_vif_is_tracking_support_disabled");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = pim_0_1_reset_vif_is_tracking_support_disabled(
	    xa_inputs.get(0, "vif_name").text());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/reset_vif_is_tracking_support_disabled", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_get_vif_accept_nohello_neighbors(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/get_vif_accept_nohello_neighbors");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    bool accept_nohello_neighbors;
    try {
	XrlCmdError e = pim_0_1_get_vif_accept_nohello_neighbors(
	    xa_inputs.get(0, "vif_name").text(),
	    accept_nohello_neighbors);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/get_vif_accept_nohello_neighbors", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("accept_nohello_neighbors", accept_nohello_neighbors);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_set_vif_accept_nohello_neighbors(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(2), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/set_vif_accept_nohello_neighbors");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = pim_0_1_set_vif_accept_nohello_neighbors(
	    xa_inputs.get(0, "vif_name").text(),
	    xa_inputs.get(1, "accept_nohello_neighbors").boolean());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/set_vif_accept_nohello_neighbors", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_reset_vif_accept_nohello_neighbors(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/reset_vif_accept_nohello_neighbors");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = pim_0_1_reset_vif_accept_nohello_neighbors(
	    xa_inputs.get(0, "vif_name").text());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/reset_vif_accept_nohello_neighbors", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_get_vif_join_prune_period(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/get_vif_join_prune_period");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t join_prune_period;
    try {
	XrlCmdError e = pim_0_1_get_vif_join_prune_period(
	    xa_inputs.get(0, "vif_name").text(),
	    join_prune_period);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/get_vif_join_prune_period", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("join_prune_period", join_prune_period);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_set_vif_join_prune_period(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(2), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/set_vif_join_prune_period");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = pim_0_1_set_vif_join_prune_period(
	    xa_inputs.get(0, "vif_name").text(),
	    xa_inputs.get(1, "join_prune_period").uint32());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/set_vif_join_prune_period", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_reset_vif_join_prune_period(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/reset_vif_join_prune_period");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = pim_0_1_reset_vif_join_prune_period(
	    xa_inputs.get(0, "vif_name").text());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/reset_vif_join_prune_period", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_get_switch_to_spt_threshold(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/get_switch_to_spt_threshold");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    bool is_enabled;
    uint32_t interval_sec;
    uint32_t bytes;
    try {
	XrlCmdError e = pim_0_1_get_switch_to_spt_threshold(
	    is_enabled,
	    interval_sec,
	    bytes);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/get_switch_to_spt_threshold", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("is_enabled", is_enabled);
	pxa_outputs->add("interval_sec", interval_sec);
	pxa_outputs->add("bytes", bytes);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_set_switch_to_spt_threshold(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(3), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/set_switch_to_spt_threshold");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = pim_0_1_set_switch_to_spt_threshold(
	    xa_inputs.get(0, "is_enabled").boolean(),
	    xa_inputs.get(1, "interval_sec").uint32(),
	    xa_inputs.get(2, "bytes").uint32());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/set_switch_to_spt_threshold", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_reset_switch_to_spt_threshold(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/reset_switch_to_spt_threshold");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = pim_0_1_reset_switch_to_spt_threshold();
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/reset_switch_to_spt_threshold", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_add_alternative_subnet4(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(2), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/add_alternative_subnet4");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = pim_0_1_add_alternative_subnet4(
	    xa_inputs.get(0, "vif_name").text(),
	    xa_inputs.get(1, "subnet").ipv4net());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/add_alternative_subnet4", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_add_alternative_subnet6(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(2), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/add_alternative_subnet6");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = pim_0_1_add_alternative_subnet6(
	    xa_inputs.get(0, "vif_name").text(),
	    xa_inputs.get(1, "subnet").ipv6net());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/add_alternative_subnet6", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_delete_alternative_subnet4(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(2), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/delete_alternative_subnet4");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = pim_0_1_delete_alternative_subnet4(
	    xa_inputs.get(0, "vif_name").text(),
	    xa_inputs.get(1, "subnet").ipv4net());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/delete_alternative_subnet4", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_delete_alternative_subnet6(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(2), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/delete_alternative_subnet6");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = pim_0_1_delete_alternative_subnet6(
	    xa_inputs.get(0, "vif_name").text(),
	    xa_inputs.get(1, "subnet").ipv6net());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/delete_alternative_subnet6", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_remove_all_alternative_subnets(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/remove_all_alternative_subnets");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = pim_0_1_remove_all_alternative_subnets(
	    xa_inputs.get(0, "vif_name").text());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/remove_all_alternative_subnets", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_log_trace_all(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/log_trace_all");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = pim_0_1_log_trace_all(
	    xa_inputs.get(0, "enable").boolean());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/log_trace_all", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_add_test_jp_entry4(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 7) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(7), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/add_test_jp_entry4");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = pim_0_1_add_test_jp_entry4(
	    xa_inputs.get(0, "source_addr").ipv4(),
	    xa_inputs.get(1, "group_addr").ipv4(),
	    xa_inputs.get(2, "group_mask_len").uint32(),
	    xa_inputs.get(3, "mrt_entry_type").text(),
	    xa_inputs.get(4, "action_jp").text(),
	    xa_inputs.get(5, "holdtime").uint32(),
	    xa_inputs.get(6, "is_new_group").boolean());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/add_test_jp_entry4", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_add_test_jp_entry6(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 7) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(7), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/add_test_jp_entry6");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = pim_0_1_add_test_jp_entry6(
	    xa_inputs.get(0, "source_addr").ipv6(),
	    xa_inputs.get(1, "group_addr").ipv6(),
	    xa_inputs.get(2, "group_mask_len").uint32(),
	    xa_inputs.get(3, "mrt_entry_type").text(),
	    xa_inputs.get(4, "action_jp").text(),
	    xa_inputs.get(5, "holdtime").uint32(),
	    xa_inputs.get(6, "is_new_group").boolean());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/add_test_jp_entry6", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_send_test_jp_entry4(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(2), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/send_test_jp_entry4");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = pim_0_1_send_test_jp_entry4(
	    xa_inputs.get(0, "vif_name").text(),
	    xa_inputs.get(1, "nbr_addr").ipv4());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/send_test_jp_entry4", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_send_test_jp_entry6(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(2), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/send_test_jp_entry6");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = pim_0_1_send_test_jp_entry6(
	    xa_inputs.get(0, "vif_name").text(),
	    xa_inputs.get(1, "nbr_addr").ipv6());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/send_test_jp_entry6", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_send_test_assert4(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 6) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(6), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/send_test_assert4");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = pim_0_1_send_test_assert4(
	    xa_inputs.get(0, "vif_name").text(),
	    xa_inputs.get(1, "source_addr").ipv4(),
	    xa_inputs.get(2, "group_addr").ipv4(),
	    xa_inputs.get(3, "rpt_bit").boolean(),
	    xa_inputs.get(4, "metric_preference").uint32(),
	    xa_inputs.get(5, "metric").uint32());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/send_test_assert4", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_send_test_assert6(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 6) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(6), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/send_test_assert6");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = pim_0_1_send_test_assert6(
	    xa_inputs.get(0, "vif_name").text(),
	    xa_inputs.get(1, "source_addr").ipv6(),
	    xa_inputs.get(2, "group_addr").ipv6(),
	    xa_inputs.get(3, "rpt_bit").boolean(),
	    xa_inputs.get(4, "metric_preference").uint32(),
	    xa_inputs.get(5, "metric").uint32());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/send_test_assert6", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_add_test_bsr_zone4(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 6) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(6), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/add_test_bsr_zone4");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = pim_0_1_add_test_bsr_zone4(
	    xa_inputs.get(0, "zone_id_scope_zone_prefix").ipv4net(),
	    xa_inputs.get(1, "zone_id_is_scope_zone").boolean(),
	    xa_inputs.get(2, "bsr_addr").ipv4(),
	    xa_inputs.get(3, "bsr_priority").uint32(),
	    xa_inputs.get(4, "hash_mask_len").uint32(),
	    xa_inputs.get(5, "fragment_tag").uint32());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/add_test_bsr_zone4", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_add_test_bsr_zone6(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 6) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(6), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/add_test_bsr_zone6");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = pim_0_1_add_test_bsr_zone6(
	    xa_inputs.get(0, "zone_id_scope_zone_prefix").ipv6net(),
	    xa_inputs.get(1, "zone_id_is_scope_zone").boolean(),
	    xa_inputs.get(2, "bsr_addr").ipv6(),
	    xa_inputs.get(3, "bsr_priority").uint32(),
	    xa_inputs.get(4, "hash_mask_len").uint32(),
	    xa_inputs.get(5, "fragment_tag").uint32());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/add_test_bsr_zone6", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_add_test_bsr_group_prefix4(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 5) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(5), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/add_test_bsr_group_prefix4");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = pim_0_1_add_test_bsr_group_prefix4(
	    xa_inputs.get(0, "zone_id_scope_zone_prefix").ipv4net(),
	    xa_inputs.get(1, "zone_id_is_scope_zone").boolean(),
	    xa_inputs.get(2, "group_prefix").ipv4net(),
	    xa_inputs.get(3, "is_scope_zone").boolean(),
	    xa_inputs.get(4, "expected_rp_count").uint32());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/add_test_bsr_group_prefix4", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_add_test_bsr_group_prefix6(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 5) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(5), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/add_test_bsr_group_prefix6");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = pim_0_1_add_test_bsr_group_prefix6(
	    xa_inputs.get(0, "zone_id_scope_zone_prefix").ipv6net(),
	    xa_inputs.get(1, "zone_id_is_scope_zone").boolean(),
	    xa_inputs.get(2, "group_prefix").ipv6net(),
	    xa_inputs.get(3, "is_scope_zone").boolean(),
	    xa_inputs.get(4, "expected_rp_count").uint32());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/add_test_bsr_group_prefix6", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_add_test_bsr_rp4(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 6) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(6), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/add_test_bsr_rp4");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = pim_0_1_add_test_bsr_rp4(
	    xa_inputs.get(0, "zone_id_scope_zone_prefix").ipv4net(),
	    xa_inputs.get(1, "zone_id_is_scope_zone").boolean(),
	    xa_inputs.get(2, "group_prefix").ipv4net(),
	    xa_inputs.get(3, "rp_addr").ipv4(),
	    xa_inputs.get(4, "rp_priority").uint32(),
	    xa_inputs.get(5, "rp_holdtime").uint32());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/add_test_bsr_rp4", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_add_test_bsr_rp6(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 6) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(6), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/add_test_bsr_rp6");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = pim_0_1_add_test_bsr_rp6(
	    xa_inputs.get(0, "zone_id_scope_zone_prefix").ipv6net(),
	    xa_inputs.get(1, "zone_id_is_scope_zone").boolean(),
	    xa_inputs.get(2, "group_prefix").ipv6net(),
	    xa_inputs.get(3, "rp_addr").ipv6(),
	    xa_inputs.get(4, "rp_priority").uint32(),
	    xa_inputs.get(5, "rp_holdtime").uint32());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/add_test_bsr_rp6", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_send_test_bootstrap(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/send_test_bootstrap");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = pim_0_1_send_test_bootstrap(
	    xa_inputs.get(0, "vif_name").text());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/send_test_bootstrap", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_send_test_bootstrap_by_dest4(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(2), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/send_test_bootstrap_by_dest4");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = pim_0_1_send_test_bootstrap_by_dest4(
	    xa_inputs.get(0, "vif_name").text(),
	    xa_inputs.get(1, "dest_addr").ipv4());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/send_test_bootstrap_by_dest4", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_send_test_bootstrap_by_dest6(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(2), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/send_test_bootstrap_by_dest6");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = pim_0_1_send_test_bootstrap_by_dest6(
	    xa_inputs.get(0, "vif_name").text(),
	    xa_inputs.get(1, "dest_addr").ipv6());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/send_test_bootstrap_by_dest6", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_send_test_cand_rp_adv(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/send_test_cand_rp_adv");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = pim_0_1_send_test_cand_rp_adv();
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/send_test_cand_rp_adv", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_pimstat_neighbors4(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/pimstat_neighbors4");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t nbrs_number;
    XrlAtomList vifs;
    XrlAtomList addresses;
    XrlAtomList pim_versions;
    XrlAtomList dr_priorities;
    XrlAtomList holdtimes;
    XrlAtomList timeouts;
    XrlAtomList uptimes;
    try {
	XrlCmdError e = pim_0_1_pimstat_neighbors4(
	    nbrs_number,
	    vifs,
	    addresses,
	    pim_versions,
	    dr_priorities,
	    holdtimes,
	    timeouts,
	    uptimes);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/pimstat_neighbors4", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("nbrs_number", nbrs_number);
	pxa_outputs->add("vifs", vifs);
	pxa_outputs->add("addresses", addresses);
	pxa_outputs->add("pim_versions", pim_versions);
	pxa_outputs->add("dr_priorities", dr_priorities);
	pxa_outputs->add("holdtimes", holdtimes);
	pxa_outputs->add("timeouts", timeouts);
	pxa_outputs->add("uptimes", uptimes);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_pimstat_neighbors6(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/pimstat_neighbors6");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t nbrs_number;
    XrlAtomList vifs;
    XrlAtomList addresses;
    XrlAtomList pim_versions;
    XrlAtomList dr_priorities;
    XrlAtomList holdtimes;
    XrlAtomList timeouts;
    XrlAtomList uptimes;
    try {
	XrlCmdError e = pim_0_1_pimstat_neighbors6(
	    nbrs_number,
	    vifs,
	    addresses,
	    pim_versions,
	    dr_priorities,
	    holdtimes,
	    timeouts,
	    uptimes);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/pimstat_neighbors6", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("nbrs_number", nbrs_number);
	pxa_outputs->add("vifs", vifs);
	pxa_outputs->add("addresses", addresses);
	pxa_outputs->add("pim_versions", pim_versions);
	pxa_outputs->add("dr_priorities", dr_priorities);
	pxa_outputs->add("holdtimes", holdtimes);
	pxa_outputs->add("timeouts", timeouts);
	pxa_outputs->add("uptimes", uptimes);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_pimstat_interface4(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/pimstat_interface4");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t pim_version;
    bool is_dr;
    uint32_t dr_priority;
    IPv4 dr_address;
    uint32_t pim_nbrs_number;
    try {
	XrlCmdError e = pim_0_1_pimstat_interface4(
	    xa_inputs.get(0, "vif_name").text(),
	    pim_version,
	    is_dr,
	    dr_priority,
	    dr_address,
	    pim_nbrs_number);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/pimstat_interface4", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("pim_version", pim_version);
	pxa_outputs->add("is_dr", is_dr);
	pxa_outputs->add("dr_priority", dr_priority);
	pxa_outputs->add("dr_address", dr_address);
	pxa_outputs->add("pim_nbrs_number", pim_nbrs_number);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_pimstat_interface6(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/pimstat_interface6");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t pim_version;
    bool is_dr;
    uint32_t dr_priority;
    IPv6 dr_address;
    uint32_t pim_nbrs_number;
    try {
	XrlCmdError e = pim_0_1_pimstat_interface6(
	    xa_inputs.get(0, "vif_name").text(),
	    pim_version,
	    is_dr,
	    dr_priority,
	    dr_address,
	    pim_nbrs_number);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/pimstat_interface6", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("pim_version", pim_version);
	pxa_outputs->add("is_dr", is_dr);
	pxa_outputs->add("dr_priority", dr_priority);
	pxa_outputs->add("dr_address", dr_address);
	pxa_outputs->add("pim_nbrs_number", pim_nbrs_number);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_pimstat_rps4(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/pimstat_rps4");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t rps_number;
    XrlAtomList addresses;
    XrlAtomList types;
    XrlAtomList priorities;
    XrlAtomList holdtimes;
    XrlAtomList timeouts;
    XrlAtomList group_prefixes;
    try {
	XrlCmdError e = pim_0_1_pimstat_rps4(
	    rps_number,
	    addresses,
	    types,
	    priorities,
	    holdtimes,
	    timeouts,
	    group_prefixes);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/pimstat_rps4", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("rps_number", rps_number);
	pxa_outputs->add("addresses", addresses);
	pxa_outputs->add("types", types);
	pxa_outputs->add("priorities", priorities);
	pxa_outputs->add("holdtimes", holdtimes);
	pxa_outputs->add("timeouts", timeouts);
	pxa_outputs->add("group_prefixes", group_prefixes);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_pimstat_rps6(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/pimstat_rps6");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t rps_number;
    XrlAtomList addresses;
    XrlAtomList types;
    XrlAtomList priorities;
    XrlAtomList holdtimes;
    XrlAtomList timeouts;
    XrlAtomList group_prefixes;
    try {
	XrlCmdError e = pim_0_1_pimstat_rps6(
	    rps_number,
	    addresses,
	    types,
	    priorities,
	    holdtimes,
	    timeouts,
	    group_prefixes);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/pimstat_rps6", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("rps_number", rps_number);
	pxa_outputs->add("addresses", addresses);
	pxa_outputs->add("types", types);
	pxa_outputs->add("priorities", priorities);
	pxa_outputs->add("holdtimes", holdtimes);
	pxa_outputs->add("timeouts", timeouts);
	pxa_outputs->add("group_prefixes", group_prefixes);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_clear_pim_statistics(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/clear_pim_statistics");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = pim_0_1_clear_pim_statistics();
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/clear_pim_statistics", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_clear_pim_statistics_per_vif(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/clear_pim_statistics_per_vif");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = pim_0_1_clear_pim_statistics_per_vif(
	    xa_inputs.get(0, "vif_name").text());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/clear_pim_statistics_per_vif", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_pimstat_hello_messages_received(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/pimstat_hello_messages_received");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t value;
    try {
	XrlCmdError e = pim_0_1_pimstat_hello_messages_received(
	    value);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/pimstat_hello_messages_received", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("value", value);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_pimstat_hello_messages_sent(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/pimstat_hello_messages_sent");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t value;
    try {
	XrlCmdError e = pim_0_1_pimstat_hello_messages_sent(
	    value);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/pimstat_hello_messages_sent", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("value", value);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_pimstat_hello_messages_rx_errors(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/pimstat_hello_messages_rx_errors");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t value;
    try {
	XrlCmdError e = pim_0_1_pimstat_hello_messages_rx_errors(
	    value);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/pimstat_hello_messages_rx_errors", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("value", value);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_pimstat_register_messages_received(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/pimstat_register_messages_received");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t value;
    try {
	XrlCmdError e = pim_0_1_pimstat_register_messages_received(
	    value);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/pimstat_register_messages_received", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("value", value);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_pimstat_register_messages_sent(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/pimstat_register_messages_sent");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t value;
    try {
	XrlCmdError e = pim_0_1_pimstat_register_messages_sent(
	    value);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/pimstat_register_messages_sent", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("value", value);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_pimstat_register_messages_rx_errors(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/pimstat_register_messages_rx_errors");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t value;
    try {
	XrlCmdError e = pim_0_1_pimstat_register_messages_rx_errors(
	    value);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/pimstat_register_messages_rx_errors", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("value", value);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_pimstat_register_stop_messages_received(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/pimstat_register_stop_messages_received");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t value;
    try {
	XrlCmdError e = pim_0_1_pimstat_register_stop_messages_received(
	    value);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/pimstat_register_stop_messages_received", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("value", value);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_pimstat_register_stop_messages_sent(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/pimstat_register_stop_messages_sent");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t value;
    try {
	XrlCmdError e = pim_0_1_pimstat_register_stop_messages_sent(
	    value);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/pimstat_register_stop_messages_sent", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("value", value);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_pimstat_register_stop_messages_rx_errors(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/pimstat_register_stop_messages_rx_errors");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t value;
    try {
	XrlCmdError e = pim_0_1_pimstat_register_stop_messages_rx_errors(
	    value);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/pimstat_register_stop_messages_rx_errors", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("value", value);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_pimstat_join_prune_messages_received(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/pimstat_join_prune_messages_received");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t value;
    try {
	XrlCmdError e = pim_0_1_pimstat_join_prune_messages_received(
	    value);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/pimstat_join_prune_messages_received", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("value", value);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_pimstat_join_prune_messages_sent(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/pimstat_join_prune_messages_sent");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t value;
    try {
	XrlCmdError e = pim_0_1_pimstat_join_prune_messages_sent(
	    value);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/pimstat_join_prune_messages_sent", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("value", value);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_pimstat_join_prune_messages_rx_errors(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/pimstat_join_prune_messages_rx_errors");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t value;
    try {
	XrlCmdError e = pim_0_1_pimstat_join_prune_messages_rx_errors(
	    value);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/pimstat_join_prune_messages_rx_errors", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("value", value);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_pimstat_bootstrap_messages_received(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/pimstat_bootstrap_messages_received");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t value;
    try {
	XrlCmdError e = pim_0_1_pimstat_bootstrap_messages_received(
	    value);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/pimstat_bootstrap_messages_received", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("value", value);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_pimstat_bootstrap_messages_sent(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/pimstat_bootstrap_messages_sent");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t value;
    try {
	XrlCmdError e = pim_0_1_pimstat_bootstrap_messages_sent(
	    value);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/pimstat_bootstrap_messages_sent", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("value", value);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_pimstat_bootstrap_messages_rx_errors(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/pimstat_bootstrap_messages_rx_errors");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t value;
    try {
	XrlCmdError e = pim_0_1_pimstat_bootstrap_messages_rx_errors(
	    value);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/pimstat_bootstrap_messages_rx_errors", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("value", value);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_pimstat_assert_messages_received(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/pimstat_assert_messages_received");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t value;
    try {
	XrlCmdError e = pim_0_1_pimstat_assert_messages_received(
	    value);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/pimstat_assert_messages_received", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("value", value);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_pimstat_assert_messages_sent(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/pimstat_assert_messages_sent");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t value;
    try {
	XrlCmdError e = pim_0_1_pimstat_assert_messages_sent(
	    value);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/pimstat_assert_messages_sent", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("value", value);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_pimstat_assert_messages_rx_errors(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/pimstat_assert_messages_rx_errors");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t value;
    try {
	XrlCmdError e = pim_0_1_pimstat_assert_messages_rx_errors(
	    value);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/pimstat_assert_messages_rx_errors", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("value", value);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_pimstat_graft_messages_received(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/pimstat_graft_messages_received");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t value;
    try {
	XrlCmdError e = pim_0_1_pimstat_graft_messages_received(
	    value);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/pimstat_graft_messages_received", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("value", value);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_pimstat_graft_messages_sent(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/pimstat_graft_messages_sent");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t value;
    try {
	XrlCmdError e = pim_0_1_pimstat_graft_messages_sent(
	    value);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/pimstat_graft_messages_sent", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("value", value);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_pimstat_graft_messages_rx_errors(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/pimstat_graft_messages_rx_errors");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t value;
    try {
	XrlCmdError e = pim_0_1_pimstat_graft_messages_rx_errors(
	    value);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/pimstat_graft_messages_rx_errors", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("value", value);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_pimstat_graft_ack_messages_received(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/pimstat_graft_ack_messages_received");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t value;
    try {
	XrlCmdError e = pim_0_1_pimstat_graft_ack_messages_received(
	    value);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/pimstat_graft_ack_messages_received", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("value", value);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_pimstat_graft_ack_messages_sent(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/pimstat_graft_ack_messages_sent");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t value;
    try {
	XrlCmdError e = pim_0_1_pimstat_graft_ack_messages_sent(
	    value);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/pimstat_graft_ack_messages_sent", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("value", value);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_pimstat_graft_ack_messages_rx_errors(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/pimstat_graft_ack_messages_rx_errors");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t value;
    try {
	XrlCmdError e = pim_0_1_pimstat_graft_ack_messages_rx_errors(
	    value);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/pimstat_graft_ack_messages_rx_errors", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("value", value);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_pimstat_candidate_rp_messages_received(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/pimstat_candidate_rp_messages_received");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t value;
    try {
	XrlCmdError e = pim_0_1_pimstat_candidate_rp_messages_received(
	    value);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/pimstat_candidate_rp_messages_received", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("value", value);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_pimstat_candidate_rp_messages_sent(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/pimstat_candidate_rp_messages_sent");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t value;
    try {
	XrlCmdError e = pim_0_1_pimstat_candidate_rp_messages_sent(
	    value);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/pimstat_candidate_rp_messages_sent", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("value", value);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_pimstat_candidate_rp_messages_rx_errors(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/pimstat_candidate_rp_messages_rx_errors");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t value;
    try {
	XrlCmdError e = pim_0_1_pimstat_candidate_rp_messages_rx_errors(
	    value);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/pimstat_candidate_rp_messages_rx_errors", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("value", value);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_pimstat_unknown_type_messages(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/pimstat_unknown_type_messages");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t value;
    try {
	XrlCmdError e = pim_0_1_pimstat_unknown_type_messages(
	    value);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/pimstat_unknown_type_messages", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("value", value);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_pimstat_unknown_version_messages(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/pimstat_unknown_version_messages");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t value;
    try {
	XrlCmdError e = pim_0_1_pimstat_unknown_version_messages(
	    value);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/pimstat_unknown_version_messages", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("value", value);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_pimstat_neighbor_unknown_messages(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/pimstat_neighbor_unknown_messages");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t value;
    try {
	XrlCmdError e = pim_0_1_pimstat_neighbor_unknown_messages(
	    value);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/pimstat_neighbor_unknown_messages", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("value", value);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_pimstat_bad_length_messages(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/pimstat_bad_length_messages");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t value;
    try {
	XrlCmdError e = pim_0_1_pimstat_bad_length_messages(
	    value);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/pimstat_bad_length_messages", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("value", value);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_pimstat_bad_checksum_messages(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/pimstat_bad_checksum_messages");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t value;
    try {
	XrlCmdError e = pim_0_1_pimstat_bad_checksum_messages(
	    value);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/pimstat_bad_checksum_messages", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("value", value);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_pimstat_bad_receive_interface_messages(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/pimstat_bad_receive_interface_messages");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t value;
    try {
	XrlCmdError e = pim_0_1_pimstat_bad_receive_interface_messages(
	    value);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/pimstat_bad_receive_interface_messages", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("value", value);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_pimstat_rx_interface_disabled_messages(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/pimstat_rx_interface_disabled_messages");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t value;
    try {
	XrlCmdError e = pim_0_1_pimstat_rx_interface_disabled_messages(
	    value);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/pimstat_rx_interface_disabled_messages", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("value", value);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_pimstat_rx_register_not_rp(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/pimstat_rx_register_not_rp");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t value;
    try {
	XrlCmdError e = pim_0_1_pimstat_rx_register_not_rp(
	    value);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/pimstat_rx_register_not_rp", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("value", value);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_pimstat_rp_filtered_source(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/pimstat_rp_filtered_source");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t value;
    try {
	XrlCmdError e = pim_0_1_pimstat_rp_filtered_source(
	    value);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/pimstat_rp_filtered_source", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("value", value);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_pimstat_unknown_register_stop(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/pimstat_unknown_register_stop");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t value;
    try {
	XrlCmdError e = pim_0_1_pimstat_unknown_register_stop(
	    value);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/pimstat_unknown_register_stop", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("value", value);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_pimstat_rx_join_prune_no_state(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/pimstat_rx_join_prune_no_state");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t value;
    try {
	XrlCmdError e = pim_0_1_pimstat_rx_join_prune_no_state(
	    value);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/pimstat_rx_join_prune_no_state", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("value", value);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_pimstat_rx_graft_graft_ack_no_state(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/pimstat_rx_graft_graft_ack_no_state");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t value;
    try {
	XrlCmdError e = pim_0_1_pimstat_rx_graft_graft_ack_no_state(
	    value);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/pimstat_rx_graft_graft_ack_no_state", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("value", value);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_pimstat_rx_graft_on_upstream_interface(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/pimstat_rx_graft_on_upstream_interface");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t value;
    try {
	XrlCmdError e = pim_0_1_pimstat_rx_graft_on_upstream_interface(
	    value);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/pimstat_rx_graft_on_upstream_interface", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("value", value);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_pimstat_rx_candidate_rp_not_bsr(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/pimstat_rx_candidate_rp_not_bsr");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t value;
    try {
	XrlCmdError e = pim_0_1_pimstat_rx_candidate_rp_not_bsr(
	    value);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/pimstat_rx_candidate_rp_not_bsr", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("value", value);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_pimstat_rx_bsr_when_bsr(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/pimstat_rx_bsr_when_bsr");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t value;
    try {
	XrlCmdError e = pim_0_1_pimstat_rx_bsr_when_bsr(
	    value);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/pimstat_rx_bsr_when_bsr", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("value", value);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_pimstat_rx_bsr_not_rpf_interface(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/pimstat_rx_bsr_not_rpf_interface");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t value;
    try {
	XrlCmdError e = pim_0_1_pimstat_rx_bsr_not_rpf_interface(
	    value);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/pimstat_rx_bsr_not_rpf_interface", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("value", value);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_pimstat_rx_unknown_hello_option(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/pimstat_rx_unknown_hello_option");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t value;
    try {
	XrlCmdError e = pim_0_1_pimstat_rx_unknown_hello_option(
	    value);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/pimstat_rx_unknown_hello_option", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("value", value);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_pimstat_rx_data_no_state(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/pimstat_rx_data_no_state");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t value;
    try {
	XrlCmdError e = pim_0_1_pimstat_rx_data_no_state(
	    value);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/pimstat_rx_data_no_state", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("value", value);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_pimstat_rx_rp_no_state(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/pimstat_rx_rp_no_state");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t value;
    try {
	XrlCmdError e = pim_0_1_pimstat_rx_rp_no_state(
	    value);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/pimstat_rx_rp_no_state", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("value", value);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_pimstat_rx_aggregate(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/pimstat_rx_aggregate");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t value;
    try {
	XrlCmdError e = pim_0_1_pimstat_rx_aggregate(
	    value);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/pimstat_rx_aggregate", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("value", value);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_pimstat_rx_malformed_packet(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/pimstat_rx_malformed_packet");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t value;
    try {
	XrlCmdError e = pim_0_1_pimstat_rx_malformed_packet(
	    value);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/pimstat_rx_malformed_packet", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("value", value);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_pimstat_no_rp(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/pimstat_no_rp");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t value;
    try {
	XrlCmdError e = pim_0_1_pimstat_no_rp(
	    value);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/pimstat_no_rp", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("value", value);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_pimstat_no_route_upstream(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/pimstat_no_route_upstream");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t value;
    try {
	XrlCmdError e = pim_0_1_pimstat_no_route_upstream(
	    value);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/pimstat_no_route_upstream", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("value", value);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_pimstat_rp_mismatch(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/pimstat_rp_mismatch");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t value;
    try {
	XrlCmdError e = pim_0_1_pimstat_rp_mismatch(
	    value);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/pimstat_rp_mismatch", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("value", value);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_pimstat_rpf_neighbor_unknown(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/pimstat_rpf_neighbor_unknown");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t value;
    try {
	XrlCmdError e = pim_0_1_pimstat_rpf_neighbor_unknown(
	    value);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/pimstat_rpf_neighbor_unknown", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("value", value);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_pimstat_rx_join_rp(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/pimstat_rx_join_rp");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t value;
    try {
	XrlCmdError e = pim_0_1_pimstat_rx_join_rp(
	    value);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/pimstat_rx_join_rp", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("value", value);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_pimstat_rx_prune_rp(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/pimstat_rx_prune_rp");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t value;
    try {
	XrlCmdError e = pim_0_1_pimstat_rx_prune_rp(
	    value);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/pimstat_rx_prune_rp", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("value", value);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_pimstat_rx_join_wc(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/pimstat_rx_join_wc");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t value;
    try {
	XrlCmdError e = pim_0_1_pimstat_rx_join_wc(
	    value);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/pimstat_rx_join_wc", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("value", value);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_pimstat_rx_prune_wc(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/pimstat_rx_prune_wc");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t value;
    try {
	XrlCmdError e = pim_0_1_pimstat_rx_prune_wc(
	    value);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/pimstat_rx_prune_wc", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("value", value);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_pimstat_rx_join_sg(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/pimstat_rx_join_sg");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t value;
    try {
	XrlCmdError e = pim_0_1_pimstat_rx_join_sg(
	    value);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/pimstat_rx_join_sg", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("value", value);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_pimstat_rx_prune_sg(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/pimstat_rx_prune_sg");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t value;
    try {
	XrlCmdError e = pim_0_1_pimstat_rx_prune_sg(
	    value);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/pimstat_rx_prune_sg", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("value", value);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_pimstat_rx_join_sg_rpt(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/pimstat_rx_join_sg_rpt");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t value;
    try {
	XrlCmdError e = pim_0_1_pimstat_rx_join_sg_rpt(
	    value);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/pimstat_rx_join_sg_rpt", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("value", value);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_pimstat_rx_prune_sg_rpt(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/pimstat_rx_prune_sg_rpt");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t value;
    try {
	XrlCmdError e = pim_0_1_pimstat_rx_prune_sg_rpt(
	    value);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/pimstat_rx_prune_sg_rpt", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("value", value);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_pimstat_hello_messages_received_per_vif(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/pimstat_hello_messages_received_per_vif");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t value;
    try {
	XrlCmdError e = pim_0_1_pimstat_hello_messages_received_per_vif(
	    xa_inputs.get(0, "vif_name").text(),
	    value);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/pimstat_hello_messages_received_per_vif", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("value", value);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_pimstat_hello_messages_sent_per_vif(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/pimstat_hello_messages_sent_per_vif");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t value;
    try {
	XrlCmdError e = pim_0_1_pimstat_hello_messages_sent_per_vif(
	    xa_inputs.get(0, "vif_name").text(),
	    value);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/pimstat_hello_messages_sent_per_vif", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("value", value);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_pimstat_hello_messages_rx_errors_per_vif(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/pimstat_hello_messages_rx_errors_per_vif");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t value;
    try {
	XrlCmdError e = pim_0_1_pimstat_hello_messages_rx_errors_per_vif(
	    xa_inputs.get(0, "vif_name").text(),
	    value);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/pimstat_hello_messages_rx_errors_per_vif", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("value", value);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_pimstat_register_messages_received_per_vif(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/pimstat_register_messages_received_per_vif");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t value;
    try {
	XrlCmdError e = pim_0_1_pimstat_register_messages_received_per_vif(
	    xa_inputs.get(0, "vif_name").text(),
	    value);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/pimstat_register_messages_received_per_vif", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("value", value);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_pimstat_register_messages_sent_per_vif(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/pimstat_register_messages_sent_per_vif");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t value;
    try {
	XrlCmdError e = pim_0_1_pimstat_register_messages_sent_per_vif(
	    xa_inputs.get(0, "vif_name").text(),
	    value);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/pimstat_register_messages_sent_per_vif", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("value", value);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_pimstat_register_messages_rx_errors_per_vif(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/pimstat_register_messages_rx_errors_per_vif");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t value;
    try {
	XrlCmdError e = pim_0_1_pimstat_register_messages_rx_errors_per_vif(
	    xa_inputs.get(0, "vif_name").text(),
	    value);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/pimstat_register_messages_rx_errors_per_vif", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("value", value);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_pimstat_register_stop_messages_received_per_vif(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/pimstat_register_stop_messages_received_per_vif");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t value;
    try {
	XrlCmdError e = pim_0_1_pimstat_register_stop_messages_received_per_vif(
	    xa_inputs.get(0, "vif_name").text(),
	    value);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/pimstat_register_stop_messages_received_per_vif", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("value", value);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_pimstat_register_stop_messages_sent_per_vif(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/pimstat_register_stop_messages_sent_per_vif");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t value;
    try {
	XrlCmdError e = pim_0_1_pimstat_register_stop_messages_sent_per_vif(
	    xa_inputs.get(0, "vif_name").text(),
	    value);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/pimstat_register_stop_messages_sent_per_vif", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("value", value);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_pimstat_register_stop_messages_rx_errors_per_vif(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/pimstat_register_stop_messages_rx_errors_per_vif");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t value;
    try {
	XrlCmdError e = pim_0_1_pimstat_register_stop_messages_rx_errors_per_vif(
	    xa_inputs.get(0, "vif_name").text(),
	    value);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/pimstat_register_stop_messages_rx_errors_per_vif", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("value", value);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_pimstat_join_prune_messages_received_per_vif(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/pimstat_join_prune_messages_received_per_vif");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t value;
    try {
	XrlCmdError e = pim_0_1_pimstat_join_prune_messages_received_per_vif(
	    xa_inputs.get(0, "vif_name").text(),
	    value);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/pimstat_join_prune_messages_received_per_vif", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("value", value);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_pimstat_join_prune_messages_sent_per_vif(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/pimstat_join_prune_messages_sent_per_vif");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t value;
    try {
	XrlCmdError e = pim_0_1_pimstat_join_prune_messages_sent_per_vif(
	    xa_inputs.get(0, "vif_name").text(),
	    value);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/pimstat_join_prune_messages_sent_per_vif", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("value", value);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_pimstat_join_prune_messages_rx_errors_per_vif(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/pimstat_join_prune_messages_rx_errors_per_vif");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t value;
    try {
	XrlCmdError e = pim_0_1_pimstat_join_prune_messages_rx_errors_per_vif(
	    xa_inputs.get(0, "vif_name").text(),
	    value);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/pimstat_join_prune_messages_rx_errors_per_vif", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("value", value);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_pimstat_bootstrap_messages_received_per_vif(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/pimstat_bootstrap_messages_received_per_vif");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t value;
    try {
	XrlCmdError e = pim_0_1_pimstat_bootstrap_messages_received_per_vif(
	    xa_inputs.get(0, "vif_name").text(),
	    value);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/pimstat_bootstrap_messages_received_per_vif", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("value", value);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_pimstat_bootstrap_messages_sent_per_vif(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/pimstat_bootstrap_messages_sent_per_vif");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t value;
    try {
	XrlCmdError e = pim_0_1_pimstat_bootstrap_messages_sent_per_vif(
	    xa_inputs.get(0, "vif_name").text(),
	    value);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/pimstat_bootstrap_messages_sent_per_vif", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("value", value);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_pimstat_bootstrap_messages_rx_errors_per_vif(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/pimstat_bootstrap_messages_rx_errors_per_vif");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t value;
    try {
	XrlCmdError e = pim_0_1_pimstat_bootstrap_messages_rx_errors_per_vif(
	    xa_inputs.get(0, "vif_name").text(),
	    value);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/pimstat_bootstrap_messages_rx_errors_per_vif", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("value", value);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_pimstat_assert_messages_received_per_vif(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/pimstat_assert_messages_received_per_vif");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t value;
    try {
	XrlCmdError e = pim_0_1_pimstat_assert_messages_received_per_vif(
	    xa_inputs.get(0, "vif_name").text(),
	    value);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/pimstat_assert_messages_received_per_vif", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("value", value);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_pimstat_assert_messages_sent_per_vif(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/pimstat_assert_messages_sent_per_vif");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t value;
    try {
	XrlCmdError e = pim_0_1_pimstat_assert_messages_sent_per_vif(
	    xa_inputs.get(0, "vif_name").text(),
	    value);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/pimstat_assert_messages_sent_per_vif", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("value", value);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_pimstat_assert_messages_rx_errors_per_vif(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/pimstat_assert_messages_rx_errors_per_vif");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t value;
    try {
	XrlCmdError e = pim_0_1_pimstat_assert_messages_rx_errors_per_vif(
	    xa_inputs.get(0, "vif_name").text(),
	    value);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/pimstat_assert_messages_rx_errors_per_vif", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("value", value);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_pimstat_graft_messages_received_per_vif(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/pimstat_graft_messages_received_per_vif");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t value;
    try {
	XrlCmdError e = pim_0_1_pimstat_graft_messages_received_per_vif(
	    xa_inputs.get(0, "vif_name").text(),
	    value);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/pimstat_graft_messages_received_per_vif", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("value", value);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_pimstat_graft_messages_sent_per_vif(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/pimstat_graft_messages_sent_per_vif");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t value;
    try {
	XrlCmdError e = pim_0_1_pimstat_graft_messages_sent_per_vif(
	    xa_inputs.get(0, "vif_name").text(),
	    value);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/pimstat_graft_messages_sent_per_vif", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("value", value);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_pimstat_graft_messages_rx_errors_per_vif(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/pimstat_graft_messages_rx_errors_per_vif");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t value;
    try {
	XrlCmdError e = pim_0_1_pimstat_graft_messages_rx_errors_per_vif(
	    xa_inputs.get(0, "vif_name").text(),
	    value);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/pimstat_graft_messages_rx_errors_per_vif", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("value", value);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_pimstat_graft_ack_messages_received_per_vif(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/pimstat_graft_ack_messages_received_per_vif");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t value;
    try {
	XrlCmdError e = pim_0_1_pimstat_graft_ack_messages_received_per_vif(
	    xa_inputs.get(0, "vif_name").text(),
	    value);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/pimstat_graft_ack_messages_received_per_vif", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("value", value);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_pimstat_graft_ack_messages_sent_per_vif(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/pimstat_graft_ack_messages_sent_per_vif");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t value;
    try {
	XrlCmdError e = pim_0_1_pimstat_graft_ack_messages_sent_per_vif(
	    xa_inputs.get(0, "vif_name").text(),
	    value);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/pimstat_graft_ack_messages_sent_per_vif", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("value", value);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_pimstat_graft_ack_messages_rx_errors_per_vif(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/pimstat_graft_ack_messages_rx_errors_per_vif");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t value;
    try {
	XrlCmdError e = pim_0_1_pimstat_graft_ack_messages_rx_errors_per_vif(
	    xa_inputs.get(0, "vif_name").text(),
	    value);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/pimstat_graft_ack_messages_rx_errors_per_vif", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("value", value);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_pimstat_candidate_rp_messages_received_per_vif(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/pimstat_candidate_rp_messages_received_per_vif");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t value;
    try {
	XrlCmdError e = pim_0_1_pimstat_candidate_rp_messages_received_per_vif(
	    xa_inputs.get(0, "vif_name").text(),
	    value);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/pimstat_candidate_rp_messages_received_per_vif", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("value", value);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_pimstat_candidate_rp_messages_sent_per_vif(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/pimstat_candidate_rp_messages_sent_per_vif");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t value;
    try {
	XrlCmdError e = pim_0_1_pimstat_candidate_rp_messages_sent_per_vif(
	    xa_inputs.get(0, "vif_name").text(),
	    value);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/pimstat_candidate_rp_messages_sent_per_vif", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("value", value);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_pimstat_candidate_rp_messages_rx_errors_per_vif(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/pimstat_candidate_rp_messages_rx_errors_per_vif");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t value;
    try {
	XrlCmdError e = pim_0_1_pimstat_candidate_rp_messages_rx_errors_per_vif(
	    xa_inputs.get(0, "vif_name").text(),
	    value);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/pimstat_candidate_rp_messages_rx_errors_per_vif", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("value", value);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_pimstat_unknown_type_messages_per_vif(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/pimstat_unknown_type_messages_per_vif");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t value;
    try {
	XrlCmdError e = pim_0_1_pimstat_unknown_type_messages_per_vif(
	    xa_inputs.get(0, "vif_name").text(),
	    value);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/pimstat_unknown_type_messages_per_vif", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("value", value);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_pimstat_unknown_version_messages_per_vif(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/pimstat_unknown_version_messages_per_vif");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t value;
    try {
	XrlCmdError e = pim_0_1_pimstat_unknown_version_messages_per_vif(
	    xa_inputs.get(0, "vif_name").text(),
	    value);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/pimstat_unknown_version_messages_per_vif", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("value", value);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_pimstat_neighbor_unknown_messages_per_vif(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/pimstat_neighbor_unknown_messages_per_vif");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t value;
    try {
	XrlCmdError e = pim_0_1_pimstat_neighbor_unknown_messages_per_vif(
	    xa_inputs.get(0, "vif_name").text(),
	    value);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/pimstat_neighbor_unknown_messages_per_vif", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("value", value);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_pimstat_bad_length_messages_per_vif(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/pimstat_bad_length_messages_per_vif");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t value;
    try {
	XrlCmdError e = pim_0_1_pimstat_bad_length_messages_per_vif(
	    xa_inputs.get(0, "vif_name").text(),
	    value);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/pimstat_bad_length_messages_per_vif", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("value", value);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_pimstat_bad_checksum_messages_per_vif(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/pimstat_bad_checksum_messages_per_vif");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t value;
    try {
	XrlCmdError e = pim_0_1_pimstat_bad_checksum_messages_per_vif(
	    xa_inputs.get(0, "vif_name").text(),
	    value);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/pimstat_bad_checksum_messages_per_vif", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("value", value);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_pimstat_bad_receive_interface_messages_per_vif(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/pimstat_bad_receive_interface_messages_per_vif");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t value;
    try {
	XrlCmdError e = pim_0_1_pimstat_bad_receive_interface_messages_per_vif(
	    xa_inputs.get(0, "vif_name").text(),
	    value);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/pimstat_bad_receive_interface_messages_per_vif", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("value", value);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_pimstat_rx_interface_disabled_messages_per_vif(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/pimstat_rx_interface_disabled_messages_per_vif");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t value;
    try {
	XrlCmdError e = pim_0_1_pimstat_rx_interface_disabled_messages_per_vif(
	    xa_inputs.get(0, "vif_name").text(),
	    value);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/pimstat_rx_interface_disabled_messages_per_vif", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("value", value);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_pimstat_rx_register_not_rp_per_vif(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/pimstat_rx_register_not_rp_per_vif");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t value;
    try {
	XrlCmdError e = pim_0_1_pimstat_rx_register_not_rp_per_vif(
	    xa_inputs.get(0, "vif_name").text(),
	    value);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/pimstat_rx_register_not_rp_per_vif", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("value", value);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_pimstat_rp_filtered_source_per_vif(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/pimstat_rp_filtered_source_per_vif");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t value;
    try {
	XrlCmdError e = pim_0_1_pimstat_rp_filtered_source_per_vif(
	    xa_inputs.get(0, "vif_name").text(),
	    value);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/pimstat_rp_filtered_source_per_vif", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("value", value);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_pimstat_unknown_register_stop_per_vif(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/pimstat_unknown_register_stop_per_vif");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t value;
    try {
	XrlCmdError e = pim_0_1_pimstat_unknown_register_stop_per_vif(
	    xa_inputs.get(0, "vif_name").text(),
	    value);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/pimstat_unknown_register_stop_per_vif", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("value", value);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_pimstat_rx_join_prune_no_state_per_vif(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/pimstat_rx_join_prune_no_state_per_vif");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t value;
    try {
	XrlCmdError e = pim_0_1_pimstat_rx_join_prune_no_state_per_vif(
	    xa_inputs.get(0, "vif_name").text(),
	    value);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/pimstat_rx_join_prune_no_state_per_vif", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("value", value);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_pimstat_rx_graft_graft_ack_no_state_per_vif(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/pimstat_rx_graft_graft_ack_no_state_per_vif");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t value;
    try {
	XrlCmdError e = pim_0_1_pimstat_rx_graft_graft_ack_no_state_per_vif(
	    xa_inputs.get(0, "vif_name").text(),
	    value);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/pimstat_rx_graft_graft_ack_no_state_per_vif", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("value", value);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_pimstat_rx_graft_on_upstream_interface_per_vif(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/pimstat_rx_graft_on_upstream_interface_per_vif");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t value;
    try {
	XrlCmdError e = pim_0_1_pimstat_rx_graft_on_upstream_interface_per_vif(
	    xa_inputs.get(0, "vif_name").text(),
	    value);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/pimstat_rx_graft_on_upstream_interface_per_vif", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("value", value);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_pimstat_rx_candidate_rp_not_bsr_per_vif(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/pimstat_rx_candidate_rp_not_bsr_per_vif");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t value;
    try {
	XrlCmdError e = pim_0_1_pimstat_rx_candidate_rp_not_bsr_per_vif(
	    xa_inputs.get(0, "vif_name").text(),
	    value);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/pimstat_rx_candidate_rp_not_bsr_per_vif", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("value", value);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_pimstat_rx_bsr_when_bsr_per_vif(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/pimstat_rx_bsr_when_bsr_per_vif");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t value;
    try {
	XrlCmdError e = pim_0_1_pimstat_rx_bsr_when_bsr_per_vif(
	    xa_inputs.get(0, "vif_name").text(),
	    value);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/pimstat_rx_bsr_when_bsr_per_vif", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("value", value);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_pimstat_rx_bsr_not_rpf_interface_per_vif(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/pimstat_rx_bsr_not_rpf_interface_per_vif");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t value;
    try {
	XrlCmdError e = pim_0_1_pimstat_rx_bsr_not_rpf_interface_per_vif(
	    xa_inputs.get(0, "vif_name").text(),
	    value);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/pimstat_rx_bsr_not_rpf_interface_per_vif", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("value", value);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_pimstat_rx_unknown_hello_option_per_vif(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/pimstat_rx_unknown_hello_option_per_vif");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t value;
    try {
	XrlCmdError e = pim_0_1_pimstat_rx_unknown_hello_option_per_vif(
	    xa_inputs.get(0, "vif_name").text(),
	    value);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/pimstat_rx_unknown_hello_option_per_vif", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("value", value);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_pimstat_rx_data_no_state_per_vif(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/pimstat_rx_data_no_state_per_vif");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t value;
    try {
	XrlCmdError e = pim_0_1_pimstat_rx_data_no_state_per_vif(
	    xa_inputs.get(0, "vif_name").text(),
	    value);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/pimstat_rx_data_no_state_per_vif", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("value", value);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_pimstat_rx_rp_no_state_per_vif(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/pimstat_rx_rp_no_state_per_vif");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t value;
    try {
	XrlCmdError e = pim_0_1_pimstat_rx_rp_no_state_per_vif(
	    xa_inputs.get(0, "vif_name").text(),
	    value);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/pimstat_rx_rp_no_state_per_vif", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("value", value);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_pimstat_rx_aggregate_per_vif(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/pimstat_rx_aggregate_per_vif");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t value;
    try {
	XrlCmdError e = pim_0_1_pimstat_rx_aggregate_per_vif(
	    xa_inputs.get(0, "vif_name").text(),
	    value);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/pimstat_rx_aggregate_per_vif", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("value", value);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_pimstat_rx_malformed_packet_per_vif(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/pimstat_rx_malformed_packet_per_vif");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t value;
    try {
	XrlCmdError e = pim_0_1_pimstat_rx_malformed_packet_per_vif(
	    xa_inputs.get(0, "vif_name").text(),
	    value);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/pimstat_rx_malformed_packet_per_vif", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("value", value);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_pimstat_no_rp_per_vif(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/pimstat_no_rp_per_vif");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t value;
    try {
	XrlCmdError e = pim_0_1_pimstat_no_rp_per_vif(
	    xa_inputs.get(0, "vif_name").text(),
	    value);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/pimstat_no_rp_per_vif", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("value", value);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_pimstat_no_route_upstream_per_vif(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/pimstat_no_route_upstream_per_vif");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t value;
    try {
	XrlCmdError e = pim_0_1_pimstat_no_route_upstream_per_vif(
	    xa_inputs.get(0, "vif_name").text(),
	    value);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/pimstat_no_route_upstream_per_vif", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("value", value);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_pimstat_rp_mismatch_per_vif(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/pimstat_rp_mismatch_per_vif");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t value;
    try {
	XrlCmdError e = pim_0_1_pimstat_rp_mismatch_per_vif(
	    xa_inputs.get(0, "vif_name").text(),
	    value);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/pimstat_rp_mismatch_per_vif", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("value", value);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_pimstat_rpf_neighbor_unknown_per_vif(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/pimstat_rpf_neighbor_unknown_per_vif");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t value;
    try {
	XrlCmdError e = pim_0_1_pimstat_rpf_neighbor_unknown_per_vif(
	    xa_inputs.get(0, "vif_name").text(),
	    value);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/pimstat_rpf_neighbor_unknown_per_vif", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("value", value);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_pimstat_rx_join_rp_per_vif(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/pimstat_rx_join_rp_per_vif");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t value;
    try {
	XrlCmdError e = pim_0_1_pimstat_rx_join_rp_per_vif(
	    xa_inputs.get(0, "vif_name").text(),
	    value);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/pimstat_rx_join_rp_per_vif", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("value", value);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_pimstat_rx_prune_rp_per_vif(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/pimstat_rx_prune_rp_per_vif");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t value;
    try {
	XrlCmdError e = pim_0_1_pimstat_rx_prune_rp_per_vif(
	    xa_inputs.get(0, "vif_name").text(),
	    value);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/pimstat_rx_prune_rp_per_vif", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("value", value);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_pimstat_rx_join_wc_per_vif(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/pimstat_rx_join_wc_per_vif");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t value;
    try {
	XrlCmdError e = pim_0_1_pimstat_rx_join_wc_per_vif(
	    xa_inputs.get(0, "vif_name").text(),
	    value);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/pimstat_rx_join_wc_per_vif", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("value", value);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_pimstat_rx_prune_wc_per_vif(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/pimstat_rx_prune_wc_per_vif");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t value;
    try {
	XrlCmdError e = pim_0_1_pimstat_rx_prune_wc_per_vif(
	    xa_inputs.get(0, "vif_name").text(),
	    value);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/pimstat_rx_prune_wc_per_vif", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("value", value);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_pimstat_rx_join_sg_per_vif(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/pimstat_rx_join_sg_per_vif");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t value;
    try {
	XrlCmdError e = pim_0_1_pimstat_rx_join_sg_per_vif(
	    xa_inputs.get(0, "vif_name").text(),
	    value);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/pimstat_rx_join_sg_per_vif", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("value", value);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_pimstat_rx_prune_sg_per_vif(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/pimstat_rx_prune_sg_per_vif");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t value;
    try {
	XrlCmdError e = pim_0_1_pimstat_rx_prune_sg_per_vif(
	    xa_inputs.get(0, "vif_name").text(),
	    value);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/pimstat_rx_prune_sg_per_vif", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("value", value);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_pimstat_rx_join_sg_rpt_per_vif(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/pimstat_rx_join_sg_rpt_per_vif");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t value;
    try {
	XrlCmdError e = pim_0_1_pimstat_rx_join_sg_rpt_per_vif(
	    xa_inputs.get(0, "vif_name").text(),
	    value);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/pimstat_rx_join_sg_rpt_per_vif", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("value", value);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlPimTargetBase::handle_pim_0_1_pimstat_rx_prune_sg_rpt_per_vif(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "pim/0.1/pimstat_rx_prune_sg_rpt_per_vif");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t value;
    try {
	XrlCmdError e = pim_0_1_pimstat_rx_prune_sg_rpt_per_vif(
	    xa_inputs.get(0, "vif_name").text(),
	    value);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "pim/0.1/pimstat_rx_prune_sg_rpt_per_vif", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("value", value);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

void
XrlPimTargetBase::add_handlers()
{
	if (_cmds->add_handler("common/0.1/get_target_name",
	    callback(this, &XrlPimTargetBase::handle_common_0_1_get_target_name)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "common/0.1/get_target_name");
	}
	if (_cmds->add_handler("common/0.1/get_version",
	    callback(this, &XrlPimTargetBase::handle_common_0_1_get_version)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "common/0.1/get_version");
	}
	if (_cmds->add_handler("common/0.1/get_status",
	    callback(this, &XrlPimTargetBase::handle_common_0_1_get_status)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "common/0.1/get_status");
	}
	if (_cmds->add_handler("common/0.1/shutdown",
	    callback(this, &XrlPimTargetBase::handle_common_0_1_shutdown)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "common/0.1/shutdown");
	}
	if (_cmds->add_handler("cli_processor/0.1/process_command",
	    callback(this, &XrlPimTargetBase::handle_cli_processor_0_1_process_command)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "cli_processor/0.1/process_command");
	}
	if (_cmds->add_handler("finder_event_observer/0.1/xrl_target_birth",
	    callback(this, &XrlPimTargetBase::handle_finder_event_observer_0_1_xrl_target_birth)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "finder_event_observer/0.1/xrl_target_birth");
	}
	if (_cmds->add_handler("finder_event_observer/0.1/xrl_target_death",
	    callback(this, &XrlPimTargetBase::handle_finder_event_observer_0_1_xrl_target_death)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "finder_event_observer/0.1/xrl_target_death");
	}
	if (_cmds->add_handler("raw_packet4_client/0.1/recv",
	    callback(this, &XrlPimTargetBase::handle_raw_packet4_client_0_1_recv)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "raw_packet4_client/0.1/recv");
	}
	if (_cmds->add_handler("raw_packet6_client/0.1/recv",
	    callback(this, &XrlPimTargetBase::handle_raw_packet6_client_0_1_recv)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "raw_packet6_client/0.1/recv");
	}
	if (_cmds->add_handler("mfea_client/0.1/recv_kernel_signal_message4",
	    callback(this, &XrlPimTargetBase::handle_mfea_client_0_1_recv_kernel_signal_message4)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "mfea_client/0.1/recv_kernel_signal_message4");
	}
	if (_cmds->add_handler("mfea_client/0.1/recv_kernel_signal_message6",
	    callback(this, &XrlPimTargetBase::handle_mfea_client_0_1_recv_kernel_signal_message6)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "mfea_client/0.1/recv_kernel_signal_message6");
	}
	if (_cmds->add_handler("mfea_client/0.1/recv_dataflow_signal4",
	    callback(this, &XrlPimTargetBase::handle_mfea_client_0_1_recv_dataflow_signal4)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "mfea_client/0.1/recv_dataflow_signal4");
	}
	if (_cmds->add_handler("mfea_client/0.1/recv_dataflow_signal6",
	    callback(this, &XrlPimTargetBase::handle_mfea_client_0_1_recv_dataflow_signal6)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "mfea_client/0.1/recv_dataflow_signal6");
	}
	if (_cmds->add_handler("redist_transaction4/0.1/start_transaction",
	    callback(this, &XrlPimTargetBase::handle_redist_transaction4_0_1_start_transaction)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "redist_transaction4/0.1/start_transaction");
	}
	if (_cmds->add_handler("redist_transaction4/0.1/commit_transaction",
	    callback(this, &XrlPimTargetBase::handle_redist_transaction4_0_1_commit_transaction)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "redist_transaction4/0.1/commit_transaction");
	}
	if (_cmds->add_handler("redist_transaction4/0.1/abort_transaction",
	    callback(this, &XrlPimTargetBase::handle_redist_transaction4_0_1_abort_transaction)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "redist_transaction4/0.1/abort_transaction");
	}
	if (_cmds->add_handler("redist_transaction4/0.1/add_route",
	    callback(this, &XrlPimTargetBase::handle_redist_transaction4_0_1_add_route)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "redist_transaction4/0.1/add_route");
	}
	if (_cmds->add_handler("redist_transaction4/0.1/delete_route",
	    callback(this, &XrlPimTargetBase::handle_redist_transaction4_0_1_delete_route)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "redist_transaction4/0.1/delete_route");
	}
	if (_cmds->add_handler("redist_transaction4/0.1/delete_all_routes",
	    callback(this, &XrlPimTargetBase::handle_redist_transaction4_0_1_delete_all_routes)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "redist_transaction4/0.1/delete_all_routes");
	}
	if (_cmds->add_handler("redist_transaction6/0.1/start_transaction",
	    callback(this, &XrlPimTargetBase::handle_redist_transaction6_0_1_start_transaction)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "redist_transaction6/0.1/start_transaction");
	}
	if (_cmds->add_handler("redist_transaction6/0.1/commit_transaction",
	    callback(this, &XrlPimTargetBase::handle_redist_transaction6_0_1_commit_transaction)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "redist_transaction6/0.1/commit_transaction");
	}
	if (_cmds->add_handler("redist_transaction6/0.1/abort_transaction",
	    callback(this, &XrlPimTargetBase::handle_redist_transaction6_0_1_abort_transaction)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "redist_transaction6/0.1/abort_transaction");
	}
	if (_cmds->add_handler("redist_transaction6/0.1/add_route",
	    callback(this, &XrlPimTargetBase::handle_redist_transaction6_0_1_add_route)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "redist_transaction6/0.1/add_route");
	}
	if (_cmds->add_handler("redist_transaction6/0.1/delete_route",
	    callback(this, &XrlPimTargetBase::handle_redist_transaction6_0_1_delete_route)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "redist_transaction6/0.1/delete_route");
	}
	if (_cmds->add_handler("redist_transaction6/0.1/delete_all_routes",
	    callback(this, &XrlPimTargetBase::handle_redist_transaction6_0_1_delete_all_routes)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "redist_transaction6/0.1/delete_all_routes");
	}
	if (_cmds->add_handler("mld6igmp_client/0.1/add_membership4",
	    callback(this, &XrlPimTargetBase::handle_mld6igmp_client_0_1_add_membership4)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "mld6igmp_client/0.1/add_membership4");
	}
	if (_cmds->add_handler("mld6igmp_client/0.1/add_membership6",
	    callback(this, &XrlPimTargetBase::handle_mld6igmp_client_0_1_add_membership6)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "mld6igmp_client/0.1/add_membership6");
	}
	if (_cmds->add_handler("mld6igmp_client/0.1/delete_membership4",
	    callback(this, &XrlPimTargetBase::handle_mld6igmp_client_0_1_delete_membership4)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "mld6igmp_client/0.1/delete_membership4");
	}
	if (_cmds->add_handler("mld6igmp_client/0.1/delete_membership6",
	    callback(this, &XrlPimTargetBase::handle_mld6igmp_client_0_1_delete_membership6)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "mld6igmp_client/0.1/delete_membership6");
	}
	if (_cmds->add_handler("pim/0.1/enable_vif",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_enable_vif)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/enable_vif");
	}
	if (_cmds->add_handler("pim/0.1/start_vif",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_start_vif)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/start_vif");
	}
	if (_cmds->add_handler("pim/0.1/stop_vif",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_stop_vif)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/stop_vif");
	}
	if (_cmds->add_handler("pim/0.1/enable_all_vifs",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_enable_all_vifs)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/enable_all_vifs");
	}
	if (_cmds->add_handler("pim/0.1/start_all_vifs",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_start_all_vifs)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/start_all_vifs");
	}
	if (_cmds->add_handler("pim/0.1/stop_all_vifs",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_stop_all_vifs)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/stop_all_vifs");
	}
	if (_cmds->add_handler("pim/0.1/enable_pim",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_enable_pim)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/enable_pim");
	}
	if (_cmds->add_handler("pim/0.1/start_pim",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_start_pim)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/start_pim");
	}
	if (_cmds->add_handler("pim/0.1/stop_pim",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_stop_pim)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/stop_pim");
	}
	if (_cmds->add_handler("pim/0.1/enable_cli",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_enable_cli)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/enable_cli");
	}
	if (_cmds->add_handler("pim/0.1/start_cli",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_start_cli)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/start_cli");
	}
	if (_cmds->add_handler("pim/0.1/stop_cli",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_stop_cli)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/stop_cli");
	}
	if (_cmds->add_handler("pim/0.1/enable_bsr",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_enable_bsr)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/enable_bsr");
	}
	if (_cmds->add_handler("pim/0.1/start_bsr",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_start_bsr)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/start_bsr");
	}
	if (_cmds->add_handler("pim/0.1/stop_bsr",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_stop_bsr)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/stop_bsr");
	}
	if (_cmds->add_handler("pim/0.1/add_config_scope_zone_by_vif_name4",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_add_config_scope_zone_by_vif_name4)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/add_config_scope_zone_by_vif_name4");
	}
	if (_cmds->add_handler("pim/0.1/add_config_scope_zone_by_vif_name6",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_add_config_scope_zone_by_vif_name6)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/add_config_scope_zone_by_vif_name6");
	}
	if (_cmds->add_handler("pim/0.1/add_config_scope_zone_by_vif_addr4",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_add_config_scope_zone_by_vif_addr4)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/add_config_scope_zone_by_vif_addr4");
	}
	if (_cmds->add_handler("pim/0.1/add_config_scope_zone_by_vif_addr6",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_add_config_scope_zone_by_vif_addr6)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/add_config_scope_zone_by_vif_addr6");
	}
	if (_cmds->add_handler("pim/0.1/delete_config_scope_zone_by_vif_name4",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_delete_config_scope_zone_by_vif_name4)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/delete_config_scope_zone_by_vif_name4");
	}
	if (_cmds->add_handler("pim/0.1/delete_config_scope_zone_by_vif_name6",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_delete_config_scope_zone_by_vif_name6)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/delete_config_scope_zone_by_vif_name6");
	}
	if (_cmds->add_handler("pim/0.1/delete_config_scope_zone_by_vif_addr4",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_delete_config_scope_zone_by_vif_addr4)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/delete_config_scope_zone_by_vif_addr4");
	}
	if (_cmds->add_handler("pim/0.1/delete_config_scope_zone_by_vif_addr6",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_delete_config_scope_zone_by_vif_addr6)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/delete_config_scope_zone_by_vif_addr6");
	}
	if (_cmds->add_handler("pim/0.1/add_config_cand_bsr4",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_add_config_cand_bsr4)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/add_config_cand_bsr4");
	}
	if (_cmds->add_handler("pim/0.1/add_config_cand_bsr6",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_add_config_cand_bsr6)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/add_config_cand_bsr6");
	}
	if (_cmds->add_handler("pim/0.1/delete_config_cand_bsr4",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_delete_config_cand_bsr4)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/delete_config_cand_bsr4");
	}
	if (_cmds->add_handler("pim/0.1/delete_config_cand_bsr6",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_delete_config_cand_bsr6)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/delete_config_cand_bsr6");
	}
	if (_cmds->add_handler("pim/0.1/add_config_cand_rp4",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_add_config_cand_rp4)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/add_config_cand_rp4");
	}
	if (_cmds->add_handler("pim/0.1/add_config_cand_rp6",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_add_config_cand_rp6)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/add_config_cand_rp6");
	}
	if (_cmds->add_handler("pim/0.1/delete_config_cand_rp4",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_delete_config_cand_rp4)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/delete_config_cand_rp4");
	}
	if (_cmds->add_handler("pim/0.1/delete_config_cand_rp6",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_delete_config_cand_rp6)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/delete_config_cand_rp6");
	}
	if (_cmds->add_handler("pim/0.1/add_config_static_rp4",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_add_config_static_rp4)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/add_config_static_rp4");
	}
	if (_cmds->add_handler("pim/0.1/add_config_static_rp6",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_add_config_static_rp6)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/add_config_static_rp6");
	}
	if (_cmds->add_handler("pim/0.1/delete_config_static_rp4",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_delete_config_static_rp4)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/delete_config_static_rp4");
	}
	if (_cmds->add_handler("pim/0.1/delete_config_static_rp6",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_delete_config_static_rp6)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/delete_config_static_rp6");
	}
	if (_cmds->add_handler("pim/0.1/delete_config_all_static_group_prefixes_rp4",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_delete_config_all_static_group_prefixes_rp4)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/delete_config_all_static_group_prefixes_rp4");
	}
	if (_cmds->add_handler("pim/0.1/delete_config_all_static_group_prefixes_rp6",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_delete_config_all_static_group_prefixes_rp6)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/delete_config_all_static_group_prefixes_rp6");
	}
	if (_cmds->add_handler("pim/0.1/delete_config_all_static_rps",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_delete_config_all_static_rps)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/delete_config_all_static_rps");
	}
	if (_cmds->add_handler("pim/0.1/config_static_rp_done",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_config_static_rp_done)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/config_static_rp_done");
	}
	if (_cmds->add_handler("pim/0.1/get_vif_proto_version",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_get_vif_proto_version)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/get_vif_proto_version");
	}
	if (_cmds->add_handler("pim/0.1/set_vif_proto_version",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_set_vif_proto_version)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/set_vif_proto_version");
	}
	if (_cmds->add_handler("pim/0.1/reset_vif_proto_version",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_reset_vif_proto_version)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/reset_vif_proto_version");
	}
	if (_cmds->add_handler("pim/0.1/get_vif_hello_triggered_delay",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_get_vif_hello_triggered_delay)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/get_vif_hello_triggered_delay");
	}
	if (_cmds->add_handler("pim/0.1/set_vif_hello_triggered_delay",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_set_vif_hello_triggered_delay)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/set_vif_hello_triggered_delay");
	}
	if (_cmds->add_handler("pim/0.1/reset_vif_hello_triggered_delay",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_reset_vif_hello_triggered_delay)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/reset_vif_hello_triggered_delay");
	}
	if (_cmds->add_handler("pim/0.1/get_vif_hello_period",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_get_vif_hello_period)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/get_vif_hello_period");
	}
	if (_cmds->add_handler("pim/0.1/set_vif_hello_period",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_set_vif_hello_period)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/set_vif_hello_period");
	}
	if (_cmds->add_handler("pim/0.1/reset_vif_hello_period",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_reset_vif_hello_period)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/reset_vif_hello_period");
	}
	if (_cmds->add_handler("pim/0.1/get_vif_hello_holdtime",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_get_vif_hello_holdtime)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/get_vif_hello_holdtime");
	}
	if (_cmds->add_handler("pim/0.1/set_vif_hello_holdtime",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_set_vif_hello_holdtime)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/set_vif_hello_holdtime");
	}
	if (_cmds->add_handler("pim/0.1/reset_vif_hello_holdtime",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_reset_vif_hello_holdtime)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/reset_vif_hello_holdtime");
	}
	if (_cmds->add_handler("pim/0.1/get_vif_dr_priority",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_get_vif_dr_priority)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/get_vif_dr_priority");
	}
	if (_cmds->add_handler("pim/0.1/set_vif_dr_priority",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_set_vif_dr_priority)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/set_vif_dr_priority");
	}
	if (_cmds->add_handler("pim/0.1/reset_vif_dr_priority",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_reset_vif_dr_priority)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/reset_vif_dr_priority");
	}
	if (_cmds->add_handler("pim/0.1/get_vif_propagation_delay",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_get_vif_propagation_delay)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/get_vif_propagation_delay");
	}
	if (_cmds->add_handler("pim/0.1/set_vif_propagation_delay",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_set_vif_propagation_delay)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/set_vif_propagation_delay");
	}
	if (_cmds->add_handler("pim/0.1/reset_vif_propagation_delay",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_reset_vif_propagation_delay)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/reset_vif_propagation_delay");
	}
	if (_cmds->add_handler("pim/0.1/get_vif_override_interval",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_get_vif_override_interval)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/get_vif_override_interval");
	}
	if (_cmds->add_handler("pim/0.1/set_vif_override_interval",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_set_vif_override_interval)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/set_vif_override_interval");
	}
	if (_cmds->add_handler("pim/0.1/reset_vif_override_interval",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_reset_vif_override_interval)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/reset_vif_override_interval");
	}
	if (_cmds->add_handler("pim/0.1/get_vif_is_tracking_support_disabled",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_get_vif_is_tracking_support_disabled)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/get_vif_is_tracking_support_disabled");
	}
	if (_cmds->add_handler("pim/0.1/set_vif_is_tracking_support_disabled",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_set_vif_is_tracking_support_disabled)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/set_vif_is_tracking_support_disabled");
	}
	if (_cmds->add_handler("pim/0.1/reset_vif_is_tracking_support_disabled",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_reset_vif_is_tracking_support_disabled)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/reset_vif_is_tracking_support_disabled");
	}
	if (_cmds->add_handler("pim/0.1/get_vif_accept_nohello_neighbors",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_get_vif_accept_nohello_neighbors)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/get_vif_accept_nohello_neighbors");
	}
	if (_cmds->add_handler("pim/0.1/set_vif_accept_nohello_neighbors",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_set_vif_accept_nohello_neighbors)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/set_vif_accept_nohello_neighbors");
	}
	if (_cmds->add_handler("pim/0.1/reset_vif_accept_nohello_neighbors",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_reset_vif_accept_nohello_neighbors)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/reset_vif_accept_nohello_neighbors");
	}
	if (_cmds->add_handler("pim/0.1/get_vif_join_prune_period",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_get_vif_join_prune_period)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/get_vif_join_prune_period");
	}
	if (_cmds->add_handler("pim/0.1/set_vif_join_prune_period",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_set_vif_join_prune_period)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/set_vif_join_prune_period");
	}
	if (_cmds->add_handler("pim/0.1/reset_vif_join_prune_period",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_reset_vif_join_prune_period)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/reset_vif_join_prune_period");
	}
	if (_cmds->add_handler("pim/0.1/get_switch_to_spt_threshold",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_get_switch_to_spt_threshold)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/get_switch_to_spt_threshold");
	}
	if (_cmds->add_handler("pim/0.1/set_switch_to_spt_threshold",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_set_switch_to_spt_threshold)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/set_switch_to_spt_threshold");
	}
	if (_cmds->add_handler("pim/0.1/reset_switch_to_spt_threshold",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_reset_switch_to_spt_threshold)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/reset_switch_to_spt_threshold");
	}
	if (_cmds->add_handler("pim/0.1/add_alternative_subnet4",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_add_alternative_subnet4)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/add_alternative_subnet4");
	}
	if (_cmds->add_handler("pim/0.1/add_alternative_subnet6",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_add_alternative_subnet6)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/add_alternative_subnet6");
	}
	if (_cmds->add_handler("pim/0.1/delete_alternative_subnet4",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_delete_alternative_subnet4)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/delete_alternative_subnet4");
	}
	if (_cmds->add_handler("pim/0.1/delete_alternative_subnet6",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_delete_alternative_subnet6)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/delete_alternative_subnet6");
	}
	if (_cmds->add_handler("pim/0.1/remove_all_alternative_subnets",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_remove_all_alternative_subnets)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/remove_all_alternative_subnets");
	}
	if (_cmds->add_handler("pim/0.1/log_trace_all",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_log_trace_all)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/log_trace_all");
	}
	if (_cmds->add_handler("pim/0.1/add_test_jp_entry4",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_add_test_jp_entry4)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/add_test_jp_entry4");
	}
	if (_cmds->add_handler("pim/0.1/add_test_jp_entry6",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_add_test_jp_entry6)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/add_test_jp_entry6");
	}
	if (_cmds->add_handler("pim/0.1/send_test_jp_entry4",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_send_test_jp_entry4)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/send_test_jp_entry4");
	}
	if (_cmds->add_handler("pim/0.1/send_test_jp_entry6",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_send_test_jp_entry6)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/send_test_jp_entry6");
	}
	if (_cmds->add_handler("pim/0.1/send_test_assert4",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_send_test_assert4)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/send_test_assert4");
	}
	if (_cmds->add_handler("pim/0.1/send_test_assert6",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_send_test_assert6)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/send_test_assert6");
	}
	if (_cmds->add_handler("pim/0.1/add_test_bsr_zone4",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_add_test_bsr_zone4)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/add_test_bsr_zone4");
	}
	if (_cmds->add_handler("pim/0.1/add_test_bsr_zone6",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_add_test_bsr_zone6)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/add_test_bsr_zone6");
	}
	if (_cmds->add_handler("pim/0.1/add_test_bsr_group_prefix4",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_add_test_bsr_group_prefix4)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/add_test_bsr_group_prefix4");
	}
	if (_cmds->add_handler("pim/0.1/add_test_bsr_group_prefix6",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_add_test_bsr_group_prefix6)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/add_test_bsr_group_prefix6");
	}
	if (_cmds->add_handler("pim/0.1/add_test_bsr_rp4",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_add_test_bsr_rp4)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/add_test_bsr_rp4");
	}
	if (_cmds->add_handler("pim/0.1/add_test_bsr_rp6",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_add_test_bsr_rp6)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/add_test_bsr_rp6");
	}
	if (_cmds->add_handler("pim/0.1/send_test_bootstrap",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_send_test_bootstrap)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/send_test_bootstrap");
	}
	if (_cmds->add_handler("pim/0.1/send_test_bootstrap_by_dest4",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_send_test_bootstrap_by_dest4)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/send_test_bootstrap_by_dest4");
	}
	if (_cmds->add_handler("pim/0.1/send_test_bootstrap_by_dest6",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_send_test_bootstrap_by_dest6)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/send_test_bootstrap_by_dest6");
	}
	if (_cmds->add_handler("pim/0.1/send_test_cand_rp_adv",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_send_test_cand_rp_adv)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/send_test_cand_rp_adv");
	}
	if (_cmds->add_handler("pim/0.1/pimstat_neighbors4",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_pimstat_neighbors4)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/pimstat_neighbors4");
	}
	if (_cmds->add_handler("pim/0.1/pimstat_neighbors6",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_pimstat_neighbors6)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/pimstat_neighbors6");
	}
	if (_cmds->add_handler("pim/0.1/pimstat_interface4",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_pimstat_interface4)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/pimstat_interface4");
	}
	if (_cmds->add_handler("pim/0.1/pimstat_interface6",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_pimstat_interface6)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/pimstat_interface6");
	}
	if (_cmds->add_handler("pim/0.1/pimstat_rps4",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_pimstat_rps4)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/pimstat_rps4");
	}
	if (_cmds->add_handler("pim/0.1/pimstat_rps6",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_pimstat_rps6)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/pimstat_rps6");
	}
	if (_cmds->add_handler("pim/0.1/clear_pim_statistics",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_clear_pim_statistics)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/clear_pim_statistics");
	}
	if (_cmds->add_handler("pim/0.1/clear_pim_statistics_per_vif",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_clear_pim_statistics_per_vif)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/clear_pim_statistics_per_vif");
	}
	if (_cmds->add_handler("pim/0.1/pimstat_hello_messages_received",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_pimstat_hello_messages_received)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/pimstat_hello_messages_received");
	}
	if (_cmds->add_handler("pim/0.1/pimstat_hello_messages_sent",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_pimstat_hello_messages_sent)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/pimstat_hello_messages_sent");
	}
	if (_cmds->add_handler("pim/0.1/pimstat_hello_messages_rx_errors",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_pimstat_hello_messages_rx_errors)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/pimstat_hello_messages_rx_errors");
	}
	if (_cmds->add_handler("pim/0.1/pimstat_register_messages_received",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_pimstat_register_messages_received)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/pimstat_register_messages_received");
	}
	if (_cmds->add_handler("pim/0.1/pimstat_register_messages_sent",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_pimstat_register_messages_sent)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/pimstat_register_messages_sent");
	}
	if (_cmds->add_handler("pim/0.1/pimstat_register_messages_rx_errors",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_pimstat_register_messages_rx_errors)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/pimstat_register_messages_rx_errors");
	}
	if (_cmds->add_handler("pim/0.1/pimstat_register_stop_messages_received",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_pimstat_register_stop_messages_received)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/pimstat_register_stop_messages_received");
	}
	if (_cmds->add_handler("pim/0.1/pimstat_register_stop_messages_sent",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_pimstat_register_stop_messages_sent)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/pimstat_register_stop_messages_sent");
	}
	if (_cmds->add_handler("pim/0.1/pimstat_register_stop_messages_rx_errors",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_pimstat_register_stop_messages_rx_errors)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/pimstat_register_stop_messages_rx_errors");
	}
	if (_cmds->add_handler("pim/0.1/pimstat_join_prune_messages_received",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_pimstat_join_prune_messages_received)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/pimstat_join_prune_messages_received");
	}
	if (_cmds->add_handler("pim/0.1/pimstat_join_prune_messages_sent",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_pimstat_join_prune_messages_sent)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/pimstat_join_prune_messages_sent");
	}
	if (_cmds->add_handler("pim/0.1/pimstat_join_prune_messages_rx_errors",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_pimstat_join_prune_messages_rx_errors)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/pimstat_join_prune_messages_rx_errors");
	}
	if (_cmds->add_handler("pim/0.1/pimstat_bootstrap_messages_received",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_pimstat_bootstrap_messages_received)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/pimstat_bootstrap_messages_received");
	}
	if (_cmds->add_handler("pim/0.1/pimstat_bootstrap_messages_sent",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_pimstat_bootstrap_messages_sent)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/pimstat_bootstrap_messages_sent");
	}
	if (_cmds->add_handler("pim/0.1/pimstat_bootstrap_messages_rx_errors",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_pimstat_bootstrap_messages_rx_errors)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/pimstat_bootstrap_messages_rx_errors");
	}
	if (_cmds->add_handler("pim/0.1/pimstat_assert_messages_received",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_pimstat_assert_messages_received)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/pimstat_assert_messages_received");
	}
	if (_cmds->add_handler("pim/0.1/pimstat_assert_messages_sent",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_pimstat_assert_messages_sent)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/pimstat_assert_messages_sent");
	}
	if (_cmds->add_handler("pim/0.1/pimstat_assert_messages_rx_errors",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_pimstat_assert_messages_rx_errors)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/pimstat_assert_messages_rx_errors");
	}
	if (_cmds->add_handler("pim/0.1/pimstat_graft_messages_received",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_pimstat_graft_messages_received)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/pimstat_graft_messages_received");
	}
	if (_cmds->add_handler("pim/0.1/pimstat_graft_messages_sent",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_pimstat_graft_messages_sent)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/pimstat_graft_messages_sent");
	}
	if (_cmds->add_handler("pim/0.1/pimstat_graft_messages_rx_errors",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_pimstat_graft_messages_rx_errors)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/pimstat_graft_messages_rx_errors");
	}
	if (_cmds->add_handler("pim/0.1/pimstat_graft_ack_messages_received",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_pimstat_graft_ack_messages_received)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/pimstat_graft_ack_messages_received");
	}
	if (_cmds->add_handler("pim/0.1/pimstat_graft_ack_messages_sent",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_pimstat_graft_ack_messages_sent)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/pimstat_graft_ack_messages_sent");
	}
	if (_cmds->add_handler("pim/0.1/pimstat_graft_ack_messages_rx_errors",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_pimstat_graft_ack_messages_rx_errors)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/pimstat_graft_ack_messages_rx_errors");
	}
	if (_cmds->add_handler("pim/0.1/pimstat_candidate_rp_messages_received",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_pimstat_candidate_rp_messages_received)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/pimstat_candidate_rp_messages_received");
	}
	if (_cmds->add_handler("pim/0.1/pimstat_candidate_rp_messages_sent",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_pimstat_candidate_rp_messages_sent)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/pimstat_candidate_rp_messages_sent");
	}
	if (_cmds->add_handler("pim/0.1/pimstat_candidate_rp_messages_rx_errors",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_pimstat_candidate_rp_messages_rx_errors)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/pimstat_candidate_rp_messages_rx_errors");
	}
	if (_cmds->add_handler("pim/0.1/pimstat_unknown_type_messages",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_pimstat_unknown_type_messages)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/pimstat_unknown_type_messages");
	}
	if (_cmds->add_handler("pim/0.1/pimstat_unknown_version_messages",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_pimstat_unknown_version_messages)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/pimstat_unknown_version_messages");
	}
	if (_cmds->add_handler("pim/0.1/pimstat_neighbor_unknown_messages",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_pimstat_neighbor_unknown_messages)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/pimstat_neighbor_unknown_messages");
	}
	if (_cmds->add_handler("pim/0.1/pimstat_bad_length_messages",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_pimstat_bad_length_messages)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/pimstat_bad_length_messages");
	}
	if (_cmds->add_handler("pim/0.1/pimstat_bad_checksum_messages",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_pimstat_bad_checksum_messages)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/pimstat_bad_checksum_messages");
	}
	if (_cmds->add_handler("pim/0.1/pimstat_bad_receive_interface_messages",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_pimstat_bad_receive_interface_messages)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/pimstat_bad_receive_interface_messages");
	}
	if (_cmds->add_handler("pim/0.1/pimstat_rx_interface_disabled_messages",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_pimstat_rx_interface_disabled_messages)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/pimstat_rx_interface_disabled_messages");
	}
	if (_cmds->add_handler("pim/0.1/pimstat_rx_register_not_rp",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_pimstat_rx_register_not_rp)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/pimstat_rx_register_not_rp");
	}
	if (_cmds->add_handler("pim/0.1/pimstat_rp_filtered_source",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_pimstat_rp_filtered_source)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/pimstat_rp_filtered_source");
	}
	if (_cmds->add_handler("pim/0.1/pimstat_unknown_register_stop",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_pimstat_unknown_register_stop)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/pimstat_unknown_register_stop");
	}
	if (_cmds->add_handler("pim/0.1/pimstat_rx_join_prune_no_state",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_pimstat_rx_join_prune_no_state)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/pimstat_rx_join_prune_no_state");
	}
	if (_cmds->add_handler("pim/0.1/pimstat_rx_graft_graft_ack_no_state",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_pimstat_rx_graft_graft_ack_no_state)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/pimstat_rx_graft_graft_ack_no_state");
	}
	if (_cmds->add_handler("pim/0.1/pimstat_rx_graft_on_upstream_interface",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_pimstat_rx_graft_on_upstream_interface)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/pimstat_rx_graft_on_upstream_interface");
	}
	if (_cmds->add_handler("pim/0.1/pimstat_rx_candidate_rp_not_bsr",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_pimstat_rx_candidate_rp_not_bsr)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/pimstat_rx_candidate_rp_not_bsr");
	}
	if (_cmds->add_handler("pim/0.1/pimstat_rx_bsr_when_bsr",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_pimstat_rx_bsr_when_bsr)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/pimstat_rx_bsr_when_bsr");
	}
	if (_cmds->add_handler("pim/0.1/pimstat_rx_bsr_not_rpf_interface",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_pimstat_rx_bsr_not_rpf_interface)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/pimstat_rx_bsr_not_rpf_interface");
	}
	if (_cmds->add_handler("pim/0.1/pimstat_rx_unknown_hello_option",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_pimstat_rx_unknown_hello_option)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/pimstat_rx_unknown_hello_option");
	}
	if (_cmds->add_handler("pim/0.1/pimstat_rx_data_no_state",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_pimstat_rx_data_no_state)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/pimstat_rx_data_no_state");
	}
	if (_cmds->add_handler("pim/0.1/pimstat_rx_rp_no_state",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_pimstat_rx_rp_no_state)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/pimstat_rx_rp_no_state");
	}
	if (_cmds->add_handler("pim/0.1/pimstat_rx_aggregate",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_pimstat_rx_aggregate)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/pimstat_rx_aggregate");
	}
	if (_cmds->add_handler("pim/0.1/pimstat_rx_malformed_packet",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_pimstat_rx_malformed_packet)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/pimstat_rx_malformed_packet");
	}
	if (_cmds->add_handler("pim/0.1/pimstat_no_rp",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_pimstat_no_rp)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/pimstat_no_rp");
	}
	if (_cmds->add_handler("pim/0.1/pimstat_no_route_upstream",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_pimstat_no_route_upstream)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/pimstat_no_route_upstream");
	}
	if (_cmds->add_handler("pim/0.1/pimstat_rp_mismatch",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_pimstat_rp_mismatch)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/pimstat_rp_mismatch");
	}
	if (_cmds->add_handler("pim/0.1/pimstat_rpf_neighbor_unknown",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_pimstat_rpf_neighbor_unknown)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/pimstat_rpf_neighbor_unknown");
	}
	if (_cmds->add_handler("pim/0.1/pimstat_rx_join_rp",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_pimstat_rx_join_rp)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/pimstat_rx_join_rp");
	}
	if (_cmds->add_handler("pim/0.1/pimstat_rx_prune_rp",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_pimstat_rx_prune_rp)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/pimstat_rx_prune_rp");
	}
	if (_cmds->add_handler("pim/0.1/pimstat_rx_join_wc",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_pimstat_rx_join_wc)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/pimstat_rx_join_wc");
	}
	if (_cmds->add_handler("pim/0.1/pimstat_rx_prune_wc",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_pimstat_rx_prune_wc)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/pimstat_rx_prune_wc");
	}
	if (_cmds->add_handler("pim/0.1/pimstat_rx_join_sg",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_pimstat_rx_join_sg)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/pimstat_rx_join_sg");
	}
	if (_cmds->add_handler("pim/0.1/pimstat_rx_prune_sg",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_pimstat_rx_prune_sg)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/pimstat_rx_prune_sg");
	}
	if (_cmds->add_handler("pim/0.1/pimstat_rx_join_sg_rpt",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_pimstat_rx_join_sg_rpt)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/pimstat_rx_join_sg_rpt");
	}
	if (_cmds->add_handler("pim/0.1/pimstat_rx_prune_sg_rpt",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_pimstat_rx_prune_sg_rpt)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/pimstat_rx_prune_sg_rpt");
	}
	if (_cmds->add_handler("pim/0.1/pimstat_hello_messages_received_per_vif",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_pimstat_hello_messages_received_per_vif)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/pimstat_hello_messages_received_per_vif");
	}
	if (_cmds->add_handler("pim/0.1/pimstat_hello_messages_sent_per_vif",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_pimstat_hello_messages_sent_per_vif)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/pimstat_hello_messages_sent_per_vif");
	}
	if (_cmds->add_handler("pim/0.1/pimstat_hello_messages_rx_errors_per_vif",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_pimstat_hello_messages_rx_errors_per_vif)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/pimstat_hello_messages_rx_errors_per_vif");
	}
	if (_cmds->add_handler("pim/0.1/pimstat_register_messages_received_per_vif",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_pimstat_register_messages_received_per_vif)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/pimstat_register_messages_received_per_vif");
	}
	if (_cmds->add_handler("pim/0.1/pimstat_register_messages_sent_per_vif",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_pimstat_register_messages_sent_per_vif)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/pimstat_register_messages_sent_per_vif");
	}
	if (_cmds->add_handler("pim/0.1/pimstat_register_messages_rx_errors_per_vif",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_pimstat_register_messages_rx_errors_per_vif)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/pimstat_register_messages_rx_errors_per_vif");
	}
	if (_cmds->add_handler("pim/0.1/pimstat_register_stop_messages_received_per_vif",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_pimstat_register_stop_messages_received_per_vif)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/pimstat_register_stop_messages_received_per_vif");
	}
	if (_cmds->add_handler("pim/0.1/pimstat_register_stop_messages_sent_per_vif",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_pimstat_register_stop_messages_sent_per_vif)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/pimstat_register_stop_messages_sent_per_vif");
	}
	if (_cmds->add_handler("pim/0.1/pimstat_register_stop_messages_rx_errors_per_vif",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_pimstat_register_stop_messages_rx_errors_per_vif)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/pimstat_register_stop_messages_rx_errors_per_vif");
	}
	if (_cmds->add_handler("pim/0.1/pimstat_join_prune_messages_received_per_vif",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_pimstat_join_prune_messages_received_per_vif)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/pimstat_join_prune_messages_received_per_vif");
	}
	if (_cmds->add_handler("pim/0.1/pimstat_join_prune_messages_sent_per_vif",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_pimstat_join_prune_messages_sent_per_vif)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/pimstat_join_prune_messages_sent_per_vif");
	}
	if (_cmds->add_handler("pim/0.1/pimstat_join_prune_messages_rx_errors_per_vif",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_pimstat_join_prune_messages_rx_errors_per_vif)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/pimstat_join_prune_messages_rx_errors_per_vif");
	}
	if (_cmds->add_handler("pim/0.1/pimstat_bootstrap_messages_received_per_vif",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_pimstat_bootstrap_messages_received_per_vif)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/pimstat_bootstrap_messages_received_per_vif");
	}
	if (_cmds->add_handler("pim/0.1/pimstat_bootstrap_messages_sent_per_vif",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_pimstat_bootstrap_messages_sent_per_vif)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/pimstat_bootstrap_messages_sent_per_vif");
	}
	if (_cmds->add_handler("pim/0.1/pimstat_bootstrap_messages_rx_errors_per_vif",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_pimstat_bootstrap_messages_rx_errors_per_vif)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/pimstat_bootstrap_messages_rx_errors_per_vif");
	}
	if (_cmds->add_handler("pim/0.1/pimstat_assert_messages_received_per_vif",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_pimstat_assert_messages_received_per_vif)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/pimstat_assert_messages_received_per_vif");
	}
	if (_cmds->add_handler("pim/0.1/pimstat_assert_messages_sent_per_vif",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_pimstat_assert_messages_sent_per_vif)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/pimstat_assert_messages_sent_per_vif");
	}
	if (_cmds->add_handler("pim/0.1/pimstat_assert_messages_rx_errors_per_vif",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_pimstat_assert_messages_rx_errors_per_vif)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/pimstat_assert_messages_rx_errors_per_vif");
	}
	if (_cmds->add_handler("pim/0.1/pimstat_graft_messages_received_per_vif",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_pimstat_graft_messages_received_per_vif)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/pimstat_graft_messages_received_per_vif");
	}
	if (_cmds->add_handler("pim/0.1/pimstat_graft_messages_sent_per_vif",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_pimstat_graft_messages_sent_per_vif)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/pimstat_graft_messages_sent_per_vif");
	}
	if (_cmds->add_handler("pim/0.1/pimstat_graft_messages_rx_errors_per_vif",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_pimstat_graft_messages_rx_errors_per_vif)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/pimstat_graft_messages_rx_errors_per_vif");
	}
	if (_cmds->add_handler("pim/0.1/pimstat_graft_ack_messages_received_per_vif",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_pimstat_graft_ack_messages_received_per_vif)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/pimstat_graft_ack_messages_received_per_vif");
	}
	if (_cmds->add_handler("pim/0.1/pimstat_graft_ack_messages_sent_per_vif",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_pimstat_graft_ack_messages_sent_per_vif)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/pimstat_graft_ack_messages_sent_per_vif");
	}
	if (_cmds->add_handler("pim/0.1/pimstat_graft_ack_messages_rx_errors_per_vif",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_pimstat_graft_ack_messages_rx_errors_per_vif)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/pimstat_graft_ack_messages_rx_errors_per_vif");
	}
	if (_cmds->add_handler("pim/0.1/pimstat_candidate_rp_messages_received_per_vif",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_pimstat_candidate_rp_messages_received_per_vif)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/pimstat_candidate_rp_messages_received_per_vif");
	}
	if (_cmds->add_handler("pim/0.1/pimstat_candidate_rp_messages_sent_per_vif",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_pimstat_candidate_rp_messages_sent_per_vif)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/pimstat_candidate_rp_messages_sent_per_vif");
	}
	if (_cmds->add_handler("pim/0.1/pimstat_candidate_rp_messages_rx_errors_per_vif",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_pimstat_candidate_rp_messages_rx_errors_per_vif)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/pimstat_candidate_rp_messages_rx_errors_per_vif");
	}
	if (_cmds->add_handler("pim/0.1/pimstat_unknown_type_messages_per_vif",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_pimstat_unknown_type_messages_per_vif)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/pimstat_unknown_type_messages_per_vif");
	}
	if (_cmds->add_handler("pim/0.1/pimstat_unknown_version_messages_per_vif",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_pimstat_unknown_version_messages_per_vif)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/pimstat_unknown_version_messages_per_vif");
	}
	if (_cmds->add_handler("pim/0.1/pimstat_neighbor_unknown_messages_per_vif",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_pimstat_neighbor_unknown_messages_per_vif)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/pimstat_neighbor_unknown_messages_per_vif");
	}
	if (_cmds->add_handler("pim/0.1/pimstat_bad_length_messages_per_vif",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_pimstat_bad_length_messages_per_vif)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/pimstat_bad_length_messages_per_vif");
	}
	if (_cmds->add_handler("pim/0.1/pimstat_bad_checksum_messages_per_vif",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_pimstat_bad_checksum_messages_per_vif)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/pimstat_bad_checksum_messages_per_vif");
	}
	if (_cmds->add_handler("pim/0.1/pimstat_bad_receive_interface_messages_per_vif",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_pimstat_bad_receive_interface_messages_per_vif)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/pimstat_bad_receive_interface_messages_per_vif");
	}
	if (_cmds->add_handler("pim/0.1/pimstat_rx_interface_disabled_messages_per_vif",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_pimstat_rx_interface_disabled_messages_per_vif)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/pimstat_rx_interface_disabled_messages_per_vif");
	}
	if (_cmds->add_handler("pim/0.1/pimstat_rx_register_not_rp_per_vif",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_pimstat_rx_register_not_rp_per_vif)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/pimstat_rx_register_not_rp_per_vif");
	}
	if (_cmds->add_handler("pim/0.1/pimstat_rp_filtered_source_per_vif",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_pimstat_rp_filtered_source_per_vif)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/pimstat_rp_filtered_source_per_vif");
	}
	if (_cmds->add_handler("pim/0.1/pimstat_unknown_register_stop_per_vif",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_pimstat_unknown_register_stop_per_vif)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/pimstat_unknown_register_stop_per_vif");
	}
	if (_cmds->add_handler("pim/0.1/pimstat_rx_join_prune_no_state_per_vif",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_pimstat_rx_join_prune_no_state_per_vif)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/pimstat_rx_join_prune_no_state_per_vif");
	}
	if (_cmds->add_handler("pim/0.1/pimstat_rx_graft_graft_ack_no_state_per_vif",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_pimstat_rx_graft_graft_ack_no_state_per_vif)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/pimstat_rx_graft_graft_ack_no_state_per_vif");
	}
	if (_cmds->add_handler("pim/0.1/pimstat_rx_graft_on_upstream_interface_per_vif",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_pimstat_rx_graft_on_upstream_interface_per_vif)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/pimstat_rx_graft_on_upstream_interface_per_vif");
	}
	if (_cmds->add_handler("pim/0.1/pimstat_rx_candidate_rp_not_bsr_per_vif",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_pimstat_rx_candidate_rp_not_bsr_per_vif)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/pimstat_rx_candidate_rp_not_bsr_per_vif");
	}
	if (_cmds->add_handler("pim/0.1/pimstat_rx_bsr_when_bsr_per_vif",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_pimstat_rx_bsr_when_bsr_per_vif)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/pimstat_rx_bsr_when_bsr_per_vif");
	}
	if (_cmds->add_handler("pim/0.1/pimstat_rx_bsr_not_rpf_interface_per_vif",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_pimstat_rx_bsr_not_rpf_interface_per_vif)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/pimstat_rx_bsr_not_rpf_interface_per_vif");
	}
	if (_cmds->add_handler("pim/0.1/pimstat_rx_unknown_hello_option_per_vif",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_pimstat_rx_unknown_hello_option_per_vif)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/pimstat_rx_unknown_hello_option_per_vif");
	}
	if (_cmds->add_handler("pim/0.1/pimstat_rx_data_no_state_per_vif",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_pimstat_rx_data_no_state_per_vif)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/pimstat_rx_data_no_state_per_vif");
	}
	if (_cmds->add_handler("pim/0.1/pimstat_rx_rp_no_state_per_vif",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_pimstat_rx_rp_no_state_per_vif)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/pimstat_rx_rp_no_state_per_vif");
	}
	if (_cmds->add_handler("pim/0.1/pimstat_rx_aggregate_per_vif",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_pimstat_rx_aggregate_per_vif)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/pimstat_rx_aggregate_per_vif");
	}
	if (_cmds->add_handler("pim/0.1/pimstat_rx_malformed_packet_per_vif",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_pimstat_rx_malformed_packet_per_vif)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/pimstat_rx_malformed_packet_per_vif");
	}
	if (_cmds->add_handler("pim/0.1/pimstat_no_rp_per_vif",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_pimstat_no_rp_per_vif)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/pimstat_no_rp_per_vif");
	}
	if (_cmds->add_handler("pim/0.1/pimstat_no_route_upstream_per_vif",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_pimstat_no_route_upstream_per_vif)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/pimstat_no_route_upstream_per_vif");
	}
	if (_cmds->add_handler("pim/0.1/pimstat_rp_mismatch_per_vif",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_pimstat_rp_mismatch_per_vif)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/pimstat_rp_mismatch_per_vif");
	}
	if (_cmds->add_handler("pim/0.1/pimstat_rpf_neighbor_unknown_per_vif",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_pimstat_rpf_neighbor_unknown_per_vif)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/pimstat_rpf_neighbor_unknown_per_vif");
	}
	if (_cmds->add_handler("pim/0.1/pimstat_rx_join_rp_per_vif",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_pimstat_rx_join_rp_per_vif)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/pimstat_rx_join_rp_per_vif");
	}
	if (_cmds->add_handler("pim/0.1/pimstat_rx_prune_rp_per_vif",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_pimstat_rx_prune_rp_per_vif)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/pimstat_rx_prune_rp_per_vif");
	}
	if (_cmds->add_handler("pim/0.1/pimstat_rx_join_wc_per_vif",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_pimstat_rx_join_wc_per_vif)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/pimstat_rx_join_wc_per_vif");
	}
	if (_cmds->add_handler("pim/0.1/pimstat_rx_prune_wc_per_vif",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_pimstat_rx_prune_wc_per_vif)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/pimstat_rx_prune_wc_per_vif");
	}
	if (_cmds->add_handler("pim/0.1/pimstat_rx_join_sg_per_vif",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_pimstat_rx_join_sg_per_vif)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/pimstat_rx_join_sg_per_vif");
	}
	if (_cmds->add_handler("pim/0.1/pimstat_rx_prune_sg_per_vif",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_pimstat_rx_prune_sg_per_vif)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/pimstat_rx_prune_sg_per_vif");
	}
	if (_cmds->add_handler("pim/0.1/pimstat_rx_join_sg_rpt_per_vif",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_pimstat_rx_join_sg_rpt_per_vif)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/pimstat_rx_join_sg_rpt_per_vif");
	}
	if (_cmds->add_handler("pim/0.1/pimstat_rx_prune_sg_rpt_per_vif",
	    callback(this, &XrlPimTargetBase::handle_pim_0_1_pimstat_rx_prune_sg_rpt_per_vif)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "pim", "pim/0.1/pimstat_rx_prune_sg_rpt_per_vif");
	}
	_cmds->finalize();
}

void
XrlPimTargetBase::remove_handlers()
{
	_cmds->remove_handler("common/0.1/get_target_name");
	_cmds->remove_handler("common/0.1/get_version");
	_cmds->remove_handler("common/0.1/get_status");
	_cmds->remove_handler("common/0.1/shutdown");
	_cmds->remove_handler("cli_processor/0.1/process_command");
	_cmds->remove_handler("finder_event_observer/0.1/xrl_target_birth");
	_cmds->remove_handler("finder_event_observer/0.1/xrl_target_death");
	_cmds->remove_handler("raw_packet4_client/0.1/recv");
	_cmds->remove_handler("raw_packet6_client/0.1/recv");
	_cmds->remove_handler("mfea_client/0.1/recv_kernel_signal_message4");
	_cmds->remove_handler("mfea_client/0.1/recv_kernel_signal_message6");
	_cmds->remove_handler("mfea_client/0.1/recv_dataflow_signal4");
	_cmds->remove_handler("mfea_client/0.1/recv_dataflow_signal6");
	_cmds->remove_handler("redist_transaction4/0.1/start_transaction");
	_cmds->remove_handler("redist_transaction4/0.1/commit_transaction");
	_cmds->remove_handler("redist_transaction4/0.1/abort_transaction");
	_cmds->remove_handler("redist_transaction4/0.1/add_route");
	_cmds->remove_handler("redist_transaction4/0.1/delete_route");
	_cmds->remove_handler("redist_transaction4/0.1/delete_all_routes");
	_cmds->remove_handler("redist_transaction6/0.1/start_transaction");
	_cmds->remove_handler("redist_transaction6/0.1/commit_transaction");
	_cmds->remove_handler("redist_transaction6/0.1/abort_transaction");
	_cmds->remove_handler("redist_transaction6/0.1/add_route");
	_cmds->remove_handler("redist_transaction6/0.1/delete_route");
	_cmds->remove_handler("redist_transaction6/0.1/delete_all_routes");
	_cmds->remove_handler("mld6igmp_client/0.1/add_membership4");
	_cmds->remove_handler("mld6igmp_client/0.1/add_membership6");
	_cmds->remove_handler("mld6igmp_client/0.1/delete_membership4");
	_cmds->remove_handler("mld6igmp_client/0.1/delete_membership6");
	_cmds->remove_handler("pim/0.1/enable_vif");
	_cmds->remove_handler("pim/0.1/start_vif");
	_cmds->remove_handler("pim/0.1/stop_vif");
	_cmds->remove_handler("pim/0.1/enable_all_vifs");
	_cmds->remove_handler("pim/0.1/start_all_vifs");
	_cmds->remove_handler("pim/0.1/stop_all_vifs");
	_cmds->remove_handler("pim/0.1/enable_pim");
	_cmds->remove_handler("pim/0.1/start_pim");
	_cmds->remove_handler("pim/0.1/stop_pim");
	_cmds->remove_handler("pim/0.1/enable_cli");
	_cmds->remove_handler("pim/0.1/start_cli");
	_cmds->remove_handler("pim/0.1/stop_cli");
	_cmds->remove_handler("pim/0.1/enable_bsr");
	_cmds->remove_handler("pim/0.1/start_bsr");
	_cmds->remove_handler("pim/0.1/stop_bsr");
	_cmds->remove_handler("pim/0.1/add_config_scope_zone_by_vif_name4");
	_cmds->remove_handler("pim/0.1/add_config_scope_zone_by_vif_name6");
	_cmds->remove_handler("pim/0.1/add_config_scope_zone_by_vif_addr4");
	_cmds->remove_handler("pim/0.1/add_config_scope_zone_by_vif_addr6");
	_cmds->remove_handler("pim/0.1/delete_config_scope_zone_by_vif_name4");
	_cmds->remove_handler("pim/0.1/delete_config_scope_zone_by_vif_name6");
	_cmds->remove_handler("pim/0.1/delete_config_scope_zone_by_vif_addr4");
	_cmds->remove_handler("pim/0.1/delete_config_scope_zone_by_vif_addr6");
	_cmds->remove_handler("pim/0.1/add_config_cand_bsr4");
	_cmds->remove_handler("pim/0.1/add_config_cand_bsr6");
	_cmds->remove_handler("pim/0.1/delete_config_cand_bsr4");
	_cmds->remove_handler("pim/0.1/delete_config_cand_bsr6");
	_cmds->remove_handler("pim/0.1/add_config_cand_rp4");
	_cmds->remove_handler("pim/0.1/add_config_cand_rp6");
	_cmds->remove_handler("pim/0.1/delete_config_cand_rp4");
	_cmds->remove_handler("pim/0.1/delete_config_cand_rp6");
	_cmds->remove_handler("pim/0.1/add_config_static_rp4");
	_cmds->remove_handler("pim/0.1/add_config_static_rp6");
	_cmds->remove_handler("pim/0.1/delete_config_static_rp4");
	_cmds->remove_handler("pim/0.1/delete_config_static_rp6");
	_cmds->remove_handler("pim/0.1/delete_config_all_static_group_prefixes_rp4");
	_cmds->remove_handler("pim/0.1/delete_config_all_static_group_prefixes_rp6");
	_cmds->remove_handler("pim/0.1/delete_config_all_static_rps");
	_cmds->remove_handler("pim/0.1/config_static_rp_done");
	_cmds->remove_handler("pim/0.1/get_vif_proto_version");
	_cmds->remove_handler("pim/0.1/set_vif_proto_version");
	_cmds->remove_handler("pim/0.1/reset_vif_proto_version");
	_cmds->remove_handler("pim/0.1/get_vif_hello_triggered_delay");
	_cmds->remove_handler("pim/0.1/set_vif_hello_triggered_delay");
	_cmds->remove_handler("pim/0.1/reset_vif_hello_triggered_delay");
	_cmds->remove_handler("pim/0.1/get_vif_hello_period");
	_cmds->remove_handler("pim/0.1/set_vif_hello_period");
	_cmds->remove_handler("pim/0.1/reset_vif_hello_period");
	_cmds->remove_handler("pim/0.1/get_vif_hello_holdtime");
	_cmds->remove_handler("pim/0.1/set_vif_hello_holdtime");
	_cmds->remove_handler("pim/0.1/reset_vif_hello_holdtime");
	_cmds->remove_handler("pim/0.1/get_vif_dr_priority");
	_cmds->remove_handler("pim/0.1/set_vif_dr_priority");
	_cmds->remove_handler("pim/0.1/reset_vif_dr_priority");
	_cmds->remove_handler("pim/0.1/get_vif_propagation_delay");
	_cmds->remove_handler("pim/0.1/set_vif_propagation_delay");
	_cmds->remove_handler("pim/0.1/reset_vif_propagation_delay");
	_cmds->remove_handler("pim/0.1/get_vif_override_interval");
	_cmds->remove_handler("pim/0.1/set_vif_override_interval");
	_cmds->remove_handler("pim/0.1/reset_vif_override_interval");
	_cmds->remove_handler("pim/0.1/get_vif_is_tracking_support_disabled");
	_cmds->remove_handler("pim/0.1/set_vif_is_tracking_support_disabled");
	_cmds->remove_handler("pim/0.1/reset_vif_is_tracking_support_disabled");
	_cmds->remove_handler("pim/0.1/get_vif_accept_nohello_neighbors");
	_cmds->remove_handler("pim/0.1/set_vif_accept_nohello_neighbors");
	_cmds->remove_handler("pim/0.1/reset_vif_accept_nohello_neighbors");
	_cmds->remove_handler("pim/0.1/get_vif_join_prune_period");
	_cmds->remove_handler("pim/0.1/set_vif_join_prune_period");
	_cmds->remove_handler("pim/0.1/reset_vif_join_prune_period");
	_cmds->remove_handler("pim/0.1/get_switch_to_spt_threshold");
	_cmds->remove_handler("pim/0.1/set_switch_to_spt_threshold");
	_cmds->remove_handler("pim/0.1/reset_switch_to_spt_threshold");
	_cmds->remove_handler("pim/0.1/add_alternative_subnet4");
	_cmds->remove_handler("pim/0.1/add_alternative_subnet6");
	_cmds->remove_handler("pim/0.1/delete_alternative_subnet4");
	_cmds->remove_handler("pim/0.1/delete_alternative_subnet6");
	_cmds->remove_handler("pim/0.1/remove_all_alternative_subnets");
	_cmds->remove_handler("pim/0.1/log_trace_all");
	_cmds->remove_handler("pim/0.1/add_test_jp_entry4");
	_cmds->remove_handler("pim/0.1/add_test_jp_entry6");
	_cmds->remove_handler("pim/0.1/send_test_jp_entry4");
	_cmds->remove_handler("pim/0.1/send_test_jp_entry6");
	_cmds->remove_handler("pim/0.1/send_test_assert4");
	_cmds->remove_handler("pim/0.1/send_test_assert6");
	_cmds->remove_handler("pim/0.1/add_test_bsr_zone4");
	_cmds->remove_handler("pim/0.1/add_test_bsr_zone6");
	_cmds->remove_handler("pim/0.1/add_test_bsr_group_prefix4");
	_cmds->remove_handler("pim/0.1/add_test_bsr_group_prefix6");
	_cmds->remove_handler("pim/0.1/add_test_bsr_rp4");
	_cmds->remove_handler("pim/0.1/add_test_bsr_rp6");
	_cmds->remove_handler("pim/0.1/send_test_bootstrap");
	_cmds->remove_handler("pim/0.1/send_test_bootstrap_by_dest4");
	_cmds->remove_handler("pim/0.1/send_test_bootstrap_by_dest6");
	_cmds->remove_handler("pim/0.1/send_test_cand_rp_adv");
	_cmds->remove_handler("pim/0.1/pimstat_neighbors4");
	_cmds->remove_handler("pim/0.1/pimstat_neighbors6");
	_cmds->remove_handler("pim/0.1/pimstat_interface4");
	_cmds->remove_handler("pim/0.1/pimstat_interface6");
	_cmds->remove_handler("pim/0.1/pimstat_rps4");
	_cmds->remove_handler("pim/0.1/pimstat_rps6");
	_cmds->remove_handler("pim/0.1/clear_pim_statistics");
	_cmds->remove_handler("pim/0.1/clear_pim_statistics_per_vif");
	_cmds->remove_handler("pim/0.1/pimstat_hello_messages_received");
	_cmds->remove_handler("pim/0.1/pimstat_hello_messages_sent");
	_cmds->remove_handler("pim/0.1/pimstat_hello_messages_rx_errors");
	_cmds->remove_handler("pim/0.1/pimstat_register_messages_received");
	_cmds->remove_handler("pim/0.1/pimstat_register_messages_sent");
	_cmds->remove_handler("pim/0.1/pimstat_register_messages_rx_errors");
	_cmds->remove_handler("pim/0.1/pimstat_register_stop_messages_received");
	_cmds->remove_handler("pim/0.1/pimstat_register_stop_messages_sent");
	_cmds->remove_handler("pim/0.1/pimstat_register_stop_messages_rx_errors");
	_cmds->remove_handler("pim/0.1/pimstat_join_prune_messages_received");
	_cmds->remove_handler("pim/0.1/pimstat_join_prune_messages_sent");
	_cmds->remove_handler("pim/0.1/pimstat_join_prune_messages_rx_errors");
	_cmds->remove_handler("pim/0.1/pimstat_bootstrap_messages_received");
	_cmds->remove_handler("pim/0.1/pimstat_bootstrap_messages_sent");
	_cmds->remove_handler("pim/0.1/pimstat_bootstrap_messages_rx_errors");
	_cmds->remove_handler("pim/0.1/pimstat_assert_messages_received");
	_cmds->remove_handler("pim/0.1/pimstat_assert_messages_sent");
	_cmds->remove_handler("pim/0.1/pimstat_assert_messages_rx_errors");
	_cmds->remove_handler("pim/0.1/pimstat_graft_messages_received");
	_cmds->remove_handler("pim/0.1/pimstat_graft_messages_sent");
	_cmds->remove_handler("pim/0.1/pimstat_graft_messages_rx_errors");
	_cmds->remove_handler("pim/0.1/pimstat_graft_ack_messages_received");
	_cmds->remove_handler("pim/0.1/pimstat_graft_ack_messages_sent");
	_cmds->remove_handler("pim/0.1/pimstat_graft_ack_messages_rx_errors");
	_cmds->remove_handler("pim/0.1/pimstat_candidate_rp_messages_received");
	_cmds->remove_handler("pim/0.1/pimstat_candidate_rp_messages_sent");
	_cmds->remove_handler("pim/0.1/pimstat_candidate_rp_messages_rx_errors");
	_cmds->remove_handler("pim/0.1/pimstat_unknown_type_messages");
	_cmds->remove_handler("pim/0.1/pimstat_unknown_version_messages");
	_cmds->remove_handler("pim/0.1/pimstat_neighbor_unknown_messages");
	_cmds->remove_handler("pim/0.1/pimstat_bad_length_messages");
	_cmds->remove_handler("pim/0.1/pimstat_bad_checksum_messages");
	_cmds->remove_handler("pim/0.1/pimstat_bad_receive_interface_messages");
	_cmds->remove_handler("pim/0.1/pimstat_rx_interface_disabled_messages");
	_cmds->remove_handler("pim/0.1/pimstat_rx_register_not_rp");
	_cmds->remove_handler("pim/0.1/pimstat_rp_filtered_source");
	_cmds->remove_handler("pim/0.1/pimstat_unknown_register_stop");
	_cmds->remove_handler("pim/0.1/pimstat_rx_join_prune_no_state");
	_cmds->remove_handler("pim/0.1/pimstat_rx_graft_graft_ack_no_state");
	_cmds->remove_handler("pim/0.1/pimstat_rx_graft_on_upstream_interface");
	_cmds->remove_handler("pim/0.1/pimstat_rx_candidate_rp_not_bsr");
	_cmds->remove_handler("pim/0.1/pimstat_rx_bsr_when_bsr");
	_cmds->remove_handler("pim/0.1/pimstat_rx_bsr_not_rpf_interface");
	_cmds->remove_handler("pim/0.1/pimstat_rx_unknown_hello_option");
	_cmds->remove_handler("pim/0.1/pimstat_rx_data_no_state");
	_cmds->remove_handler("pim/0.1/pimstat_rx_rp_no_state");
	_cmds->remove_handler("pim/0.1/pimstat_rx_aggregate");
	_cmds->remove_handler("pim/0.1/pimstat_rx_malformed_packet");
	_cmds->remove_handler("pim/0.1/pimstat_no_rp");
	_cmds->remove_handler("pim/0.1/pimstat_no_route_upstream");
	_cmds->remove_handler("pim/0.1/pimstat_rp_mismatch");
	_cmds->remove_handler("pim/0.1/pimstat_rpf_neighbor_unknown");
	_cmds->remove_handler("pim/0.1/pimstat_rx_join_rp");
	_cmds->remove_handler("pim/0.1/pimstat_rx_prune_rp");
	_cmds->remove_handler("pim/0.1/pimstat_rx_join_wc");
	_cmds->remove_handler("pim/0.1/pimstat_rx_prune_wc");
	_cmds->remove_handler("pim/0.1/pimstat_rx_join_sg");
	_cmds->remove_handler("pim/0.1/pimstat_rx_prune_sg");
	_cmds->remove_handler("pim/0.1/pimstat_rx_join_sg_rpt");
	_cmds->remove_handler("pim/0.1/pimstat_rx_prune_sg_rpt");
	_cmds->remove_handler("pim/0.1/pimstat_hello_messages_received_per_vif");
	_cmds->remove_handler("pim/0.1/pimstat_hello_messages_sent_per_vif");
	_cmds->remove_handler("pim/0.1/pimstat_hello_messages_rx_errors_per_vif");
	_cmds->remove_handler("pim/0.1/pimstat_register_messages_received_per_vif");
	_cmds->remove_handler("pim/0.1/pimstat_register_messages_sent_per_vif");
	_cmds->remove_handler("pim/0.1/pimstat_register_messages_rx_errors_per_vif");
	_cmds->remove_handler("pim/0.1/pimstat_register_stop_messages_received_per_vif");
	_cmds->remove_handler("pim/0.1/pimstat_register_stop_messages_sent_per_vif");
	_cmds->remove_handler("pim/0.1/pimstat_register_stop_messages_rx_errors_per_vif");
	_cmds->remove_handler("pim/0.1/pimstat_join_prune_messages_received_per_vif");
	_cmds->remove_handler("pim/0.1/pimstat_join_prune_messages_sent_per_vif");
	_cmds->remove_handler("pim/0.1/pimstat_join_prune_messages_rx_errors_per_vif");
	_cmds->remove_handler("pim/0.1/pimstat_bootstrap_messages_received_per_vif");
	_cmds->remove_handler("pim/0.1/pimstat_bootstrap_messages_sent_per_vif");
	_cmds->remove_handler("pim/0.1/pimstat_bootstrap_messages_rx_errors_per_vif");
	_cmds->remove_handler("pim/0.1/pimstat_assert_messages_received_per_vif");
	_cmds->remove_handler("pim/0.1/pimstat_assert_messages_sent_per_vif");
	_cmds->remove_handler("pim/0.1/pimstat_assert_messages_rx_errors_per_vif");
	_cmds->remove_handler("pim/0.1/pimstat_graft_messages_received_per_vif");
	_cmds->remove_handler("pim/0.1/pimstat_graft_messages_sent_per_vif");
	_cmds->remove_handler("pim/0.1/pimstat_graft_messages_rx_errors_per_vif");
	_cmds->remove_handler("pim/0.1/pimstat_graft_ack_messages_received_per_vif");
	_cmds->remove_handler("pim/0.1/pimstat_graft_ack_messages_sent_per_vif");
	_cmds->remove_handler("pim/0.1/pimstat_graft_ack_messages_rx_errors_per_vif");
	_cmds->remove_handler("pim/0.1/pimstat_candidate_rp_messages_received_per_vif");
	_cmds->remove_handler("pim/0.1/pimstat_candidate_rp_messages_sent_per_vif");
	_cmds->remove_handler("pim/0.1/pimstat_candidate_rp_messages_rx_errors_per_vif");
	_cmds->remove_handler("pim/0.1/pimstat_unknown_type_messages_per_vif");
	_cmds->remove_handler("pim/0.1/pimstat_unknown_version_messages_per_vif");
	_cmds->remove_handler("pim/0.1/pimstat_neighbor_unknown_messages_per_vif");
	_cmds->remove_handler("pim/0.1/pimstat_bad_length_messages_per_vif");
	_cmds->remove_handler("pim/0.1/pimstat_bad_checksum_messages_per_vif");
	_cmds->remove_handler("pim/0.1/pimstat_bad_receive_interface_messages_per_vif");
	_cmds->remove_handler("pim/0.1/pimstat_rx_interface_disabled_messages_per_vif");
	_cmds->remove_handler("pim/0.1/pimstat_rx_register_not_rp_per_vif");
	_cmds->remove_handler("pim/0.1/pimstat_rp_filtered_source_per_vif");
	_cmds->remove_handler("pim/0.1/pimstat_unknown_register_stop_per_vif");
	_cmds->remove_handler("pim/0.1/pimstat_rx_join_prune_no_state_per_vif");
	_cmds->remove_handler("pim/0.1/pimstat_rx_graft_graft_ack_no_state_per_vif");
	_cmds->remove_handler("pim/0.1/pimstat_rx_graft_on_upstream_interface_per_vif");
	_cmds->remove_handler("pim/0.1/pimstat_rx_candidate_rp_not_bsr_per_vif");
	_cmds->remove_handler("pim/0.1/pimstat_rx_bsr_when_bsr_per_vif");
	_cmds->remove_handler("pim/0.1/pimstat_rx_bsr_not_rpf_interface_per_vif");
	_cmds->remove_handler("pim/0.1/pimstat_rx_unknown_hello_option_per_vif");
	_cmds->remove_handler("pim/0.1/pimstat_rx_data_no_state_per_vif");
	_cmds->remove_handler("pim/0.1/pimstat_rx_rp_no_state_per_vif");
	_cmds->remove_handler("pim/0.1/pimstat_rx_aggregate_per_vif");
	_cmds->remove_handler("pim/0.1/pimstat_rx_malformed_packet_per_vif");
	_cmds->remove_handler("pim/0.1/pimstat_no_rp_per_vif");
	_cmds->remove_handler("pim/0.1/pimstat_no_route_upstream_per_vif");
	_cmds->remove_handler("pim/0.1/pimstat_rp_mismatch_per_vif");
	_cmds->remove_handler("pim/0.1/pimstat_rpf_neighbor_unknown_per_vif");
	_cmds->remove_handler("pim/0.1/pimstat_rx_join_rp_per_vif");
	_cmds->remove_handler("pim/0.1/pimstat_rx_prune_rp_per_vif");
	_cmds->remove_handler("pim/0.1/pimstat_rx_join_wc_per_vif");
	_cmds->remove_handler("pim/0.1/pimstat_rx_prune_wc_per_vif");
	_cmds->remove_handler("pim/0.1/pimstat_rx_join_sg_per_vif");
	_cmds->remove_handler("pim/0.1/pimstat_rx_prune_sg_per_vif");
	_cmds->remove_handler("pim/0.1/pimstat_rx_join_sg_rpt_per_vif");
	_cmds->remove_handler("pim/0.1/pimstat_rx_prune_sg_rpt_per_vif");
}
